/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.util.IncorrectOperationException;

public class FieldReturnValue
implements ReturnValue {
    private final PsiField myField;

    public FieldReturnValue(PsiField psiField) {
        this.myField = psiField;
    }

    @Override
    public boolean isEquivalent(ReturnValue other) {
        if (!(other instanceof FieldReturnValue)) {
            return false;
        }
        return this.myField == ((FieldReturnValue)other).myField;
    }

    public PsiField getField() {
        return this.myField;
    }

    @Override
    public PsiStatement createReplacement(PsiMethod extractedMethod, PsiMethodCallExpression methodCallExpression) throws IncorrectOperationException {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)methodCallExpression.getProject()).getElementFactory();
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)methodCallExpression.getProject());
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)elementFactory.createStatementFromText("x = y();", null);
        expressionStatement = (PsiExpressionStatement)styleManager.reformat((PsiElement)expressionStatement);
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expressionStatement.getExpression();
        assignmentExpression.getLExpression().replace((PsiElement)elementFactory.createExpressionFromText(this.myField.getName(), (PsiElement)this.myField));
        assignmentExpression.getRExpression().replace((PsiElement)methodCallExpression);
        return expressionStatement;
    }
}

