/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConflictsUtil {
    private ConflictsUtil() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiElement getContainer(PsiElement place) {
        PsiElement parent = place;
        while (true) {
            PsiElement psiElement;
            if (parent instanceof PsiMember && !(parent instanceof PsiTypeParameter)) {
                psiElement = parent;
                if (psiElement == null) throw new IllegalStateException("@NotNull method com/intellij/refactoring/util/ConflictsUtil.getContainer must not return null");
                return psiElement;
            }
            if (parent instanceof PsiFile) {
                psiElement = parent;
                if (psiElement != null) return psiElement;
                throw new IllegalStateException("@NotNull method com/intellij/refactoring/util/ConflictsUtil.getContainer must not return null");
            }
            parent = parent.getParent();
        }
    }

    public static void checkMethodConflicts(@Nullable PsiClass aClass, PsiMethod refactoredMethod, PsiMethod prototype, MultiMap<PsiElement, String> conflicts) {
        PsiMethod method;
        if (prototype == null) {
            return;
        }
        PsiMethod psiMethod = method = aClass != null ? aClass.findMethodBySignature(prototype, true) : null;
        if (method != null && method != refactoredMethod) {
            if (aClass.equals(method.getContainingClass())) {
                String classDescr = aClass instanceof PsiAnonymousClass ? RefactoringBundle.message((String)"current.class") : RefactoringUIUtil.getDescription((PsiElement)aClass, false);
                conflicts.putValue((Object)method, (Object)RefactoringBundle.message((String)"method.0.is.already.defined.in.the.1", (Object[])new Object[]{ConflictsUtil.getMethodPrototypeString(prototype), classDescr}));
            } else if (JavaPsiFacade.getInstance((Project)method.getProject()).getResolveHelper().isAccessible((PsiMember)method, (PsiElement)aClass, null)) {
                String protoMethodInfo = ConflictsUtil.getMethodPrototypeString(prototype);
                String className = CommonRefactoringUtil.htmlEmphasize((String)UsageViewUtil.getDescriptiveName((PsiElement)method.getContainingClass()));
                if (PsiUtil.getAccessLevel((PsiModifierList)prototype.getModifierList()) >= PsiUtil.getAccessLevel((PsiModifierList)method.getModifierList())) {
                    boolean isMethodAbstract = method.hasModifierProperty("abstract");
                    boolean isMyMethodAbstract = refactoredMethod != null && refactoredMethod.hasModifierProperty("abstract");
                    String conflict = isMethodAbstract != isMyMethodAbstract ? RefactoringBundle.message((String)"method.0.will.implement.method.of.the.base.class", (Object[])new Object[]{protoMethodInfo, className}) : RefactoringBundle.message((String)"method.0.will.override.a.method.of.the.base.class", (Object[])new Object[]{protoMethodInfo, className});
                    conflicts.putValue((Object)method, (Object)conflict);
                } else {
                    conflicts.putValue((Object)method, (Object)RefactoringBundle.message((String)"method.0.will.hide.method.of.the.base.class", (Object[])new Object[]{protoMethodInfo, className}));
                }
            }
        }
    }

    private static String getMethodPrototypeString(PsiMethod prototype) {
        return PsiFormatUtil.formatMethod((PsiMethod)prototype, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
    }

    public static void checkFieldConflicts(@Nullable PsiClass aClass, String newName, MultiMap<PsiElement, String> conflicts) {
        PsiField existingField;
        PsiField psiField = existingField = aClass != null ? aClass.findFieldByName(newName, true) : null;
        if (existingField != null) {
            if (aClass.equals(existingField.getContainingClass())) {
                String className = aClass instanceof PsiAnonymousClass ? RefactoringBundle.message((String)"current.class") : RefactoringUIUtil.getDescription((PsiElement)aClass, false);
                String conflict = RefactoringBundle.message((String)"field.0.is.already.defined.in.the.1", (Object[])new Object[]{existingField.getName(), className});
                conflicts.putValue((Object)existingField, (Object)conflict);
            } else if (!existingField.hasModifierProperty("private")) {
                String fieldInfo = PsiFormatUtil.formatVariable((PsiVariable)existingField, (int)7, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                String className = RefactoringUIUtil.getDescription((PsiElement)existingField.getContainingClass(), false);
                String descr = RefactoringBundle.message((String)"field.0.will.hide.field.1.of.the.base.class", (Object[])new Object[]{newName, fieldInfo, className});
                conflicts.putValue((Object)existingField, (Object)descr);
            }
        }
    }
}

