/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.PsiType;
import java.awt.event.ItemListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeSelector {
    private final PsiType myType;
    private final JComponent myComponent;
    private final MyComboBoxModel myComboBoxModel;

    public TypeSelector(PsiType type) {
        this.myType = type;
        this.myComponent = new JLabel(this.myType.getPresentableText());
        this.myComboBoxModel = null;
    }

    public TypeSelector() {
        this.myComboBoxModel = new MyComboBoxModel();
        this.myComponent = new ComboBox();
        ((ComboBox)this.myComponent).setModel((ComboBoxModel)this.myComboBoxModel);
        this.myType = null;
    }

    public void setTypes(PsiType[] types) {
        if (this.myComboBoxModel == null) {
            return;
        }
        PsiType oldType = this.myComboBoxModel.getSize() > 0 ? this.getSelectedType() : null;
        this.myComboBoxModel.setSuggestions(TypeSelector.wrapToItems(types));
        if (oldType != null) {
            for (int i = 0; i < types.length; ++i) {
                PsiType type = types[i];
                if (!type.equals(oldType)) continue;
                ((JComboBox)this.myComponent).setSelectedIndex(i);
                return;
            }
        }
        if (types.length > 0) {
            ((JComboBox)this.myComponent).setSelectedIndex(0);
        }
    }

    private static PsiTypeItem[] wrapToItems(PsiType[] types) {
        PsiTypeItem[] result = new PsiTypeItem[types.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new PsiTypeItem(types[i]);
        }
        return result;
    }

    public void addItemListener(ItemListener aListener) {
        if (this.myComponent instanceof JComboBox) {
            ((JComboBox)this.myComponent).addItemListener(aListener);
        }
    }

    public void removeItemListener(ItemListener aListener) {
        if (this.myComponent instanceof JComboBox) {
            ((JComboBox)this.myComponent).removeItemListener(aListener);
        }
    }

    public ItemListener[] getItemListeners() {
        if (this.myComponent instanceof JComboBox) {
            return ((JComboBox)this.myComponent).getItemListeners();
        }
        return new ItemListener[0];
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public JComponent getFocusableComponent() {
        if (this.myComponent instanceof JComboBox) {
            return this.myComponent;
        }
        return null;
    }

    @Nullable
    public PsiType getSelectedType() {
        if (this.myComponent instanceof JLabel) {
            return this.myType;
        }
        PsiTypeItem selItem = (PsiTypeItem)((JComboBox)this.myComponent).getSelectedItem();
        return selItem == null ? null : selItem.getType();
    }

    public void selectType(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/ui/TypeSelector.selectType must not be null");
        }
        if (this.myComponent instanceof JComboBox) {
            ((JComboBox)this.myComponent).setSelectedItem(new PsiTypeItem(type));
        }
    }

    private static class PsiTypeItem {
        private final PsiType myType;

        private PsiTypeItem(PsiType type) {
            this.myType = type;
        }

        public PsiType getType() {
            return this.myType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PsiTypeItem that = (PsiTypeItem)o;
            return this.myType.equals(that.myType);
        }

        public int hashCode() {
            return this.myType.hashCode();
        }

        public String toString() {
            return this.myType.getPresentableText();
        }
    }

    private static class MyComboBoxModel
    extends DefaultComboBoxModel {
        private PsiTypeItem[] mySuggestions = new PsiTypeItem[0];

        MyComboBoxModel() {
        }

        @Override
        public int getSize() {
            return this.mySuggestions.length;
        }

        @Override
        public Object getElementAt(int index) {
            return this.mySuggestions[index];
        }

        public void setSuggestions(PsiTypeItem[] suggestions) {
            this.fireIntervalRemoved(this, 0, this.mySuggestions.length);
            this.mySuggestions = suggestions;
            this.fireIntervalAdded(this, 0, this.mySuggestions.length);
        }
    }
}

