/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete.usageInfo;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceUsageInfo;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;

public class SafeDeleteFieldWriteReference
extends SafeDeleteReferenceUsageInfo {
    private final PsiAssignmentExpression myExpression;

    public SafeDeleteFieldWriteReference(PsiAssignmentExpression expr, PsiField referencedElement) {
        super((PsiElement)expr, (PsiElement)referencedElement, SafeDeleteFieldWriteReference.safeRemoveRHS(expr));
        this.myExpression = expr;
    }

    private static boolean safeRemoveRHS(PsiAssignmentExpression expression) {
        PsiExpression rExpression = expression.getRExpression();
        PsiElement parent = expression.getParent();
        return RefactoringUtil.verifySafeCopyExpression((PsiElement)rExpression) == 0 && parent instanceof PsiExpressionStatement && ((PsiExpressionStatement)parent).getExpression() == expression;
    }

    @Override
    public void deleteElement() throws IncorrectOperationException {
        this.myExpression.getParent().delete();
    }
}

