/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveMembers;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.refactoring.move.MoveMemberViewDescriptor;
import com.intellij.refactoring.move.moveMembers.MoveMemberHandler;
import com.intellij.refactoring.move.moveMembers.MoveMembersImpl;
import com.intellij.refactoring.move.moveMembers.MoveMembersOptions;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MoveMembersProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveMembers.MoveMembersProcessor");
    private PsiClass myTargetClass;
    private final Set<PsiMember> myMembersToMove = new LinkedHashSet<PsiMember>();
    private final MoveCallback myMoveCallback;
    private String myNewVisibility;
    private String myCommandName = MoveMembersImpl.REFACTORING_NAME;
    private boolean myMakeEnumConstant;
    private MoveMembersOptions myOptions;

    public MoveMembersProcessor(Project project, MoveCallback moveCallback, MoveMembersOptions options) {
        super(project);
        this.myMoveCallback = moveCallback;
        this.setOptions(options);
    }

    public MoveMembersProcessor(Project project, MoveMembersOptions options) {
        this(project, null, options);
    }

    @Override
    protected String getCommandName() {
        return this.myCommandName;
    }

    private void setOptions(MoveMembersOptions dialog) {
        this.myOptions = dialog;
        PsiMember[] members = dialog.getSelectedMembers();
        this.myMembersToMove.clear();
        this.myMembersToMove.addAll(Arrays.asList(members));
        this.setCommandName(members);
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        this.myTargetClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(dialog.getTargetClassName(), GlobalSearchScope.projectScope((Project)this.myProject));
        this.myNewVisibility = dialog.getMemberVisibility();
        this.myMakeEnumConstant = dialog.makeEnumConstant();
    }

    private void setCommandName(PsiMember[] members) {
        StringBuilder commandName = new StringBuilder();
        commandName.append(MoveHandler.REFACTORING_NAME);
        commandName.append(" ");
        boolean first = true;
        for (PsiMember member : members) {
            if (!first) {
                commandName.append(", ");
            }
            commandName.append(UsageViewUtil.getType((PsiElement)member));
            commandName.append(' ');
            commandName.append(UsageViewUtil.getShortName((PsiElement)member));
            first = false;
        }
        this.myCommandName = commandName.toString();
    }

    @Override
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        return new MoveMemberViewDescriptor(this.myMembersToMove.toArray(new PsiElement[this.myMembersToMove.size()]));
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<MoveMembersUsageInfo> usagesList = new ArrayList<MoveMembersUsageInfo>();
        for (PsiMember member : this.myMembersToMove) {
            for (PsiReference psiReference : ReferencesSearch.search((PsiElement)member)) {
                PsiElement ref = psiReference.getElement();
                MoveMemberHandler handler = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(ref.getLanguage());
                MoveMembersUsageInfo usage = null;
                if (handler != null) {
                    usage = handler.getUsage(member, psiReference, this.myMembersToMove, this.myTargetClass);
                }
                if (usage != null) {
                    usagesList.add(usage);
                    continue;
                }
                if (this.isInMovedElement(ref)) continue;
                usagesList.add(new MoveMembersUsageInfo(member, ref, null, ref, psiReference));
            }
        }
        UsageInfo[] usageInfos = usagesList.toArray(new UsageInfo[usagesList.size()]);
        if ((usageInfos = UsageViewUtil.removeDuplicatedUsages(usageInfos)) == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/move/moveMembers/MoveMembersProcessor.findUsages must not return null");
        }
        return usageInfos;
    }

    @Override
    protected void refreshElements(PsiElement[] elements) {
        LOG.assertTrue(this.myMembersToMove.size() == elements.length);
        this.myMembersToMove.clear();
        for (PsiElement resolved : elements) {
            this.myMembersToMove.add((PsiMember)resolved);
        }
    }

    private boolean isInMovedElement(PsiElement element) {
        for (PsiMember member : this.myMembersToMove) {
            if (!PsiTreeUtil.isAncestor((PsiElement)member, (PsiElement)element, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void performRefactoring(UsageInfo[] usages) {
        try {
            LanguageExtension extension = new LanguageExtension("com.intellij.refactoring.moveMemberHandler");
            PsiClass targetClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.myOptions.getTargetClassName(), GlobalSearchScope.projectScope((Project)this.myProject));
            if (targetClass == null) {
                return;
            }
            HashMap anchors = new HashMap();
            for (PsiMember member : this.myMembersToMove) {
                anchors.put(member, ((MoveMemberHandler)extension.forLanguage(member.getLanguage())).getAnchor(member, targetClass));
            }
            ArrayList<MoveMembersUsageInfo> otherUsages = new ArrayList<MoveMembersUsageInfo>();
            for (UsageInfo usageInfo : usages) {
                MoveMemberHandler handler;
                MoveMembersUsageInfo usage = (MoveMembersUsageInfo)usageInfo;
                if (!usage.reference.isValid() || (handler = (MoveMemberHandler)extension.forLanguage(usageInfo.getElement().getLanguage())) != null && handler.changeExternalUsage(this.myOptions, usage)) continue;
                otherUsages.add(usage);
            }
            for (PsiMember member : this.myMembersToMove) {
                ArrayList<PsiReference> refsToBeRebind = new ArrayList<PsiReference>();
                Iterator iterator = otherUsages.iterator();
                while (iterator.hasNext()) {
                    MoveMembersUsageInfo info = (MoveMembersUsageInfo)((Object)iterator.next());
                    if (!member.equals(info.member)) continue;
                    PsiReference ref = info.getReference();
                    if (ref != null) {
                        refsToBeRebind.add(ref);
                    }
                    iterator.remove();
                }
                RefactoringElementListener elementListener = this.getTransaction().getElementListener((PsiElement)member);
                MoveMemberHandler handler = (MoveMemberHandler)extension.forLanguage(member.getLanguage());
                PsiMember newMember = handler.doMove(this.myOptions, member, (PsiElement)anchors.get(member), targetClass);
                elementListener.elementMoved((PsiElement)newMember);
                this.fixModifierList(newMember, usages);
                for (PsiReference reference : refsToBeRebind) {
                    reference.bindToElement((PsiElement)newMember);
                }
            }
            MoveMemberHandler handler = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(this.myTargetClass.getLanguage());
            if (handler != null) {
                handler.decodeContextInfo((PsiElement)this.myTargetClass);
            }
            this.myMembersToMove.clear();
            if (this.myMoveCallback != null) {
                this.myMoveCallback.refactoringCompleted();
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void fixModifierList(PsiMember newMember, UsageInfo[] usages) throws IncorrectOperationException {
        PsiModifierList modifierList = newMember.getModifierList();
        if (this.myTargetClass.isInterface()) {
            modifierList.setModifierProperty("public", false);
            modifierList.setModifierProperty("protected", false);
            modifierList.setModifierProperty("private", false);
            if (newMember instanceof PsiClass) {
                modifierList.setModifierProperty("static", false);
            }
            return;
        }
        if (this.myNewVisibility == null) {
            return;
        }
        VisibilityUtil.fixVisibility((UsageInfo[])usages, (PsiMember)newMember, (String)this.myNewVisibility);
    }

    @Override
    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        MultiMap conflicts = new MultiMap();
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        try {
            this.addInaccessiblleConflicts((MultiMap<PsiElement, String>)conflicts, usages);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        MoveMembersProcessor.analyzeMoveConflicts(this.myMembersToMove, this.myTargetClass, this.myNewVisibility, (MultiMap<PsiElement, String>)conflicts);
        RefactoringConflictsUtil.analyzeModuleConflicts(this.myProject, this.myMembersToMove, usages, (PsiElement)this.myTargetClass, (MultiMap<PsiElement, String>)conflicts);
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts);
    }

    private void addInaccessiblleConflicts(MultiMap<PsiElement, String> conflicts, UsageInfo[] usages) throws IncorrectOperationException {
        String newVisibility = this.myNewVisibility;
        if ("EscalateVisible".equals(newVisibility)) {
            newVisibility = "public";
        }
        HashMap modifierListCopies = new HashMap();
        for (PsiMember member : this.myMembersToMove) {
            PsiModifierList copy = member.getModifierList();
            if (copy != null) {
                copy = (PsiModifierList)copy.copy();
            }
            if (newVisibility != null && copy != null) {
                VisibilityUtil.setVisibility((PsiModifierList)copy, (String)newVisibility);
            }
            modifierListCopies.put(member, copy);
        }
        for (UsageInfo usage : usages) {
            ReadWriteAccessDetector.Access access;
            ReadWriteAccessDetector accessDetector;
            if (!(usage instanceof MoveMembersUsageInfo)) continue;
            MoveMembersUsageInfo usageInfo = (MoveMembersUsageInfo)usage;
            PsiElement element = usage.getElement();
            if (element == null) continue;
            PsiMember member = usageInfo.member;
            if (element instanceof PsiReferenceExpression) {
                PsiExpression qualifier = ((PsiReferenceExpression)element).getQualifierExpression();
                PsiClass accessObjectClass = null;
                if (qualifier != null) {
                    accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass((PsiExpression)qualifier).getElement();
                }
                if (!JavaResolveUtil.isAccessible(member, this.myTargetClass, (PsiModifierList)modifierListCopies.get(member), element, accessObjectClass, null)) {
                    newVisibility = newVisibility == null ? VisibilityUtil.getVisibilityStringToDisplay((PsiMember)member) : newVisibility;
                    String message = CommonRefactoringUtil.capitalize((String)RefactoringBundle.message((String)"0.with.1.visibility.is.not.accesible.from.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, false), newVisibility, RefactoringUIUtil.getDescription(ConflictsUtil.getContainer(element), true)}));
                    conflicts.putValue((Object)member, (Object)message);
                }
            }
            if (!(member instanceof PsiField) || !this.myTargetClass.isInterface() || (accessDetector = ReadWriteAccessDetector.findDetector((PsiElement)member)) == null || (access = accessDetector.getExpressionAccess(element)) == ReadWriteAccessDetector.Access.Read) continue;
            conflicts.putValue((Object)element, (Object)(CommonRefactoringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)member, true)) + " has write access but is moved to an interface"));
        }
    }

    @Override
    public void doRun() {
        if (this.myMembersToMove.isEmpty()) {
            String message = RefactoringBundle.message((String)"no.members.selected");
            CommonRefactoringUtil.showErrorMessage((String)MoveMembersImpl.REFACTORING_NAME, (String)message, (String)"refactoring.moveMembers", (Project)this.myProject);
            return;
        }
        super.doRun();
    }

    private static void analyzeMoveConflicts(@NotNull Set<PsiMember> membersToMove, PsiClass targetClass, String newVisibility, MultiMap<PsiElement, String> conflicts) {
        if (membersToMove == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/move/moveMembers/MoveMembersProcessor.analyzeMoveConflicts must not be null");
        }
        for (PsiMember member : membersToMove) {
            PsiField field;
            String message;
            if (member instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)member;
                if (!MoveMembersProcessor.hasMethod(targetClass, method)) continue;
                message = RefactoringBundle.message((String)"0.already.exists.in.the.target.class", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)method, false)});
                message = CommonRefactoringUtil.capitalize((String)message);
                conflicts.putValue((Object)method, (Object)message);
                continue;
            }
            if (!(member instanceof PsiField) || !MoveMembersProcessor.hasField(targetClass, field = (PsiField)member)) continue;
            message = RefactoringBundle.message((String)"0.already.exists.in.the.target.class", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)field, false)});
            message = CommonRefactoringUtil.capitalize((String)message);
            conflicts.putValue((Object)field, (Object)message);
        }
        RefactoringConflictsUtil.analyzeAccessibilityConflicts(membersToMove, targetClass, conflicts, newVisibility);
    }

    private static boolean hasMethod(PsiClass targetClass, PsiMethod method) {
        PsiMethod[] targetClassMethods;
        for (PsiMethod method1 : targetClassMethods = targetClass.getMethods()) {
            if (!MethodSignatureUtil.areSignaturesEqual((MethodSignature)method.getSignature(PsiSubstitutor.EMPTY), (MethodSignature)method1.getSignature(PsiSubstitutor.EMPTY))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasField(PsiClass targetClass, PsiField field) {
        PsiField[] targetClassFields;
        String fieldName = field.getName();
        for (PsiField targetClassField : targetClassFields = targetClass.getFields()) {
            if (!fieldName.equals(targetClassField.getName())) continue;
            return true;
        }
        return false;
    }

    public List<PsiElement> getMembers() {
        return new ArrayList<PsiMember>(this.myMembersToMove);
    }

    public PsiClass getTargetClass() {
        return this.myTargetClass;
    }

    public static class MoveMembersUsageInfo
    extends MoveRenameUsageInfo {
        public final PsiClass qualifierClass;
        public final PsiElement reference;
        public final PsiMember member;

        public MoveMembersUsageInfo(PsiMember member, PsiElement element, PsiClass qualifierClass, PsiElement highlightElement, PsiReference ref) {
            super(highlightElement, ref, (PsiElement)member);
            this.member = member;
            this.qualifierClass = qualifierClass;
            this.reference = element;
        }
    }
}

