/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveInner;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesHandler;
import com.intellij.refactoring.move.moveInner.MoveInnerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.Nullable;

public class MoveInnerToUpperHandler
extends MoveHandlerDelegate {
    @Override
    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer) {
        if (elements.length != 1) {
            return false;
        }
        PsiElement element = elements[0];
        return MoveInnerToUpperHandler.isNonStaticInnerClass(element) && (targetContainer == null || targetContainer.equals(MoveInnerImpl.getTargetContainer((PsiClass)elements[0], false)));
    }

    private static boolean isNonStaticInnerClass(PsiElement element) {
        return element instanceof PsiClass && element.getParent() instanceof PsiClass && !((PsiClass)element).hasModifierProperty("static");
    }

    @Override
    public void doMove(Project project, PsiElement[] elements, PsiElement targetContainer, MoveCallback callback) {
        MoveInnerImpl.doMove(project, elements, callback);
    }

    @Override
    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, PsiReference reference, Editor editor) {
        if (MoveInnerToUpperHandler.isNonStaticInnerClass(element) && !MoveClassesHandler.isReferenceInAnonymousClass(reference)) {
            PsiClass aClass = (PsiClass)element;
            FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.move.moveInner");
            PsiClass containingClass = aClass.getContainingClass();
            if (containingClass instanceof JspClass) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.message((String)"move.nonstatic.class.from.jsp.not.supported"), (String)RefactoringBundle.message((String)"move.title"), null);
                return true;
            }
            MoveInnerImpl.doMove(project, new PsiElement[]{aClass}, null);
            return true;
        }
        return false;
    }
}

