/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.HelpID;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveClassesOrPackagesCallback;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.refactoring.move.moveClassesOrPackages.AutocreatingSingleSourceRootMoveDestination;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassToInnerProcessor;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesProcessor;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.MultipleRootsMoveDestination;
import com.intellij.refactoring.ui.ClassNameReferenceEditor;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveClassesOrPackagesDialog
extends RefactoringDialog {
    @NonNls
    private static final String RECENTS_KEY = "MoveClassesOrPackagesDialog.RECENTS_KEY";
    private final PsiElement[] myElementsToMove;
    private final MoveCallback myMoveCallback;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesDialog");
    private JLabel myNameLabel;
    private ReferenceEditorComboWithBrowseButton myWithBrowseButtonReference;
    private JCheckBox myCbSearchInComments;
    private JCheckBox myCbSearchTextOccurences;
    private JCheckBox myCbMoveToAnotherSourceFolder;
    private String myHelpID;
    private final boolean mySearchTextOccurencesEnabled;
    private PsiDirectory myInitialTargetDirectory;
    private final PsiManager myManager;
    private JPanel myMainPanel;
    private JRadioButton myToPackageRadioButton;
    private JRadioButton myMakeInnerClassOfRadioButton;
    private ReferenceEditorComboWithBrowseButton myClassPackageChooser;
    private JPanel myCardPanel;
    private ReferenceEditorWithBrowseButton myInnerClassChooser;
    private JPanel myMoveClassPanel;
    private JPanel myMovePackagePanel;
    private boolean myHavePackages;
    private boolean myTargetDirectoryFixed;

    public MoveClassesOrPackagesDialog(Project project, boolean searchTextOccurences, PsiElement[] elementsToMove, PsiElement initialTargetElement, MoveCallback moveCallback) {
        super(project, true);
        this.myElementsToMove = elementsToMove;
        this.myMoveCallback = moveCallback;
        this.$$$setupUI$$$();
        this.myManager = PsiManager.getInstance((Project)this.myProject);
        this.setTitle(MoveHandler.REFACTORING_NAME);
        this.mySearchTextOccurencesEnabled = searchTextOccurences;
        this.selectInitialCard();
        this.init();
        if (initialTargetElement instanceof PsiClass) {
            this.myMakeInnerClassOfRadioButton.setSelected(true);
            this.myInnerClassChooser.setText(((PsiClass)initialTargetElement).getQualifiedName());
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    MoveClassesOrPackagesDialog.this.myInnerClassChooser.requestFocus();
                }
            }, ModalityState.stateForComponent((Component)this.myMainPanel));
        } else if (initialTargetElement instanceof PsiPackage) {
            this.myClassPackageChooser.setText(((PsiPackage)initialTargetElement).getQualifiedName());
        }
        this.updateControlsEnabled();
        this.myToPackageRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MoveClassesOrPackagesDialog.this.updateControlsEnabled();
                MoveClassesOrPackagesDialog.this.myClassPackageChooser.requestFocus();
            }
        });
        this.myMakeInnerClassOfRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MoveClassesOrPackagesDialog.this.updateControlsEnabled();
                MoveClassesOrPackagesDialog.this.myInnerClassChooser.requestFocus();
            }
        });
    }

    private void updateControlsEnabled() {
        this.myClassPackageChooser.setEnabled(this.myToPackageRadioButton.isSelected());
        this.myInnerClassChooser.setEnabled(this.myMakeInnerClassOfRadioButton.isSelected());
        this.myCbMoveToAnotherSourceFolder.setEnabled(this.isMoveToPackage() && this.getSourceRoots().length > 1 && !this.myTargetDirectoryFixed);
        this.validateButtons();
    }

    private void selectInitialCard() {
        this.myHavePackages = false;
        for (PsiElement psiElement : this.myElementsToMove) {
            if (psiElement instanceof PsiClass) continue;
            this.myHavePackages = true;
            break;
        }
        CardLayout cardLayout = (CardLayout)this.myCardPanel.getLayout();
        cardLayout.show(this.myCardPanel, this.myHavePackages ? "Package" : "Class");
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myHavePackages ? (EditorComboBox)this.myWithBrowseButtonReference.getChildComponent() : (EditorComboBox)this.myClassPackageChooser.getChildComponent();
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    private void createUIComponents() {
        this.myWithBrowseButtonReference = this.createPackageChooser();
        this.myClassPackageChooser = this.createPackageChooser();
        this.myInnerClassChooser = new ClassNameReferenceEditor(PsiManager.getInstance((Project)this.myProject), null, ProjectScope.getProjectScope((Project)this.myProject));
        this.myInnerClassChooser.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                MoveClassesOrPackagesDialog.this.validateButtons();
            }
        });
        this.myCardPanel = new JPanel(){

            @Override
            public Dimension getMinimumSize() {
                return MoveClassesOrPackagesDialog.this.myHavePackages ? MoveClassesOrPackagesDialog.this.myMovePackagePanel.getMinimumSize() : MoveClassesOrPackagesDialog.this.myMoveClassPanel.getMinimumSize();
            }

            @Override
            public Dimension getPreferredSize() {
                return MoveClassesOrPackagesDialog.this.myHavePackages ? MoveClassesOrPackagesDialog.this.myMovePackagePanel.getPreferredSize() : MoveClassesOrPackagesDialog.this.myMoveClassPanel.getPreferredSize();
            }
        };
    }

    private ReferenceEditorComboWithBrowseButton createPackageChooser() {
        PackageNameReferenceEditorCombo packageChooser = new PackageNameReferenceEditorCombo("", this.myProject, RECENTS_KEY, RefactoringBundle.message((String)"choose.destination.package"));
        Document document = ((EditorComboBox)packageChooser.getChildComponent()).getDocument();
        document.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                MoveClassesOrPackagesDialog.this.validateButtons();
            }
        });
        return packageChooser;
    }

    protected JComponent createNorthPanel() {
        if (!this.mySearchTextOccurencesEnabled) {
            this.myCbSearchTextOccurences.setEnabled(false);
            this.myCbSearchTextOccurences.setVisible(false);
            this.myCbSearchTextOccurences.setSelected(false);
        }
        return this.myMainPanel;
    }

    protected String getDimensionServiceKey() {
        return this.myHavePackages ? "#com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesDialog.packages" : "#com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesDialog.classes";
    }

    public void setData(PsiElement[] psiElements, String targetPackageName, PsiDirectory initialTargetDirectory, boolean isTargetDirectoryFixed, boolean searchInComments, boolean searchForTextOccurences, String helpID) {
        String nameFromCallback;
        this.myInitialTargetDirectory = initialTargetDirectory;
        this.myTargetDirectoryFixed = isTargetDirectoryFixed;
        if (targetPackageName.length() != 0) {
            this.myWithBrowseButtonReference.prependItem(targetPackageName);
            this.myClassPackageChooser.prependItem(targetPackageName);
        }
        String string = nameFromCallback = this.myMoveCallback instanceof MoveClassesOrPackagesCallback ? ((MoveClassesOrPackagesCallback)this.myMoveCallback).getElementsToMoveName() : null;
        if (nameFromCallback != null) {
            this.myNameLabel.setText(nameFromCallback);
        } else if (psiElements.length == 1) {
            PsiElement firstElement = psiElements[0];
            PsiElement parent = firstElement.getParent();
            LOG.assertTrue(parent != null);
            this.myNameLabel.setText(RefactoringBundle.message((String)"move.single.class.or.package.name.label", (Object[])new Object[]{UsageViewUtil.getType(firstElement), UsageViewUtil.getLongName(firstElement)}));
        } else if (psiElements.length > 1) {
            this.myNameLabel.setText(psiElements[0] instanceof PsiClass ? RefactoringBundle.message((String)"move.specified.classes") : RefactoringBundle.message((String)"move.specified.packages"));
        }
        this.selectInitialCard();
        this.myCbSearchInComments.setSelected(searchInComments);
        this.myCbSearchTextOccurences.setSelected(searchForTextOccurences);
        if (this.getSourceRoots().length == 1) {
            this.myCbMoveToAnotherSourceFolder.setSelected(false);
            this.myCbMoveToAnotherSourceFolder.setEnabled(false);
        } else {
            this.myCbMoveToAnotherSourceFolder.setSelected(!isTargetDirectoryFixed);
        }
        this.validateButtons();
        this.myHelpID = helpID;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.myHelpID);
    }

    protected final boolean isSearchInComments() {
        return this.myCbSearchInComments.isSelected();
    }

    @Override
    protected void canRun() throws ConfigurationException {
        if (this.isMoveToPackage()) {
            String name = this.getTargetPackage().trim();
            if (name.length() == 0 || !JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getNameHelper().isQualifiedName(name)) {
                throw new ConfigurationException("'" + StringUtil.last((CharSequence)name, (int)10, (boolean)true) + "' is invalid destination package name");
            }
        } else {
            if (this.findTargetClass() == null) {
                throw new ConfigurationException("Destination class not found");
            }
            String validationError = this.getValidationError();
            if (validationError != null) {
                throw new ConfigurationException(validationError);
            }
        }
    }

    @Override
    protected void validateButtons() {
        super.validateButtons();
        this.setErrorText(this.getValidationError());
    }

    @Nullable
    private String getValidationError() {
        if (!this.isMoveToPackage()) {
            return this.verifyInnerClassDestination();
        }
        return null;
    }

    @Nullable
    private PsiClass findTargetClass() {
        String name = this.myInnerClassChooser.getText().trim();
        return JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findClass(name, ProjectScope.getProjectScope((Project)this.myProject));
    }

    protected boolean isMoveToPackage() {
        return this.myHavePackages || this.myToPackageRadioButton.isSelected();
    }

    protected String getTargetPackage() {
        return this.myHavePackages ? this.myWithBrowseButtonReference.getText() : this.myClassPackageChooser.getText();
    }

    @Nullable
    private static String verifyDestinationForElement(PsiElement element, MoveDestination moveDestination) {
        String message = element instanceof PsiDirectory ? moveDestination.verify((PsiDirectory)element) : (element instanceof PsiPackage ? moveDestination.verify((PsiPackage)element) : moveDestination.verify(element.getContainingFile()));
        return message;
    }

    @Override
    protected void doAction() {
        if (this.isMoveToPackage()) {
            this.invokeMoveToPackage();
        } else {
            this.invokeMoveToInner();
        }
    }

    private void invokeMoveToPackage() {
        MoveDestination destination = this.selectDestination();
        if (destination == null) {
            return;
        }
        this.saveRefactoringSettings();
        PsiManager manager = PsiManager.getInstance((Project)this.getProject());
        for (PsiElement element : this.myElementsToMove) {
            String message = MoveClassesOrPackagesDialog.verifyDestinationForElement(element, destination);
            if (message == null) continue;
            String helpId = HelpID.getMoveHelpID(this.myElementsToMove[0]);
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)message, (String)helpId, (Project)this.getProject());
            return;
        }
        try {
            for (PsiElement element : this.myElementsToMove) {
                if (!(element instanceof PsiClass)) continue;
                PsiClass aClass = (PsiClass)element;
                PsiDirectory targetDirectory = destination.getTargetIfExists(element.getContainingFile());
                if (targetDirectory == null) continue;
                manager.checkMove((PsiElement)aClass, (PsiElement)targetDirectory);
            }
            MoveClassesOrPackagesProcessor processor = this.createMoveToPackageProcessor(destination, this.myElementsToMove, this.myMoveCallback);
            if (processor.verifyValidPackageName()) {
                this.invokeRefactoring(processor);
            }
        }
        catch (IncorrectOperationException e) {
            String helpId = HelpID.getMoveHelpID(this.myElementsToMove[0]);
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)e.getMessage(), (String)helpId, (Project)this.getProject());
        }
    }

    protected MoveClassesOrPackagesProcessor createMoveToPackageProcessor(MoveDestination destination, PsiElement[] elementsToMove, MoveCallback callback) {
        return new MoveClassesOrPackagesProcessor(this.getProject(), elementsToMove, destination, this.isSearchInComments(), this.isSearchInNonJavaFiles(), callback);
    }

    private void saveRefactoringSettings() {
        JavaRefactoringSettings refactoringSettings = JavaRefactoringSettings.getInstance();
        boolean searchInComments = this.isSearchInComments();
        boolean searchForTextOccurences = this.isSearchInNonJavaFiles();
        refactoringSettings.MOVE_SEARCH_IN_COMMENTS = searchInComments;
        refactoringSettings.MOVE_SEARCH_FOR_TEXT = searchForTextOccurences;
        refactoringSettings.MOVE_PREVIEW_USAGES = this.isPreviewUsages();
    }

    @Nullable
    private String verifyInnerClassDestination() {
        PsiClass targetClass = this.findTargetClass();
        if (targetClass == null) {
            return null;
        }
        for (PsiElement element : this.myElementsToMove) {
            if (PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)targetClass, (boolean)false)) {
                return RefactoringBundle.message((String)"move.class.to.inner.move.to.self.error");
            }
            Language targetClassLanguage = targetClass.getLanguage();
            if (!element.getLanguage().equals(targetClassLanguage)) {
                return RefactoringBundle.message((String)"move.to.different.language", (Object[])new Object[]{UsageViewUtil.getType(element), ((PsiClass)element).getQualifiedName(), targetClass.getQualifiedName()});
            }
            if (!element.getLanguage().equals(Language.findLanguageByID((String)"Groovy"))) continue;
            return RefactoringBundle.message((String)"dont.support.inner.classes", (Object[])new Object[]{"Groovy"});
        }
        while (targetClass != null) {
            if (targetClass.getContainingClass() != null && !targetClass.hasModifierProperty("static")) {
                return RefactoringBundle.message((String)"move.class.to.inner.nonstatic.error");
            }
            targetClass = targetClass.getContainingClass();
        }
        return null;
    }

    private void invokeMoveToInner() {
        this.saveRefactoringSettings();
        PsiClass targetClass = this.findTargetClass();
        PsiClass[] classesToMove = new PsiClass[this.myElementsToMove.length];
        for (int i = 0; i < this.myElementsToMove.length; ++i) {
            classesToMove[i] = (PsiClass)this.myElementsToMove[i];
        }
        this.invokeRefactoring(this.createMoveToInnerProcessor(targetClass, classesToMove, this.myMoveCallback));
    }

    protected MoveClassToInnerProcessor createMoveToInnerProcessor(PsiClass destination, @NotNull PsiClass[] classesToMove, @Nullable MoveCallback callback) {
        if (classesToMove == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesDialog.createMoveToInnerProcessor must not be null");
        }
        return new MoveClassToInnerProcessor(this.getProject(), classesToMove, destination, this.isSearchInComments(), this.isSearchInNonJavaFiles(), callback);
    }

    protected final boolean isSearchInNonJavaFiles() {
        return this.myCbSearchTextOccurences.isSelected();
    }

    private MoveDestination selectDestination() {
        int ret;
        String packageName = this.getTargetPackage().trim();
        if (packageName.length() > 0 && !JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getNameHelper().isQualifiedName(packageName)) {
            Messages.showErrorDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"please.enter.a.valid.target.package.name"), (String)RefactoringBundle.message((String)"move.title"));
            return null;
        }
        RecentsManager.getInstance(this.myProject).registerRecentEntry(RECENTS_KEY, packageName);
        PackageWrapper targetPackage = new PackageWrapper(this.myManager, packageName);
        if (!targetPackage.exists() && (ret = Messages.showYesNoDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"package.does.not.exist", (Object[])new Object[]{packageName}), (String)RefactoringBundle.message((String)"move.title"), (Icon)Messages.getQuestionIcon())) != 0) {
            return null;
        }
        if (!this.myCbMoveToAnotherSourceFolder.isSelected()) {
            return new MultipleRootsMoveDestination(targetPackage);
        }
        VirtualFile[] contentSourceRoots = this.getSourceRoots();
        if (contentSourceRoots.length == 1) {
            return new AutocreatingSingleSourceRootMoveDestination(targetPackage, contentSourceRoots[0]);
        }
        VirtualFile sourceRootForFile = MoveClassesOrPackagesUtil.chooseSourceRoot(targetPackage, contentSourceRoots, this.myInitialTargetDirectory);
        if (sourceRootForFile == null) {
            return null;
        }
        return new AutocreatingSingleSourceRootMoveDestination(targetPackage, sourceRootForFile);
    }

    private VirtualFile[] getSourceRoots() {
        return ProjectRootManager.getInstance((Project)this.myProject).getContentSourceRoots();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel2;
        JLabel jLabel;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(-8355712)), null, 0, 0, null, null));
        this.myNameLabel = jLabel = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 8, 4, 8);
        jPanel3.add((Component)jLabel, gridBagConstraints);
        NonFocusableCheckBox nonFocusableCheckBox = new NonFocusableCheckBox();
        this.myCbSearchInComments = nonFocusableCheckBox;
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox, ResourceBundle.getBundle("messages/RefactoringBundle").getString("search.in.comments.and.strings"));
        nonFocusableCheckBox.setSelected(true);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(4, 8, 4, 8);
        jPanel3.add((Component)nonFocusableCheckBox, gridBagConstraints2);
        NonFocusableCheckBox nonFocusableCheckBox2 = new NonFocusableCheckBox();
        this.myCbSearchTextOccurences = nonFocusableCheckBox2;
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox2, ResourceBundle.getBundle("messages/RefactoringBundle").getString("search.for.text.occurrences"));
        nonFocusableCheckBox2.setSelected(true);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.insets = new Insets(4, 8, 4, 8);
        jPanel3.add((Component)nonFocusableCheckBox2, gridBagConstraints3);
        NonFocusableCheckBox nonFocusableCheckBox3 = new NonFocusableCheckBox();
        this.myCbMoveToAnotherSourceFolder = nonFocusableCheckBox3;
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox3, ResourceBundle.getBundle("messages/RefactoringBundle").getString("move.classes.move.to.another.source.folder"));
        nonFocusableCheckBox3.setSelected(true);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 3;
        gridBagConstraints4.gridwidth = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.insets = new Insets(4, 8, 4, 8);
        jPanel3.add((Component)nonFocusableCheckBox3, gridBagConstraints4);
        JPanel jPanel4 = this.myCardPanel;
        jPanel4.setLayout(new CardLayout(0, 0));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.gridwidth = 2;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.insets = new Insets(4, 8, 4, 8);
        jPanel3.add((Component)jPanel4, gridBagConstraints5);
        this.myMoveClassPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, "Class");
        this.myToPackageRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/RefactoringBundle").getString("move.classes.destination.to.package"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myMakeInnerClassOfRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/RefactoringBundle").getString("move.classes.destination.make.inner"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.myClassPackageChooser;
        jPanel2.add((Component)((Object)referenceEditorComboWithBrowseButton), new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 2));
        ReferenceEditorWithBrowseButton referenceEditorWithBrowseButton = this.myInnerClassChooser;
        jPanel2.add((Component)((Object)referenceEditorWithBrowseButton), new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null, 2));
        this.myMovePackagePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, "Package");
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton2 = this.myWithBrowseButtonReference;
        jPanel.add((Component)((Object)referenceEditorComboWithBrowseButton2), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("To package:");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

