/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveClassesOrPackagesCallback;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesProcessor;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesViewDescriptor;
import com.intellij.refactoring.move.moveClassesOrPackages.PackageLocalsUsageCollector;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MoveClassToInnerProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveClassesOrPackages.MoveClassToInnerProcessor");
    private PsiClass[] myClassesToMove;
    private final PsiClass myTargetClass;
    private PsiPackage[] mySourcePackage;
    private final PsiPackage myTargetPackage;
    private String[] mySourceVisibility;
    private final boolean mySearchInComments;
    private final boolean mySearchInNonJavaFiles;
    private NonCodeUsageInfo[] myNonCodeUsages;
    private static final Key<List<NonCodeUsageInfo>> ourNonCodeUsageKey = Key.create((String)"MoveClassToInner.NonCodeUsage");
    private final MoveCallback myMoveCallback;

    public MoveClassToInnerProcessor(Project project, PsiClass[] classesToMove, @NotNull PsiClass targetClass, boolean searchInComments, boolean searchInNonJavaFiles, MoveCallback moveCallback) {
        if (targetClass == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/refactoring/move/moveClassesOrPackages/MoveClassToInnerProcessor.<init> must not be null");
        }
        super(project);
        this.setClassesToMove(classesToMove);
        this.myTargetClass = targetClass;
        this.mySearchInComments = searchInComments;
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
        this.myMoveCallback = moveCallback;
        this.myTargetPackage = JavaDirectoryService.getInstance().getPackage(this.myTargetClass.getContainingFile().getContainingDirectory());
    }

    private void setClassesToMove(PsiClass[] classesToMove) {
        this.myClassesToMove = classesToMove;
        this.mySourcePackage = new PsiPackage[classesToMove.length];
        this.mySourceVisibility = new String[classesToMove.length];
        for (int i = 0; i < classesToMove.length; ++i) {
            PsiClass psiClass = classesToMove[i];
            this.mySourceVisibility[i] = VisibilityUtil.getVisibilityModifier((PsiModifierList)psiClass.getModifierList());
            this.mySourcePackage[i] = JavaDirectoryService.getInstance().getPackage(psiClass.getContainingFile().getContainingDirectory());
        }
    }

    @Override
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        return new MoveClassesOrPackagesViewDescriptor((PsiElement[])this.myClassesToMove, this.mySearchInComments, this.mySearchInNonJavaFiles, this.myTargetClass.getQualifiedName());
    }

    @Override
    @NotNull
    public UsageInfo[] findUsages() {
        ArrayList usages = new ArrayList();
        for (PsiClass classToMove : this.myClassesToMove) {
            String newName = this.myTargetClass.getQualifiedName() + "." + classToMove.getName();
            Collections.addAll(usages, MoveClassesOrPackagesUtil.findUsages((PsiElement)classToMove, this.mySearchInComments, this.mySearchInNonJavaFiles, newName));
        }
        UsageInfo[] usageInfoArray = usages.toArray(new UsageInfo[usages.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/move/moveClassesOrPackages/MoveClassToInnerProcessor.findUsages must not return null");
        }
        return usageInfoArray;
    }

    @Override
    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        return this.showConflicts(this.getConflicts((UsageInfo[])refUsages.get()));
    }

    @Override
    protected void refreshElements(final PsiElement[] elements) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiClass[] classesToMove = new PsiClass[elements.length];
                for (int i = 0; i < classesToMove.length; ++i) {
                    classesToMove[i] = (PsiClass)elements[i];
                }
                MoveClassToInnerProcessor.this.setClassesToMove(classesToMove);
            }
        });
    }

    @Override
    protected void performRefactoring(UsageInfo[] usages) {
        if (!this.prepareWritable(usages)) {
            return;
        }
        ArrayList<PsiElement> importStatements = new ArrayList<PsiElement>();
        if (!CodeStyleSettingsManager.getSettings((Project)this.myProject).INSERT_INNER_CLASS_IMPORTS) {
            usages = MoveClassToInnerProcessor.filterUsagesInImportStatements(usages, importStatements);
        } else {
            Arrays.sort(usages, new Comparator<UsageInfo>(){

                @Override
                public int compare(UsageInfo o1, UsageInfo o2) {
                    return PsiUtil.BY_POSITION.compare(o1.getElement(), o2.getElement());
                }
            });
        }
        this.saveNonCodeUsages(usages);
        HashMap<PsiElement, PsiElement> oldToNewElementsMapping = new HashMap<PsiElement, PsiElement>();
        try {
            for (PsiClass classToMove : this.myClassesToMove) {
                ChangeContextUtil.encodeContextInfo((PsiElement)classToMove, true);
                PsiClass newClass = (PsiClass)this.myTargetClass.addBefore((PsiElement)classToMove, (PsiElement)this.myTargetClass.getRBrace());
                if (this.myTargetClass.isInterface()) {
                    PsiUtil.setModifierProperty((PsiModifierListOwner)newClass, (String)"packageLocal", (boolean)true);
                } else {
                    PsiUtil.setModifierProperty((PsiModifierListOwner)newClass, (String)"static", (boolean)true);
                }
                newClass = (PsiClass)ChangeContextUtil.decodeContextInfo((PsiElement)newClass, null, null);
                oldToNewElementsMapping.put((PsiElement)classToMove, (PsiElement)newClass);
            }
            this.myNonCodeUsages = MoveClassesOrPackagesProcessor.retargetUsages(usages, oldToNewElementsMapping);
            this.retargetNonCodeUsages(oldToNewElementsMapping);
            MoveClassToInnerProcessor.retargetClassRefsInMoved(oldToNewElementsMapping);
            JavaCodeStyleManager.getInstance((Project)this.myProject).removeRedundantImports((PsiJavaFile)this.myTargetClass.getContainingFile());
            for (PsiClass classToMove : this.myClassesToMove) {
                classToMove.delete();
            }
            for (PsiElement element : importStatements) {
                if (!element.isValid()) continue;
                element.delete();
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private boolean prepareWritable(UsageInfo[] usages) {
        HashSet<Object> elementsToMakeWritable = new HashSet<Object>();
        Collections.addAll(elementsToMakeWritable, this.myClassesToMove);
        elementsToMakeWritable.add(this.myTargetClass);
        for (UsageInfo usage : usages) {
            PsiElement element = usage.getElement();
            if (element == null) continue;
            elementsToMakeWritable.add(element);
        }
        return CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement[])elementsToMakeWritable.toArray(new PsiElement[elementsToMakeWritable.size()]));
    }

    private void saveNonCodeUsages(UsageInfo[] usages) {
        for (PsiClass classToMove : this.myClassesToMove) {
            for (UsageInfo usageInfo : usages) {
                NonCodeUsageInfo nonCodeUsage;
                PsiElement element;
                if (!(usageInfo instanceof NonCodeUsageInfo) || (element = (nonCodeUsage = (NonCodeUsageInfo)usageInfo).getElement()) == null || !PsiTreeUtil.isAncestor((PsiElement)classToMove, (PsiElement)element, (boolean)false)) continue;
                ArrayList<NonCodeUsageInfo> list = (ArrayList<NonCodeUsageInfo>)element.getCopyableUserData(ourNonCodeUsageKey);
                if (list == null) {
                    list = new ArrayList<NonCodeUsageInfo>();
                    element.putCopyableUserData(ourNonCodeUsageKey, list);
                }
                list.add(nonCodeUsage);
            }
        }
    }

    private void retargetNonCodeUsages(Map<PsiElement, PsiElement> oldToNewElementMap) {
        for (PsiElement newClass : oldToNewElementMap.values()) {
            newClass.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(PsiElement element) {
                    super.visitElement(element);
                    List list = (List)element.getCopyableUserData(ourNonCodeUsageKey);
                    if (list != null) {
                        block0: for (NonCodeUsageInfo info : list) {
                            for (int i = 0; i < MoveClassToInnerProcessor.this.myNonCodeUsages.length; ++i) {
                                if (MoveClassToInnerProcessor.this.myNonCodeUsages[i] != info) continue;
                                ((MoveClassToInnerProcessor)MoveClassToInnerProcessor.this).myNonCodeUsages[i] = info.replaceElement(element);
                                continue block0;
                            }
                        }
                        element.putCopyableUserData(ourNonCodeUsageKey, null);
                    }
                }
            });
        }
    }

    @Override
    protected void performPsiSpoilingRefactoring() {
        if (this.myNonCodeUsages != null) {
            RenameUtil.renameNonCodeUsages(this.myProject, this.myNonCodeUsages);
        }
        if (this.myMoveCallback != null) {
            if (this.myMoveCallback instanceof MoveClassesOrPackagesCallback) {
                ((MoveClassesOrPackagesCallback)this.myMoveCallback).classesMovedToInner(this.myTargetClass);
            }
            this.myMoveCallback.refactoringCompleted();
        }
    }

    private static void retargetClassRefsInMoved(final Map<PsiElement, PsiElement> oldToNewElementsMapping) {
        for (PsiElement newClass : oldToNewElementsMapping.values()) {
            newClass.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                    PsiElement element = reference.resolve();
                    if (element instanceof PsiClass) {
                        for (PsiElement oldClass : oldToNewElementsMapping.keySet()) {
                            if (!PsiTreeUtil.isAncestor((PsiElement)oldClass, (PsiElement)element, (boolean)false)) continue;
                            PsiClass newInnerClass = MoveClassToInnerProcessor.findMatchingClass((PsiClass)oldClass, (PsiClass)oldToNewElementsMapping.get(oldClass), (PsiClass)element);
                            try {
                                reference.bindToElement((PsiElement)newInnerClass);
                                return;
                            }
                            catch (IncorrectOperationException ex) {
                                LOG.error((Throwable)ex);
                            }
                        }
                    }
                    super.visitReferenceElement(reference);
                }
            });
        }
    }

    private static PsiClass findMatchingClass(PsiClass classToMove, PsiClass newClass, PsiClass innerClass) {
        if (classToMove == innerClass) {
            return newClass;
        }
        PsiClass parentClass = MoveClassToInnerProcessor.findMatchingClass(classToMove, newClass, innerClass.getContainingClass());
        PsiClass newInnerClass = parentClass.findInnerClassByName(innerClass.getName(), false);
        assert (newInnerClass != null);
        return newInnerClass;
    }

    private static UsageInfo[] filterUsagesInImportStatements(UsageInfo[] usages, List<PsiElement> importStatements) {
        ArrayList<UsageInfo> remainingUsages = new ArrayList<UsageInfo>();
        for (UsageInfo usage : usages) {
            PsiElement element = usage.getElement();
            if (element == null) continue;
            PsiImportStatement stmt = (PsiImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class);
            if (stmt != null) {
                importStatements.add((PsiElement)stmt);
                continue;
            }
            remainingUsages.add(usage);
        }
        return remainingUsages.toArray(new UsageInfo[remainingUsages.size()]);
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"move.class.to.inner.command.name", (Object[])new Object[]{(this.myClassesToMove.length > 1 ? "classes " : "class ") + StringUtil.join((Object[])this.myClassesToMove, (Function)new Function<PsiClass, String>(){

            public String fun(PsiClass psiClass) {
                return psiClass.getName();
            }
        }, (String)", "), this.myTargetClass.getQualifiedName()});
    }

    @Override
    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/move/moveClassesOrPackages/MoveClassToInnerProcessor.getElementsToWrite must not be null");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(super.getElementsToWrite(descriptor));
        result.add(this.myTargetClass);
        ArrayList<Object> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/move/moveClassesOrPackages/MoveClassToInnerProcessor.getElementsToWrite must not return null");
        }
        return arrayList;
    }

    public MultiMap<PsiElement, String> getConflicts(UsageInfo[] usages) {
        MultiMap conflicts = new MultiMap();
        for (PsiClass classToMove : this.myClassesToMove) {
            PsiClass innerClass = this.myTargetClass.findInnerClassByName(classToMove.getName(), false);
            if (innerClass == null) continue;
            conflicts.putValue((Object)innerClass, (Object)RefactoringBundle.message((String)"move.to.inner.duplicate.inner.class", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)this.myTargetClass.getQualifiedName()), CommonRefactoringUtil.htmlEmphasize((String)classToMove.getName())}));
        }
        for (int i = 0; i < this.myClassesToMove.length; ++i) {
            boolean moveToOtherPackage;
            PsiClass classToMove = this.myClassesToMove[i];
            String classToMoveVisibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)classToMove.getModifierList());
            String targetClassVisibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)this.myTargetClass.getModifierList());
            boolean bl = moveToOtherPackage = !Comparing.equal((Object)this.mySourcePackage[i], (Object)this.myTargetPackage);
            if (moveToOtherPackage) {
                classToMove.accept((PsiElementVisitor)new PackageLocalsUsageCollector((PsiElement[])this.myClassesToMove, new PackageWrapper(this.myTargetPackage), (MultiMap<PsiElement, String>)conflicts));
            }
            ConflictsCollector collector = new ConflictsCollector(classToMove, (MultiMap<PsiElement, String>)conflicts);
            if (moveToOtherPackage && (classToMoveVisibility.equals("packageLocal") || targetClassVisibility.equals("packageLocal")) || targetClassVisibility.equals("private")) {
                this.detectInaccessibleClassUsages(usages, collector, this.mySourceVisibility[i]);
            }
            if (!moveToOtherPackage) continue;
            this.detectInaccessibleMemberUsages(collector);
        }
        return conflicts;
    }

    private void detectInaccessibleClassUsages(UsageInfo[] usages, ConflictsCollector collector, String visibility) {
        for (UsageInfo usage : usages) {
            PsiElement element;
            if (!(usage instanceof MoveRenameUsageInfo) || usage instanceof NonCodeUsageInfo || (element = usage.getElement()) == null || PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class) != null || !this.isInaccessibleFromTarget(element, visibility)) continue;
            collector.addConflict(collector.getClassToMove(), element);
        }
    }

    private boolean isInaccessibleFromTarget(PsiElement element, String visibility) {
        PsiPackage elementPackage = JavaDirectoryService.getInstance().getPackage(element.getContainingFile().getContainingDirectory());
        return !PsiUtil.isAccessible((PsiMember)this.myTargetClass, (PsiElement)element, null) || !this.myTargetClass.isInterface() && visibility.equals("packageLocal") && !Comparing.equal((Object)elementPackage, (Object)this.myTargetPackage);
    }

    private void detectInaccessibleMemberUsages(final ConflictsCollector collector) {
        PsiElement[] members;
        for (PsiElement member : members = MoveClassToInnerProcessor.collectPackageLocalMembers(collector.getClassToMove())) {
            ReferencesSearch.search((PsiElement)member).forEach((Processor)new Processor<PsiReference>(){

                public boolean process(PsiReference psiReference) {
                    PsiElement element = psiReference.getElement();
                    if (MoveClassToInnerProcessor.this.isInaccessibleFromTarget(element, "packageLocal")) {
                        collector.addConflict(psiReference.resolve(), element);
                    }
                    return true;
                }
            });
        }
    }

    private static PsiElement[] collectPackageLocalMembers(PsiElement classToMove) {
        return PsiTreeUtil.collectElements((PsiElement)classToMove, (PsiElementFilter)new PsiElementFilter(){

            public boolean isAccepted(PsiElement element) {
                PsiMember member;
                return element instanceof PsiMember && VisibilityUtil.getVisibilityModifier((PsiModifierList)(member = (PsiMember)element).getModifierList()) == "packageLocal";
            }
        });
    }

    private static class ConflictsCollector {
        private final PsiClass myClassToMove;
        private final MultiMap<PsiElement, String> myConflicts;
        private final Set<PsiElement> myReportedContainers = new HashSet<PsiElement>();

        public ConflictsCollector(PsiClass classToMove, MultiMap<PsiElement, String> conflicts) {
            this.myClassToMove = classToMove;
            this.myConflicts = conflicts;
        }

        public void addConflict(PsiElement targetElement, PsiElement sourceElement) {
            PsiElement container = ConflictsUtil.getContainer(sourceElement);
            if (!this.myReportedContainers.contains(container)) {
                this.myReportedContainers.add(container);
                String targetDescription = targetElement == this.myClassToMove ? "Class " + CommonRefactoringUtil.htmlEmphasize((String)this.myClassToMove.getName()) : StringUtil.capitalize((String)RefactoringUIUtil.getDescription(targetElement, true));
                String message = RefactoringBundle.message((String)"element.will.no.longer.be.accessible", (Object[])new Object[]{targetDescription, RefactoringUIUtil.getDescription(container, true)});
                this.myConflicts.putValue((Object)targetElement, (Object)message);
            }
        }

        public PsiElement getClassToMove() {
            return this.myClassToMove;
        }
    }
}

