/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceParameter.ClassMemberInExprUsageInfo;
import com.intellij.refactoring.introduceParameter.LocalVariableInExprUsageInfo;
import com.intellij.refactoring.introduceParameter.ParameterInExprUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Util {
    public static void analyzeExpression(PsiExpression expr, List<UsageInfo> localVars, List<UsageInfo> classMemberRefs, List<UsageInfo> params) {
        PsiElement[] children;
        if (expr instanceof PsiThisExpression || expr instanceof PsiSuperExpression) {
            classMemberRefs.add(new ClassMemberInExprUsageInfo((PsiElement)expr));
        } else if (expr instanceof PsiReferenceExpression) {
            PsiReferenceExpression refExpr = (PsiReferenceExpression)expr;
            PsiElement subj = refExpr.resolve();
            if (subj instanceof PsiParameter) {
                params.add(new ParameterInExprUsageInfo((PsiElement)refExpr));
            } else if (subj instanceof PsiLocalVariable) {
                localVars.add(new LocalVariableInExprUsageInfo((PsiElement)refExpr));
            } else if (subj instanceof PsiField || subj instanceof PsiMethod) {
                classMemberRefs.add(new ClassMemberInExprUsageInfo((PsiElement)refExpr));
            }
        }
        for (PsiElement child : children = expr.getChildren()) {
            if (!(child instanceof PsiExpression)) continue;
            Util.analyzeExpression((PsiExpression)child, localVars, classMemberRefs, params);
        }
    }

    public static PsiMethod getContainingMethod(PsiElement expr) {
        return (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiMethod.class);
    }

    public static boolean anyFieldsWithGettersPresent(List<UsageInfo> classMemberRefs) {
        for (UsageInfo usageInfo : classMemberRefs) {
            PsiElement e;
            if (!(usageInfo.getElement() instanceof PsiReferenceExpression) || !((e = ((PsiReferenceExpression)usageInfo.getElement()).resolve()) instanceof PsiField)) continue;
            PsiField psiField = (PsiField)e;
            PsiMethod getterPrototype = PropertyUtil.generateGetterPrototype((PsiField)psiField);
            PsiMethod getter = psiField.getContainingClass().findMethodBySignature(getterPrototype, true);
            if (getter == null) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static TIntArrayList findParametersToRemove(@NotNull PsiMethod method, final @NotNull PsiExpression expr) {
        TIntArrayList tIntArrayList;
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/introduceParameter/Util.findParametersToRemove must not be null");
        }
        if (expr == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/introduceParameter/Util.findParametersToRemove must not be null");
        }
        final PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length == 0) {
            tIntArrayList = new TIntArrayList();
            if (tIntArrayList == null) throw new IllegalStateException("@NotNull method com/intellij/refactoring/introduceParameter/Util.findParametersToRemove must not return null");
            return tIntArrayList;
        }
        Object[] overridingMethods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)method.getUseScope(), (boolean)true).toArray((Object[])PsiMethod.EMPTY_ARRAY);
        PsiMethod[] allMethods = (PsiMethod[])ArrayUtil.append((Object[])overridingMethods, (Object)method);
        final TIntHashSet suspects = new TIntHashSet();
        expr.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                int i;
                super.visitReferenceExpression(expression);
                PsiElement resolved = expression.resolve();
                if (resolved instanceof PsiParameter && (i = ArrayUtil.find((Object[])parameters, (Object)resolved)) != -1) {
                    suspects.add(i);
                }
            }
        });
        final TIntIterator iterator = suspects.iterator();
        block0: while (true) {
            if (!iterator.hasNext()) {
                tIntArrayList = new TIntArrayList(suspects.toArray());
                if (tIntArrayList != null) return tIntArrayList;
                throw new IllegalStateException("@NotNull method com/intellij/refactoring/introduceParameter/Util.findParametersToRemove must not return null");
            }
            int paramNum = iterator.next();
            PsiMethod[] arr$ = allMethods;
            int len$ = arr$.length;
            int i$ = 0;
            while (true) {
                PsiParameter parameter;
                PsiMethod psiMethod;
                PsiParameter[] psiParameters;
                if (i$ >= len$ || paramNum < (psiParameters = (psiMethod = arr$[i$]).getParameterList().getParameters()).length && !ReferencesSearch.search((PsiElement)(parameter = psiParameters[paramNum]), (SearchScope)parameter.getResolveScope(), (boolean)false).forEach((Processor)new Processor<PsiReference>(){

                    public boolean process(PsiReference reference) {
                        boolean stillCanBeRemoved;
                        PsiElement element = reference.getElement();
                        boolean bl = stillCanBeRemoved = element != null && (PsiTreeUtil.isAncestor((PsiElement)expr, (PsiElement)element, (boolean)false) || PsiUtil.isInsideJavadocComment((PsiElement)element));
                        if (!stillCanBeRemoved) {
                            iterator.remove();
                            return false;
                        }
                        return true;
                    }
                })) continue block0;
                ++i$;
            }
            break;
        }
    }
}

