/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.codeInsight.TestUtil;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.Modifier;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.introduceField.IntroduceFieldHandler;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.NameSuggestionsGenerator;
import com.intellij.refactoring.ui.NameSuggestionsManager;
import com.intellij.refactoring.ui.TypeSelector;
import com.intellij.refactoring.ui.TypeSelectorManager;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.StateRestoringCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class IntroduceFieldDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.introduceField.IntroduceFieldDialog");
    private static boolean ourLastCbFinalState = false;
    private static BaseExpressionToFieldHandler.InitializationPlace ourLastInitializerPlace;
    private final Project myProject;
    private final PsiClass myParentClass;
    private final PsiExpression myInitializerExpression;
    private final PsiLocalVariable myLocalVariable;
    private final boolean myIsCurrentMethodConstructor;
    private final boolean myIsInvokedOnDeclaration;
    private final boolean myWillBeDeclaredStatic;
    private final int myOccurrencesCount;
    private final boolean myAllowInitInMethod;
    private final boolean myAllowInitInMethodIfAll;
    private final TypeSelectorManager myTypeSelectorManager;
    private NameSuggestionsField myNameField;
    private JCheckBox myCbReplaceAll;
    private StateRestoringCheckBox myCbDeleteVariable;
    private StateRestoringCheckBox myCbFinal;
    private JRadioButton myRbInConstructor;
    private JRadioButton myRbInCurrentMethod;
    private JRadioButton myRbInFieldDeclaration;
    private JRadioButton myRbInSetUp;
    private JRadioButton myRbPrivate;
    private JRadioButton myRbProtected;
    private JRadioButton myRbPackageLocal;
    private JRadioButton myRbPublic;
    private TypeSelector myTypeSelector;
    private NameSuggestionsManager myNameSuggestionsManager;
    private static final String REFACTORING_NAME;

    public IntroduceFieldDialog(Project project, PsiClass parentClass, PsiExpression initializerExpression, PsiLocalVariable localVariable, boolean isCurrentMethodConstructor, boolean isInvokedOnDeclaration, boolean willBeDeclaredStatic, int occurrencesCount, boolean allowInitInMethod, boolean allowInitInMethodIfAll, TypeSelectorManager typeSelectorManager) {
        super(project, true);
        this.myProject = project;
        this.myParentClass = parentClass;
        this.myInitializerExpression = initializerExpression;
        this.myLocalVariable = localVariable;
        this.myIsCurrentMethodConstructor = isCurrentMethodConstructor;
        this.myIsInvokedOnDeclaration = isInvokedOnDeclaration;
        this.myWillBeDeclaredStatic = willBeDeclaredStatic;
        this.myOccurrencesCount = occurrencesCount;
        this.myAllowInitInMethod = allowInitInMethod;
        this.myAllowInitInMethodIfAll = allowInitInMethodIfAll;
        this.myTypeSelectorManager = typeSelectorManager;
        this.setTitle(REFACTORING_NAME);
        this.init();
        this.initializeControls(initializerExpression);
    }

    private void initializeControls(PsiExpression initializerExpression) {
        if (initializerExpression != null) {
            this.setEnabledInitializationPlaces((PsiElement)initializerExpression, (PsiElement)initializerExpression);
            if (!this.myAllowInitInMethod) {
                this.myRbInCurrentMethod.setEnabled(false);
            }
        } else {
            this.myRbInConstructor.setEnabled(false);
            this.myRbInCurrentMethod.setEnabled(false);
            this.myRbInFieldDeclaration.setEnabled(false);
            if (this.myRbInSetUp != null) {
                this.myRbInSetUp.setEnabled(false);
            }
        }
        if (ourLastInitializerPlace == BaseExpressionToFieldHandler.InitializationPlace.IN_CONSTRUCTOR) {
            if (this.myRbInConstructor.isEnabled()) {
                this.myRbInConstructor.setSelected(true);
            } else {
                this.selectInCurrentMethod();
            }
        } else if (ourLastInitializerPlace == BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION) {
            if (this.myRbInFieldDeclaration.isEnabled()) {
                this.myRbInFieldDeclaration.setSelected(true);
            } else {
                this.selectInCurrentMethod();
            }
        } else if (ourLastInitializerPlace == BaseExpressionToFieldHandler.InitializationPlace.IN_SETUP_METHOD && TestUtil.isTestClass((PsiClass)this.myParentClass) && this.myRbInSetUp.isEnabled()) {
            this.myRbInSetUp.setSelected(true);
        } else {
            this.selectInCurrentMethod();
        }
        String ourLastVisibility = JavaRefactoringSettings.getInstance().INTRODUCE_FIELD_VISIBILITY;
        if ("public".equals(ourLastVisibility)) {
            this.myRbPublic.setSelected(true);
        } else if ("protected".equals(ourLastVisibility)) {
            this.myRbProtected.setSelected(true);
        } else if ("packageLocal".equals(ourLastVisibility)) {
            this.myRbPackageLocal.setSelected(true);
        } else if ("private".equals(ourLastVisibility)) {
            this.myRbPrivate.setSelected(true);
        } else {
            this.myRbPrivate.setSelected(true);
        }
        this.myCbFinal.setSelected(this.myCbFinal.isEnabled() && ourLastCbFinalState);
    }

    private void selectInCurrentMethod() {
        if (this.myRbInCurrentMethod.isEnabled()) {
            this.myRbInCurrentMethod.setSelected(true);
        } else if (this.myRbInFieldDeclaration.isEnabled()) {
            this.myRbInFieldDeclaration.setSelected(true);
        } else {
            this.myRbInCurrentMethod.setSelected(true);
        }
    }

    public String getEnteredName() {
        return this.myNameField.getEnteredName();
    }

    public BaseExpressionToFieldHandler.InitializationPlace getInitializerPlace() {
        if (this.myRbInConstructor.isSelected()) {
            return BaseExpressionToFieldHandler.InitializationPlace.IN_CONSTRUCTOR;
        }
        if (this.myRbInCurrentMethod.isSelected()) {
            return BaseExpressionToFieldHandler.InitializationPlace.IN_CURRENT_METHOD;
        }
        if (this.myRbInFieldDeclaration.isSelected()) {
            return BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION;
        }
        if (this.myRbInSetUp != null && this.myRbInSetUp.isSelected()) {
            return BaseExpressionToFieldHandler.InitializationPlace.IN_SETUP_METHOD;
        }
        LOG.assertTrue(false);
        return BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION;
    }

    @Modifier
    public String getFieldVisibility() {
        if (this.myRbPublic.isSelected()) {
            return "public";
        }
        if (this.myRbPackageLocal.isSelected()) {
            return "packageLocal";
        }
        if (this.myRbProtected.isSelected()) {
            return "protected";
        }
        if (this.myRbPrivate.isSelected()) {
            return "private";
        }
        LOG.assertTrue(false);
        return null;
    }

    public boolean isReplaceAllOccurrences() {
        if (this.myIsInvokedOnDeclaration) {
            return true;
        }
        if (this.myOccurrencesCount <= 1) {
            return false;
        }
        return this.myCbReplaceAll.isSelected();
    }

    public boolean isDeleteVariable() {
        if (this.myIsInvokedOnDeclaration) {
            return true;
        }
        if (this.myCbDeleteVariable == null) {
            return false;
        }
        return this.myCbDeleteVariable.isSelected();
    }

    public boolean isDeclareFinal() {
        return this.myCbFinal.isSelected();
    }

    public PsiType getFieldType() {
        return this.myTypeSelector.getSelectedType();
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(4, 4, 4, 0);
        gbConstraints.anchor = 13;
        gbConstraints.fill = 1;
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        JLabel type = new JLabel(this.getTypeLabel());
        panel.add((Component)type, gbConstraints);
        ++gbConstraints.gridx;
        gbConstraints.insets = new Insets(4, 0, 4, 4);
        gbConstraints.weightx = 0.0;
        this.myTypeSelector = this.myTypeSelectorManager.getTypeSelector();
        panel.add((Component)this.myTypeSelector.getComponent(), gbConstraints);
        gbConstraints.insets = new Insets(4, 4, 4, 0);
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 1;
        JLabel namePrompt = new JLabel(RefactoringBundle.message((String)"name.prompt"));
        panel.add((Component)namePrompt, gbConstraints);
        gbConstraints.insets = new Insets(4, 0, 4, 4);
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 1;
        gbConstraints.gridy = 1;
        this.myNameField = new NameSuggestionsField(this.myProject);
        panel.add((Component)this.myNameField.getComponent(), gbConstraints);
        namePrompt.setLabelFor(this.myNameField.getFocusableComponent());
        this.myNameSuggestionsManager = new NameSuggestionsManager(this.myTypeSelector, this.myNameField, this.createGenerator());
        this.myNameSuggestionsManager.setLabelsFor(type, namePrompt);
        return panel;
    }

    private String getTypeLabel() {
        return this.myWillBeDeclaredStatic ? RefactoringBundle.message((String)"introduce.field.static.field.of.type") : RefactoringBundle.message((String)"introduce.field.field.of.type");
    }

    protected JComponent createCenterPanel() {
        Insets standardInsets;
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 2;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        gbConstraints.insets = standardInsets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.createInitializerPlacePanel(), gbConstraints);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (IntroduceFieldDialog.this.myCbReplaceAll != null && IntroduceFieldDialog.this.myAllowInitInMethod) {
                    IntroduceFieldDialog.this.myRbInCurrentMethod.setEnabled(IntroduceFieldDialog.this.myAllowInitInMethodIfAll || !IntroduceFieldDialog.this.myCbReplaceAll.isSelected());
                    if (!IntroduceFieldDialog.this.myRbInCurrentMethod.isEnabled() && IntroduceFieldDialog.this.myRbInCurrentMethod.isSelected()) {
                        IntroduceFieldDialog.this.myRbInCurrentMethod.setSelected(false);
                        IntroduceFieldDialog.this.myRbInFieldDeclaration.setSelected(true);
                    }
                }
                IntroduceFieldDialog.this.updateTypeSelector();
                IntroduceFieldDialog.this.myNameField.requestFocusInWindow();
            }
        };
        ItemListener finalUpdater = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                IntroduceFieldDialog.this.updateCbFinal();
            }
        };
        this.myRbInConstructor.addItemListener(itemListener);
        this.myRbInCurrentMethod.addItemListener(itemListener);
        this.myRbInFieldDeclaration.addItemListener(itemListener);
        this.myRbInConstructor.addItemListener(finalUpdater);
        this.myRbInCurrentMethod.addItemListener(finalUpdater);
        this.myRbInFieldDeclaration.addItemListener(finalUpdater);
        if (this.myRbInSetUp != null) {
            this.myRbInSetUp.addItemListener(finalUpdater);
        }
        if (this.myOccurrencesCount > 1) {
            this.myCbReplaceAll = new NonFocusableCheckBox();
            this.myCbReplaceAll.setText(RefactoringBundle.message((String)"replace.all.occurrences.of.expression.0.occurrences", (Object[])new Object[]{this.myOccurrencesCount}));
            ++gbConstraints.gridy;
            panel.add((Component)this.myCbReplaceAll, gbConstraints);
            this.myCbReplaceAll.addItemListener(itemListener);
            if (this.myIsInvokedOnDeclaration) {
                this.myCbReplaceAll.setEnabled(false);
                this.myCbReplaceAll.setSelected(true);
            }
        }
        if (this.myLocalVariable != null) {
            ++gbConstraints.gridy;
            if (this.myCbReplaceAll != null) {
                gbConstraints.insets = new Insets(0, 8, 0, 0);
            }
            this.myCbDeleteVariable = new StateRestoringCheckBox();
            this.myCbDeleteVariable.setText(RefactoringBundle.message((String)"delete.variable.declaration"));
            panel.add((Component)this.myCbDeleteVariable, gbConstraints);
            if (this.myIsInvokedOnDeclaration) {
                this.myCbDeleteVariable.setEnabled(false);
                this.myCbDeleteVariable.setSelected(true);
            } else if (this.myCbReplaceAll != null) {
                this.updateCbDeleteVariable();
                this.myCbReplaceAll.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        IntroduceFieldDialog.this.updateCbDeleteVariable();
                    }
                });
            }
            gbConstraints.insets = standardInsets;
        }
        this.myCbFinal.addItemListener(itemListener);
        this.updateTypeSelector();
        return panel;
    }

    private void updateTypeSelector() {
        if (this.myCbReplaceAll != null) {
            this.myTypeSelectorManager.setAllOccurences(this.myCbReplaceAll.isSelected());
        } else {
            this.myTypeSelectorManager.setAllOccurences(false);
        }
    }

    private void updateCbDeleteVariable() {
        if (!this.myCbReplaceAll.isSelected()) {
            this.myCbDeleteVariable.makeUnselectable(false);
        } else {
            this.myCbDeleteVariable.makeSelectable();
        }
    }

    private JComponent createInitializerPlacePanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        JPanel initializationPanel = new JPanel();
        initializationPanel.setBorder(IdeBorderFactory.createTitledBorder((String)RefactoringBundle.message((String)"initialize.in.border.title")));
        initializationPanel.setLayout(new BoxLayout(initializationPanel, 1));
        JPanel visibilityPanel = new JPanel();
        visibilityPanel.setBorder(IdeBorderFactory.createTitledBorder((String)RefactoringBundle.message((String)"visibility.border.title")));
        visibilityPanel.setLayout(new BoxLayout(visibilityPanel, 1));
        this.myRbInCurrentMethod = new JRadioButton();
        this.myRbInCurrentMethod.setText(RefactoringBundle.message((String)"current.method.radio"));
        this.myRbInCurrentMethod.setEnabled(this.myAllowInitInMethod);
        this.myRbInFieldDeclaration = new JRadioButton();
        this.myRbInFieldDeclaration.setText(RefactoringBundle.message((String)"field.declaration.radio"));
        this.myRbInConstructor = new JRadioButton();
        this.myRbInConstructor.setText(RefactoringBundle.message((String)"class.constructors.radio"));
        this.myRbPrivate = new JRadioButton();
        this.myRbPrivate.setText(RefactoringBundle.message((String)"visibility.private"));
        this.myRbPrivate.setFocusable(false);
        this.myRbPackageLocal = new JRadioButton();
        this.myRbPackageLocal.setText(RefactoringBundle.message((String)"visibility.package.local"));
        this.myRbPackageLocal.setFocusable(false);
        this.myRbProtected = new JRadioButton();
        this.myRbProtected.setText(RefactoringBundle.message((String)"visibility.protected"));
        this.myRbProtected.setFocusable(false);
        this.myRbPublic = new JRadioButton();
        this.myRbPublic.setText(RefactoringBundle.message((String)"visibility.public"));
        this.myRbPublic.setFocusable(false);
        this.myCbFinal = new StateRestoringCheckBox();
        this.myCbFinal.setText(RefactoringBundle.message((String)"declare.final"));
        initializationPanel.add(this.myRbInCurrentMethod);
        initializationPanel.add(this.myRbInFieldDeclaration);
        initializationPanel.add(this.myRbInConstructor);
        if (TestUtil.isTestClass((PsiClass)this.myParentClass)) {
            this.myRbInSetUp = new JRadioButton();
            this.myRbInSetUp.setText(RefactoringBundle.message((String)"setup.method.radio"));
            initializationPanel.add(this.myRbInSetUp);
        }
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.myRbInCurrentMethod);
        bg.add(this.myRbInFieldDeclaration);
        bg.add(this.myRbInConstructor);
        if (this.myRbInSetUp != null) {
            bg.add(this.myRbInSetUp);
        }
        visibilityPanel.add(this.myRbPrivate);
        visibilityPanel.add(this.myRbPackageLocal);
        visibilityPanel.add(this.myRbProtected);
        visibilityPanel.add(this.myRbPublic);
        bg = new ButtonGroup();
        bg.add(this.myRbPrivate);
        bg.add(this.myRbPackageLocal);
        bg.add(this.myRbProtected);
        bg.add(this.myRbPublic);
        JPanel groupPanel = new JPanel(new GridLayout(1, 2));
        groupPanel.add(initializationPanel);
        groupPanel.add(visibilityPanel);
        mainPanel.add((Component)groupPanel, "Center");
        mainPanel.add((Component)this.myCbFinal, "South");
        return mainPanel;
    }

    private void updateCbFinal() {
        boolean allowFinal;
        boolean bl = allowFinal = this.myRbInFieldDeclaration.isSelected() || this.myRbInConstructor.isSelected() && !this.myWillBeDeclaredStatic;
        if (this.myRbInCurrentMethod.isSelected() && this.myIsCurrentMethodConstructor) {
            PsiMethod[] constructors = this.myParentClass.getConstructors();
            boolean bl2 = allowFinal = constructors.length <= 1;
        }
        if (!allowFinal) {
            this.myCbFinal.makeUnselectable(false);
        } else {
            this.myCbFinal.makeSelectable();
        }
    }

    private NameSuggestionsGenerator createGenerator() {
        return new NameSuggestionsGenerator(){
            private final JavaCodeStyleManager myCodeStyleManager;
            {
                this.myCodeStyleManager = JavaCodeStyleManager.getInstance((Project)IntroduceFieldDialog.this.myProject);
            }

            @Override
            public SuggestedNameInfo getSuggestedNameInfo(PsiType type) {
                VariableKind variableKind = IntroduceFieldDialog.this.myWillBeDeclaredStatic ? VariableKind.STATIC_FIELD : VariableKind.FIELD;
                String propertyName = null;
                if (IntroduceFieldDialog.this.myIsInvokedOnDeclaration) {
                    propertyName = this.myCodeStyleManager.variableNameToPropertyName(IntroduceFieldDialog.this.myLocalVariable.getName(), VariableKind.LOCAL_VARIABLE);
                }
                SuggestedNameInfo nameInfo = this.myCodeStyleManager.suggestVariableName(variableKind, propertyName, IntroduceFieldDialog.this.myInitializerExpression, type);
                String[] strings = JavaCompletionUtil.completeVariableNameForRefactoring(this.myCodeStyleManager, type, VariableKind.LOCAL_VARIABLE, nameInfo);
                return new SuggestedNameInfo.Delegate(strings, nameInfo);
            }
        };
    }

    protected void doOKAction() {
        int answer;
        String fieldName = this.getEnteredName();
        String errorString = null;
        if ("".equals(fieldName)) {
            errorString = RefactoringBundle.message((String)"no.field.name.specified");
        } else if (!JavaPsiFacade.getInstance((Project)this.myProject).getNameHelper().isIdentifier(fieldName)) {
            errorString = RefactoringMessageUtil.getIncorrectIdentifierMessage(fieldName);
        }
        if (errorString != null) {
            CommonRefactoringUtil.showErrorMessage((String)IntroduceFieldHandler.REFACTORING_NAME, (String)errorString, (String)"refactoring.introduceField", (Project)this.myProject);
            return;
        }
        PsiField oldField = this.myParentClass.findFieldByName(fieldName, true);
        if (oldField != null && (answer = Messages.showYesNoDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"field.exists", (Object[])new Object[]{fieldName, oldField.getContainingClass().getQualifiedName()}), (String)IntroduceFieldHandler.REFACTORING_NAME, (Icon)Messages.getWarningIcon())) != 0) {
            return;
        }
        ourLastCbFinalState = this.myCbFinal.isSelected();
        ourLastInitializerPlace = this.getInitializerPlace();
        JavaRefactoringSettings.getInstance().INTRODUCE_FIELD_VISIBILITY = this.getFieldVisibility();
        this.myNameSuggestionsManager.nameSelected();
        super.doOKAction();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField.getFocusableComponent();
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.introduceField");
    }

    private boolean setEnabledInitializationPlaces(PsiElement initializerPart, PsiElement initializer) {
        PsiElement[] children;
        PsiElement refElement;
        PsiReferenceExpression refExpr;
        if (initializerPart instanceof PsiReferenceExpression && (refExpr = (PsiReferenceExpression)initializerPart).getQualifierExpression() == null && ((refElement = refExpr.resolve()) == null || (refElement instanceof PsiLocalVariable || refElement instanceof PsiParameter) && !PsiTreeUtil.isAncestor((PsiElement)initializer, (PsiElement)refElement, (boolean)true))) {
            this.myRbInFieldDeclaration.setEnabled(false);
            this.myRbInConstructor.setEnabled(false);
            if (this.myRbInSetUp != null) {
                this.myRbInSetUp.setEnabled(false);
            }
            this.myCbFinal.setEnabled(false);
            return false;
        }
        for (PsiElement child : children = initializerPart.getChildren()) {
            if (this.setEnabledInitializationPlaces(child, initializer)) continue;
            return false;
        }
        return true;
    }

    static {
        REFACTORING_NAME = RefactoringBundle.message((String)"introduce.field.title");
    }
}

