/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractSuperclass;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.extractSuperclass.ExtractSuperBaseDialog;
import com.intellij.refactoring.extractSuperclass.ExtractSuperBaseProcessor;
import com.intellij.refactoring.extractSuperclass.ExtractSuperClassProcessor;
import com.intellij.refactoring.extractSuperclass.ExtractSuperclassHandler;
import com.intellij.refactoring.memberPullUp.PullUpHelper;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.classMembers.InterfaceContainmentVerifier;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.classMembers.UsesAndInterfacesDependencyMemberInfoModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

class ExtractSuperclassDialog
extends ExtractSuperBaseDialog {
    private final InterfaceContainmentVerifier myContainmentVerifier = new InterfaceContainmentVerifier(){

        @Override
        public boolean checkedInterfacesContain(PsiMethod psiMethod) {
            return PullUpHelper.checkedInterfacesContain(ExtractSuperclassDialog.this.myMemberInfos, psiMethod);
        }
    };
    private JLabel myClassNameLabel;
    private JLabel myPackageLabel;
    private final Callback myCallback;

    public ExtractSuperclassDialog(Project project, PsiClass sourceClass, List<MemberInfo> selectedMembers, Callback callback) {
        super(project, sourceClass, selectedMembers, ExtractSuperclassHandler.REFACTORING_NAME);
        this.myCallback = callback;
        this.init();
    }

    public MemberInfo[] getSelectedMemberInfos() {
        ArrayList<MemberInfo> list = new ArrayList<MemberInfo>(this.myMemberInfos.size());
        for (MemberInfo info : this.myMemberInfos) {
            if (!info.isChecked()) continue;
            list.add(info);
        }
        return list.toArray(new MemberInfo[list.size()]);
    }

    InterfaceContainmentVerifier getContainmentVerifier() {
        return this.myContainmentVerifier;
    }

    protected JComponent createNorthPanel() {
        Box box = Box.createVerticalBox();
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)new JLabel(RefactoringBundle.message((String)"extract.superclass.from")), "North");
        _panel.add((Component)this.mySourceClassField, "Center");
        box.add(_panel);
        box.add(Box.createVerticalStrut(10));
        box.add(this.createActionComponent());
        box.add(Box.createVerticalStrut(10));
        this.myClassNameLabel = new JLabel();
        this.myClassNameLabel.setLabelFor(this.myExtractedSuperNameField);
        _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.myClassNameLabel, "North");
        _panel.add((Component)this.myExtractedSuperNameField, "Center");
        box.add(_panel);
        box.add(Box.createVerticalStrut(5));
        _panel = new JPanel(new BorderLayout());
        this.myPackageLabel = new JLabel();
        this.myPackageLabel.setText(RefactoringBundle.message((String)"package.for.new.superclass"));
        _panel.add((Component)this.myPackageLabel, "North");
        _panel.add((Component)((Object)this.myPackageNameField), "Center");
        box.add(_panel);
        box.add(Box.createVerticalStrut(10));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)box, "Center");
        return panel;
    }

    @Override
    protected String getClassNameLabelText() {
        return RefactoringBundle.message((String)"superclass.name");
    }

    @Override
    protected JLabel getClassNameLabel() {
        return this.myClassNameLabel;
    }

    @Override
    protected JLabel getPackageNameLabel() {
        return this.myPackageLabel;
    }

    @Override
    protected String getEntityName() {
        return RefactoringBundle.message((String)"ExtractSuperClass.superclass");
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        MemberSelectionPanel memberSelectionPanel = new MemberSelectionPanel(RefactoringBundle.message((String)"members.to.form.superclass"), this.myMemberInfos, RefactoringBundle.message((String)"make.abstract"));
        panel.add((Component)memberSelectionPanel, "Center");
        UsesAndInterfacesDependencyMemberInfoModel memberInfoModel = new UsesAndInterfacesDependencyMemberInfoModel(this.mySourceClass, null, false, this.myContainmentVerifier){

            @Override
            public Boolean isFixedAbstract(MemberInfo member) {
                return Boolean.TRUE;
            }
        };
        memberInfoModel.memberInfoChanged(new MemberInfoChange((Collection)this.myMemberInfos));
        memberSelectionPanel.getTable().setMemberInfoModel(memberInfoModel);
        memberSelectionPanel.getTable().addMemberInfoChangeListener(memberInfoModel);
        panel.add((Component)this.myJavaDocPanel, "East");
        return panel;
    }

    @Override
    protected String getJavaDocPanelName() {
        return RefactoringBundle.message((String)"javadoc.for.abstracts");
    }

    @Override
    protected String getExtractedSuperNameNotSpecifiedKey() {
        return RefactoringBundle.message((String)"no.superclass.name.specified");
    }

    @Override
    protected boolean checkConflicts() {
        return this.myCallback.checkConflicts(this);
    }

    @Override
    protected int getJavaDocPolicySetting() {
        return JavaRefactoringSettings.getInstance().EXTRACT_SUPERCLASS_JAVADOC;
    }

    @Override
    protected void setJavaDocPolicySetting(int policy) {
        JavaRefactoringSettings.getInstance().EXTRACT_SUPERCLASS_JAVADOC = policy;
    }

    @Override
    protected ExtractSuperBaseProcessor createProcessor() {
        return new ExtractSuperClassProcessor(this.myProject, this.getTargetDirectory(), this.getExtractedSuperName(), this.mySourceClass, this.getSelectedMemberInfos(), false, new DocCommentPolicy(this.getJavaDocPolicy()));
    }

    @Override
    protected String getHelpId() {
        return "refactoring.extractSuperclass";
    }

    public static interface Callback {
        public boolean checkConflicts(ExtractSuperclassDialog var1);
    }
}

