/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.anonymousToInner;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.anonymousToInner.AnonymousToInnerHandler;
import com.intellij.refactoring.anonymousToInner.VariableInfo;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ParameterTablePanel;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.Function;
import com.intellij.util.containers.HashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

class AnonymousToInnerDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.anonymousToInner.AnonymousToInnerDialog");
    private final Project myProject;
    private final PsiAnonymousClass myAnonClass;
    private final boolean myNeedsThis;
    private NameSuggestionsField myNameField;
    private final ParameterTablePanel.VariableData[] myVariableData;
    private final Map<PsiVariable, VariableInfo> myVariableToInfoMap = new HashMap();
    private JCheckBox myCbMakeStatic;

    public AnonymousToInnerDialog(Project project, PsiAnonymousClass anonClass, VariableInfo[] variableInfos, boolean needsThis) {
        super(project, true);
        this.myProject = project;
        this.myAnonClass = anonClass;
        this.myNeedsThis = needsThis;
        this.setTitle(AnonymousToInnerHandler.REFACTORING_NAME);
        for (VariableInfo info : variableInfos) {
            this.myVariableToInfoMap.put(info.variable, info);
        }
        this.myVariableData = new ParameterTablePanel.VariableData[variableInfos.length];
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        for (int idx = 0; idx < variableInfos.length; ++idx) {
            VariableInfo info = variableInfos[idx];
            String name = info.variable.getName();
            VariableKind kind = codeStyleManager.getVariableKind(info.variable);
            name = codeStyleManager.variableNameToPropertyName(name, kind);
            name = codeStyleManager.propertyNameToVariableName(name, VariableKind.PARAMETER);
            ParameterTablePanel.VariableData data = new ParameterTablePanel.VariableData(info.variable);
            data.name = name;
            data.passAsParameter = true;
            this.myVariableData[idx] = data;
        }
        this.init();
        String name = this.myAnonClass.getBaseClassReference().getReferenceName();
        Object[] typeParameters = this.myAnonClass.getBaseClassReference().getTypeParameters();
        String[] names = typeParameters.length > 0 ? new String[]{StringUtil.join((Object[])typeParameters, (Function)new Function<PsiType, String>(){

            public String fun(PsiType psiType) {
                return psiType.getPresentableText();
            }
        }, (String)"") + name, "My" + name} : new String[]{"My" + name};
        this.myNameField.setSuggestions(names);
        this.myNameField.selectNameWithoutExtension();
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    public boolean isMakeStatic() {
        if (this.myNeedsThis) {
            return false;
        }
        return this.myCbMakeStatic.isSelected();
    }

    public String getClassName() {
        return this.myNameField.getEnteredName();
    }

    public VariableInfo[] getVariableInfos() {
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        VariableInfo[] infos = new VariableInfo[this.myVariableData.length];
        for (int idx = 0; idx < this.myVariableData.length; ++idx) {
            ParameterTablePanel.VariableData data = this.myVariableData[idx];
            VariableInfo info = this.myVariableToInfoMap.get(data.variable);
            info.passAsParameter = data.passAsParameter;
            info.parameterName = data.name;
            info.parameterName = data.name;
            String propertyName = codeStyleManager.variableNameToPropertyName(data.name, VariableKind.PARAMETER);
            info.fieldName = codeStyleManager.propertyNameToVariableName(propertyName, VariableKind.FIELD);
            infos[idx] = info;
        }
        return infos;
    }

    protected void doOKAction() {
        String errorString = null;
        String innerClassName = this.getClassName();
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        if ("".equals(innerClassName)) {
            errorString = RefactoringBundle.message((String)"anonymousToInner.no.inner.class.name");
        } else if (!JavaPsiFacade.getInstance((Project)manager.getProject()).getNameHelper().isIdentifier(innerClassName)) {
            errorString = RefactoringMessageUtil.getIncorrectIdentifierMessage(innerClassName);
        } else {
            PsiElement targetContainer = AnonymousToInnerHandler.findTargetContainer(this.myAnonClass);
            if (targetContainer instanceof PsiClass) {
                PsiClass[] innerClasses;
                PsiClass targetClass = (PsiClass)targetContainer;
                for (PsiClass innerClass : innerClasses = targetClass.getInnerClasses()) {
                    if (!innerClassName.equals(innerClass.getName())) continue;
                    errorString = RefactoringBundle.message((String)"inner.class.exists", (Object[])new Object[]{innerClassName, targetClass.getName()});
                    break;
                }
            } else {
                LOG.assertTrue(false);
            }
        }
        if (errorString != null) {
            CommonRefactoringUtil.showErrorMessage((String)AnonymousToInnerHandler.REFACTORING_NAME, (String)errorString, (String)"refactoring.convertAnonymous", (Project)this.myProject);
            this.myNameField.requestFocusInWindow();
            return;
        }
        super.doOKAction();
        this.myNameField.requestFocusInWindow();
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(4, 4, 4, 4);
        gbConstraints.anchor = 13;
        gbConstraints.fill = 1;
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        JLabel namePrompt = new JLabel(RefactoringBundle.message((String)"anonymousToInner.class.name.label.text"));
        panel.add((Component)namePrompt, gbConstraints);
        this.myNameField = new NameSuggestionsField(this.myProject);
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 1;
        gbConstraints.gridy = 0;
        panel.add((Component)this.myNameField, gbConstraints);
        if (!this.myNeedsThis) {
            this.myCbMakeStatic = new NonFocusableCheckBox();
            this.myCbMakeStatic.setText(RefactoringBundle.message((String)"anonymousToInner.make.class.static.checkbox.text"));
            gbConstraints.gridx = 0;
            ++gbConstraints.gridy;
            gbConstraints.gridwidth = 2;
            panel.add((Component)this.myCbMakeStatic, gbConstraints);
            this.myCbMakeStatic.setSelected(true);
        }
        return panel;
    }

    private JComponent createParametersPanel() {
        ParameterTablePanel panel = new ParameterTablePanel(this.myProject, this.myVariableData, new PsiElement[]{this.myAnonClass}){

            @Override
            protected void updateSignature() {
            }

            @Override
            protected void doEnterAction() {
                AnonymousToInnerDialog.this.clickDefaultButton();
            }

            @Override
            protected void doCancelAction() {
                AnonymousToInnerDialog.this.doCancelAction();
            }
        };
        panel.setBorder(IdeBorderFactory.createTitledBorder((String)RefactoringBundle.message((String)"anonymousToInner.parameters.panel.border.title")));
        return panel;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createParametersPanel(), "Center");
        return panel;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.convertAnonymous");
    }
}

