/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.anonymousToInner.AnonymousToInnerHandler;

public class AnonymousToInnerAction
extends BaseRefactoringAction {
    @Override
    public boolean isAvailableInEditorOnly() {
        return true;
    }

    @Override
    public boolean isEnabledOnElements(PsiElement[] elements) {
        return false;
    }

    @Override
    protected boolean isAvailableOnElementInEditor(PsiElement element, Editor editor) {
        PsiElement targetElement;
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)element.getProject()).getPsiFile(document);
        if (file != null && PsiTreeUtil.getParentOfType((PsiElement)(targetElement = file.findElementAt(editor.getCaretModel().getOffset())), PsiAnonymousClass.class) != null) {
            return true;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnonymousClass.class) != null) {
            return true;
        }
        PsiNewExpression newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class);
        return newExpression != null && newExpression.getAnonymousClass() != null;
    }

    @Override
    public RefactoringActionHandler getHandler(DataContext dataContext) {
        return new AnonymousToInnerHandler();
    }
}

