/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexExtension;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubIndexState;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexStorage;
import com.intellij.util.indexing.MapIndexStorage;
import com.intellij.util.indexing.MapReduceIndex;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import org.jetbrains.annotations.NotNull;

@State(name="FileBasedIndex", roamingType=RoamingType.DISABLED, storages={@Storage(id="stubIndex", file="$APP_CONFIG$/stubIndex.xml")})
public class StubIndexImpl
extends StubIndex
implements ApplicationComponent,
PersistentStateComponent<StubIndexState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.StubIndexImpl");
    private final Map<StubIndexKey<?, ?>, MyIndex<?>> myIndices = new HashMap();
    private final TObjectIntHashMap<ID<?, ?>> myIndexIdToVersionMap = new TObjectIntHashMap();
    private StubIndexState myPreviouslyRegistered;

    public StubIndexImpl() throws IOException {
        StubIndexExtension[] extensions = (StubIndexExtension[])Extensions.getExtensions((ExtensionPointName)StubIndexExtension.EP_NAME);
        boolean needRebuild = false;
        for (StubIndexExtension extension : extensions) {
            needRebuild |= this.registerIndexer(extension);
        }
        if (needRebuild) {
            StubIndexImpl.requestRebuild();
        }
        this.dropUnregisteredIndices();
    }

    private <K> boolean registerIndexer(StubIndexExtension<K, ?> extension) throws IOException {
        StubIndexKey indexKey = extension.getKey();
        int version = extension.getVersion();
        this.myIndexIdToVersionMap.put((Object)indexKey, version);
        File versionFile = IndexInfrastructure.getVersionFile(indexKey);
        boolean versionFileExisted = versionFile.exists();
        File indexRootDir = IndexInfrastructure.getIndexRootDir(indexKey);
        boolean needRebuild = false;
        if (IndexInfrastructure.versionDiffers(versionFile, version)) {
            String[] children = indexRootDir.list();
            boolean bl = needRebuild = versionFileExisted || children != null && children.length > 0;
            if (needRebuild) {
                LOG.info("Version has changed for stub index " + extension.getKey() + ". The index will be rebuilt.");
            }
            FileUtil.delete((File)indexRootDir);
            IndexInfrastructure.rewriteVersion(versionFile, version);
        }
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                MapIndexStorage storage = new MapIndexStorage(IndexInfrastructure.getStorageFile(indexKey), extension.getKeyDescriptor(), new StubIdExternalizer(), 2048);
                MemoryIndexStorage memStorage = new MemoryIndexStorage(storage);
                this.myIndices.put(indexKey, new MyIndex(memStorage));
                break;
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                needRebuild = true;
                FileUtil.delete((File)indexRootDir);
                IndexInfrastructure.rewriteVersion(versionFile, version);
                continue;
            }
        }
        return needRebuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Key, Psi extends PsiElement> Collection<Psi> get(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, final Project project, final GlobalSearchScope scope) {
        if (indexKey == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/stubs/StubIndexImpl.get must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/stubs/StubIndexImpl.get must not be null");
        }
        FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, project, scope);
        final PersistentFS fs = (PersistentFS)ManagingFS.getInstance();
        final PsiManager psiManager = PsiManager.getInstance((Project)project);
        final ArrayList result = new ArrayList();
        MyIndex<?> index = this.myIndices.get(indexKey);
        try {
            try {
                FileBasedIndex.disableUpToDateCheckForCurrentThread();
                index.getReadLock().lock();
                ValueContainer<TIntArrayList> container = index.getData(key);
                container.forEach(new ValueContainer.ContainerAction<TIntArrayList>(){

                    @Override
                    public void perform(int id, TIntArrayList value) {
                        block4: {
                            StubTree stubTree;
                            block5: {
                                final VirtualFile file = IndexInfrastructure.findFileById(fs, id);
                                if (file == null || scope != null && !scope.contains(file)) break block4;
                                stubTree = null;
                                PsiFile _psifile = psiManager.findFile(file);
                                PsiFileWithStubSupport psiFile = null;
                                if (_psifile != null && !(_psifile instanceof PsiPlainTextFile) && _psifile instanceof PsiFileWithStubSupport && (stubTree = (psiFile = (PsiFileWithStubSupport)_psifile).getStubTree()) == null && psiFile instanceof PsiFileImpl) {
                                    stubTree = ((PsiFileImpl)psiFile).calcStubTree();
                                }
                                if (stubTree == null && psiFile == null) break block4;
                                if (stubTree != null) break block5;
                                stubTree = StubTree.readFromVFile(project, file);
                                if (stubTree == null) break block4;
                                List<StubElement<?>> plained = stubTree.getPlainList();
                                for (int i = 0; i < value.size(); ++i) {
                                    StubElement<?> stub = plained.get(value.get(i));
                                    ASTNode tree = psiFile.findTreeForStub(stubTree, stub);
                                    if (tree == null) continue;
                                    if (tree.getElementType() == StubIndexImpl.stubType(stub)) {
                                        result.add(tree.getPsi());
                                        continue;
                                    }
                                    String persistedStubTree = ((PsiFileStubImpl)stubTree.getRoot()).printTree();
                                    String stubTreeJustBuilt = ((PsiFileStubImpl)((IStubFileElementType)((PsiFileImpl)psiFile).getContentElementType()).getBuilder().buildStubTree((PsiFile)psiFile)).printTree();
                                    StringBuilder builder = new StringBuilder();
                                    builder.append("Oops\n");
                                    builder.append("Recorded stub:-----------------------------------\n");
                                    builder.append(persistedStubTree);
                                    builder.append("\nAST built stub: ------------------------------------\n");
                                    builder.append(stubTreeJustBuilt);
                                    builder.append("\n");
                                    LOG.info(builder.toString());
                                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            FileBasedIndex.getInstance().requestReindex(file);
                                        }
                                    }, ModalityState.NON_MODAL);
                                }
                                break block4;
                            }
                            List<StubElement<?>> plained = stubTree.getPlainList();
                            for (int i = 0; i < value.size(); ++i) {
                                result.add(plained.get(value.get(i)).getPsi());
                            }
                        }
                    }
                });
            }
            finally {
                index.getReadLock().unlock();
                FileBasedIndex.enableUpToDateCheckForCurrentThread();
            }
        }
        catch (StorageException e) {
            StubIndexImpl.forceRebuild(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException || cause instanceof StorageException) {
                StubIndexImpl.forceRebuild(e);
            }
            throw e;
        }
        return result;
    }

    private static IElementType stubType(StubElement<?> stub) {
        if (stub instanceof PsiFileStub) {
            return ((PsiFileStub)stub).getType();
        }
        return stub.getStubType();
    }

    private static void forceRebuild(Throwable e) {
        LOG.info(e);
        StubIndexImpl.requestRebuild();
        FileBasedIndex.getInstance().scheduleRebuild(StubUpdatingIndex.INDEX_ID, e);
    }

    private static void requestRebuild() {
        FileBasedIndex.requestRebuild(StubUpdatingIndex.INDEX_ID);
    }

    public <K> Collection<K> getAllKeys(StubIndexKey<K, ?> indexKey, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/stubs/StubIndexImpl.getAllKeys must not be null");
        }
        FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, project, GlobalSearchScope.allScope((Project)project));
        MyIndex<?> index = this.myIndices.get(indexKey);
        try {
            return index.getAllKeys();
        }
        catch (StorageException e) {
            StubIndexImpl.forceRebuild(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException || cause instanceof StorageException) {
                StubIndexImpl.forceRebuild(e);
            }
            throw e;
        }
        return Collections.emptyList();
    }

    @NotNull
    public String getComponentName() {
        if ("Stub.IndexManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/stubs/StubIndexImpl.getComponentName must not return null");
        }
        return "Stub.IndexManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void dispose() {
        for (MyIndex<?> index : this.myIndices.values()) {
            index.dispose();
        }
    }

    public void setDataBufferingEnabled(boolean enabled) {
        for (MyIndex<?> index : this.myIndices.values()) {
            IndexStorage indexStorage = ((MapReduceIndex)index).getStorage();
            ((MemoryIndexStorage)indexStorage).setBufferingEnabled(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupMemoryStorage() {
        for (MyIndex<?> index : this.myIndices.values()) {
            IndexStorage indexStorage = ((MapReduceIndex)index).getStorage();
            index.getWriteLock().lock();
            try {
                ((MemoryIndexStorage)indexStorage).clearMemoryMap();
            }
            finally {
                index.getWriteLock().unlock();
            }
        }
    }

    public void clearAllIndices() {
        for (MyIndex<?> index : this.myIndices.values()) {
            try {
                index.clear();
            }
            catch (StorageException e) {
                LOG.error((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private void dropUnregisteredIndices() {
        HashSet indicesToDrop = new HashSet(this.myPreviouslyRegistered != null ? this.myPreviouslyRegistered.registeredIndices : Collections.emptyList());
        for (StubIndexKey<?, ?> key : this.myIndices.keySet()) {
            indicesToDrop.remove(key.toString());
        }
        for (String s : indicesToDrop) {
            FileUtil.delete((File)IndexInfrastructure.getIndexRootDir(ID.create((String)s)));
        }
    }

    public StubIndexState getState() {
        return new StubIndexState(this.myIndices.keySet());
    }

    public void loadState(StubIndexState state) {
        this.myPreviouslyRegistered = state;
    }

    public Lock getWriteLock(StubIndexKey indexKey) {
        return this.myIndices.get(indexKey).getWriteLock();
    }

    public Collection<StubIndexKey> getAllStubIndexKeys() {
        return Collections.unmodifiableCollection(this.myIndices.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(StubIndexKey key) throws StorageException {
        MyIndex<?> index = this.myIndices.get(key);
        index.getReadLock().lock();
        try {
            index.flush();
        }
        finally {
            index.getReadLock().unlock();
        }
    }

    public <K> void updateIndex(StubIndexKey key, int fileId, final Map<K, TIntArrayList> oldValues, Map<K, TIntArrayList> newValues) {
        try {
            MyIndex<?> index = this.myIndices.get(key);
            index.updateWithMap(fileId, newValues, (Callable<Collection<?>>)new Callable<Collection<K>>(){

                @Override
                public Collection<K> call() throws Exception {
                    return oldValues.keySet();
                }
            });
        }
        catch (StorageException e) {
            LOG.info((Throwable)e);
            StubIndexImpl.requestRebuild();
        }
    }

    private static class MyIndex<K>
    extends MapReduceIndex<K, TIntArrayList, Void> {
        public MyIndex(IndexStorage<K, TIntArrayList> storage) {
            super(null, null, storage);
        }

        @Override
        public void updateWithMap(int inputId, Map<K, TIntArrayList> newData, Callable<Collection<K>> oldKeysGetter) throws StorageException {
            super.updateWithMap(inputId, newData, oldKeysGetter);
        }
    }

    private static class StubIdExternalizer
    implements DataExternalizer<TIntArrayList> {
        private StubIdExternalizer() {
        }

        public void save(DataOutput out, TIntArrayList value) throws IOException {
            int size = value.size();
            if (size == 0) {
                DataInputOutputUtil.writeSINT((DataOutput)out, (int)Integer.MAX_VALUE);
            } else if (size == 1) {
                DataInputOutputUtil.writeSINT((DataOutput)out, (int)(-value.get(0)));
            } else {
                DataInputOutputUtil.writeSINT((DataOutput)out, (int)size);
                for (int i = 0; i < size; ++i) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)value.get(i));
                }
            }
        }

        public TIntArrayList read(DataInput in) throws IOException {
            int size = DataInputOutputUtil.readSINT((DataInput)in);
            if (size == Integer.MAX_VALUE) {
                return new TIntArrayList();
            }
            if (size <= 0) {
                TIntArrayList result = new TIntArrayList(1);
                result.add(-size);
                return result;
            }
            TIntArrayList result = new TIntArrayList(size);
            for (int i = 0; i < size; ++i) {
                result.add(DataInputOutputUtil.readINT((DataInput)in));
            }
            return result;
        }
    }
}

