/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlElementImpl
extends CompositePsiElement
implements XmlElement {
    public XmlElementImpl(IElementType type) {
        super(type);
    }

    public boolean processElements(PsiElementProcessor processor, PsiElement place) {
        return XmlUtil.processXmlElements(this, processor, false);
    }

    public boolean processChildren(PsiElementProcessor processor) {
        return XmlUtil.processXmlElementChildren(this, processor, false);
    }

    public XmlElement findElementByTokenType(final IElementType type) {
        final XmlElement[] result = new XmlElement[]{null};
        this.processElements(new PsiElementProcessor(){

            public boolean execute(PsiElement element) {
                if (element instanceof TreeElement && ((ASTNode)element).getElementType() == type) {
                    result[0] = (XmlElement)element;
                    return false;
                }
                return true;
            }
        }, this);
        return result[0];
    }

    @Override
    public PsiElement getContext() {
        XmlElement data = (XmlElement)this.getUserData(INCLUDING_ELEMENT);
        if (data != null) {
            return data;
        }
        return super.getParent();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        Object object;
        PsiElement data = (PsiElement)this.getUserData(ORIGINAL_ELEMENT);
        if (data != null) {
            object = data;
            if (object == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlElementImpl.getNavigationElement must not return null");
            return object;
        }
        if (!this.isPhysical()) {
            XmlElement including = (XmlElement)this.getUserData(INCLUDING_ELEMENT);
            object = including != null ? including : super.getParent().getNavigationElement();
            if (object == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlElementImpl.getNavigationElement must not return null");
            return object;
        }
        object = super.getNavigationElement();
        if (object != null) return object;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlElementImpl.getNavigationElement must not return null");
    }

    @Override
    public PsiElement getParent() {
        return this.getContext();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.getContainingFile().getLanguage();
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlElementImpl.getLanguage must not return null");
        }
        return language;
    }

    @Nullable
    protected static String getNameFromEntityRef(CompositeElement compositeElement, IElementType xmlEntityDeclStart) {
        ASTNode node = compositeElement.findChildByType(xmlEntityDeclStart);
        if (node == null) {
            return null;
        }
        ASTNode name = node.getTreeNext();
        if (name != null && name.getElementType() == TokenType.WHITE_SPACE) {
            name = name.getTreeNext();
        }
        if (name != null && name.getElementType() == XmlElementType.XML_ENTITY_REF) {
            final StringBuilder builder = new StringBuilder();
            ((XmlElement)name.getPsi()).processElements(new PsiElementProcessor(){

                public boolean execute(PsiElement element) {
                    builder.append(element.getText());
                    return true;
                }
            }, name.getPsi());
            if (builder.length() > 0) {
                return builder.toString();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.getProject());
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlElementImpl.getUseScope must not return null");
        }
        return globalSearchScope;
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        if (super.isEquivalentTo(another)) {
            return true;
        }
        XmlElementImpl element1 = this;
        PsiElement element2 = another;
        if (element1 instanceof XmlTag && element2 instanceof XmlTag && !element1.isPhysical() && !element2.isPhysical()) {
            return element1.getText().equals(element2.getText());
        }
        return false;
    }
}

