/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class PsiFieldUpdater<T, V> {
    private static final Unsafe unsafe = PsiFieldUpdater.getUnsafe();
    private final long offset;

    private static Unsafe getUnsafe() {
        Unsafe unsafe = null;
        try {
            Field[] fields;
            Class<Unsafe> uc = Unsafe.class;
            for (Field field : fields = uc.getDeclaredFields()) {
                if (!field.getName().equals("theUnsafe")) continue;
                field.setAccessible(true);
                unsafe = (Unsafe)field.get(uc);
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return unsafe;
    }

    public static <T, V> PsiFieldUpdater<T, V> forOnlyFieldWithType(Class<T> ownerClass, Class<V> fieldType) {
        return new PsiFieldUpdater<T, V>(ownerClass, fieldType);
    }

    private PsiFieldUpdater(Class<T> ownerClass, Class<V> fieldType) {
        Field[] declaredFields = ownerClass.getDeclaredFields();
        Field found = null;
        for (Field field : declaredFields) {
            if (!field.getType().equals(fieldType)) continue;
            if (found == null) {
                found = field;
                continue;
            }
            throw new IllegalArgumentException("Two fields with the " + fieldType + " found in the " + ownerClass + ": " + found.getName() + " and " + field.getName());
        }
        if (found == null) {
            throw new IllegalArgumentException("No field with the " + fieldType + " found in the " + ownerClass);
        }
        found.setAccessible(true);
        this.offset = unsafe.objectFieldOffset(found);
    }

    public boolean compareAndSet(T owner, V expected, V newValue) {
        return unsafe.compareAndSwapObject(owner, this.offset, expected, newValue);
    }
}

