/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class TreeElement
extends ElementBase
implements ASTNode,
Cloneable {
    public static final TreeElement[] EMPTY_ARRAY = new TreeElement[0];
    private TreeElement myNextSibling = null;
    private TreeElement myPrevSibling = null;
    private CompositeElement myParent = null;
    private final IElementType myType;
    private volatile int myStartOffsetInParent = -1;
    @NonNls
    protected static final String START_OFFSET_LOCK = new String("TreeElement.START_OFFSET_LOCK");

    public TreeElement(IElementType type) {
        this.myType = type;
    }

    public Object clone() {
        TreeElement clone = (TreeElement)super.clone();
        clone.clearCaches();
        clone.myNextSibling = null;
        clone.myPrevSibling = null;
        clone.myParent = null;
        clone.myStartOffsetInParent = -1;
        return clone;
    }

    public ASTNode copyElement() {
        CharTable table = SharedImplUtil.findCharTableByTree(this);
        return ChangeUtil.copyElement(this, table);
    }

    public PsiManagerEx getManager() {
        TreeElement element = this;
        while (element.getTreeParent() != null) {
            element = element.getTreeParent();
        }
        if (element instanceof FileElement) {
            return element.getManager();
        }
        if (this.getTreeParent() != null) {
            return this.getTreeParent().getManager();
        }
        return null;
    }

    public abstract LeafElement findLeafElementAt(int var1);

    @NotNull
    public abstract char[] textToCharArray();

    public abstract TreeElement getFirstChildNode();

    public abstract TreeElement getLastChildNode();

    public abstract int getNotCachedLength();

    public abstract int getCachedLength();

    public TextRange getTextRange() {
        int start = this.getStartOffset();
        return new TextRange(start, start + this.getTextLength());
    }

    public int getStartOffset() {
        if (this.myParent == null) {
            return 0;
        }
        return this.myParent.getStartOffset() + this.getStartOffsetInParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getStartOffsetInParent() {
        if (this.myParent == null) {
            return -1;
        }
        int offsetInParent = this.myStartOffsetInParent;
        if (offsetInParent != -1) {
            return offsetInParent;
        }
        String string = START_OFFSET_LOCK;
        synchronized (string) {
            TreeElement prev;
            TreeElement cur = this;
            offsetInParent = this.myStartOffsetInParent;
            if (offsetInParent != -1) {
                return offsetInParent;
            }
            while ((prev = cur.getTreePrev()) != null) {
                cur = prev;
                offsetInParent = cur.myStartOffsetInParent;
                if (offsetInParent == -1) continue;
                break;
            }
            if (offsetInParent == -1) {
                offsetInParent = 0;
                cur.myStartOffsetInParent = 0;
            }
            while (cur != this) {
                TreeElement next = cur.getTreeNext();
                next.myStartOffsetInParent = offsetInParent += cur.getTextLength();
                cur = next;
            }
            return offsetInParent;
        }
    }

    public int getTextOffset() {
        return this.getStartOffset();
    }

    public boolean textMatches(CharSequence buffer, int startOffset, int endOffset) {
        return this.textMatches(buffer, startOffset) == endOffset;
    }

    protected abstract int textMatches(CharSequence var1, int var2);

    public boolean textMatches(@NotNull CharSequence seq) {
        if (seq == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/TreeElement.textMatches must not be null");
        }
        return this.textMatches(seq, 0, seq.length());
    }

    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/TreeElement.textMatches must not be null");
        }
        return this.getTextLength() == element.getTextLength() && this.textMatches(element.getText());
    }

    @NonNls
    public String toString() {
        return "Element(" + this.getElementType().toString() + ")";
    }

    public final CompositeElement getTreeParent() {
        return this.myParent;
    }

    public final TreeElement getTreePrev() {
        return this.myPrevSibling;
    }

    public final void setTreeParent(CompositeElement parent) {
        this.myParent = parent;
    }

    public final void setTreePrev(TreeElement prev) {
        this.myPrevSibling = prev;
        TreeElement.clearRelativeOffsets(this);
    }

    public final TreeElement getTreeNext() {
        return this.myNextSibling;
    }

    public final void setTreeNext(TreeElement next) {
        this.myNextSibling = next;
        TreeElement.clearRelativeOffsets(next);
    }

    protected static void clearRelativeOffsets(TreeElement element) {
        for (TreeElement cur = element; cur != null && cur.myStartOffsetInParent != -1; cur = cur.getTreeNext()) {
            cur.myStartOffsetInParent = -1;
        }
    }

    public void clearCaches() {
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    public abstract int hc();

    public abstract void acceptTree(TreeElementVisitor var1);

    protected void onInvalidated() {
        Boolean trackInvalidation;
        if (DebugUtil.shouldTrackInvalidation() && (trackInvalidation = (Boolean)this.getUserData(DebugUtil.TRACK_INVALIDATION_KEY)) != null && trackInvalidation.booleanValue()) {
            new Throwable("Element invalidated:" + this).printStackTrace();
        }
    }

    public void rawInsertBeforeMe(@NotNull TreeElement firstNew) {
        if (firstNew == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/TreeElement.rawInsertBeforeMe must not be null");
        }
        TreeElement anchorPrev = this.getTreePrev();
        if (anchorPrev == null) {
            firstNew.rawRemoveUpToLast();
            CompositeElement p = this.getTreeParent();
            if (p != null) {
                p.setFirstChildNode(firstNew);
            }
            while (true) {
                TreeElement treeNext = firstNew.getTreeNext();
                assert (treeNext != this) : "Attempt to create cycle";
                firstNew.setTreeParent(p);
                if (treeNext == null) break;
                firstNew = treeNext;
            }
            this.setTreePrev(firstNew);
            firstNew.setTreeNext(this);
        } else {
            anchorPrev.rawInsertAfterMe(firstNew);
        }
        if (DebugUtil.CHECK) {
            DebugUtil.checkTreeStructure(this);
        }
    }

    public void rawInsertAfterMe(@NotNull TreeElement firstNew) {
        if (firstNew == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/TreeElement.rawInsertAfterMe must not be null");
        }
        firstNew.rawRemoveUpToLast();
        CompositeElement p = this.getTreeParent();
        TreeElement treeNext = this.getTreeNext();
        firstNew.setTreePrev(this);
        this.setTreeNext(firstNew);
        while (true) {
            TreeElement n = firstNew.getTreeNext();
            assert (n != this) : "Attempt to create cycle";
            firstNew.setTreeParent(p);
            if (n == null) break;
            firstNew = n;
        }
        if (treeNext == null) {
            if (p != null) {
                firstNew.setTreeParent(p);
                p.setLastChildNode(firstNew);
            }
        } else {
            firstNew.setTreeNext(treeNext);
            treeNext.setTreePrev(firstNew);
        }
        if (DebugUtil.CHECK) {
            DebugUtil.checkTreeStructure(this);
        }
    }

    public void rawRemove() {
        TreeElement nxt = this.getTreeNext();
        CompositeElement p = this.getTreeParent();
        TreeElement prv = this.getTreePrev();
        if (prv != null) {
            prv.setTreeNext(nxt);
        } else if (p != null) {
            p.setFirstChildNode(nxt);
        }
        if (nxt != null) {
            nxt.setTreePrev(prv);
        } else if (p != null) {
            p.setLastChildNode(prv);
        }
        if (DebugUtil.CHECK) {
            if (this.getTreeParent() != null) {
                DebugUtil.checkTreeStructure(this.getTreeParent());
            }
            if (this.getTreePrev() != null) {
                DebugUtil.checkTreeStructure(this.getTreePrev());
            }
            if (this.getTreeNext() != null) {
                DebugUtil.checkTreeStructure(this.getTreeNext());
            }
        }
        this.invalidate();
    }

    public void rawReplaceWithList(TreeElement firstNew) {
        if (firstNew != null) {
            this.rawInsertAfterMe(firstNew);
        }
        this.rawRemove();
    }

    protected void invalidate() {
        this.setTreeNext(null);
        this.setTreePrev(null);
        this.setTreeParent(null);
        this.onInvalidated();
    }

    public void rawRemoveUpToLast() {
        this.rawRemoveUpTo(null);
    }

    public void rawRemoveUpTo(TreeElement end) {
        TreeElement endPrev;
        if (this == end) {
            return;
        }
        CompositeElement parent = this.getTreeParent();
        TreeElement startPrev = this.getTreePrev();
        TreeElement treeElement = endPrev = end != null ? end.getTreePrev() : null;
        assert (end == null || end.getTreeParent() == parent) : "Trying to remove non-child";
        if (parent != null) {
            if (this == parent.getFirstChildNode()) {
                parent.setFirstChildNode(end);
            }
            if (end == null) {
                parent.setLastChildNode(startPrev);
            }
        }
        if (startPrev != null) {
            startPrev.setTreeNext(end);
        }
        if (end != null) {
            end.setTreePrev(startPrev);
        }
        this.setTreePrev(null);
        if (endPrev != null) {
            endPrev.setTreeNext(null);
        }
        if (parent != null) {
            for (TreeElement element = this; element != null; element = element.getTreeNext()) {
                element.setTreeParent(null);
                element.onInvalidated();
            }
        }
        if (DebugUtil.CHECK) {
            if (parent != null) {
                DebugUtil.checkTreeStructure(parent);
            }
            DebugUtil.checkTreeStructure(this);
        }
    }

    public IElementType getElementType() {
        return this.myType;
    }
}

