/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lang.StdLanguages;
import com.intellij.lexer.JavaLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.parsing.JavaParsingContext;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.IReparseableElementType;
import com.intellij.psi.tree.java.IJavaDocElementType;
import com.intellij.util.CharTable;

public interface JavaDocElementType {
    public static final IElementType DOC_TAG = new IJavaDocElementType("DOC_TAG");
    public static final IElementType DOC_TAG_VALUE = new IJavaDocElementType("DOC_TAG_VALUE");
    public static final IElementType DOC_INLINE_TAG = new IJavaDocElementType("DOC_INLINE_TAG");
    public static final IElementType DOC_METHOD_OR_FIELD_REF = new IJavaDocElementType("DOC_METHOD_OR_FIELD_REF");
    public static final IElementType DOC_PARAMETER_REF = new IJavaDocElementType("DOC_PARAMETER_REF");
    public static final ILazyParseableElementType DOC_REFERENCE_HOLDER = new ILazyParseableElementType("DOC_REFERENCE_HOLDER", StdLanguages.JAVA){

        public ASTNode parseContents(ASTNode chameleon) {
            CharSequence chars = chameleon.getChars();
            PsiManager manager = chameleon.getTreeParent().getPsi().getManager();
            CharTable table = SharedImplUtil.findCharTableByTree(chameleon);
            JavaParsingContext context = new JavaParsingContext(table, LanguageLevel.JDK_1_3);
            return context.getJavadocParsing().parseJavaDocReference(chars, (Lexer)new JavaLexer(LanguageLevel.JDK_1_3), false, manager);
        }

        public ASTNode createNode(CharSequence text) {
            return new LazyParseablePsiElement((IElementType)this, text);
        }
    };
    public static final ILazyParseableElementType DOC_TYPE_HOLDER = new ILazyParseableElementType("DOC_TYPE_HOLDER", StdLanguages.JAVA){

        public ASTNode parseContents(ASTNode chameleon) {
            CharSequence chars = chameleon.getChars();
            PsiManager manager = chameleon.getTreeParent().getPsi().getManager();
            CharTable table = SharedImplUtil.findCharTableByTree(chameleon);
            JavaParsingContext context = new JavaParsingContext(table, LanguageLevel.JDK_1_3);
            return context.getJavadocParsing().parseJavaDocReference(chars, (Lexer)new JavaLexer(LanguageLevel.JDK_1_3), true, manager);
        }

        public ASTNode createNode(CharSequence text) {
            return new LazyParseablePsiElement((IElementType)this, text);
        }
    };
    public static final ILazyParseableElementType DOC_COMMENT = new IReparseableElementType("DOC_COMMENT", StdLanguages.JAVA){

        public ASTNode parseContents(ASTNode chameleon) {
            CharSequence chars = chameleon.getChars();
            PsiManager manager = chameleon.getTreeParent().getPsi().getManager();
            JavaParsingContext context = new JavaParsingContext(SharedImplUtil.findCharTableByTree(chameleon), LanguageLevel.JDK_1_3);
            return context.getJavadocParsing().parseDocCommentText(manager, chars, 0, chars.length());
        }

        public boolean isParsable(CharSequence buffer, Project project) {
            JavaLexer lexer = new JavaLexer(LanguageLevel.JDK_1_5);
            lexer.start(buffer);
            if (lexer.getTokenType() != DOC_COMMENT) {
                return false;
            }
            lexer.advance();
            return lexer.getTokenType() == null;
        }
    };
}

