/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.ChangeInfo;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeCopyHandler;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeGenerator;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ChangeUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.ChangeUtil");
    private static final List<TreeCopyHandler> ourCopyHandlers = ContainerUtil.createEmptyCOWList();
    private static final List<TreeGenerator> ourTreeGenerators = ContainerUtil.createEmptyCOWList();

    private ChangeUtil() {
    }

    public static void registerCopyHandler(TreeCopyHandler handler) {
        ourCopyHandlers.add(handler);
    }

    public static void registerTreeGenerator(TreeGenerator generator) {
        ourTreeGenerators.add(generator);
    }

    public static void changeElementInPlace(final ASTNode element, final ChangeAction action) {
        ChangeUtil.prepareAndRunChangeAction(new ChangeAction(){

            @Override
            public void makeChange(TreeChangeEvent destinationTreeChange) {
                destinationTreeChange.addElementaryChange(element, (ChangeInfo)ChangeInfoImpl.create((short)3, element));
                action.makeChange(destinationTreeChange);
                ASTNode node = element;
                while (node != null) {
                    ASTNode parent = node.getTreeParent();
                    ((TreeElement)node).clearCaches();
                    node = parent;
                }
            }
        }, (TreeElement)element);
    }

    public static void encodeInformation(TreeElement element) {
        ChangeUtil.encodeInformation(element, element);
    }

    private static void encodeInformation(TreeElement element, ASTNode original) {
        ChangeUtil.encodeInformation(element, original, (Map<Object, Object>)new HashMap());
    }

    private static void encodeInformation(TreeElement element, ASTNode original, Map<Object, Object> state) {
        for (TreeCopyHandler handler : ourCopyHandlers) {
            handler.encodeInformation(element, original, state);
        }
        if (original instanceof CompositeElement) {
            TreeElement child = element.getFirstChildNode();
            ASTNode child1 = original.getFirstChildNode();
            while (child != null) {
                ChangeUtil.encodeInformation(child, child1, state);
                child = child.getTreeNext();
                child1 = child1.getTreeNext();
            }
        }
    }

    public static TreeElement decodeInformation(TreeElement element) {
        return ChangeUtil.decodeInformation(element, (Map<Object, Object>)new HashMap());
    }

    private static TreeElement decodeInformation(TreeElement element, Map<Object, Object> state) {
        for (TreeElement child = element.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            child = ChangeUtil.decodeInformation(child, state);
        }
        for (TreeCopyHandler handler : ourCopyHandlers) {
            TreeElement handled = handler.decodeInformation(element, state);
            if (handled == null) continue;
            return handled;
        }
        return element;
    }

    public static LeafElement copyLeafWithText(LeafElement original, String text) {
        LeafElement element = ASTFactory.leaf(original.getElementType(), text);
        original.copyCopyableDataTo((UserDataHolderBase)element);
        ChangeUtil.encodeInformation(element, original);
        TreeUtil.clearCaches(element);
        ChangeUtil.saveIndentationToCopy(original, element);
        return element;
    }

    public static TreeElement copyElement(TreeElement original, CharTable table) {
        CompositeElement treeParent = original.getTreeParent();
        return ChangeUtil.copyElement(original, treeParent == null ? null : treeParent.getPsi(), table);
    }

    public static TreeElement copyElement(TreeElement original, PsiElement context, CharTable table) {
        TreeElement element = (TreeElement)original.clone();
        PsiManagerEx manager = original.getManager();
        DummyHolderFactory.createHolder(manager, element, context, table).getTreeElement();
        ChangeUtil.encodeInformation(element, original);
        TreeUtil.clearCaches(element);
        ChangeUtil.saveIndentationToCopy(original, element);
        return element;
    }

    private static void saveIndentationToCopy(TreeElement original, TreeElement element) {
        if (original == null || element == null || CodeEditUtil.isNodeGenerated(original)) {
            return;
        }
        int indentation = CodeEditUtil.getOldIndentation(original);
        if (indentation < 0) {
            CodeEditUtil.saveWhitespacesInfo(original);
        }
        CodeEditUtil.setOldIndentation(element, CodeEditUtil.getOldIndentation(original));
        if (indentation < 0) {
            CodeEditUtil.setOldIndentation(original, -1);
        }
    }

    public static TreeElement copyToElement(PsiElement original) {
        DummyHolder holder = DummyHolderFactory.createHolder(original.getManager(), null, original.getLanguage());
        FileElement holderElement = holder.getTreeElement();
        TreeElement treeElement = ChangeUtil.generateTreeElement(original, holderElement.getCharTable(), original.getManager());
        holderElement.rawAddChildren(treeElement);
        TreeUtil.clearCaches(holderElement);
        ChangeUtil.saveIndentationToCopy((TreeElement)original.getNode(), treeElement);
        return treeElement;
    }

    @Nullable
    public static TreeElement generateTreeElement(PsiElement original, CharTable table, PsiManager manager) {
        LOG.assertTrue(original.isValid());
        if (SourceTreeToPsiMap.hasTreeElement(original)) {
            return ChangeUtil.copyElement((TreeElement)SourceTreeToPsiMap.psiElementToTree(original), table);
        }
        for (TreeGenerator generator : ourTreeGenerators) {
            TreeElement element = generator.generateTreeFor(original, table, manager);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    public static void prepareAndRunChangeAction(final ChangeAction action, final TreeElement changedElement) {
        final FileElement changedFile = TreeUtil.getFileElement(changedElement);
        final PsiManagerEx manager = changedFile.getManager();
        final PomModel model = PomManager.getModel((Project)manager.getProject());
        try {
            final TreeAspect treeAspect = (TreeAspect)model.getModelAspect(TreeAspect.class);
            model.runTransaction((PomTransaction)new PomTransactionBase(changedElement.getPsi(), (PomModelAspect)treeAspect){

                public PomModelEvent runInner() {
                    PomModelEvent event = new PomModelEvent(model);
                    TreeChangeEventImpl destinationTreeChange = new TreeChangeEventImpl((PomModelAspect)treeAspect, changedFile);
                    event.registerChangeSet((PomModelAspect)treeAspect, (PomChangeSet)destinationTreeChange);
                    PsiManagerEx psiManager = (PsiManagerEx)manager;
                    PsiFile file = (PsiFile)changedFile.getPsi();
                    if (file.isPhysical()) {
                        SmartPointerManagerImpl.fastenBelts(file);
                    }
                    action.makeChange(destinationTreeChange);
                    psiManager.invalidateFile(file);
                    TreeUtil.clearCaches(changedElement);
                    if (changedElement instanceof CompositeElement) {
                        ((CompositeElement)changedElement).subtreeChanged();
                    }
                    return event;
                }
            });
        }
        catch (IncorrectOperationException ioe) {
            LOG.error((Throwable)ioe);
        }
    }

    public static interface ChangeAction {
        public void makeChange(TreeChangeEvent var1);
    }
}

