/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.text;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomManager;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import com.intellij.pom.tree.events.impl.ReplaceChangeInfoImpl;
import com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.text.BlockSupportImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import org.jetbrains.annotations.NotNull;

public class ASTDiffBuilder
implements DiffTreeChangeBuilder<ASTNode, ASTNode> {
    public static boolean DEBUG = false;
    private final TreeChangeEventImpl myEvent;
    private final PsiFileImpl myFile;
    private final PsiManagerEx myPsiManager;
    private final boolean myIsPhysicalScope;

    public ASTDiffBuilder(PsiFileImpl fileImpl) {
        this.myFile = fileImpl;
        this.myIsPhysicalScope = fileImpl.isPhysical();
        this.myPsiManager = (PsiManagerEx)fileImpl.getManager();
        this.myEvent = new TreeChangeEventImpl(PomManager.getModel((Project)fileImpl.getProject()).getModelAspect(TreeAspect.class), fileImpl.getTreeElement());
    }

    public void nodeReplaced(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
        if (oldNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/ASTDiffBuilder.nodeReplaced must not be null");
        }
        if (newNode == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/ASTDiffBuilder.nodeReplaced must not be null");
        }
        if (oldNode instanceof FileElement && newNode instanceof FileElement) {
            BlockSupportImpl.replaceFileElement(this.myFile, (FileElement)oldNode, (FileElement)newNode, this.myPsiManager);
        } else {
            PsiElement psiChild;
            ASTNode parent = oldNode.getTreeParent();
            TreeUtil.ensureParsed(oldNode);
            PsiElement psiParent = parent.getPsi();
            PsiElement psiElement = psiChild = this.myIsPhysicalScope ? oldNode.getPsi() : null;
            if (psiParent != null && psiChild != null) {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myPsiManager);
                event.setParent(psiParent);
                event.setChild(psiChild);
                this.myPsiManager.beforeChildReplacement(event);
            }
            ((TreeElement)newNode).rawRemove();
            ((TreeElement)oldNode).rawReplaceWithList((TreeElement)newNode);
            ReplaceChangeInfoImpl change = (ReplaceChangeInfoImpl)ChangeInfoImpl.create((short)2, newNode);
            change.setReplaced(oldNode);
            this.myEvent.addElementaryChange(newNode, change);
            ((TreeElement)newNode).clearCaches();
            if (!(newNode instanceof FileElement)) {
                ((CompositeElement)newNode.getTreeParent()).subtreeChanged();
            }
            if (DEBUG) {
                DebugUtil.checkTreeStructure(parent);
            }
        }
    }

    public void nodeDeleted(@NotNull ASTNode parent, @NotNull ASTNode child) {
        PsiElement psiChild;
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/ASTDiffBuilder.nodeDeleted must not be null");
        }
        if (child == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/ASTDiffBuilder.nodeDeleted must not be null");
        }
        PsiElement psiParent = parent.getPsi();
        PsiElement psiElement = psiChild = this.myIsPhysicalScope ? child.getPsi() : null;
        if (psiParent != null && psiChild != null) {
            PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myPsiManager);
            event.setParent(psiParent);
            event.setChild(psiChild);
            this.myPsiManager.beforeChildRemoval(event);
        }
        this.myEvent.addElementaryChange(child, ChangeInfoImpl.create((short)1, child));
        ((TreeElement)child).rawRemove();
        ((CompositeElement)parent).subtreeChanged();
        if (DEBUG) {
            DebugUtil.checkTreeStructure(parent);
        }
    }

    public void nodeInserted(@NotNull ASTNode oldParent, @NotNull ASTNode node, int pos) {
        if (oldParent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/ASTDiffBuilder.nodeInserted must not be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/ASTDiffBuilder.nodeInserted must not be null");
        }
        ASTNode anchor = null;
        for (int i = 0; i < pos; ++i) {
            anchor = anchor == null ? oldParent.getFirstChildNode() : anchor.getTreeNext();
        }
        ((TreeElement)node).rawRemove();
        if (anchor != null) {
            ((TreeElement)anchor).rawInsertAfterMe((TreeElement)node);
        } else if (oldParent.getFirstChildNode() != null) {
            ((TreeElement)oldParent.getFirstChildNode()).rawInsertBeforeMe((TreeElement)node);
        } else {
            ((CompositeElement)oldParent).rawAddChildren((TreeElement)node);
        }
        this.myEvent.addElementaryChange(node, ChangeInfoImpl.create((short)0, node));
        ((TreeElement)node).clearCaches();
        ((CompositeElement)oldParent).subtreeChanged();
        if (DEBUG) {
            DebugUtil.checkTreeStructure(oldParent);
        }
    }

    public TreeChangeEventImpl getEvent() {
        return this.myEvent;
    }
}

