/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.daemon.QuickFixProvider;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.BasicAttributeValueReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.ComplexTypeDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class SchemaReferencesProvider
extends PsiReferenceProvider {
    @NonNls
    private static final String VALUE_ATTR_NAME = "value";
    @NonNls
    private static final String PATTERN_TAG_NAME = "pattern";
    @NonNls
    private static final String NAME_ATTR_NAME = "name";
    @NonNls
    private static final String MEMBER_TYPES_ATTR_NAME = "memberTypes";
    @NonNls
    private static final String ITEM_TYPE_ATTR_NAME = "itemType";
    @NonNls
    private static final String BASE_ATTR_NAME = "base";
    @NonNls
    private static final String GROUP_TAG_NAME = "group";
    @NonNls
    private static final String ATTRIBUTE_GROUP_TAG_NAME = "attributeGroup";
    @NonNls
    private static final String ATTRIBUTE_TAG_NAME = "attribute";
    @NonNls
    private static final String ELEMENT_TAG_NAME = "element";
    @NonNls
    private static final String SIMPLE_TYPE_TAG_NAME = "simpleType";
    @NonNls
    private static final String COMPLEX_TYPE_TAG_NAME = "complexType";
    @NonNls
    private static final String REF_ATTR_NAME = "ref";
    @NonNls
    private static final String TARGET_NAMESPACE = "targetNamespace";
    @NonNls
    private static final String TYPE_ATTR_NAME = "type";
    @NonNls
    private static final String SUBSTITUTION_GROUP_ATTR_NAME = "substitutionGroup";

    public String[] getCandidateAttributeNamesForSchemaReferences() {
        return new String[]{REF_ATTR_NAME, TYPE_ATTR_NAME, BASE_ATTR_NAME, NAME_ATTR_NAME, SUBSTITUTION_GROUP_ATTR_NAME, MEMBER_TYPES_ATTR_NAME, VALUE_ATTR_NAME, ITEM_TYPE_ATTR_NAME};
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference[] psiReferenceArray;
        PsiReference[] psiReferenceArray2;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider.getReferencesByElement must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider.getReferencesByElement must not be null");
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof XmlAttribute)) {
            psiReferenceArray2 = PsiReference.EMPTY_ARRAY;
            if (PsiReference.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider.getReferencesByElement must not return null");
            return psiReferenceArray2;
        }
        String attrName = ((XmlAttribute)parent).getName();
        if (VALUE_ATTR_NAME.equals(attrName)) {
            if (PATTERN_TAG_NAME.equals(((XmlAttribute)parent).getParent().getLocalName())) {
                psiReferenceArray2 = new PsiReference[]{new RegExpReference(element)};
                if (psiReferenceArray2 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider.getReferencesByElement must not return null");
                return psiReferenceArray2;
            } else {
                psiReferenceArray2 = PsiReference.EMPTY_ARRAY;
                if (PsiReference.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider.getReferencesByElement must not return null");
                return psiReferenceArray2;
            }
        }
        if (NAME_ATTR_NAME.equals(attrName)) {
            psiReferenceArray2 = new PsiReference[]{new NameReference(element)};
            if (psiReferenceArray2 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider.getReferencesByElement must not return null");
            return psiReferenceArray2;
        }
        if (MEMBER_TYPES_ATTR_NAME.equals(attrName)) {
            ArrayList<TypeOrElementOrAttributeReference> result = new ArrayList<TypeOrElementOrAttributeReference>(1);
            String text = element.getText();
            int lastIndex = 1;
            int testLength = text.length();
            for (int i = 1; i < testLength; ++i) {
                if (!Character.isWhitespace(text.charAt(i))) continue;
                if (lastIndex != i) {
                    result.add(new TypeOrElementOrAttributeReference(element, new TextRange(lastIndex, i)));
                }
                lastIndex = i + 1;
            }
            if (lastIndex != testLength - 1) {
                result.add(new TypeOrElementOrAttributeReference(element, new TextRange(lastIndex, testLength - 1)));
            }
            if ((psiReferenceArray2 = result.toArray(new PsiReference[result.size()])) == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider.getReferencesByElement must not return null");
            return psiReferenceArray2;
        }
        PsiReference prefix = SchemaReferencesProvider.createSchemaPrefixReference(element);
        PsiReference ref = SchemaReferencesProvider.createTypeOrElementOrAttributeReference(element, prefix == null ? null : prefix.getCanonicalText());
        if (prefix == null) {
            PsiReference[] psiReferenceArray3 = new PsiReference[1];
            psiReferenceArray = psiReferenceArray3;
            psiReferenceArray3[0] = ref;
        } else {
            PsiReference[] psiReferenceArray4 = new PsiReference[2];
            psiReferenceArray4[0] = ref;
            psiReferenceArray = psiReferenceArray4;
            psiReferenceArray4[1] = prefix;
        }
        psiReferenceArray2 = psiReferenceArray;
        if (psiReferenceArray != null) return psiReferenceArray2;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider.getReferencesByElement must not return null");
    }

    public static PsiReference createTypeOrElementOrAttributeReference(PsiElement element) {
        return SchemaReferencesProvider.createTypeOrElementOrAttributeReference(element, null);
    }

    public static PsiReference createTypeOrElementOrAttributeReference(PsiElement element, String ns) {
        int offset;
        int length = element.getTextLength();
        int n = offset = element instanceof XmlAttributeValue ? XmlUtil.findPrefixByQualifiedName(((XmlAttributeValue)element).getValue()).length() : 0;
        if (offset > 0) {
            ++offset;
        }
        TypeOrElementOrAttributeReference ref = new TypeOrElementOrAttributeReference(element, length >= 2 ? new TextRange(1 + offset, length - 1) : new TextRange(0, 0));
        ref.setNamespacePrefix(ns);
        return ref;
    }

    @Nullable
    public static PsiReference createSchemaPrefixReference(PsiElement element) {
        XmlAttributeValue attributeValue;
        String prefix;
        if (element instanceof XmlAttributeValue && (prefix = XmlUtil.findPrefixByQualifiedName((attributeValue = (XmlAttributeValue)element).getValue())).length() > 0) {
            return new SchemaPrefixReference((XmlElement)attributeValue, TextRange.from((int)1, (int)prefix.length()), prefix);
        }
        return null;
    }

    @Nullable
    public static XmlNSDescriptorImpl findRedefinedDescriptor(XmlTag tag, String text) {
        for (XmlTag parentTag = tag.getParentTag(); parentTag != null; parentTag = parentTag.getParentTag()) {
            XmlTag grandParent;
            if (!text.equals(parentTag.getAttributeValue(NAME_ATTR_NAME)) || (grandParent = parentTag.getParentTag()) == null || !"redefine".equals(grandParent.getLocalName())) continue;
            return XmlNSDescriptorImpl.getRedefinedElementDescriptor(grandParent);
        }
        return null;
    }

    private static class CreateXmlElementIntentionAction
    implements IntentionAction {
        private final String myMessageKey;
        protected final TypeOrElementOrAttributeReference myRef;
        private boolean myIsAvailableEvaluated;
        private XmlFile myTargetFile;
        private final String myDeclarationTagName;

        CreateXmlElementIntentionAction(@PropertyKey(resourceBundle="messages.XmlBundle") String messageKey, @NonNls @NotNull String declarationTagName, TypeOrElementOrAttributeReference ref) {
            if (declarationTagName == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider$CreateXmlElementIntentionAction.<init> must not be null");
            }
            this.myMessageKey = messageKey;
            this.myRef = ref;
            this.myDeclarationTagName = declarationTagName;
        }

        @NotNull
        public String getText() {
            String string = XmlBundle.message((String)this.myMessageKey, (Object[])new Object[]{XmlUtil.findLocalNameByQualifiedName(this.myRef.getCanonicalText())});
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider$CreateXmlElementIntentionAction.getText must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = XmlBundle.message((String)"xml.create.xml.declaration.intention.type", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider$CreateXmlElementIntentionAction.getFamilyName must not return null");
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider$CreateXmlElementIntentionAction.isAvailable must not be null");
            }
            if (!this.myIsAvailableEvaluated) {
                XmlNSDescriptorImpl descriptor;
                XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myRef.getElement(), XmlTag.class);
                if (tag != null && (descriptor = this.myRef.getDescriptor(tag, this.myRef.getCanonicalText())) != null && descriptor.getDescriptorFile() != null && descriptor.getDescriptorFile().isWritable()) {
                    this.myTargetFile = descriptor.getDescriptorFile();
                }
                this.myIsAvailableEvaluated = true;
            }
            return this.myTargetFile != null;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider$CreateXmlElementIntentionAction.invoke must not be null");
            }
            if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
                return;
            }
            XmlTag rootTag = this.myTargetFile.getDocument().getRootTag();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, this.myTargetFile.getVirtualFile(), rootTag.getValue().getTextRange().getEndOffset());
            Editor targetEditor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
            TemplateManager manager = TemplateManager.getInstance(project);
            Template template = manager.createTemplate("", "");
            this.addTextTo(template, rootTag);
            manager.startTemplate(targetEditor, template);
        }

        protected void addTextTo(Template template, XmlTag rootTag) {
            String schemaPrefix = rootTag.getPrefixByNamespace("http://www.w3.org/2001/XMLSchema");
            if (schemaPrefix.length() > 0) {
                schemaPrefix = schemaPrefix + ":";
            }
            template.addTextSegment("<" + schemaPrefix + this.myDeclarationTagName + " name=\"" + XmlUtil.findLocalNameByQualifiedName(this.myRef.getCanonicalText()) + "\">");
            template.addEndVariable();
            template.addTextSegment("</" + schemaPrefix + this.myDeclarationTagName + ">\n");
            template.setToReformat(true);
        }

        public boolean startInWriteAction() {
            return true;
        }
    }

    static class TypeOrElementOrAttributeReference
    implements PsiReference,
    QuickFixProvider<TypeOrElementOrAttributeReference> {
        private final PsiElement myElement;
        private TextRange myRange;
        private String nsPrefix;
        private ReferenceType myType;

        @Override
        public void registerQuickfix(HighlightInfo info, TypeOrElementOrAttributeReference reference) {
            if (this.myType == ReferenceType.TypeReference) {
                QuickFixAction.registerQuickFixAction(info, new CreateXmlElementIntentionAction("xml.schema.create.complex.type.intention.name", SchemaReferencesProvider.COMPLEX_TYPE_TAG_NAME, reference));
                QuickFixAction.registerQuickFixAction(info, new CreateXmlElementIntentionAction("xml.schema.create.simple.type.intention.name", SchemaReferencesProvider.SIMPLE_TYPE_TAG_NAME, reference));
            } else if (this.myType != null) {
                String key = null;
                String declarationTagName = null;
                if (this.myType == ReferenceType.ElementReference) {
                    declarationTagName = SchemaReferencesProvider.ELEMENT_TAG_NAME;
                    key = "xml.schema.create.element.intention.name";
                } else if (this.myType == ReferenceType.AttributeReference) {
                    declarationTagName = SchemaReferencesProvider.ATTRIBUTE_TAG_NAME;
                    key = "xml.schema.create.attribute.intention.name";
                } else if (this.myType == ReferenceType.AttributeGroupReference) {
                    declarationTagName = SchemaReferencesProvider.ATTRIBUTE_GROUP_TAG_NAME;
                    key = "xml.schema.create.attribute.group.intention.name";
                } else if (this.myType == ReferenceType.GroupReference) {
                    declarationTagName = SchemaReferencesProvider.GROUP_TAG_NAME;
                    key = "xml.schema.create.group.intention.name";
                }
                assert (key != null && declarationTagName != null);
                QuickFixAction.registerQuickFixAction(info, new CreateXmlElementIntentionAction(key, declarationTagName, reference));
            }
        }

        public void setNamespacePrefix(String prefix) {
            this.nsPrefix = prefix;
        }

        TypeOrElementOrAttributeReference(PsiElement element, TextRange range) {
            this.myElement = element;
            this.myRange = range;
            assert (this.myRange.getLength() >= 0);
            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlAttribute.class);
            XmlTag tag = attribute.getParent();
            String localName = tag.getLocalName();
            String attributeLocalName = attribute.getLocalName();
            if (SchemaReferencesProvider.REF_ATTR_NAME.equals(attributeLocalName) || SchemaReferencesProvider.SUBSTITUTION_GROUP_ATTR_NAME.equals(attributeLocalName)) {
                if (localName.equals(SchemaReferencesProvider.GROUP_TAG_NAME)) {
                    this.myType = ReferenceType.GroupReference;
                } else if (localName.equals(SchemaReferencesProvider.ATTRIBUTE_GROUP_TAG_NAME)) {
                    this.myType = ReferenceType.AttributeGroupReference;
                } else if (SchemaReferencesProvider.ELEMENT_TAG_NAME.equals(localName)) {
                    this.myType = ReferenceType.ElementReference;
                } else if (SchemaReferencesProvider.ATTRIBUTE_TAG_NAME.equals(localName)) {
                    this.myType = ReferenceType.AttributeReference;
                }
            } else if (SchemaReferencesProvider.TYPE_ATTR_NAME.equals(attributeLocalName) || SchemaReferencesProvider.BASE_ATTR_NAME.equals(attributeLocalName) || SchemaReferencesProvider.MEMBER_TYPES_ATTR_NAME.equals(attributeLocalName) || SchemaReferencesProvider.ITEM_TYPE_ATTR_NAME.equals(attributeLocalName)) {
                this.myType = ReferenceType.TypeReference;
            }
        }

        public PsiElement getElement() {
            return this.myElement;
        }

        public TextRange getRangeInElement() {
            return this.myRange;
        }

        @Nullable
        public PsiElement resolve() {
            PsiManager manager = this.getElement().getManager();
            PsiElement psiElement = manager instanceof PsiManagerImpl ? ((PsiManagerImpl)manager).getResolveCache().resolveWithCaching(this, MyResolver.INSTANCE, false, false) : this.resolveInner();
            return psiElement != PsiUtilBase.NULL_PSI_ELEMENT ? psiElement : null;
        }

        private PsiElement resolveInner() {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlTag.class);
            if (tag == null) {
                return PsiUtilBase.NULL_PSI_ELEMENT;
            }
            String canonicalText = this.getCanonicalText();
            XmlNSDescriptorImpl nsDescriptor = this.getDescriptor(tag, canonicalText);
            if (this.myType != null && nsDescriptor != null && nsDescriptor.getTag() != null) {
                switch (this.myType) {
                    case GroupReference: {
                        return nsDescriptor.findGroup(canonicalText);
                    }
                    case AttributeGroupReference: {
                        return nsDescriptor.findAttributeGroup(canonicalText);
                    }
                    case ElementReference: {
                        XmlElementDescriptor descriptor = nsDescriptor.getElementDescriptor(XmlUtil.findLocalNameByQualifiedName(canonicalText), TypeOrElementOrAttributeReference.getNamespace(tag, canonicalText), new HashSet<XmlNSDescriptorImpl>(), true);
                        return descriptor != null ? descriptor.getDeclaration() : PsiUtilBase.NULL_PSI_ELEMENT;
                    }
                    case AttributeReference: {
                        String localNameByQualifiedName = XmlUtil.findLocalNameByQualifiedName(canonicalText);
                        XmlAttributeDescriptor descriptor = nsDescriptor.getAttribute(localNameByQualifiedName, TypeOrElementOrAttributeReference.getNamespace(tag, canonicalText), tag);
                        if (descriptor != null) {
                            return descriptor.getDeclaration();
                        }
                        return PsiUtilBase.NULL_PSI_ELEMENT;
                    }
                    case TypeReference: {
                        TypeDescriptor typeDescriptor = nsDescriptor.getTypeDescriptor(canonicalText, tag);
                        if (typeDescriptor instanceof ComplexTypeDescriptor) {
                            return ((ComplexTypeDescriptor)typeDescriptor).getDeclaration();
                        }
                        if (!(typeDescriptor instanceof TypeDescriptor)) break;
                        return this.myElement;
                    }
                }
            }
            return PsiUtilBase.NULL_PSI_ELEMENT;
        }

        private XmlNSDescriptorImpl getDescriptor(XmlTag tag, String text) {
            if (this.myType != ReferenceType.ElementReference && this.myType != ReferenceType.AttributeReference) {
                XmlNSDescriptorImpl redefinedDescriptor;
                PsiElement parentElement = this.myElement.getParent();
                PsiElement grandParentElement = parentElement != null ? parentElement.getParent() : null;
                boolean doRedefineCheck = false;
                if (parentElement instanceof XmlAttribute && grandParentElement instanceof XmlTag) {
                    String attrName = ((XmlAttribute)parentElement).getName();
                    String tagLocalName = ((XmlTag)grandParentElement).getLocalName();
                    boolean bl = doRedefineCheck = SchemaReferencesProvider.REF_ATTR_NAME.equals(attrName) && (SchemaReferencesProvider.GROUP_TAG_NAME.equals(tagLocalName) || SchemaReferencesProvider.ATTRIBUTE_GROUP_TAG_NAME.equals(tagLocalName)) || SchemaReferencesProvider.BASE_ATTR_NAME.equals(attrName) || SchemaReferencesProvider.MEMBER_TYPES_ATTR_NAME.equals(attrName);
                }
                if (doRedefineCheck && (redefinedDescriptor = SchemaReferencesProvider.findRedefinedDescriptor(tag, text)) != null) {
                    return redefinedDescriptor;
                }
            }
            final String namespace = TypeOrElementOrAttributeReference.getNamespace(tag, text);
            XmlNSDescriptor nsDescriptor = tag.getNSDescriptor(namespace, true);
            XmlDocument document = ((XmlFile)tag.getContainingFile()).getDocument();
            if (nsDescriptor == null) {
                nsDescriptor = (XmlNSDescriptor)document.getMetaData();
            }
            if (nsDescriptor == null) {
                final XmlNSDescriptor[] descrs = new XmlNSDescriptor[1];
                URLReference.processWsdlSchemas(document.getRootTag(), new Processor<XmlTag>(){

                    public boolean process(XmlTag xmlTag) {
                        if (namespace.equals(xmlTag.getAttributeValue(SchemaReferencesProvider.TARGET_NAMESPACE))) {
                            descrs[0] = (XmlNSDescriptor)xmlTag.getMetaData();
                            return false;
                        }
                        return true;
                    }
                });
                if (descrs[0] instanceof XmlNSDescriptorImpl) {
                    return (XmlNSDescriptorImpl)descrs[0];
                }
            }
            return nsDescriptor instanceof XmlNSDescriptorImpl ? (XmlNSDescriptorImpl)nsDescriptor : null;
        }

        private static String getNamespace(XmlTag tag, String text) {
            String targetNsPrefix;
            String targetNS;
            String namespacePrefix = XmlUtil.findPrefixByQualifiedName(text);
            String namespaceByPrefix = tag.getNamespaceByPrefix(namespacePrefix);
            if (namespaceByPrefix.length() > 0) {
                return namespaceByPrefix;
            }
            XmlTag rootTag = ((XmlFile)tag.getContainingFile()).getDocument().getRootTag();
            if (rootTag != null && "schema".equals(rootTag.getLocalName()) && XmlUtil.ourSchemaUrisList.indexOf(rootTag.getNamespace()) != -1 && (targetNS = rootTag.getAttributeValue(SchemaReferencesProvider.TARGET_NAMESPACE)) != null && (namespacePrefix.equals(targetNsPrefix = rootTag.getPrefixByNamespace(targetNS)) || namespaceByPrefix.length() == 0 && targetNsPrefix == null)) {
                return targetNS;
            }
            return namespaceByPrefix;
        }

        public String getCanonicalText() {
            String name;
            String text = this.myElement.getText();
            String string = name = this.myRange.getEndOffset() < text.length() ? this.myRange.substring(text) : "";
            if (name.length() > 0 && this.nsPrefix != null && this.nsPrefix.length() > 0) {
                name = this.nsPrefix + ":" + name;
            }
            return name;
        }

        public PsiElement handleElementRename(String _newElementName) throws IncorrectOperationException {
            String canonicalText = this.getCanonicalText();
            String newElementName = _newElementName;
            PsiElement element = ElementManipulators.getManipulator((PsiElement)this.myElement).handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
            this.myRange = new TextRange(this.myRange.getStartOffset(), this.myRange.getEndOffset() - (canonicalText.length() - newElementName.length()));
            return element;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider$TypeOrElementOrAttributeReference.bindToElement must not be null");
            }
            throw new IncorrectOperationException();
        }

        public boolean isReferenceTo(PsiElement element) {
            return this.myElement.getManager().areElementsEquivalent(this.resolve(), element);
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        @NotNull
        public Object[] getVariants() {
            String ourNamespace;
            Object[] objectArray;
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlTag.class);
            if (tag == null) {
                objectArray = null;
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider$TypeOrElementOrAttributeReference.getVariants must not return null");
            }
            String[] tagNames = null;
            switch (this.myType) {
                case GroupReference: {
                    tagNames = new String[]{SchemaReferencesProvider.GROUP_TAG_NAME};
                    break;
                }
                case AttributeGroupReference: {
                    tagNames = new String[]{SchemaReferencesProvider.ATTRIBUTE_GROUP_TAG_NAME};
                    break;
                }
                case AttributeReference: {
                    tagNames = new String[]{SchemaReferencesProvider.ATTRIBUTE_TAG_NAME};
                    break;
                }
                case ElementReference: {
                    tagNames = new String[]{SchemaReferencesProvider.ELEMENT_TAG_NAME};
                    break;
                }
                case TypeReference: {
                    tagNames = new String[]{SchemaReferencesProvider.SIMPLE_TYPE_TAG_NAME, SchemaReferencesProvider.COMPLEX_TYPE_TAG_NAME};
                    break;
                }
            }
            CompletionProcessor processor = new CompletionProcessor();
            processor.tag = tag;
            XmlDocument document = ((XmlFile)this.myElement.getContainingFile()).getDocument();
            XmlTag rootTag = document.getRootTag();
            String string = ourNamespace = rootTag != null ? rootTag.getAttributeValue(SchemaReferencesProvider.TARGET_NAMESPACE) : "";
            if (ourNamespace == null) {
                ourNamespace = "";
            }
            for (String namespace : tag.knownNamespaces()) {
                XmlNSDescriptor nsDescriptor;
                if (ourNamespace.equals(namespace) || !((nsDescriptor = tag.getNSDescriptor(namespace, true)) instanceof XmlNSDescriptorImpl)) continue;
                TypeOrElementOrAttributeReference.processNamespace(namespace, processor, nsDescriptor, tagNames);
            }
            XmlNSDescriptor nsDescriptor = (XmlNSDescriptor)document.getMetaData();
            if (nsDescriptor != null) {
                TypeOrElementOrAttributeReference.processNamespace(ourNamespace, processor, nsDescriptor, tagNames);
            }
            Object[] objectArray2 = ArrayUtil.toStringArray(processor.myElements);
            objectArray = objectArray2;
            if (objectArray2 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider$TypeOrElementOrAttributeReference.getVariants must not return null");
            return objectArray;
        }

        private static void processNamespace(String namespace, CompletionProcessor processor, XmlNSDescriptor nsDescriptor, String[] tagNames) {
            processor.namespace = namespace;
            XmlNSDescriptorImpl xmlNSDescriptor = (XmlNSDescriptorImpl)nsDescriptor;
            xmlNSDescriptor.processTagsInNamespace(xmlNSDescriptor.getTag(), tagNames, processor);
        }

        public boolean isSoft() {
            return false;
        }

        private static class MyResolver
        implements ResolveCache.Resolver {
            static MyResolver INSTANCE = new MyResolver();

            private MyResolver() {
            }

            @Override
            public PsiElement resolve(PsiReference ref, boolean incompleteCode) {
                return ((TypeOrElementOrAttributeReference)ref).resolveInner();
            }
        }

        class CompletionProcessor
        implements PsiElementProcessor<XmlTag> {
            List<String> myElements = new ArrayList<String>(1);
            String namespace;
            XmlTag tag;

            CompletionProcessor() {
            }

            public boolean execute(XmlTag element) {
                String name = element.getAttributeValue(SchemaReferencesProvider.NAME_ATTR_NAME);
                String prefixByNamespace = this.tag.getPrefixByNamespace(this.namespace);
                if (prefixByNamespace != null && prefixByNamespace.length() > 0 && TypeOrElementOrAttributeReference.this.nsPrefix == null) {
                    name = prefixByNamespace + ":" + name;
                }
                this.myElements.add(name);
                return true;
            }
        }

        static enum ReferenceType {
            ElementReference,
            AttributeReference,
            GroupReference,
            AttributeGroupReference,
            TypeReference;

        }
    }

    public static class NameReference
    implements PsiReference {
        private final PsiElement myElement;

        public NameReference(PsiElement element) {
            this.myElement = element;
        }

        public PsiElement getElement() {
            return this.myElement;
        }

        public TextRange getRangeInElement() {
            return new TextRange(1, this.myElement.getTextLength() - 1);
        }

        @Nullable
        public PsiElement resolve() {
            return this.myElement.getParent().getParent();
        }

        public String getCanonicalText() {
            String text = this.myElement.getText();
            return text.substring(1, text.length() - 1);
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return ElementManipulators.getManipulator((PsiElement)this.myElement).handleContentChange(this.myElement, this.getRangeInElement(), newElementName.substring(newElementName.indexOf(58) + 1));
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider$NameReference.bindToElement must not be null");
            }
            return null;
        }

        public boolean isReferenceTo(PsiElement element) {
            return this.myElement.getManager().areElementsEquivalent(this.resolve(), element);
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider$NameReference.getVariants must not return null");
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public boolean isSoft() {
            return true;
        }
    }

    static class RegExpReference
    extends BasicAttributeValueReference
    implements EmptyResolveMessageProvider {
        private String message;
        private static final Pattern pattern = Pattern.compile("^(?:\\\\i|\\\\l)");
        private static final Pattern pattern2 = Pattern.compile("([^\\\\])(?:\\\\i|\\\\l)");

        public RegExpReference(PsiElement element) {
            super(element);
        }

        @Nullable
        public PsiElement resolve() {
            try {
                String text = this.getCanonicalText();
                text = pattern2.matcher(pattern.matcher(text).replaceFirst("\\\\w")).replaceAll("$1\\\\w");
                Pattern.compile(text);
                this.message = null;
                return this.myElement;
            }
            catch (Exception e) {
                this.message = PsiBundle.message((String)"invalid.reqular.expression.message", (Object[])new Object[]{this.getCanonicalText()});
                return null;
            }
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider$RegExpReference.getVariants must not return null");
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public boolean isSoft() {
            return false;
        }

        public String getUnresolvedMessagePattern() {
            return this.message;
        }
    }
}

