/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.BasicAttributeValueReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileBasedUserDataCache;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.util.XmlDeclareIdInCommentAction;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdRefReference
extends BasicAttributeValueReference {
    private final boolean myIdAttrsOnly;
    private static final FileBasedUserDataCache<List<PsiElement>> ourCachedIdsCache = new FileBasedUserDataCache<List<PsiElement>>(){
        private final Key<CachedValue<List<PsiElement>>> ourCachedIdsValueKey = Key.create((String)"my.ids.cached.value");

        @Override
        protected List<PsiElement> doCompute(PsiFile file) {
            final ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(true){

                public void visitXmlTag(XmlTag tag) {
                    if (IdRefReference.isAcceptableTagType(tag)) {
                        result.add(tag);
                    }
                    super.visitXmlTag(tag);
                }

                public void visitComment(PsiComment comment) {
                    if (IdRefReference.isDeclarationComment(comment)) {
                        result.add(comment);
                    }
                    super.visitComment(comment);
                }

                public void visitXmlComment(XmlComment comment) {
                    if (IdRefReference.isDeclarationComment((PsiComment)comment)) {
                        result.add(comment);
                    }
                    super.visitComment((PsiComment)comment);
                }
            });
            return result;
        }

        @Override
        protected Key<CachedValue<List<PsiElement>>> getKey() {
            return this.ourCachedIdsValueKey;
        }
    };

    public IdRefReference(PsiElement element, int offset, boolean idAttrsOnly) {
        super(element, offset);
        this.myIdAttrsOnly = idAttrsOnly;
    }

    public IdRefReference(PsiElement element) {
        super(element);
        this.myIdAttrsOnly = false;
    }

    @Nullable
    protected PsiElement getIdValueElement(PsiElement element) {
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            XmlAttribute attribute = tag.getAttribute("id", null);
            if (!this.myIdAttrsOnly) {
                if (attribute == null) {
                    attribute = tag.getAttribute("name", null);
                }
                if (attribute == null) {
                    attribute = tag.getAttribute("styleId", null);
                }
            }
            return attribute != null ? attribute.getValueElement() : null;
        }
        return element;
    }

    @Nullable
    protected String getIdValue(PsiElement element) {
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            String s = tag.getAttributeValue("id");
            if (!this.myIdAttrsOnly) {
                if (s == null) {
                    s = tag.getAttributeValue("name");
                }
                if (s == null) {
                    s = tag.getAttributeValue("styleId");
                }
            }
            return s;
        }
        if (element instanceof PsiComment) {
            return IdRefReference.getImplicitIdValue((PsiComment)element);
        }
        return null;
    }

    protected static boolean isAcceptableTagType(XmlTag subTag) {
        return subTag.getAttributeValue("id") != null || subTag.getAttributeValue("for") != null || subTag.getAttributeValue("name") != null && subTag.getName().indexOf(".directive") == -1;
    }

    private static boolean isDeclarationComment(@NotNull PsiComment comment) {
        if (comment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/IdRefReference.isDeclarationComment must not be null");
        }
        return comment.getText().contains("@declare id=");
    }

    @Nullable
    private static String getImplicitIdValue(@NotNull PsiComment comment) {
        if (comment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/IdRefReference.getImplicitIdValue must not be null");
        }
        return XmlDeclareIdInCommentAction.getImplicitlyDeclaredId(comment);
    }

    private void process(PsiElementProcessor<PsiElement> processor) {
        PsiFile psiFile = this.getElement().getContainingFile();
        IdRefReference.process(processor, psiFile);
    }

    public static void process(PsiElementProcessor<PsiElement> processor, PsiFile file) {
        for (PsiElement e : ourCachedIdsCache.compute(file)) {
            if (processor.execute(e)) continue;
            return;
        }
    }

    @Nullable
    public PsiElement resolve() {
        final PsiElement[] result = new PsiElement[1];
        this.process(new PsiElementProcessor<PsiElement>(){
            String canonicalText;
            {
                this.canonicalText = IdRefReference.this.getCanonicalText();
            }

            public boolean execute(PsiElement element) {
                String idValue = IdRefReference.this.getIdValue(element);
                if (idValue != null && idValue.equals(this.canonicalText)) {
                    result[0] = IdRefReference.this.getIdValueElement(element);
                    return false;
                }
                return true;
            }
        });
        return result[0];
    }

    @NotNull
    public Object[] getVariants() {
        final LinkedList result = new LinkedList();
        this.process(new PsiElementProcessor<PsiElement>(){

            public boolean execute(PsiElement element) {
                String value = IdRefReference.this.getIdValue(element);
                if (value != null) {
                    result.add(value);
                }
                return true;
            }
        });
        Object[] objectArray = ArrayUtil.toObjectArray(result);
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/IdRefReference.getVariants must not return null");
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }
}

