/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaResolveCache {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.resolve.JavaResolveCache");
    private static final NotNullLazyKey<JavaResolveCache, Project> INSTANCE_KEY = ServiceManager.createLazyKey(JavaResolveCache.class);
    private final ConcurrentMap<PsiExpression, PsiType> myCalculatedTypes = new ConcurrentWeakHashMap();
    private static final Key<ResolveCache.MapPair<PsiVariable, Object>> VAR_TO_CONST_VALUE_MAP_KEY = Key.create((String)"ResolveCache.VAR_TO_CONST_VALUE_MAP_KEY");
    private final Map<PsiVariable, Object> myVarToConstValueMap1;
    private final Map<PsiVariable, Object> myVarToConstValueMap2;
    private static final Object NULL = Key.create((String)"NULL");
    public static final PsiType NULL_TYPE = new PsiEllipsisType(PsiType.NULL){

        public boolean isValid() {
            return true;
        }

        @NonNls
        public String getPresentableText() {
            return "FAKE TYPE";
        }
    };

    public static JavaResolveCache getInstance(Project project) {
        return (JavaResolveCache)INSTANCE_KEY.getValue((UserDataHolder)project);
    }

    public JavaResolveCache(PsiManagerEx manager) {
        ResolveCache cache = manager.getResolveCache();
        this.myVarToConstValueMap1 = cache.getOrCreateWeakMap(VAR_TO_CONST_VALUE_MAP_KEY, true);
        this.myVarToConstValueMap2 = cache.getOrCreateWeakMap(VAR_TO_CONST_VALUE_MAP_KEY, false);
        Runnable cleanuper = new Runnable(){

            @Override
            public void run() {
                JavaResolveCache.this.myCalculatedTypes.clear();
            }
        };
        cache.addRunnableToRunOnDropCaches(cleanuper);
        manager.registerRunnableToRunOnAnyChange(cleanuper);
    }

    public boolean isTypeCached(@NotNull PsiExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/JavaResolveCache.isTypeCached must not be null");
        }
        return this.myCalculatedTypes.get(expr) != null;
    }

    @Nullable
    public <T extends PsiExpression> PsiType getType(@NotNull T expr, @NotNull Function<T, PsiType> f) {
        if (expr == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/JavaResolveCache.getType must not be null");
        }
        if (f == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/JavaResolveCache.getType must not be null");
        }
        PsiType type = (PsiType)this.myCalculatedTypes.get(expr);
        if (type == null) {
            type = (PsiType)f.fun(expr);
            if (type == null) {
                type = NULL_TYPE;
            }
            type = (PsiType)ConcurrencyUtil.cacheOrGet(this.myCalculatedTypes, expr, (Object)type);
        }
        if (!type.isValid()) {
            LOG.error("Type is invalid: " + type + "; expr: '" + expr + "' is " + (expr.isValid() ? "valid" : "invalid"));
        }
        return type == NULL_TYPE ? null : type;
    }

    @Nullable
    public Object computeConstantValueWithCaching(PsiVariable variable, ConstValueComputer computer, Set<PsiVariable> visitedVars) {
        boolean physical = variable.isPhysical();
        Object cached = (physical ? this.myVarToConstValueMap1 : this.myVarToConstValueMap2).get(variable);
        if (cached == NULL) {
            return null;
        }
        if (cached != null) {
            return cached;
        }
        Object result = computer.execute(variable, visitedVars);
        (physical ? this.myVarToConstValueMap1 : this.myVarToConstValueMap2).put(variable, result != null ? result : NULL);
        return result;
    }

    public static interface ConstValueComputer {
        public Object execute(PsiVariable var1, Set<PsiVariable> var2);
    }
}

