/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter;
import java.util.ArrayList;

public class JDComment {
    protected CommentFormatter myFormatter;
    String description;
    protected ArrayList unknownList;
    protected ArrayList seeAlsoList;
    protected String since;
    String deprecated;

    public JDComment(CommentFormatter formatter) {
        this.myFormatter = formatter;
    }

    protected static boolean isNull(String s) {
        return s == null || s.trim().length() == 0;
    }

    protected static boolean isNull(ArrayList l) {
        return l == null || l.size() == 0;
    }

    public String generate(String indent) {
        String s;
        String prefix = this.myFormatter.getSettings().JD_LEADING_ASTERISKS_ARE_ENABLED ? indent + " * " : indent;
        StringBuffer sb = new StringBuffer();
        int start = sb.length();
        if (!JDComment.isNull(this.description)) {
            sb.append(this.myFormatter.getParser().splitIntoCLines(this.description, prefix));
            if (this.myFormatter.getSettings().JD_ADD_BLANK_AFTER_DESCRIPTION) {
                sb.append(prefix);
                sb.append('\n');
            }
        }
        this.generateSpecial(prefix, sb);
        if (!JDComment.isNull(this.unknownList) && this.myFormatter.getSettings().JD_KEEP_INVALID_TAGS) {
            for (Object aUnknownList : this.unknownList) {
                s = (String)aUnknownList;
                sb.append(this.myFormatter.getParser().splitIntoCLines(s, prefix));
            }
        }
        if (!JDComment.isNull(this.seeAlsoList)) {
            for (Object aSeeAlsoList : this.seeAlsoList) {
                s = (String)aSeeAlsoList;
                sb.append(prefix);
                sb.append("@see ");
                sb.append(this.myFormatter.getParser().splitIntoCLines(s, prefix + "     ", false));
            }
        }
        if (!JDComment.isNull(this.since)) {
            sb.append(prefix);
            sb.append("@since ");
            sb.append(this.myFormatter.getParser().splitIntoCLines(this.since, prefix + "       ", false));
        }
        if (this.deprecated != null) {
            sb.append(prefix);
            sb.append("@deprecated ");
            sb.append(this.myFormatter.getParser().splitIntoCLines(this.deprecated, prefix + "            ", false));
        }
        if (sb.length() == start) {
            return null;
        }
        int nlen = sb.length() - prefix.length() - 1;
        if (sb.substring(nlen, sb.length()).equals(prefix + "\n")) {
            sb.delete(nlen, sb.length());
        }
        if (!this.myFormatter.getSettings().JD_DO_NOT_WRAP_ONE_LINE_COMMENTS || sb.indexOf("\n") != sb.length() - 1) {
            sb.insert(0, "/**\n");
            sb.append(indent);
        } else {
            sb.replace(0, prefix.length(), "/** ");
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(" */");
        return sb.toString();
    }

    protected void generateSpecial(String prefix, StringBuffer sb) {
    }

    public void addSeeAlso(String seeAlso) {
        if (this.seeAlsoList == null) {
            this.seeAlsoList = new ArrayList();
        }
        this.seeAlsoList.add(seeAlso);
    }

    public void addUnknownTag(String unknownTag) {
        if (this.unknownList == null) {
            this.unknownList = new ArrayList();
        }
        this.unknownList.add(unknownTag);
    }

    public ArrayList getSeeAlsoList() {
        return this.seeAlsoList;
    }

    public void setUnknownList(ArrayList unknownList) {
        this.unknownList = unknownList;
    }

    public void setSeeAlsoList(ArrayList seeAlsoList) {
        this.seeAlsoList = seeAlsoList;
    }

    public ArrayList getUnknownList() {
        return this.unknownList;
    }

    public String getSince() {
        return this.since;
    }

    public void setSince(String since) {
        this.since = since;
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(String deprecated) {
        this.deprecated = deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

