/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CodeStyleSchemesImpl
extends CodeStyleSchemes
implements ExportableApplicationComponent,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl");
    @NonNls
    private static final String DEFAULT_SCHEME_NAME = "Default";
    public String CURRENT_SCHEME_NAME = "Default";
    private boolean myIsInitialized = false;
    @NonNls
    private static final String CODESTYLES_DIRECTORY = "codestyles";
    private final SchemesManager<CodeStyleScheme, CodeStyleSchemeImpl> mySchemesManager;
    private static final String FILE_SPEC = "$ROOT_CONFIG$/codestyles";

    public CodeStyleSchemesImpl(SchemesManagerFactory schemesManagerFactory) {
        SchemeProcessor<CodeStyleSchemeImpl> processor = new SchemeProcessor<CodeStyleSchemeImpl>(){

            public CodeStyleSchemeImpl readScheme(Document schemeContent) throws IOException, JDOMException, InvalidDataException {
                return CodeStyleSchemeImpl.readScheme(schemeContent);
            }

            public Document writeScheme(CodeStyleSchemeImpl scheme) throws WriteExternalException {
                return scheme.saveToDocument();
            }

            public boolean shouldBeSaved(CodeStyleSchemeImpl scheme) {
                return !scheme.isDefault();
            }

            public void initScheme(CodeStyleSchemeImpl scheme) {
                scheme.init(CodeStyleSchemesImpl.this);
            }

            public void onSchemeAdded(CodeStyleSchemeImpl scheme) {
            }

            public void onSchemeDeleted(CodeStyleSchemeImpl scheme) {
            }

            public void onCurrentSchemeChanged(Scheme newCurrentScheme) {
            }
        };
        this.mySchemesManager = schemesManagerFactory.createSchemesManager(FILE_SPEC, (SchemeProcessor)processor, RoamingType.PER_USER);
    }

    @NotNull
    public String getComponentName() {
        if ("CodeStyleSchemes" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl.getComponentName must not return null");
        }
        return "CodeStyleSchemes";
    }

    public void initComponent() {
        this.init();
        this.addScheme(new CodeStyleSchemeImpl(DEFAULT_SCHEME_NAME, true, null));
        CodeStyleScheme current = this.findSchemeByName(this.CURRENT_SCHEME_NAME);
        if (current == null) {
            current = this.getDefaultScheme();
        }
        this.setCurrentScheme(current);
    }

    public void disposeComponent() {
    }

    public CodeStyleScheme[] getSchemes() {
        List schemes = this.mySchemesManager.getAllSchemes();
        return schemes.toArray(new CodeStyleScheme[schemes.size()]);
    }

    public CodeStyleScheme getCurrentScheme() {
        return (CodeStyleScheme)this.mySchemesManager.getCurrentScheme();
    }

    public void setCurrentScheme(CodeStyleScheme scheme) {
        this.mySchemesManager.setCurrentSchemeName(scheme == null ? null : scheme.getName());
        this.CURRENT_SCHEME_NAME = scheme.getName();
    }

    public CodeStyleScheme createNewScheme(String preferredName, CodeStyleScheme parentScheme) {
        String name;
        if (preferredName == null) {
            name = null;
            int i = 1;
            while (name == null) {
                String currName = parentScheme.getName() + " (" + i + ")";
                if (null == this.findSchemeByName(currName)) {
                    name = currName;
                }
                ++i;
            }
        } else {
            name = null;
            int i = 0;
            while (name == null) {
                String currName;
                String string = currName = i == 0 ? preferredName : preferredName + " (" + i + ")";
                if (null == this.findSchemeByName(currName)) {
                    name = currName;
                }
                ++i;
            }
        }
        return new CodeStyleSchemeImpl(name, false, parentScheme);
    }

    public void deleteScheme(CodeStyleScheme scheme) {
        if (scheme.isDefault()) {
            throw new IllegalArgumentException("Unable to delete default scheme!");
        }
        CodeStyleSchemeImpl currScheme = (CodeStyleSchemeImpl)this.getCurrentScheme();
        if (currScheme == scheme) {
            CodeStyleScheme newCurrentScheme = this.getDefaultScheme();
            if (newCurrentScheme == null) {
                throw new IllegalStateException("Unable to load default scheme!");
            }
            this.setCurrentScheme(newCurrentScheme);
        }
        this.mySchemesManager.removeScheme((Scheme)scheme);
    }

    public CodeStyleScheme getDefaultScheme() {
        return this.findSchemeByName(DEFAULT_SCHEME_NAME);
    }

    public CodeStyleScheme findSchemeByName(String name) {
        return (CodeStyleScheme)this.mySchemesManager.findSchemeByName(name);
    }

    public void addScheme(CodeStyleScheme scheme) {
        this.mySchemesManager.addNewScheme((Scheme)scheme, true);
    }

    protected void removeScheme(CodeStyleScheme scheme) {
        this.mySchemesManager.removeScheme((Scheme)scheme);
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.init();
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
    }

    private void init() {
        if (this.myIsInitialized) {
            return;
        }
        this.myIsInitialized = true;
        this.mySchemesManager.loadSchemes();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{CodeStyleSchemesImpl.getDir(true), PathManager.getDefaultOptionsFile()};
        if (fileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl.getExportFiles must not return null");
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = PsiBundle.message((String)"codestyle.export.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl.getPresentableName must not return null");
        }
        return string;
    }

    private static File getDir(boolean create) {
        String directoryPath = PathManager.getConfigPath() + File.separator + CODESTYLES_DIRECTORY;
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            if (!create) {
                return null;
            }
            if (!directory.mkdir()) {
                Messages.showErrorDialog((String)PsiBundle.message((String)"codestyle.cannot.save.settings.directory.cant.be.created.message", (Object[])new Object[]{directoryPath}), (String)PsiBundle.message((String)"codestyle.cannot.save.settings.directory.cant.be.created.title", (Object[])new Object[0]));
                return null;
            }
        }
        return directory;
    }

    public SchemesManager<CodeStyleScheme, CodeStyleSchemeImpl> getSchemesManager() {
        return this.mySchemesManager;
    }
}

