/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.CompositeLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PlainTextTokenTypes;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.Indent;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.impl.source.codeStyle.Helper;
import com.intellij.psi.impl.source.codeStyle.HelperFactory;
import com.intellij.psi.impl.source.codeStyle.IndentImpl;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleManagerImpl
extends CodeStyleManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.CodeStyleManagerImpl");
    private final Project myProject;
    @NonNls
    private static final String DUMMY_IDENTIFIER = "xxx";

    public CodeStyleManagerImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl.getProject must not return null");
        }
        return project;
    }

    @NotNull
    public PsiElement reformat(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl.reformat must not be null");
        }
        PsiElement psiElement = this.reformat(element, false);
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl.reformat must not return null");
        }
        return psiElement;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiElement reformat(@NotNull PsiElement element, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        PsiElement psiElement;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl.reformat must not be null");
        }
        CheckUtil.checkWritable(element);
        if (!SourceTreeToPsiMap.hasTreeElement(element)) {
            psiElement = element;
            if (psiElement == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl.reformat must not return null");
            return psiElement;
        }
        ASTNode treeElement = SourceTreeToPsiMap.psiElementToTree(element);
        PsiFileImpl file = (PsiFileImpl)element.getContainingFile();
        LanguageFileType fileType = StdFileTypes.JAVA;
        if (file != null) {
            fileType = file.getFileType();
        }
        Helper helper = HelperFactory.createHelper((FileType)fileType, this.myProject);
        PsiElement formatted = SourceTreeToPsiMap.treeElementToPsi(new CodeFormatterFacade(this.getSettings(), helper).process(treeElement, -1));
        if (!canChangeWhiteSpacesOnly) {
            psiElement = this.postProcessElement(formatted);
            if (psiElement == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl.reformat must not return null");
            return psiElement;
        }
        psiElement = formatted;
        if (psiElement != null) return psiElement;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl.reformat must not return null");
    }

    private PsiElement postProcessElement(PsiElement formatted) {
        PsiElement result = formatted;
        for (PostFormatProcessor postFormatProcessor : (PostFormatProcessor[])Extensions.getExtensions(PostFormatProcessor.EP_NAME)) {
            result = postFormatProcessor.processElement(result, this.getSettings());
        }
        return result;
    }

    private void postProcessText(PsiFile file, TextRange textRange) {
        TextRange currentRange = textRange;
        for (PostFormatProcessor myPostFormatProcessor : (PostFormatProcessor[])Extensions.getExtensions(PostFormatProcessor.EP_NAME)) {
            currentRange = myPostFormatProcessor.processText(file, currentRange, this.getSettings());
        }
    }

    public PsiElement reformatRange(@NotNull PsiElement element, int startOffset, int endOffset, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl.reformatRange must not be null");
        }
        return this.reformatRangeImpl(element, startOffset, endOffset, canChangeWhiteSpacesOnly);
    }

    public PsiElement reformatRange(@NotNull PsiElement element, int startOffset, int endOffset) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl.reformatRange must not be null");
        }
        return this.reformatRangeImpl(element, startOffset, endOffset, false);
    }

    private static void transformAllChildren(ASTNode file) {
        for (ASTNode child = file.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            CodeStyleManagerImpl.transformAllChildren(child);
        }
    }

    public void reformatText(@NotNull PsiFile file, int startOffset, int endOffset) throws IncorrectOperationException {
        PsiElement endElement;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl.reformatText must not be null");
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        CheckUtil.checkWritable((PsiElement)file);
        if (!SourceTreeToPsiMap.hasTreeElement((PsiElement)file)) {
            return;
        }
        ASTNode treeElement = SourceTreeToPsiMap.psiElementToTree((PsiElement)file);
        CodeStyleManagerImpl.transformAllChildren(treeElement);
        FileType fileType = file.getFileType();
        Helper helper = HelperFactory.createHelper(fileType, this.myProject);
        CodeFormatterFacade codeFormatter = new CodeFormatterFacade(this.getSettings(), helper);
        LOG.assertTrue(file.isValid());
        PsiElement start = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file, startOffset);
        PsiElement end = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file, endOffset);
        if (start != null && !start.isValid()) {
            LOG.error("start=" + start + "; file=" + file);
        }
        if (end != null && !end.isValid()) {
            LOG.error("end=" + start + "; end=" + file);
        }
        boolean formatFromStart = startOffset == 0;
        boolean formatToEnd = endOffset == file.getTextLength();
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.getProject());
        SmartPsiElementPointer startPointer = start == null ? null : smartPointerManager.createSmartPsiElementPointer(start);
        SmartPsiElementPointer endPointer = end == null ? null : smartPointerManager.createSmartPsiElementPointer(end);
        codeFormatter.processTextWithPostponedFormatting(file, new FormatTextRanges(new TextRange(startOffset, endOffset), true));
        PsiElement startElement = startPointer == null ? null : startPointer.getElement();
        PsiElement psiElement = endElement = endPointer == null ? null : endPointer.getElement();
        if ((startElement != null || formatFromStart) && (endElement != null || formatToEnd)) {
            this.postProcessText(file, new TextRange(formatFromStart ? 0 : startElement.getTextRange().getStartOffset(), formatToEnd ? file.getTextLength() : endElement.getTextRange().getEndOffset()));
        }
    }

    private PsiElement reformatRangeImpl(PsiElement element, int startOffset, int endOffset, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        LOG.assertTrue(element.isValid());
        CheckUtil.checkWritable(element);
        if (!SourceTreeToPsiMap.hasTreeElement(element)) {
            return element;
        }
        ASTNode treeElement = SourceTreeToPsiMap.psiElementToTree(element);
        LanguageFileType fileType = StdFileTypes.JAVA;
        PsiFile file = element.getContainingFile();
        if (file != null) {
            fileType = file.getFileType();
        }
        Helper helper = HelperFactory.createHelper((FileType)fileType, this.myProject);
        CodeFormatterFacade codeFormatter = new CodeFormatterFacade(this.getSettings(), helper);
        PsiElement formatted = SourceTreeToPsiMap.treeElementToPsi(codeFormatter.processRange(treeElement, startOffset, endOffset));
        return canChangeWhiteSpacesOnly ? formatted : this.postProcessElement(formatted);
    }

    public void reformatNewlyAddedElement(@NotNull ASTNode parent, @NotNull ASTNode addedElement) throws IncorrectOperationException {
        FormattingModelBuilder builder;
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl.reformatNewlyAddedElement must not be null");
        }
        if (addedElement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl.reformatNewlyAddedElement must not be null");
        }
        LOG.assertTrue(addedElement.getTreeParent() == parent, (Object)"addedElement must be added to parent");
        PsiElement psiElement = parent.getPsi();
        PsiFile containingFile = psiElement.getContainingFile();
        FileViewProvider fileViewProvider = containingFile.getViewProvider();
        if (fileViewProvider instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
            containingFile = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
        }
        if ((builder = LanguageFormatting.INSTANCE.forContext((PsiElement)containingFile)) != null) {
            FormattingModel model = builder.createModel((PsiElement)containingFile, this.getSettings());
            FormatterEx.getInstanceEx().formatAroundRange(model, this.getSettings(), addedElement.getTextRange(), containingFile.getFileType());
        }
        this.adjustLineIndent(containingFile, addedElement.getTextRange());
    }

    public int adjustLineIndent(final @NotNull PsiFile file, final int offset) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl.adjustLineIndent must not be null");
        }
        Computable<Pair<Integer, IncorrectOperationException>> computable = new Computable<Pair<Integer, IncorrectOperationException>>(){

            public Pair<Integer, IncorrectOperationException> compute() {
                try {
                    return new Pair((Object)CodeStyleManagerImpl.this.adjustLineIndentInner(file, offset), null);
                }
                catch (IncorrectOperationException e) {
                    return new Pair(null, (Object)e);
                }
            }
        };
        Pair<Integer, IncorrectOperationException> pair = PostprocessReformattingAspect.getInstance(file.getProject()).disablePostprocessFormattingInside(computable);
        if (pair.getSecond() != null) {
            throw (IncorrectOperationException)((Object)pair.getSecond());
        }
        return (Integer)pair.getFirst();
    }

    public int adjustLineIndentInner(PsiFile file, int offset) throws IncorrectOperationException {
        FormattingModelBuilder builder;
        PsiElement element;
        PsiFile templateFile = PsiUtilBase.getTemplateLanguageFile((PsiElement)file);
        if (templateFile != null) {
            file = templateFile;
        }
        if ((element = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file, offset)) == null && offset != file.getTextLength()) {
            return offset;
        }
        if (element instanceof PsiComment && CodeStyleManagerImpl.insideElement(element, offset)) {
            return CharArrayUtil.shiftForward((CharSequence)file.getViewProvider().getContents(), (int)offset, (String)" \t");
        }
        FormattingModelBuilder elementBuilder = builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file);
        if (element != null) {
            elementBuilder = LanguageFormatting.INSTANCE.forContext(element);
        }
        if (builder != null && elementBuilder != null) {
            CodeStyleSettings settings = this.getSettings();
            CodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions(file.getFileType());
            TextRange significantRange = CodeStyleManagerImpl.getSignificantRange(file, offset);
            FormattingModel model = builder.createModel((PsiElement)file, settings);
            Document doc = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file);
            if (doc != null) {
                model = new DocumentBasedFormattingModel(model.getRootBlock(), doc, this.getProject(), settings, file.getFileType(), file);
            }
            return FormatterEx.getInstanceEx().adjustLineIndent(model, settings, indentOptions, offset, significantRange);
        }
        return offset;
    }

    @Nullable
    public static PsiElement findElementInTreeWithFormatterEnabled(PsiFile file, int offset) {
        PsiElement bottomost = file.findElementAt(offset);
        if (bottomost != null && LanguageFormatting.INSTANCE.forContext(bottomost) != null) {
            return bottomost;
        }
        Language fileLang = file.getLanguage();
        if (fileLang instanceof CompositeLanguage) {
            return file.getViewProvider().findElementAt(offset, fileLang);
        }
        return bottomost;
    }

    public int adjustLineIndent(final @NotNull Document document, final int offset) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl.adjustLineIndent must not be null");
        }
        return PostprocessReformattingAspect.getInstance(this.getProject()).disablePostprocessFormattingInside(new Computable<Integer>(){

            public Integer compute() {
                return CodeStyleManagerImpl.this.adjustLineIndentInner(document, offset);
            }
        });
    }

    public int adjustLineIndentInner(Document document, int offset) {
        FormattingModelBuilder builder;
        PsiElement element;
        PsiDocumentManager psiDocManager = PsiDocumentManager.getInstance((Project)this.myProject);
        psiDocManager.commitDocument(document);
        PsiFile file = psiDocManager.getPsiFile(document);
        if (file == null) {
            return offset;
        }
        PsiFile jspFile = PsiUtilBase.getTemplateLanguageFile((PsiElement)file);
        if (jspFile != null) {
            file = jspFile;
        }
        if ((element = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file, offset)) == null && offset != file.getTextLength()) {
            return offset;
        }
        if (element instanceof PsiComment && CodeStyleManagerImpl.insideElement(element, offset)) {
            return CharArrayUtil.shiftForward((CharSequence)file.getViewProvider().getContents(), (int)offset, (String)" \t");
        }
        FormattingModelBuilder elementBuilder = builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file);
        if (element != null) {
            elementBuilder = LanguageFormatting.INSTANCE.forContext(element);
        }
        if (builder != null && elementBuilder != null) {
            CodeStyleSettings settings = this.getSettings();
            CodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions(file.getFileType());
            TextRange significantRange = CodeStyleManagerImpl.getSignificantRange(file, offset);
            FormattingModel model = builder.createModel((PsiElement)file, settings);
            DocumentBasedFormattingModel documentBasedModel = new DocumentBasedFormattingModel(model.getRootBlock(), document, this.getProject(), settings, file.getFileType(), file);
            try {
                return FormatterEx.getInstanceEx().adjustLineIndent(documentBasedModel, settings, indentOptions, offset, significantRange);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return offset;
            }
        }
        return offset;
    }

    public void adjustLineIndent(@NotNull PsiFile file, TextRange rangeToAdjust) throws IncorrectOperationException {
        FormattingModelBuilder builder;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl.adjustLineIndent must not be null");
        }
        PsiFile templateFile = PsiUtilBase.getTemplateLanguageFile((PsiElement)file);
        if (templateFile != null) {
            file = templateFile;
        }
        if ((builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file)) != null) {
            CodeStyleSettings settings = this.getSettings();
            CodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions(file.getFileType());
            FormattingModel model = builder.createModel((PsiElement)file, settings);
            Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file);
            FormatterEx.getInstanceEx().adjustLineIndentsForRange(new DocumentBasedFormattingModel(model.getRootBlock(), document, this.getProject(), settings, file.getFileType(), file), settings, indentOptions, rangeToAdjust);
        }
    }

    @Nullable
    public String getLineIndent(@NotNull PsiFile file, int offset) {
        PsiElement element;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl.getLineIndent must not be null");
        }
        if (file instanceof PsiCompiledElement) {
            file = (PsiFile)((PsiCompiledElement)file).getMirror();
        }
        if ((element = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file, offset)) == null) {
            return null;
        }
        if (element instanceof PsiComment && CodeStyleManagerImpl.insideElement(element, offset)) {
            return null;
        }
        FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file);
        FormattingModelBuilder elementBuilder = LanguageFormatting.INSTANCE.forContext(element);
        if (builder != null && elementBuilder != null) {
            CodeStyleSettings settings = this.getSettings();
            CodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions(file.getFileType());
            TextRange significantRange = CodeStyleManagerImpl.getSignificantRange(file, offset);
            FormattingModel model = builder.createModel((PsiElement)file, settings);
            return FormatterEx.getInstanceEx().getLineIndent(model, settings, indentOptions, offset, significantRange);
        }
        return null;
    }

    @Nullable
    public String getLineIndent(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl.getLineIndent must not be null");
        }
        Document doc = editor.getDocument();
        int offset = editor.getCaretModel().getOffset();
        if (offset >= doc.getTextLength()) {
            return "";
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(doc);
        if (file == null) {
            return "";
        }
        return this.getLineIndent(file, offset);
    }

    private static boolean insideElement(PsiElement element, int offset) {
        TextRange textRange = element.getTextRange();
        return textRange.getStartOffset() < offset && textRange.getEndOffset() >= offset;
    }

    private static TextRange getSignificantRange(PsiFile file, int offset) {
        ASTNode elementAtOffset = SourceTreeToPsiMap.psiElementToTree(CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file, offset));
        if (elementAtOffset == null) {
            int significantRangeStart = CharArrayUtil.shiftBackward((CharSequence)file.getText(), (int)(offset - 1), (String)"\r\t ");
            return new TextRange(significantRangeStart, offset);
        }
        FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file);
        TextRange textRange = builder.getRangeAffectingIndent(file, offset, elementAtOffset);
        if (textRange != null) {
            return textRange;
        }
        return elementAtOffset.getTextRange();
    }

    public boolean isLineToBeIndented(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl.isLineToBeIndented must not be null");
        }
        if (!SourceTreeToPsiMap.hasTreeElement((PsiElement)file)) {
            return false;
        }
        Helper helper = HelperFactory.createHelper(file.getFileType(), this.myProject);
        CharSequence chars = file.getViewProvider().getContents();
        int start = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)" \t");
        if (start > 0 && chars.charAt(start) != '\n' && chars.charAt(start) != '\r') {
            return false;
        }
        int end = CharArrayUtil.shiftForward((CharSequence)chars, (int)offset, (String)" \t");
        if (end >= chars.length()) {
            return false;
        }
        ASTNode element = SourceTreeToPsiMap.psiElementToTree(CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file, end));
        if (element == null) {
            return false;
        }
        if (element.getElementType() == TokenType.WHITE_SPACE) {
            return false;
        }
        if (element.getElementType() == PlainTextTokenTypes.PLAIN_TEXT) {
            return false;
        }
        return !this.getSettings().KEEP_FIRST_COLUMN_COMMENT || !CodeStyleManagerImpl.isCommentToken(element) || helper.getIndent(element, true) != 0;
    }

    private static boolean isCommentToken(ASTNode element) {
        Language language = element.getElementType().getLanguage();
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        if (commenter instanceof CodeDocumentationAwareCommenter) {
            CodeDocumentationAwareCommenter documentationAwareCommenter = (CodeDocumentationAwareCommenter)commenter;
            return element.getElementType() == documentationAwareCommenter.getBlockCommentTokenType() || element.getElementType() == documentationAwareCommenter.getLineCommentTokenType();
        }
        return false;
    }

    @Nullable
    public PsiElement insertNewLineIndentMarker(@NotNull PsiFile file, int offset) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl.insertNewLineIndentMarker must not be null");
        }
        CheckUtil.checkWritable((PsiElement)file);
        CharTable charTable = ((FileElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)file)).getCharTable();
        PsiElement elementAt = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file, offset);
        if (elementAt == null) {
            return null;
        }
        ASTNode element = SourceTreeToPsiMap.psiElementToTree(elementAt);
        ASTNode parent = element.getTreeParent();
        int elementStart = element.getTextRange().getStartOffset();
        if (element.getElementType() != TokenType.WHITE_SPACE) {
            return null;
        }
        ASTNode space1 = CodeStyleManagerImpl.splitSpaceElement((TreeElement)element, offset - elementStart, charTable);
        LeafElement marker = Factory.createSingleLeafElement(TokenType.NEW_LINE_INDENT, DUMMY_IDENTIFIER, charTable, file.getManager());
        parent.addChild((ASTNode)marker, space1.getTreeNext());
        return SourceTreeToPsiMap.treeElementToPsi(marker);
    }

    public Indent getIndent(String text, FileType fileType) {
        int indent = HelperFactory.createHelper(fileType, this.myProject).getIndent(text, true);
        int indenLevel = indent / 10000;
        int spaceCount = indent - indenLevel * 10000;
        return new IndentImpl(this.getSettings(), indenLevel, spaceCount, fileType);
    }

    public String fillIndent(Indent indent, FileType fileType) {
        IndentImpl indent1 = (IndentImpl)indent;
        int indentLevel = indent1.getIndentLevel();
        int spaceCount = indent1.getSpaceCount();
        if (indentLevel < 0) {
            spaceCount += indentLevel * this.getSettings().getIndentSize(fileType);
            indentLevel = 0;
            if (spaceCount < 0) {
                spaceCount = 0;
            }
        } else if (spaceCount < 0) {
            int v = (-spaceCount + this.getSettings().getIndentSize(fileType) - 1) / this.getSettings().getIndentSize(fileType);
            spaceCount += v * this.getSettings().getIndentSize(fileType);
            if ((indentLevel -= v) < 0) {
                indentLevel = 0;
            }
        }
        return HelperFactory.createHelper(fileType, this.myProject).fillIndent(indentLevel * 10000 + spaceCount);
    }

    public Indent zeroIndent() {
        return new IndentImpl(this.getSettings(), 0, 0, null);
    }

    private static ASTNode splitSpaceElement(TreeElement space, int offset, CharTable charTable) {
        LOG.assertTrue(space.getElementType() == TokenType.WHITE_SPACE);
        CharSequence chars = space.getChars();
        LeafElement space1 = Factory.createSingleLeafElement(TokenType.WHITE_SPACE, chars, 0, offset, charTable, SharedImplUtil.getManagerByTree(space));
        LeafElement space2 = Factory.createSingleLeafElement(TokenType.WHITE_SPACE, chars, offset, chars.length(), charTable, SharedImplUtil.getManagerByTree(space));
        CompositeElement parent = space.getTreeParent();
        parent.replaceChild(space, space1);
        parent.addChild(space2, space1.getTreeNext());
        return space1;
    }

    private CodeStyleSettings getSettings() {
        return CodeStyleSettingsManager.getSettings((Project)this.myProject);
    }
}

