/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import org.jetbrains.annotations.Nullable;

public class AbstractPostFormatProcessor {
    public final CodeStyleSettings mySettings;
    private TextRange myResultTextRange;

    public AbstractPostFormatProcessor(CodeStyleSettings settings) {
        this.mySettings = settings;
    }

    public void updateResultRange(int oldTextLength, int newTextLength) {
        if (this.myResultTextRange == null) {
            return;
        }
        this.myResultTextRange = new TextRange(this.myResultTextRange.getStartOffset(), this.myResultTextRange.getEndOffset() - oldTextLength + newTextLength);
    }

    public boolean checkElementContainsRange(PsiElement element) {
        if (this.myResultTextRange == null) {
            return true;
        }
        TextRange elementRange = element.getTextRange();
        if (elementRange.getEndOffset() < this.myResultTextRange.getStartOffset()) {
            return false;
        }
        return elementRange.getStartOffset() <= this.myResultTextRange.getEndOffset();
    }

    public boolean checkRangeContainsElement(PsiElement element) {
        if (this.myResultTextRange == null) {
            return true;
        }
        TextRange elementRange = element.getTextRange();
        return elementRange.getStartOffset() >= this.myResultTextRange.getStartOffset() && elementRange.getEndOffset() <= this.myResultTextRange.getEndOffset();
    }

    public static boolean isMultiline(@Nullable PsiElement statement) {
        if (statement == null) {
            return false;
        }
        return statement.textContains('\n');
    }

    public void setResultTextRange(TextRange resultTextRange) {
        this.myResultTextRange = resultTextRange;
    }

    public TextRange getResultTextRange() {
        return this.myResultTextRange;
    }
}

