/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.StringSearcher;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LowLevelSearchUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.LowLevelSearchUtil");

    private LowLevelSearchUtil() {
    }

    private static Boolean processInjectedFile(PsiElement element, TextOccurenceProcessor processor, StringSearcher searcher, ProgressIndicator progress) {
        if (!(element instanceof PsiLanguageInjectionHost)) {
            return null;
        }
        List list = ((PsiLanguageInjectionHost)element).getInjectedPsi();
        if (list == null) {
            return null;
        }
        for (Pair pair : list) {
            PsiElement injected = (PsiElement)pair.getFirst();
            if (LowLevelSearchUtil.processElementsContainingWordInElement(processor, injected, searcher, false, progress)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static boolean processTreeUp(TextOccurenceProcessor processor, PsiElement scope, StringSearcher searcher, int offset, boolean ignoreInjectedPsi, ProgressIndicator progress) {
        int start;
        boolean useTree;
        int scopeStartOffset = scope.getTextRange().getStartOffset();
        int patternLength = searcher.getPatternLength();
        PsiElement leafElement = null;
        TreeElement leafNode = null;
        ASTNode scopeNode = scope.getNode();
        boolean bl = useTree = scopeNode != null;
        if (useTree) {
            leafNode = (LeafElement)scopeNode.findLeafElementAt(offset);
            if (leafNode == null) {
                return true;
            }
            start = offset - leafNode.getStartOffset() + scopeStartOffset;
        } else {
            leafElement = scope instanceof PsiFile ? ((PsiFile)scope).getViewProvider().findElementAt(offset, scope.getLanguage()) : scope.findElementAt(offset);
            if (leafElement == null) {
                return true;
            }
            start = offset - leafElement.getTextRange().getStartOffset() + scopeStartOffset;
        }
        if (start < 0) {
            LOG.error("offset=" + offset + " scopeStartOffset=" + scopeStartOffset + " leafElement=" + leafElement + " " + " scope=" + scope.toString());
        }
        boolean contains = false;
        PsiElement prev = null;
        TreeElement prevNode = null;
        PsiElement run = null;
        while (run != scope) {
            if (progress != null) {
                progress.checkCanceled();
            }
            if (useTree) {
                start += prevNode == null ? 0 : prevNode.getStartOffsetInParent();
                prevNode = leafNode;
                run = leafNode.getPsi();
            } else {
                start += prev == null ? 0 : prev.getStartOffsetInParent();
                prev = run;
                run = leafElement;
            }
            if (contains |= run.getTextLength() - start >= patternLength) {
                Boolean result;
                if (!ignoreInjectedPsi && (result = LowLevelSearchUtil.processInjectedFile(run, processor, searcher, progress)) != null) {
                    return result;
                }
                if (!processor.execute(run, start)) {
                    return false;
                }
            }
            if (!(useTree ? (leafNode = leafNode.getTreeParent()) == null : (leafElement = leafElement.getParent()) == null)) continue;
        }
        assert (run == scope) : "Malbuilt PSI: scopeNode=" + scope + "; leafNode=" + run + "; isAncestor=" + PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)run, (boolean)false);
        return true;
    }

    public static boolean processElementsContainingWordInElement(TextOccurenceProcessor processor, PsiElement scope, StringSearcher searcher, boolean ignoreInjectedPsi, ProgressIndicator progress) {
        int scopeStart;
        if (progress != null) {
            progress.checkCanceled();
        }
        PsiFile file = scope.getContainingFile();
        CharSequence buffer = file.getViewProvider().getContents();
        TextRange range = scope.getTextRange();
        int startOffset = scopeStart = range.getStartOffset();
        int endOffset = range.getEndOffset();
        do {
            if (progress != null) {
                progress.checkCanceled();
            }
            if ((startOffset = LowLevelSearchUtil.searchWord(buffer, startOffset, endOffset, searcher, progress)) < 0) {
                return true;
            }
            if (LowLevelSearchUtil.processTreeUp(processor, scope, searcher, startOffset - scopeStart, ignoreInjectedPsi, progress)) continue;
            return false;
        } while (++startOffset < endOffset);
        return true;
    }

    public static int searchWord(@NotNull CharSequence text, int startOffset, int endOffset, @NotNull StringSearcher searcher, @Nullable ProgressIndicator progress) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/search/LowLevelSearchUtil.searchWord must not be null");
        }
        if (searcher == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/search/LowLevelSearchUtil.searchWord must not be null");
        }
        for (int index = startOffset; index < endOffset; ++index) {
            char c;
            String pattern;
            char c2;
            if (progress != null) {
                progress.checkCanceled();
            }
            if ((index = searcher.scan(text, index, endOffset)) < 0) {
                return -1;
            }
            if (!searcher.isJavaIdentifier()) {
                return index;
            }
            if (index > startOffset && Character.isJavaIdentifierPart(c2 = text.charAt(index - 1)) && c2 != '$' && (index < 2 || text.charAt(index - 2) != '\\') || index + (pattern = searcher.getPattern()).length() < endOffset && Character.isJavaIdentifierPart(c = text.charAt(index + pattern.length())) && c != '$') continue;
            return index;
        }
        return -1;
    }
}

