/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsParameterImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.impl.java.stubs.impl.PsiParameterStubImpl;
import com.intellij.psi.impl.source.PsiParameterImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.io.StringRef;
import java.io.IOException;

public class JavaParameterElementType
extends JavaStubElementType<PsiParameterStub, PsiParameter> {
    public JavaParameterElementType() {
        super("PARAMETER");
    }

    public PsiParameter createPsi(PsiParameterStub stub) {
        if (this.isCompiled(stub)) {
            return new ClsParameterImpl(stub);
        }
        return new PsiParameterImpl(stub);
    }

    @Override
    public PsiParameter createPsi(ASTNode node) {
        return new PsiParameterImpl(node);
    }

    public PsiParameterStub createStub(PsiParameter psi, StubElement parentStub) {
        TypeInfo type = TypeInfo.create(psi.getTypeNoResolve(), psi.getTypeElement());
        return new PsiParameterStubImpl(parentStub, psi.getName(), type, psi.isVarArgs());
    }

    public void serialize(PsiParameterStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        TypeInfo.writeTYPE(dataStream, stub.getType(false));
        dataStream.writeBoolean(stub.isParameterTypeEllipsis());
    }

    public PsiParameterStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name = dataStream.readName();
        TypeInfo type = TypeInfo.readTYPE(dataStream, parentStub);
        boolean isEll = dataStream.readBoolean();
        return new PsiParameterStubImpl(parentStub, name, type, isEll);
    }

    public boolean shouldCreateStub(ASTNode node) {
        IElementType type = node.getTreeParent().getElementType();
        return type == JavaElementType.PARAMETER_LIST;
    }

    public void indexStub(PsiParameterStub stub, IndexSink sink) {
    }
}

