/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class JavaDirectoryServiceImpl
extends JavaDirectoryService {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.file.JavaDirectoryServiceImpl");
    private static final Key<LanguageLevel> LANG_LEVEL_IN_DIRECTORY = new Key("LANG_LEVEL_IN_DIRECTORY");

    public PsiPackage getPackage(@NotNull PsiDirectory dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/JavaDirectoryServiceImpl.getPackage must not be null");
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)dir.getProject()).getFileIndex();
        String packageName = projectFileIndex.getPackageNameByDirectory(dir.getVirtualFile());
        if (packageName == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)dir.getProject()).findPackage(packageName);
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiDirectory dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/JavaDirectoryServiceImpl.getClasses must not be null");
        }
        LOG.assertTrue(dir.isValid());
        ArrayList<PsiClass> classes = null;
        for (PsiFile file : dir.getFiles()) {
            PsiClass[] psiClasses;
            if (!(file instanceof PsiClassOwner) || (psiClasses = ((PsiClassOwner)file).getClasses()).length == 0) continue;
            if (classes == null) {
                classes = new ArrayList<PsiClass>();
            }
            classes.addAll(Arrays.asList(psiClasses));
        }
        PsiClass[] psiClassArray = classes == null ? PsiClass.EMPTY_ARRAY : classes.toArray(new PsiClass[classes.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/JavaDirectoryServiceImpl.getClasses must not return null");
        }
        return psiClassArray;
    }

    @NotNull
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/JavaDirectoryServiceImpl.createClass must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/file/JavaDirectoryServiceImpl.createClass must not be null");
        }
        PsiClass psiClass = JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, "Class");
        if (psiClass == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/JavaDirectoryServiceImpl.createClass must not return null");
        }
        return psiClass;
    }

    @NotNull
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name, @NotNull String templateName) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/JavaDirectoryServiceImpl.createClass must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/file/JavaDirectoryServiceImpl.createClass must not be null");
        }
        if (templateName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/file/JavaDirectoryServiceImpl.createClass must not be null");
        }
        PsiClass psiClass = JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, templateName);
        if (psiClass == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/JavaDirectoryServiceImpl.createClass must not return null");
        }
        return psiClass;
    }

    @NotNull
    public PsiClass createInterface(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/JavaDirectoryServiceImpl.createInterface must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/file/JavaDirectoryServiceImpl.createInterface must not be null");
        }
        String templateName = "Interface";
        PsiClass someClass = JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, templateName);
        if (!someClass.isInterface()) {
            throw new IncorrectOperationException(JavaDirectoryServiceImpl.getIncorrectTemplateMessage(templateName));
        }
        PsiClass psiClass = someClass;
        if (psiClass == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/JavaDirectoryServiceImpl.createInterface must not return null");
        }
        return psiClass;
    }

    @NotNull
    public PsiClass createEnum(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/JavaDirectoryServiceImpl.createEnum must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/file/JavaDirectoryServiceImpl.createEnum must not be null");
        }
        String templateName = "Enum";
        PsiClass someClass = JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, templateName);
        if (!someClass.isEnum()) {
            throw new IncorrectOperationException(JavaDirectoryServiceImpl.getIncorrectTemplateMessage(templateName));
        }
        PsiClass psiClass = someClass;
        if (psiClass == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/JavaDirectoryServiceImpl.createEnum must not return null");
        }
        return psiClass;
    }

    @NotNull
    public PsiClass createAnnotationType(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/JavaDirectoryServiceImpl.createAnnotationType must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/file/JavaDirectoryServiceImpl.createAnnotationType must not be null");
        }
        String templateName = "AnnotationType";
        PsiClass someClass = JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, templateName);
        if (!someClass.isAnnotationType()) {
            throw new IncorrectOperationException(JavaDirectoryServiceImpl.getIncorrectTemplateMessage(templateName));
        }
        PsiClass psiClass = someClass;
        if (psiClass == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/JavaDirectoryServiceImpl.createAnnotationType must not return null");
        }
        return psiClass;
    }

    private static PsiClass createClassFromTemplate(@NotNull PsiDirectory dir, String name, String templateName) throws IncorrectOperationException {
        PsiElement element;
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/JavaDirectoryServiceImpl.createClassFromTemplate must not be null");
        }
        JavaDirectoryServiceImpl.checkCreateClassOrInterface(dir, name);
        FileTemplate template = FileTemplateManager.getInstance().getInternalTemplate(templateName);
        Properties defaultProperties = FileTemplateManager.getInstance().getDefaultProperties();
        Properties properties = new Properties(defaultProperties);
        properties.setProperty("NAME", name);
        String ext = StdFileTypes.JAVA.getDefaultExtension();
        String fileName = name + "." + ext;
        try {
            element = FileTemplateUtil.createFromTemplate(template, fileName, properties, dir);
        }
        catch (IncorrectOperationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
        PsiJavaFile file = (PsiJavaFile)element.getContainingFile();
        PsiClass[] classes = file.getClasses();
        if (classes.length != 1 || !name.equals(classes[0].getName())) {
            throw new IncorrectOperationException(JavaDirectoryServiceImpl.getIncorrectTemplateMessage(templateName));
        }
        return file.getClasses()[0];
    }

    private static String getIncorrectTemplateMessage(String templateName) {
        return PsiBundle.message((String)"psi.error.incorroect.class.template.message", (Object[])new Object[]{FileTemplateManager.getInstance().internalTemplateToSubject(templateName), templateName});
    }

    public void checkCreateClass(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/JavaDirectoryServiceImpl.checkCreateClass must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/file/JavaDirectoryServiceImpl.checkCreateClass must not be null");
        }
        JavaDirectoryServiceImpl.checkCreateClassOrInterface(dir, name);
    }

    public void checkCreateInterface(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/JavaDirectoryServiceImpl.checkCreateInterface must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/file/JavaDirectoryServiceImpl.checkCreateInterface must not be null");
        }
        JavaDirectoryServiceImpl.checkCreateClassOrInterface(dir, name);
    }

    public static void checkCreateClassOrInterface(@NotNull PsiDirectory directory, String name) throws IncorrectOperationException {
        String qualifiedName;
        if (directory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/JavaDirectoryServiceImpl.checkCreateClassOrInterface must not be null");
        }
        PsiUtil.checkIsIdentifier((PsiManager)directory.getManager(), (String)name);
        String fileName = name + "." + StdFileTypes.JAVA.getDefaultExtension();
        directory.checkCreateFile(fileName);
        PsiNameHelper helper = JavaPsiFacade.getInstance((Project)directory.getProject()).getNameHelper();
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        String string = qualifiedName = aPackage == null ? null : aPackage.getQualifiedName();
        if (!StringUtil.isEmpty((String)qualifiedName) && !helper.isQualifiedName(qualifiedName)) {
            throw new IncorrectOperationException("Cannot create class in invalid package: '" + qualifiedName + "'");
        }
    }

    public boolean isSourceRoot(@NotNull PsiDirectory dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/JavaDirectoryServiceImpl.isSourceRoot must not be null");
        }
        VirtualFile file = dir.getVirtualFile();
        VirtualFile sourceRoot = ProjectRootManager.getInstance((Project)dir.getProject()).getFileIndex().getSourceRootForFile(file);
        return file.equals(sourceRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LanguageLevel getLanguageLevel(@NotNull PsiDirectory dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/JavaDirectoryServiceImpl.getLanguageLevel must not be null");
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            LanguageLevel level = (LanguageLevel)dir.getUserData(LANG_LEVEL_IN_DIRECTORY);
            if (level == null) {
                level = JavaDirectoryServiceImpl.getLanguageLevelInner(dir);
                dir.putUserData(LANG_LEVEL_IN_DIRECTORY, (Object)level);
            }
            return level;
        }
    }

    private static LanguageLevel getLanguageLevelInner(@NotNull PsiDirectory dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/JavaDirectoryServiceImpl.getLanguageLevelInner must not be null");
        }
        VirtualFile virtualFile = dir.getVirtualFile();
        Project project = dir.getProject();
        Module module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(virtualFile);
        if (module != null) {
            return LanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
        }
        return LanguageLevelProjectExtension.getInstance((Project)project).getLanguageLevel();
    }
}

