/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.compiled.ClsAnnotationsUtil;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsIdentifierImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ClsNameValuePairImpl
extends ClsElementImpl
implements PsiNameValuePair {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.psi.impl.compiled.ClsNameValuePairImpl");
    private final ClsElementImpl myParent;
    private final ClsIdentifierImpl myNameIdentifier;
    private final PsiAnnotationMemberValue myMemberValue;

    public ClsNameValuePairImpl(ClsElementImpl parent, String name, PsiAnnotationMemberValue value) {
        this.myParent = parent;
        this.myNameIdentifier = new ClsIdentifierImpl(this, name);
        this.myMemberValue = ClsAnnotationsUtil.getMemberValue((PsiElement)value, this);
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuffer buffer) {
        if (this.myNameIdentifier.getText() != null) {
            this.myNameIdentifier.appendMirrorText(0, buffer);
            buffer.append(" = ");
        }
        ((ClsElementImpl)this.myMemberValue).appendMirrorText(0, buffer);
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsNameValuePairImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiNameValuePair mirror = (PsiNameValuePair)SourceTreeToPsiMap.treeElementToPsi(element);
        PsiIdentifier mirrorIdentifier = mirror.getNameIdentifier();
        if (mirrorIdentifier != null) {
            ((ClsElementImpl)this.getNameIdentifier()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirrorIdentifier));
        }
        ((ClsElementImpl)this.getValue()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getValue()));
    }

    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = new PsiElement[]{this.myNameIdentifier, this.myMemberValue};
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsNameValuePairImpl.getChildren must not return null");
        }
        return psiElementArray;
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsNameValuePairImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitNameValuePair((PsiNameValuePair)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiIdentifier getNameIdentifier() {
        return this.myNameIdentifier;
    }

    public String getName() {
        return this.myNameIdentifier.getText();
    }

    public PsiAnnotationMemberValue getValue() {
        return this.myMemberValue;
    }

    @NotNull
    public PsiAnnotationMemberValue setValue(@NotNull PsiAnnotationMemberValue newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsNameValuePairImpl.setValue must not be null");
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }
}

