/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.JavaTemplateUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.PsiElementFactoryImpl;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiParserFacadeImpl;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.parsing.DeclarationParsing;
import com.intellij.psi.impl.source.parsing.ExpressionParsing;
import com.intellij.psi.impl.source.parsing.JavaParsingContext;
import com.intellij.psi.impl.source.parsing.Parsing;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class PsiJavaParserFacadeImpl
extends PsiParserFacadeImpl
implements PsiJavaParserFacade {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiJavaParserFacadeImpl");
    protected static final Map<String, PsiPrimitiveType> ourPrimitiveTypesMap = new HashMap();
    protected PsiJavaFile myDummyJavaFile;

    public PsiJavaParserFacadeImpl(PsiManagerEx manager) {
        super(manager);
    }

    @NotNull
    public PsiAnnotation createAnnotationFromText(@NotNull String annotationText, PsiElement context) throws IncorrectOperationException {
        if (annotationText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createAnnotationFromText must not be null");
        }
        FileElement holderElement = DummyHolderFactory.createHolder(this.myManager, context).getTreeElement();
        CompositeElement annotationElement = this.getJavaParsingContext(holderElement).getDeclarationParsing().parseAnnotationFromText(this.myManager, annotationText, this.getLanguageLevel(context));
        if (annotationElement == null || annotationElement.getElementType() != JavaElementType.ANNOTATION) {
            throw new IncorrectOperationException("Incorrect annotation \"" + annotationText + "\".");
        }
        holderElement.rawAddChildren(annotationElement);
        PsiAnnotation psiAnnotation = (PsiAnnotation)SourceTreeToPsiMap.treeElementToPsi(annotationElement);
        if (psiAnnotation == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createAnnotationFromText must not return null");
        }
        return psiAnnotation;
    }

    private LanguageLevel getLanguageLevel(PsiElement context) {
        if (context == null) {
            return LanguageLevelProjectExtension.getInstance((Project)this.myManager.getProject()).getLanguageLevel();
        }
        return PsiUtil.getLanguageLevel((PsiElement)context);
    }

    @NotNull
    public PsiDocTag createDocTagFromText(@NotNull String docTagText, PsiElement context) throws IncorrectOperationException {
        if (docTagText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createDocTagFromText must not be null");
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("/**\n");
        buffer.append(docTagText);
        buffer.append("\n */");
        PsiDocComment comment = this.createDocCommentFromText(buffer.toString(), context);
        PsiDocTag psiDocTag = comment.getTags()[0];
        if (psiDocTag == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createDocTagFromText must not return null");
        }
        return psiDocTag;
    }

    @NotNull
    public PsiDocComment createDocCommentFromText(@NotNull String docCommentText, PsiElement context) throws IncorrectOperationException {
        if (docCommentText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createDocCommentFromText must not be null");
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(docCommentText);
        buffer.append("void m();");
        PsiMethod method = this.createMethodFromText(buffer.toString(), null);
        PsiDocComment psiDocComment = method.getDocComment();
        if (psiDocComment == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createDocCommentFromText must not return null");
        }
        return psiDocComment;
    }

    @NotNull
    public PsiClass createClassFromText(@NotNull String body, PsiElement context) throws IncorrectOperationException {
        if (body == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createClassFromText must not be null");
        }
        String fileText = "class _Dummy_ { " + body + " }";
        PsiJavaFile aFile = this.createDummyJavaFile(fileText);
        PsiClass[] classes = aFile.getClasses();
        if (classes.length != 1) {
            throw new IncorrectOperationException("Incorrect class \"" + body + "\".");
        }
        PsiClass psiClass = classes[0];
        if (psiClass == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createClassFromText must not return null");
        }
        return psiClass;
    }

    @NotNull
    public PsiField createFieldFromText(@NotNull String text, PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createFieldFromText must not be null");
        }
        FileElement holderElement = DummyHolderFactory.createHolder(this.myManager, context).getTreeElement();
        TreeElement decl = this.getJavaParsingContext(holderElement).getDeclarationParsing().parseDeclarationText(this.myManager, LanguageLevelProjectExtension.getInstance((Project)this.myManager.getProject()).getLanguageLevel(), text, DeclarationParsing.Context.CLASS_CONTEXT);
        if (decl == null || decl.getElementType() != JavaElementType.FIELD) {
            throw new IncorrectOperationException("Incorrect field \"" + text + "\".");
        }
        holderElement.rawAddChildren(decl);
        PsiField psiField = (PsiField)SourceTreeToPsiMap.treeElementToPsi(decl);
        if (psiField == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createFieldFromText must not return null");
        }
        return psiField;
    }

    protected JavaParsingContext getJavaParsingContext(FileElement holderElement) {
        return new JavaParsingContext(holderElement.getCharTable(), LanguageLevelProjectExtension.getInstance((Project)this.myManager.getProject()).getLanguageLevel());
    }

    private static JavaParsingContext getJavaParsingContext(FileElement holderElement, LanguageLevel languageLevel) {
        return new JavaParsingContext(holderElement.getCharTable(), languageLevel);
    }

    @NotNull
    public PsiMethod createMethodFromText(@NotNull String text, PsiElement context, LanguageLevel level) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createMethodFromText must not be null");
        }
        FileElement holderElement = DummyHolderFactory.createHolder(this.myManager, context).getTreeElement();
        TreeElement decl = PsiJavaParserFacadeImpl.getJavaParsingContext(holderElement, level).getDeclarationParsing().parseDeclarationText(this.myManager, level, text, DeclarationParsing.Context.CLASS_CONTEXT);
        if (decl == null || decl.getElementType() != JavaElementType.METHOD) {
            throw new IncorrectOperationException("Incorrect method '" + text + "'. Context:" + context + "; Level:" + level + "; parsed: " + (decl == null ? null : DebugUtil.treeToString(decl, false)));
        }
        holderElement.rawAddChildren(decl);
        PsiMethod psiMethod = (PsiMethod)SourceTreeToPsiMap.treeElementToPsi(decl);
        if (psiMethod == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createMethodFromText must not return null");
        }
        return psiMethod;
    }

    @NotNull
    public final PsiMethod createMethodFromText(@NotNull String text, PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createMethodFromText must not be null");
        }
        PsiMethod psiMethod = this.createMethodFromText(text, context, LanguageLevelProjectExtension.getInstance((Project)this.myManager.getProject()).getLanguageLevel());
        if (psiMethod == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createMethodFromText must not return null");
        }
        return psiMethod;
    }

    @NotNull
    public PsiParameter createParameterFromText(@NotNull String text, PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createParameterFromText must not be null");
        }
        FileElement holderElement = DummyHolderFactory.createHolder(this.myManager, context).getTreeElement();
        CompositeElement param = this.getJavaParsingContext(holderElement).getDeclarationParsing().parseParameterText(text);
        if (param == null) {
            throw new IncorrectOperationException("Incorrect parameter \"" + text + "\".");
        }
        holderElement.rawAddChildren(param);
        PsiParameter psiParameter = (PsiParameter)SourceTreeToPsiMap.treeElementToPsi(param);
        if (psiParameter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createParameterFromText must not return null");
        }
        return psiParameter;
    }

    @NotNull
    public PsiType createTypeFromText(@NotNull String text, PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createTypeFromText must not be null");
        }
        PsiType psiType = this.createTypeInner(text, context, false);
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createTypeFromText must not return null");
        }
        return psiType;
    }

    protected PsiType createTypeInner(String text, PsiElement context, boolean markAsCopy) throws IncorrectOperationException {
        PsiTypeElement psiTypeElement;
        PsiPrimitiveType primitiveType = ourPrimitiveTypesMap.get(text);
        if (primitiveType != null) {
            return primitiveType;
        }
        FileElement holderElement = DummyHolderFactory.createHolder(this.myManager, context).getTreeElement();
        CompositeElement typeElement = Parsing.parseTypeText(this.myManager, text, 0, text.length(), holderElement.getCharTable());
        if (typeElement == null) {
            throw new IncorrectOperationException("Incorrect type \"" + text + "\"");
        }
        holderElement.rawAddChildren(typeElement);
        if (markAsCopy) {
            holderElement.acceptTree(new GeneratedMarkerVisitor());
        }
        if ((psiTypeElement = (PsiTypeElement)SourceTreeToPsiMap.treeElementToPsi(typeElement)) == null) {
            throw new IncorrectOperationException("PSI is null for element " + typeElement);
        }
        return psiTypeElement.getType();
    }

    @NotNull
    public PsiCodeBlock createCodeBlockFromText(@NotNull String text, PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createCodeBlockFromText must not be null");
        }
        FileElement holderElement = DummyHolderFactory.createHolder(this.myManager, context).getTreeElement();
        CompositeElement treeElement = this.getJavaParsingContext(holderElement).getStatementParsing().parseCodeBlockText(this.myManager, text);
        if (treeElement == null) {
            throw new IncorrectOperationException("Incorrect code block \"" + text + "\".");
        }
        holderElement.rawAddChildren(treeElement);
        PsiCodeBlock psiCodeBlock = (PsiCodeBlock)SourceTreeToPsiMap.treeElementToPsi(treeElement);
        if (psiCodeBlock == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createCodeBlockFromText must not return null");
        }
        return psiCodeBlock;
    }

    @NotNull
    public PsiStatement createStatementFromText(@NotNull String text, PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createStatementFromText must not be null");
        }
        FileElement treeHolder = DummyHolderFactory.createHolder(this.myManager, context).getTreeElement();
        TreeElement treeElement = this.getJavaParsingContext(treeHolder).getStatementParsing().parseStatementText(text);
        if (treeElement == null) {
            throw new IncorrectOperationException("Incorrect statement \"" + text + "\".");
        }
        treeHolder.rawAddChildren(treeElement);
        PsiStatement psiStatement = (PsiStatement)SourceTreeToPsiMap.treeElementToPsi(treeElement);
        if (psiStatement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createStatementFromText must not return null");
        }
        return psiStatement;
    }

    @NotNull
    public PsiExpression createExpressionFromText(@NotNull String text, PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createExpressionFromText must not be null");
        }
        FileElement treeHolder = DummyHolderFactory.createHolder(this.myManager, context).getTreeElement();
        CompositeElement treeElement = ExpressionParsing.parseExpressionText(this.myManager, text, 0, text.length(), treeHolder.getCharTable());
        if (treeElement == null) {
            throw new IncorrectOperationException("Incorrect expression \"" + text + "\".");
        }
        treeHolder.rawAddChildren(treeElement);
        PsiExpression psiExpression = (PsiExpression)SourceTreeToPsiMap.treeElementToPsi(treeElement);
        if (psiExpression == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createExpressionFromText must not return null");
        }
        return psiExpression;
    }

    protected PsiJavaFile createDummyJavaFile(String text) {
        String ext = StdFileTypes.JAVA.getDefaultExtension();
        String fileName = "_Dummy_." + ext;
        LanguageFileType type = StdFileTypes.JAVA;
        return (PsiJavaFile)PsiFileFactory.getInstance((Project)this.myManager.getProject()).createFileFromText((FileType)type, fileName, (CharSequence)text, 0, text.length());
    }

    @NotNull
    public PsiTypeParameter createTypeParameterFromText(@NotNull String text, PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createTypeParameterFromText must not be null");
        }
        FileElement holderElement = DummyHolderFactory.createHolder(this.myManager, context).getTreeElement();
        TreeElement treeElement = this.getJavaParsingContext(holderElement).getDeclarationParsing().parseTypeParameterText(text);
        if (treeElement == null) {
            throw new IncorrectOperationException("Incorrect type parameter \"" + text + "\"");
        }
        holderElement.rawAddChildren(treeElement);
        PsiTypeParameter psiTypeParameter = (PsiTypeParameter)SourceTreeToPsiMap.treeElementToPsi(treeElement);
        if (psiTypeParameter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createTypeParameterFromText must not return null");
        }
        return psiTypeParameter;
    }

    @NotNull
    public PsiComment createCommentFromText(@NotNull String text, PsiElement context) throws IncorrectOperationException {
        PsiElement[] children;
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createCommentFromText must not be null");
        }
        PsiJavaFile aFile = this.createDummyJavaFile(text);
        for (PsiElement aChildren : children = aFile.getChildren()) {
            if (!(aChildren instanceof PsiComment)) continue;
            if (!aChildren.getText().equals(text)) {
                throw new IncorrectOperationException("Incorrect comment \"" + text + "\".");
            }
            PsiComment comment = (PsiComment)aChildren;
            DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)comment), context);
            PsiComment psiComment = comment;
            if (psiComment == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createCommentFromText must not return null");
            }
            return psiComment;
        }
        throw new IncorrectOperationException("Incorrect comment \"" + text + "\".");
    }

    @NotNull
    public PsiEnumConstant createEnumConstantFromText(@NotNull String text, PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createEnumConstantFromText must not be null");
        }
        FileElement holderElement = DummyHolderFactory.createHolder(this.myManager, context).getTreeElement();
        TreeElement decl = this.getJavaParsingContext(holderElement).getDeclarationParsing().parseEnumConstantText(text);
        if (decl == null || decl.getElementType() != JavaElementType.ENUM_CONSTANT) {
            throw new IncorrectOperationException("Incorrect enum constant text \"" + text + "\".");
        }
        holderElement.rawAddChildren(decl);
        PsiEnumConstant psiEnumConstant = (PsiEnumConstant)SourceTreeToPsiMap.treeElementToPsi(decl);
        if (psiEnumConstant == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createEnumConstantFromText must not return null");
        }
        return psiEnumConstant;
    }

    @NotNull
    public PsiCatchSection createCatchSection(@NotNull PsiClassType exceptionType, @NotNull String exceptionName, PsiElement context) throws IncorrectOperationException {
        if (exceptionType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createCatchSection must not be null");
        }
        if (exceptionName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createCatchSection must not be null");
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("catch (");
        buffer.append(exceptionType.getCanonicalText());
        buffer.append(" ").append(exceptionName).append("){}");
        String catchSectionText = buffer.toString();
        FileElement holderElement = DummyHolderFactory.createHolder(this.myManager, context).getTreeElement();
        TreeElement catchSection = this.getJavaParsingContext(holderElement).getStatementParsing().parseCatchSectionText(catchSectionText);
        LOG.assertTrue(catchSection != null && catchSection.getElementType() == JavaElementType.CATCH_SECTION, (Object)catchSectionText);
        holderElement.rawAddChildren(catchSection);
        PsiCatchSection psiCatchSection = (PsiCatchSection)SourceTreeToPsiMap.treeElementToPsi(catchSection);
        this.setupCatchBlock(exceptionName, context, psiCatchSection);
        PsiCatchSection psiCatchSection2 = (PsiCatchSection)this.myManager.getCodeStyleManager().reformat((PsiElement)psiCatchSection);
        if (psiCatchSection2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiJavaParserFacadeImpl.createCatchSection must not return null");
        }
        return psiCatchSection2;
    }

    private void setupCatchBlock(String exceptionName, PsiElement context, PsiCatchSection psiCatchSection) throws IncorrectOperationException {
        PsiCodeBlock codeBlockFromText;
        PsiDirectory directory;
        FileTemplate catchBodyTemplate = FileTemplateManager.getInstance().getCodeTemplate("Catch Statement Body.java");
        LOG.assertTrue(catchBodyTemplate != null);
        Properties props = new Properties();
        props.setProperty("EXCEPTION", exceptionName);
        if (context != null && context.isPhysical() && (directory = context.getContainingFile().getContainingDirectory()) != null) {
            JavaTemplateUtil.setPackageNameAttribute(props, directory);
        }
        try {
            String catchBody = catchBodyTemplate.getText(props);
            codeBlockFromText = this.createCodeBlockFromText("{\n" + catchBody + "\n}", null);
        }
        catch (ProcessCanceledException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new IncorrectOperationException("Incorrect file template", e);
        }
        psiCatchSection.getCatchBlock().replace((PsiElement)codeBlockFromText);
    }

    public PsiType createPrimitiveType(@NotNull String text, @NotNull PsiAnnotation[] annotations) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createPrimitiveType must not be null");
        }
        if (annotations == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiJavaParserFacadeImpl.createPrimitiveType must not be null");
        }
        if (annotations.length == 0) {
            return PsiElementFactoryImpl.getPrimitiveType(text);
        }
        return new PsiPrimitiveType(text, annotations);
    }
}

