/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.impl.CompositeShortNamesCache;
import com.intellij.psi.impl.EmptyShortNamesCacheImpl;
import com.intellij.psi.impl.JavaPsiFacadeEx;
import com.intellij.psi.impl.PackagePrefixIndex;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.impl.PsiElementFactoryImpl;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiNameHelperImpl;
import com.intellij.psi.impl.PsiShortNamesCacheImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.file.impl.JavaFileManagerImpl;
import com.intellij.psi.impl.migration.PsiMigrationImpl;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.impl.source.JavaDummyHolderFactory;
import com.intellij.psi.impl.source.codeStyle.HelperFactory;
import com.intellij.psi.impl.source.codeStyle.JavaHelperFactory;
import com.intellij.psi.impl.source.javadoc.JavadocManagerImpl;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.resolve.PsiResolveHelperImpl;
import com.intellij.psi.impl.source.tree.JavaChangeUtilSupport;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.javadoc.JavadocManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.HashMap;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class JavaPsiFacadeImpl
extends JavaPsiFacadeEx
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.JavaPsiFacadeImpl");
    private PsiMigrationImpl myCurrentMigration;
    private final PsiElementFinder[] myElementFinders;
    private PsiShortNamesCache myShortNamesCache;
    private final PsiResolveHelper myResolveHelper;
    private final JavadocManager myJavadocManager;
    private final PsiNameHelper myNameHelper;
    private final PsiElementFactory myElementFactory;
    private final PsiConstantEvaluationHelper myConstantEvaluationHelper;
    private final ConcurrentMap<String, PsiPackage> myPackageCache = new ConcurrentHashMap();
    private final Project myProject;
    private final JavaFileManager myFileManager;
    private final PackagePrefixIndex myPackagePrefixIndex;

    public JavaPsiFacadeImpl(Project project, PsiManagerImpl psiManager, ProjectRootManagerEx projectRootManagerEx, StartupManager startupManager, MessageBus bus) {
        this.myProject = project;
        this.myResolveHelper = new PsiResolveHelperImpl(PsiManager.getInstance((Project)project));
        this.myJavadocManager = new JavadocManagerImpl(project);
        this.myNameHelper = new PsiNameHelperImpl(this);
        this.myConstantEvaluationHelper = new PsiConstantEvaluationHelperImpl();
        this.myElementFactory = new PsiElementFactoryImpl(psiManager);
        ArrayList<Object> elementFinders = new ArrayList<Object>();
        elementFinders.add((Object)new PsiElementFinderImpl());
        elementFinders.addAll(Arrays.asList(this.myProject.getExtensions(PsiElementFinder.EP_NAME)));
        this.myElementFinders = elementFinders.toArray(new PsiElementFinder[elementFinders.size()]);
        this.myPackagePrefixIndex = new PackagePrefixIndex(this.myProject);
        boolean isProjectDefault = project.isDefault();
        if (isProjectDefault) {
            this.myShortNamesCache = new EmptyShortNamesCacheImpl();
        } else {
            this.myShortNamesCache = new PsiShortNamesCacheImpl((PsiManagerEx)PsiManager.getInstance((Project)project));
            for (PsiShortNamesCache cache : (PsiShortNamesCache[])project.getExtensions(PsiShortNamesCache.EP_NAME)) {
                this._registerShortNamesCache(cache);
            }
        }
        this.myFileManager = new JavaFileManagerImpl(psiManager, projectRootManagerEx, psiManager.getFileManager(), bus);
        final PsiModificationTrackerImpl modificationTracker = (PsiModificationTrackerImpl)psiManager.getModificationTracker();
        psiManager.addTreeChangePreprocessor(new JavaCodeBlockModificationListener(modificationTracker));
        bus.connect().subscribe(ProjectTopics.MODIFICATION_TRACKER, (Object)new PsiModificationTracker.Listener(){
            private long lastTimeSeen = -1L;

            public void modificationCountChanged() {
                long now = modificationTracker.getJavaStructureModificationCount();
                if (this.lastTimeSeen != now) {
                    this.lastTimeSeen = now;
                    JavaPsiFacadeImpl.this.myPackageCache.clear();
                }
            }
        });
        startupManager.registerStartupActivity(new Runnable(){

            @Override
            public void run() {
                JavaPsiFacadeImpl.this.runStartupActivity();
            }
        });
        JavaChangeUtilSupport.setup();
        DummyHolderFactory.setFactory(new JavaDummyHolderFactory());
        HelperFactory.setFactory(new JavaHelperFactory());
        JavaElementType.ANNOTATION.getIndex();
        Disposer.register((Disposable)project, (Disposable)this);
    }

    private void runStartupActivity() {
        this.myFileManager.initialize();
        this.myShortNamesCache.runStartupActivity();
    }

    public void dispose() {
        this.myFileManager.dispose();
    }

    public PsiClass findClass(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl.findClass must not be null");
        }
        return this.findClass(qualifiedName, GlobalSearchScope.allScope((Project)this.myProject));
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl.findClass must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl.findClass must not be null");
        }
        ProgressManager.checkCanceled();
        if (DumbService.getInstance((Project)this.getProject()).isDumb()) {
            List<PsiClass> classes = this.findClassesInDumbMode(qualifiedName, scope);
            if (!classes.isEmpty()) {
                return classes.get(0);
            }
            return null;
        }
        for (PsiElementFinder finder : this.myElementFinders) {
            PsiClass aClass = finder.findClass(qualifiedName, scope);
            if (aClass == null) continue;
            return aClass;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private List<PsiClass> findClassesInDumbMode(String qualifiedName, GlobalSearchScope scope) {
        List<Object> list;
        String packageName = StringUtil.getPackageName((String)qualifiedName);
        PsiPackage pkg = this.findPackage(packageName);
        String className = StringUtil.getShortName((String)qualifiedName);
        if (pkg == null && packageName.length() < qualifiedName.length()) {
            List<PsiClass> containingClasses = this.findClassesInDumbMode(packageName, scope);
            if (!(containingClasses.size() == 1 ? (list = JavaPsiFacadeImpl.filterByName(className, containingClasses.get(0).getInnerClasses())) != null : (list = Collections.emptyList()) != null)) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl.findClassesInDumbMode must not return null");
            return list;
        }
        if (pkg == null || pkg instanceof PsiPackageImpl && !((PsiPackageImpl)pkg).containsClassNamed(className)) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl.findClassesInDumbMode must not return null");
            return list;
        }
        list = JavaPsiFacadeImpl.filterByName(className, pkg.getClasses(scope));
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl.findClassesInDumbMode must not return null");
    }

    private static List<PsiClass> filterByName(String className, PsiClass[] classes) {
        SmartList foundClasses = new SmartList();
        for (PsiClass psiClass : classes) {
            if (!className.equals(psiClass.getName())) continue;
            foundClasses.add(psiClass);
        }
        return foundClasses;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass[] psiClassArray;
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl.findClasses must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl.findClasses must not be null");
        }
        if (DumbService.getInstance((Project)this.getProject()).isDumb()) {
            List<PsiClass> classes = this.findClassesInDumbMode(qualifiedName, scope);
            psiClassArray = classes.toArray(new PsiClass[classes.size()]);
            if (psiClassArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl.findClasses must not return null");
            return psiClassArray;
        }
        SmartList classes = new SmartList();
        for (PsiElementFinder finder : this.myElementFinders) {
            PsiClass[] finderClasses = finder.findClasses(qualifiedName, scope);
            classes.addAll(Arrays.asList(finderClasses));
        }
        psiClassArray = classes.toArray(new PsiClass[classes.size()]);
        if (psiClassArray != null) return psiClassArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl.findClasses must not return null");
    }

    @NotNull
    public PsiConstantEvaluationHelper getConstantEvaluationHelper() {
        PsiConstantEvaluationHelper psiConstantEvaluationHelper = this.myConstantEvaluationHelper;
        if (psiConstantEvaluationHelper == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl.getConstantEvaluationHelper must not return null");
        }
        return psiConstantEvaluationHelper;
    }

    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl.findPackage must not be null");
        }
        PsiPackage aPackage = (PsiPackage)this.myPackageCache.get(qualifiedName);
        if (aPackage == null) {
            if (DumbService.getInstance((Project)this.getProject()).isDumb()) {
                return this.findPackageDefault(qualifiedName);
            }
            for (PsiElementFinder finder : this.myElementFinders) {
                aPackage = finder.findPackage(qualifiedName);
                if (aPackage == null) continue;
                aPackage = (PsiPackage)ConcurrencyUtil.cacheOrGet(this.myPackageCache, (Object)qualifiedName, (Object)aPackage);
                break;
            }
        }
        return aPackage;
    }

    public PsiMigrationImpl getCurrentMigration() {
        return this.myCurrentMigration;
    }

    @NotNull
    public PsiJavaParserFacade getParserFacade() {
        PsiElementFactory psiElementFactory = this.getElementFactory();
        if (psiElementFactory == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl.getParserFacade must not return null");
        }
        return psiElementFactory;
    }

    @NotNull
    public PsiResolveHelper getResolveHelper() {
        PsiResolveHelper psiResolveHelper = this.myResolveHelper;
        if (psiResolveHelper == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl.getResolveHelper must not return null");
        }
        return psiResolveHelper;
    }

    @NotNull
    public PsiShortNamesCache getShortNamesCache() {
        PsiShortNamesCache psiShortNamesCache = this.myShortNamesCache;
        if (psiShortNamesCache == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl.getShortNamesCache must not return null");
        }
        return psiShortNamesCache;
    }

    public void registerShortNamesCache(@NotNull PsiShortNamesCache cache) {
        if (cache == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl.registerShortNamesCache must not be null");
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this._registerShortNamesCache(cache);
    }

    private void _registerShortNamesCache(PsiShortNamesCache cache) {
        assert (!(cache instanceof CompositeShortNamesCache)) : cache;
        if (this.myShortNamesCache instanceof CompositeShortNamesCache) {
            ((CompositeShortNamesCache)this.myShortNamesCache).addCache(cache);
        } else {
            CompositeShortNamesCache composite = new CompositeShortNamesCache();
            composite.addCache(this.myShortNamesCache);
            composite.addCache(cache);
            this.myShortNamesCache = composite;
        }
    }

    @NotNull
    public PsiMigration startMigration() {
        LOG.assertTrue(this.myCurrentMigration == null);
        PsiMigrationImpl psiMigrationImpl = this.myCurrentMigration = new PsiMigrationImpl(this, (PsiManagerImpl)PsiManager.getInstance((Project)this.myProject));
        if (psiMigrationImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl.startMigration must not return null");
        }
        return psiMigrationImpl;
    }

    @NotNull
    public JavadocManager getJavadocManager() {
        JavadocManager javadocManager = this.myJavadocManager;
        if (javadocManager == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl.getJavadocManager must not return null");
        }
        return javadocManager;
    }

    @NotNull
    public PsiNameHelper getNameHelper() {
        PsiNameHelper psiNameHelper = this.myNameHelper;
        if (psiNameHelper == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl.getNameHelper must not return null");
        }
        return psiNameHelper;
    }

    public PsiClass[] getClasses(PsiPackageImpl psiPackage, GlobalSearchScope scope) {
        ArrayList<PsiClass> result = null;
        for (PsiElementFinder finder : this.myElementFinders) {
            PsiClass[] classes = finder.getClasses((PsiPackage)psiPackage, scope);
            if (classes.length == 0) continue;
            if (result == null) {
                result = new ArrayList<PsiClass>();
            }
            result.addAll(Arrays.asList(classes));
        }
        return result == null ? PsiClass.EMPTY_ARRAY : result.toArray(new PsiClass[result.size()]);
    }

    public PsiPackage[] getSubPackages(PsiPackageImpl psiPackage, GlobalSearchScope scope) {
        ArrayList<PsiPackage> result = new ArrayList<PsiPackage>();
        for (PsiElementFinder finder : this.myElementFinders) {
            PsiPackage[] packages = finder.getSubPackages((PsiPackage)psiPackage, scope);
            result.addAll(Arrays.asList(packages));
        }
        return result.toArray(new PsiPackage[result.size()]);
    }

    public JavaFileManager getJavaFileManager() {
        return this.myFileManager;
    }

    public boolean packagePrefixExists(String packageQName) {
        for (String prefix : this.myPackagePrefixIndex.getAllPackagePrefixes(null)) {
            if (!StringUtil.startsWithConcatenationOf((String)prefix, (String)packageQName, (String)".") && !prefix.equals(packageQName)) continue;
            return true;
        }
        return false;
    }

    private PsiPackage findPackageDefault(String qualifiedName) {
        PsiPackage migrationPackage;
        PsiPackage aPackage = this.myFileManager.findPackage(qualifiedName);
        if (aPackage == null && this.myCurrentMigration != null && (migrationPackage = this.myCurrentMigration.getMigrationPackage(qualifiedName)) != null) {
            return migrationPackage;
        }
        if (this.packagePrefixExists(qualifiedName)) {
            return new PsiPackageImpl((PsiManagerEx)PsiManager.getInstance((Project)this.myProject), qualifiedName);
        }
        return aPackage;
    }

    public void migrationModified(boolean terminated) {
        if (terminated) {
            this.myCurrentMigration = null;
        }
        ((PsiManagerEx)PsiManager.getInstance((Project)this.myProject)).physicalChange();
    }

    public boolean isPartOfPackagePrefix(String packageName) {
        Collection<String> packagePrefixes = this.myFileManager.getNonTrivialPackagePrefixes();
        for (String subpackageName : packagePrefixes) {
            if (!JavaPsiFacadeImpl.isSubpackageOf(subpackageName, packageName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSubpackageOf(String subpackageName, String packageName) {
        return subpackageName.equals(packageName) || subpackageName.startsWith(packageName) && subpackageName.charAt(packageName.length()) == '.';
    }

    public boolean isInPackage(@NotNull PsiElement element, @NotNull PsiPackage aPackage) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl.isInPackage must not be null");
        }
        if (aPackage == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl.isInPackage must not be null");
        }
        PsiFile file = FileContextUtil.getContextFile(element);
        if (file instanceof JavaDummyHolder) {
            return ((JavaDummyHolder)file).isInPackage(aPackage);
        }
        if (file instanceof PsiJavaFile) {
            String packageName = ((PsiJavaFile)file).getPackageName();
            return packageName.equals(aPackage.getQualifiedName());
        }
        return false;
    }

    public boolean arePackagesTheSame(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiFile file2;
        if (element1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl.arePackagesTheSame must not be null");
        }
        if (element2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl.arePackagesTheSame must not be null");
        }
        PsiFile file1 = FileContextUtil.getContextFile(element1);
        if (Comparing.equal((Object)file1, (Object)(file2 = FileContextUtil.getContextFile(element2)))) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder && file2 instanceof JavaDummyHolder) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder || file2 instanceof JavaDummyHolder) {
            JavaDummyHolder dummyHolder = (JavaDummyHolder)(file1 instanceof JavaDummyHolder ? file1 : file2);
            PsiFile other = file1 instanceof JavaDummyHolder ? file2 : file1;
            return dummyHolder.isSamePackage((PsiElement)other);
        }
        if (!(file1 instanceof PsiClassOwner)) {
            return false;
        }
        if (!(file2 instanceof PsiClassOwner)) {
            return false;
        }
        String package1 = ((PsiClassOwner)file1).getPackageName();
        String package2 = ((PsiClassOwner)file2).getPackageName();
        return Comparing.equal((String)package1, (String)package2);
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public PsiElementFactory getElementFactory() {
        PsiElementFactory psiElementFactory = this.myElementFactory;
        if (psiElementFactory == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl.getElementFactory must not return null");
        }
        return psiElementFactory;
    }

    @Override
    public void setAssertOnFileLoadingFilter(VirtualFileFilter filter) {
        ((PsiManagerImpl)PsiManager.getInstance((Project)this.myProject)).setAssertOnFileLoadingFilter(filter);
    }

    private static class JavaCodeBlockModificationListener
    implements PsiTreeChangePreprocessor {
        private final PsiModificationTrackerImpl myModificationTracker;

        private JavaCodeBlockModificationListener(PsiModificationTrackerImpl modificationTracker) {
            this.myModificationTracker = modificationTracker;
        }

        @Override
        public void treeChanged(PsiTreeChangeEventImpl event) {
            switch (event.getCode()) {
                case BEFORE_CHILDREN_CHANGE: 
                case BEFORE_PROPERTY_CHANGE: 
                case BEFORE_CHILD_MOVEMENT: 
                case BEFORE_CHILD_REPLACEMENT: 
                case BEFORE_CHILD_ADDITION: {
                    break;
                }
                case BEFORE_CHILD_REMOVAL: {
                    PsiClass[] classes;
                    this.checkAnnotation(event.getChild());
                    this.checkModifierListOwner(event.getChild());
                    if (!(event.getChild() instanceof PsiClassOwner)) break;
                    for (PsiClass psiClass : classes = ((PsiClassOwner)event.getChild()).getClasses()) {
                        this.checkModifierListOwner((PsiElement)psiClass);
                    }
                    break;
                }
                case CHILD_ADDED: 
                case CHILD_REMOVED: 
                case CHILD_REPLACED: {
                    this.processChange(event.getParent(), event.getOldChild(), event.getChild());
                    break;
                }
                case CHILDREN_CHANGED: {
                    this.processChange(event.getParent(), event.getParent(), null);
                    break;
                }
                case CHILD_MOVED: 
                case PROPERTY_CHANGED: {
                    this.myModificationTracker.incCounter();
                    break;
                }
                default: {
                    LOG.error("Unknown code:" + (Object)((Object)event.getCode()));
                }
            }
        }

        private void checkModifierListOwner(PsiElement child) {
            PsiModifierList modifierList;
            if ((child instanceof PsiClass || child instanceof PsiMethod) && (modifierList = ((PsiModifierListOwner)child).getModifierList()) != null && modifierList.getAnnotations().length > 0) {
                this.myModificationTracker.incAnnotationModificationCounter();
            }
        }

        private void processChange(PsiElement parent, PsiElement child1, PsiElement child2) {
            try {
                if (!JavaCodeBlockModificationListener.isInsideCodeBlock(parent)) {
                    if (parent != null && JavaCodeBlockModificationListener.isClassOwner((PsiElement)parent.getContainingFile()) || JavaCodeBlockModificationListener.isClassOwner(child1) || JavaCodeBlockModificationListener.isClassOwner(child2)) {
                        this.myModificationTracker.incCounter();
                    } else {
                        this.myModificationTracker.incOutOfCodeBlockModificationCounter();
                    }
                    this.checkAnnotation(parent);
                    this.checkModifierListOwner(parent);
                    return;
                }
                if (JavaCodeBlockModificationListener.containsClassesInside(child1) || child2 != child1 && JavaCodeBlockModificationListener.containsClassesInside(child2)) {
                    this.myModificationTracker.incCounter();
                }
            }
            catch (PsiInvalidElementAccessException e) {
                this.myModificationTracker.incCounter();
            }
        }

        private void checkAnnotation(PsiElement parent) {
            if (PsiTreeUtil.getParentOfType((PsiElement)parent, PsiAnnotation.class, (boolean)false) != null) {
                this.myModificationTracker.incAnnotationModificationCounter();
            }
        }

        private static boolean isClassOwner(PsiElement element) {
            return element instanceof PsiClassOwner && !(element instanceof XmlFile);
        }

        private static boolean containsClassesInside(PsiElement element) {
            if (element == null) {
                return false;
            }
            if (element instanceof PsiClass) {
                return true;
            }
            for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!JavaCodeBlockModificationListener.containsClassesInside(child)) continue;
                return true;
            }
            return false;
        }

        private static boolean isInsideCodeBlock(PsiElement element) {
            if (element instanceof PsiFileSystemItem) {
                return false;
            }
            if (element == null || element.getParent() == null) {
                return true;
            }
            while (!(element instanceof PsiFile) && !(element instanceof PsiDirectory) && element != null) {
                PsiElement pparent = element.getParent();
                if (element instanceof PsiClass) {
                    return false;
                }
                if (element instanceof PsiCodeBlock && (pparent instanceof PsiMethod || pparent instanceof PsiClassInitializer)) {
                    return true;
                }
                element = pparent;
            }
            return false;
        }
    }

    private class PsiElementFinderImpl
    extends PsiElementFinder {
        private PsiElementFinderImpl() {
        }

        public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.findClass must not be null");
            }
            if (scope == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.findClass must not be null");
            }
            PsiClass psiClass = JavaPsiFacadeImpl.this.myFileManager.findClass(qualifiedName, scope);
            if (psiClass == null && JavaPsiFacadeImpl.this.myCurrentMigration != null) {
                psiClass = JavaPsiFacadeImpl.this.myCurrentMigration.getMigrationClass(qualifiedName);
            }
            return psiClass;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
            PsiClass[] psiClassArray;
            PsiClass migrationClass;
            if (qualifiedName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.findClasses must not be null");
            }
            if (scope == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.findClasses must not be null");
            }
            PsiClass[] classes = JavaPsiFacadeImpl.this.myFileManager.findClasses(qualifiedName, scope);
            if (classes.length == 0 && JavaPsiFacadeImpl.this.myCurrentMigration != null && (migrationClass = JavaPsiFacadeImpl.this.myCurrentMigration.getMigrationClass(qualifiedName)) != null) {
                psiClassArray = new PsiClass[]{migrationClass};
                if (psiClassArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.findClasses must not return null");
                return psiClassArray;
            }
            psiClassArray = classes;
            if (classes != null) return psiClassArray;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.findClasses must not return null");
        }

        public PsiPackage findPackage(@NotNull String qualifiedName) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.findPackage must not be null");
            }
            return JavaPsiFacadeImpl.this.findPackageDefault(qualifiedName);
        }

        @NotNull
        public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
            if (psiPackage == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.getSubPackages must not be null");
            }
            if (scope == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.getSubPackages must not be null");
            }
            HashMap packagesMap = new HashMap();
            String qualifiedName = psiPackage.getQualifiedName();
            for (PsiDirectory dir : psiPackage.getDirectories(scope)) {
                PsiDirectory[] subdirs;
                for (PsiDirectory subdir : subdirs = dir.getSubdirectories()) {
                    String subQualifiedName;
                    PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(subdir);
                    if (aPackage == null || !(subQualifiedName = aPackage.getQualifiedName()).startsWith(qualifiedName) || packagesMap.containsKey(subQualifiedName)) continue;
                    packagesMap.put(aPackage.getQualifiedName(), aPackage);
                }
            }
            for (String prefix : JavaPsiFacadeImpl.this.myPackagePrefixIndex.getAllPackagePrefixes(scope)) {
                int i;
                String childName;
                if (!StringUtil.isEmpty((String)qualifiedName) && !StringUtil.startsWithConcatenationOf((String)prefix, (String)qualifiedName, (String)".") || packagesMap.containsKey(childName = (i = prefix.indexOf(46, qualifiedName.length() + 1)) >= 0 ? prefix.substring(0, i) : prefix)) continue;
                packagesMap.put(childName, new PsiPackageImpl((PsiManagerEx)psiPackage.getManager(), childName));
            }
            packagesMap.remove(qualifiedName);
            PsiPackage[] psiPackageArray = packagesMap.values().toArray(new PsiPackage[packagesMap.size()]);
            if (psiPackageArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.getSubPackages must not return null");
            }
            return psiPackageArray;
        }

        @NotNull
        public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
            if (psiPackage == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.getClasses must not be null");
            }
            if (scope == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.getClasses must not be null");
            }
            ArrayList<PsiClass> list = null;
            PsiDirectory[] dirs = psiPackage.getDirectories(scope);
            String packageName = psiPackage.getQualifiedName();
            for (PsiDirectory dir : dirs) {
                PsiClass[] classes = JavaDirectoryService.getInstance().getClasses(dir);
                if (classes.length == 0) continue;
                if (list == null) {
                    list = new ArrayList<PsiClass>();
                }
                for (PsiClass aClass : classes) {
                    String qualifiedName = aClass.getQualifiedName();
                    if (qualifiedName != null) {
                        qualifiedName = StringUtil.getPackageName((String)qualifiedName);
                    }
                    if (!Comparing.strEqual((String)qualifiedName, (String)packageName)) continue;
                    list.add(aClass);
                }
            }
            PsiClass[] psiClassArray = list == null ? PsiClass.EMPTY_ARRAY : list.toArray(new PsiClass[list.size()]);
            if (psiClassArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl.getClasses must not return null");
            }
            return psiClassArray;
        }
    }
}

