/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InheritanceImplUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.InheritanceImplUtil");

    public static boolean isInheritor(@NotNull PsiClass candidateClass, @NotNull PsiClass baseClass, boolean checkDeep) {
        if (candidateClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/InheritanceImplUtil.isInheritor must not be null");
        }
        if (baseClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/InheritanceImplUtil.isInheritor must not be null");
        }
        return !(baseClass instanceof PsiAnonymousClass) && InheritanceImplUtil.isInheritor(candidateClass, baseClass, checkDeep, null);
    }

    private static boolean isInheritor(@NotNull PsiClass candidateClass, @NotNull PsiClass baseClass, boolean checkDeep, Set<PsiClass> checkedClasses) {
        PsiClass objectClass;
        String baseName;
        if (candidateClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/InheritanceImplUtil.isInheritor must not be null");
        }
        if (baseClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/InheritanceImplUtil.isInheritor must not be null");
        }
        if (candidateClass instanceof PsiAnonymousClass) {
            PsiClass baseCandidateClass = ((PsiAnonymousClass)candidateClass).getBaseClassType().resolve();
            return baseCandidateClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)baseCandidateClass, (PsiClass)baseClass, (boolean)checkDeep);
        }
        PsiManager manager = candidateClass.getManager();
        if (checkDeep && LOG.isDebugEnabled()) {
            LOG.debug("Using uncached version for " + candidateClass.getQualifiedName() + " and " + baseClass);
        }
        if ("Object".equals(baseName = baseClass.getName()) && manager.areElementsEquivalent((PsiElement)baseClass, (PsiElement)(objectClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.Object", candidateClass.getResolveScope())))) {
            if (manager.areElementsEquivalent((PsiElement)candidateClass, (PsiElement)objectClass)) {
                return false;
            }
            if (checkDeep || candidateClass.isInterface()) {
                return true;
            }
            return manager.areElementsEquivalent((PsiElement)candidateClass.getSuperClass(), (PsiElement)objectClass);
        }
        if (!checkDeep) {
            boolean cInt = candidateClass.isInterface();
            boolean bInt = baseClass.isInterface();
            if (candidateClass instanceof PsiCompiledElement) {
                String baseQName = baseClass.getQualifiedName();
                if (baseQName == null) {
                    return false;
                }
                GlobalSearchScope scope = candidateClass.getResolveScope();
                if (cInt == bInt && InheritanceImplUtil.checkReferenceListWithQualifiedNames(baseQName, candidateClass.getExtendsList(), manager, scope)) {
                    return true;
                }
                return bInt && !cInt && InheritanceImplUtil.checkReferenceListWithQualifiedNames(baseQName, candidateClass.getImplementsList(), manager, scope);
            }
            if (cInt == bInt) {
                for (PsiClassType type : candidateClass.getExtendsListTypes()) {
                    if (!Comparing.equal((String)type.getClassName(), (String)baseName) || !manager.areElementsEquivalent((PsiElement)baseClass, (PsiElement)type.resolve())) continue;
                    return true;
                }
            } else if (!cInt) {
                for (PsiClassType type : candidateClass.getImplementsListTypes()) {
                    if (!Comparing.equal((String)type.getClassName(), (String)baseName) || !manager.areElementsEquivalent((PsiElement)baseClass, (PsiElement)type.resolve())) continue;
                    return true;
                }
            }
            return false;
        }
        return InheritanceImplUtil.isInheritorWithoutCaching(candidateClass, baseClass, checkDeep, checkedClasses);
    }

    private static boolean checkReferenceListWithQualifiedNames(String baseQName, PsiReferenceList extList, PsiManager manager, GlobalSearchScope scope) {
        if (extList != null) {
            PsiJavaCodeReferenceElement[] refs;
            for (PsiJavaCodeReferenceElement ref : refs = extList.getReferenceElements()) {
                if (!Comparing.equal((String)PsiNameHelper.getQualifiedClassName((String)ref.getQualifiedName(), (boolean)false), (String)baseQName) || JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(baseQName, scope) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isInheritorWithoutCaching(PsiClass aClass, PsiClass baseClass, boolean checkDeep, Set<PsiClass> checkedClasses) {
        PsiManager manager = aClass.getManager();
        if (manager.areElementsEquivalent((PsiElement)aClass, (PsiElement)baseClass)) {
            return false;
        }
        if (aClass.isInterface() && !baseClass.isInterface()) {
            return false;
        }
        if (checkDeep) {
            if (checkedClasses == null) {
                checkedClasses = new THashSet();
            }
            checkedClasses.add((PsiClass)aClass);
        }
        if (!aClass.isInterface() && baseClass.isInterface()) {
            if (checkDeep && InheritanceImplUtil.checkInheritor(aClass.getSuperClass(), baseClass, checkDeep, (Set<PsiClass>)checkedClasses)) {
                return true;
            }
            return InheritanceImplUtil.checkInheritor(aClass.getInterfaces(), baseClass, checkDeep, (Set<PsiClass>)checkedClasses);
        }
        return InheritanceImplUtil.checkInheritor(aClass.getSupers(), baseClass, checkDeep, (Set<PsiClass>)checkedClasses);
    }

    private static boolean checkInheritor(PsiClass[] supers, PsiClass baseClass, boolean checkDeep, Set<PsiClass> checkedClasses) {
        for (PsiClass aSuper : supers) {
            if (!InheritanceImplUtil.checkInheritor(aSuper, baseClass, checkDeep, checkedClasses)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkInheritor(PsiClass aClass, PsiClass baseClass, boolean checkDeep, Set<PsiClass> checkedClasses) {
        ProgressManager.checkCanceled();
        if (aClass != null) {
            PsiManager manager = baseClass.getManager();
            if (manager.areElementsEquivalent((PsiElement)baseClass, (PsiElement)aClass)) {
                return true;
            }
            if (checkedClasses != null && checkedClasses.contains(aClass)) {
                return false;
            }
            if (checkDeep && InheritanceImplUtil.isInheritor(aClass, baseClass, checkDeep, checkedClasses)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isInheritorDeep(@NotNull PsiClass candidateClass, @NotNull PsiClass baseClass, @Nullable PsiClass classToByPass) {
        if (candidateClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/InheritanceImplUtil.isInheritorDeep must not be null");
        }
        if (baseClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/InheritanceImplUtil.isInheritorDeep must not be null");
        }
        if (baseClass instanceof PsiAnonymousClass) {
            return false;
        }
        HashSet checkedClasses = null;
        if (classToByPass != null) {
            checkedClasses = new HashSet();
            checkedClasses.add(classToByPass);
        }
        return InheritanceImplUtil.isInheritor(candidateClass, baseClass, true, (Set<PsiClass>)checkedClasses);
    }
}

