/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.xml.AbstractSyntheticBlock;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.SyntheticBlock;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagBlock
extends AbstractXmlBlock {
    private final Indent myIndent;

    public XmlTagBlock(ASTNode node, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, Indent indent) {
        super(node, wrap, alignment, policy);
        this.myIndent = indent;
    }

    @Override
    protected List<Block> buildChildren() {
        ASTNode child = this.myNode.getFirstChildNode();
        Wrap attrWrap = Wrap.createWrap((WrapType)XmlTagBlock.getWrapType(this.myXmlFormattingPolicy.getAttributesWrap()), (boolean)false);
        Wrap textWrap = Wrap.createWrap((WrapType)XmlTagBlock.getWrapType(this.myXmlFormattingPolicy.getTextWrap(this.getTag())), (boolean)true);
        Wrap tagBeginWrap = this.createTagBeginWrapping(this.getTag());
        Alignment attrAlignment = Alignment.createAlignment();
        Alignment textAlignment = Alignment.createAlignment();
        ArrayList<Block> result = new ArrayList<Block>(3);
        ArrayList<Object> localResult = new ArrayList<Block>(1);
        boolean insideTag = true;
        while (child != null) {
            if (!FormatterUtil.containsWhiteSpacesOnly(child) && child.getTextLength() > 0) {
                Wrap wrap = this.chooseWrap(child, tagBeginWrap, attrWrap, textWrap);
                Alignment alignment = this.chooseAlignment(child, attrAlignment, textAlignment);
                if (child.getElementType() == XmlElementType.XML_TAG_END) {
                    child = this.processChild(localResult, child, wrap, alignment, null);
                    result.add(this.createTagDescriptionNode(localResult));
                    localResult = new ArrayList(1);
                    insideTag = true;
                } else if (child.getElementType() == XmlElementType.XML_START_TAG_START) {
                    insideTag = false;
                    if (!localResult.isEmpty()) {
                        result.add(this.createTagContentNode(localResult));
                    }
                    localResult = new ArrayList(1);
                    child = this.processChild(localResult, child, wrap, alignment, null);
                } else if (child.getElementType() == XmlElementType.XML_END_TAG_START) {
                    insideTag = false;
                    if (!localResult.isEmpty()) {
                        result.add(this.createTagContentNode(localResult));
                        localResult = new ArrayList(1);
                    }
                    child = this.processChild(localResult, child, wrap, alignment, null);
                } else if (child.getElementType() == XmlElementType.XML_EMPTY_ELEMENT_END) {
                    child = this.processChild(localResult, child, wrap, alignment, null);
                    result.add(this.createTagDescriptionNode(localResult));
                    localResult = new ArrayList(1);
                } else if (this.isJspxJavaContainingNode(child)) {
                    this.createJspTextNode(localResult, child, this.getChildIndent());
                } else {
                    Object indent = this.isJspResult(localResult) ? this.getChildrenIndent() : (!insideTag ? null : this.getChildrenIndent());
                    child = this.processChild((List<Block>)localResult, child, wrap, alignment, (Indent)indent);
                }
            }
            if (child == null) continue;
            child = child.getTreeNext();
        }
        if (!localResult.isEmpty()) {
            result.add(this.createTagContentNode(localResult));
        }
        return result;
    }

    protected boolean isJspResult(ArrayList<Block> localResult) {
        return false;
    }

    @Override
    @Nullable
    protected ASTNode processChild(List<Block> result, ASTNode child, Wrap wrap, Alignment alignment, Indent indent) {
        IElementType type = child.getElementType();
        if (type == XmlElementType.XML_TEXT) {
            PsiElement parent = child.getPsi().getParent();
            if (parent instanceof XmlTag && ((XmlTag)parent).getSubTags().length == 0 && this.buildInjectedPsiBlocks(result, child, wrap, alignment, indent)) {
                return child;
            }
            return this.createXmlTextBlocks(result, child, wrap, alignment);
        }
        if (type == XmlElementType.XML_COMMENT) {
            if (this.buildInjectedPsiBlocks(result, child, wrap, alignment, indent)) {
                return child;
            }
            return super.processChild(result, child, wrap, alignment, indent);
        }
        return super.processChild(result, child, wrap, alignment, indent);
    }

    private boolean buildInjectedPsiBlocks(List<Block> result, final ASTNode child, Wrap wrap, Alignment alignment, Indent indent) {
        Language childLanguage;
        FormattingModelBuilder builder;
        final PsiFile[] injectedFile = new PsiFile[1];
        final Ref offset = new Ref();
        final Ref offset2 = new Ref();
        final Ref prefixLength = new Ref();
        final Ref suffixLength = new Ref();
        ((PsiLanguageInjectionHost)child.getPsi()).processInjectedPsi(new PsiLanguageInjectionHost.InjectedPsiVisitor(){

            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                if (injectedPsi == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/formatter/xml/XmlTagBlock$1.visit must not be null");
                }
                if (places == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/formatter/xml/XmlTagBlock$1.visit must not be null");
                }
                if (places.size() == 1) {
                    String childText;
                    PsiLanguageInjectionHost.Shred shred = places.get(0);
                    TextRange textRange = shred.getRangeInsideHost();
                    if (child.getTextLength() == textRange.getEndOffset() && textRange.getStartOffset() == 0 || this.canProcessFragments((childText = child.getText()).substring(0, textRange.getStartOffset())) && this.canProcessFragments(childText.substring(textRange.getEndOffset()))) {
                        injectedFile[0] = injectedPsi;
                        offset.set((Object)textRange.getStartOffset());
                        offset2.set((Object)textRange.getEndOffset());
                        prefixLength.set((Object)(shred.prefix != null ? shred.prefix.length() : 0));
                        suffixLength.set((Object)(shred.suffix != null ? shred.suffix.length() : 0));
                    }
                }
            }

            private boolean canProcessFragments(String s) {
                IElementType type = child.getElementType();
                if (type == XmlElementType.XML_TEXT) {
                    s = s.trim();
                    s = s.replace("<![CDATA[", "");
                    s = s.replace("]]>", "");
                } else if (type == XmlElementType.XML_COMMENT) {
                    s = "";
                }
                return s.length() == 0;
            }
        });
        if (injectedFile[0] != null && (builder = LanguageFormatting.INSTANCE.forContext(childLanguage = injectedFile[0].getLanguage(), child.getPsi())) != null) {
            ASTNode leaf;
            int startOffset = (Integer)offset.get();
            int endOffset = (Integer)offset2.get();
            TextRange range = child.getTextRange();
            int childOffset = range.getStartOffset();
            if (startOffset != 0) {
                leaf = child.findLeafElementAt(startOffset - 1);
                result.add((Block)new XmlBlock(leaf, wrap, alignment, this.myXmlFormattingPolicy, indent, new TextRange(childOffset, childOffset + startOffset)));
            }
            this.createAnotherLanguageBlockWrapper(childLanguage, injectedFile[0].getNode(), result, indent, childOffset + startOffset, new TextRange(((Integer)prefixLength.get()).intValue(), injectedFile[0].getTextLength() - (Integer)suffixLength.get()));
            if (endOffset != child.getTextLength()) {
                leaf = child.findLeafElementAt(endOffset);
                result.add((Block)new XmlBlock(leaf, wrap, alignment, this.myXmlFormattingPolicy, indent, new TextRange(childOffset + endOffset, range.getEndOffset())));
            }
            return true;
        }
        PsiFile containingFile = child.getPsi().getContainingFile();
        FileViewProvider fileViewProvider = containingFile.getViewProvider();
        if (fileViewProvider instanceof TemplateLanguageFileViewProvider) {
            Language templateLanguage = ((TemplateLanguageFileViewProvider)fileViewProvider).getTemplateDataLanguage();
            PsiElement at = fileViewProvider.findElementAt(child.getStartOffset(), templateLanguage);
            if (at instanceof XmlToken) {
                at = at.getParent();
            }
            if (at instanceof PsiComment && at.getTextRange().equals((Object)child.getTextRange()) && at.getNode() != child) {
                return this.buildInjectedPsiBlocks(result, at.getNode(), wrap, alignment, indent);
            }
        }
        return false;
    }

    private Indent getChildrenIndent() {
        return this.myXmlFormattingPolicy.indentChildrenOf(this.getTag()) ? Indent.getNormalIndent() : Indent.getNoneIndent();
    }

    @Override
    public Indent getIndent() {
        return this.myIndent;
    }

    private ASTNode createXmlTextBlocks(List<Block> list, ASTNode textNode, Wrap wrap, Alignment alignment) {
        ASTNode child = textNode.getFirstChildNode();
        return this.createXmlTextBlocks(list, textNode, child, wrap, alignment);
    }

    private ASTNode createXmlTextBlocks(List<Block> list, ASTNode textNode, ASTNode child, Wrap wrap, Alignment alignment) {
        while (child != null) {
            if (!FormatterUtil.containsWhiteSpacesOnly(child) && child.getTextLength() > 0) {
                Indent indent = this.getChildrenIndent();
                if ((child = this.processChild(list, child, wrap, alignment, indent)) == null) {
                    return child;
                }
                if (child.getTreeParent() != textNode) {
                    if (child.getTreeParent() != this.myNode) {
                        return this.createXmlTextBlocks(list, child.getTreeParent(), child.getTreeNext(), wrap, alignment);
                    }
                    return child;
                }
            }
            child = child.getTreeNext();
        }
        return textNode;
    }

    private Block createTagContentNode(ArrayList<Block> localResult) {
        return this.createSyntheticBlock(localResult, this.getChildrenIndent());
    }

    protected Block createSyntheticBlock(ArrayList<Block> localResult, Indent childrenIndent) {
        return new SyntheticBlock(localResult, (Block)this, Indent.getNoneIndent(), this.myXmlFormattingPolicy, childrenIndent);
    }

    private Block createTagDescriptionNode(ArrayList<Block> localResult) {
        return this.createSyntheticBlock(localResult, null);
    }

    public Spacing getSpacing(Block child1, Block child2) {
        if (child1 instanceof AbstractSyntheticBlock && child2 instanceof AbstractSyntheticBlock) {
            return this.getSpacing((AbstractSyntheticBlock)child1, (AbstractSyntheticBlock)child2);
        }
        return null;
    }

    protected Spacing getSpacing(AbstractSyntheticBlock syntheticBlock1, AbstractSyntheticBlock syntheticBlock2) {
        boolean saveSpacesBetweenTagAndText;
        XmlTag startTag;
        if (syntheticBlock2.startsWithCDATA() || syntheticBlock1.endsWithCDATA()) {
            return Spacing.getReadOnlySpacing();
        }
        if (syntheticBlock2.isJspTextBlock() || syntheticBlock1.isJspTextBlock()) {
            return Spacing.createSafeSpacing((boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock2.isJspxTextBlock() || syntheticBlock1.isJspxTextBlock()) {
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (this.myXmlFormattingPolicy.keepWhiteSpacesInsideTag(this.getTag())) {
            return Spacing.getReadOnlySpacing();
        }
        if (this.myXmlFormattingPolicy.getShouldKeepWhiteSpaces()) {
            return Spacing.getReadOnlySpacing();
        }
        if (syntheticBlock2.startsWithTag() && this.myXmlFormattingPolicy.keepWhiteSpacesInsideTag(startTag = syntheticBlock2.getStartTag()) && startTag.textContains('\n')) {
            return this.getChildrenIndent() != Indent.getNoneIndent() ? Spacing.getReadOnlySpacing() : Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        boolean bl = saveSpacesBetweenTagAndText = this.myXmlFormattingPolicy.shouldSaveSpacesBetweenTagAndText() && syntheticBlock1.getTextRange().getEndOffset() < syntheticBlock2.getTextRange().getStartOffset();
        if (syntheticBlock1.endsWithTextElement() && syntheticBlock2.startsWithTextElement()) {
            return Spacing.createSafeSpacing((boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaksInText(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock1.endsWithText()) {
            if (syntheticBlock1.insertLineFeedAfter()) {
                return Spacing.createDependentLFSpacing((int)0, (int)0, (TextRange)this.getTag().getTextRange(), (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            if (saveSpacesBetweenTagAndText) {
                return Spacing.createSafeSpacing((boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock1.isTagDescription() && syntheticBlock2.isTagDescription()) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock2.startsWithText()) {
            if (saveSpacesBetweenTagAndText) {
                return Spacing.createSafeSpacing((boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock1.isTagDescription() && syntheticBlock2.startsWithTag()) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock1.insertLineFeedAfter()) {
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock1.endsWithTag() && syntheticBlock2.isTagDescription()) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        return this.createDefaultSpace(true, true);
    }

    @Override
    public boolean insertLineBreakBeforeTag() {
        return this.myXmlFormattingPolicy.insertLineBreakBeforeTag(this.getTag());
    }

    @Override
    public boolean removeLineBreakBeforeTag() {
        return this.myXmlFormattingPolicy.removeLineBreakBeforeTag(this.getTag());
    }

    @Override
    public boolean isTextElement() {
        return this.myXmlFormattingPolicy.isTextElement(this.getTag());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes;
        if (this.isAfterAttribute(newChildIndex)) {
            int prevSubBlockChildrenCount;
            List<Block> subBlocks = this.getSubBlocks();
            Block subBlock = subBlocks.get(newChildIndex - 1);
            childAttributes = subBlock.getChildAttributes(prevSubBlockChildrenCount = subBlock.getSubBlocks().size());
            if (childAttributes == null) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/xml/XmlTagBlock.getChildAttributes must not return null");
            return childAttributes;
        }
        if (this.myXmlFormattingPolicy.indentChildrenOf(this.getTag())) {
            childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/xml/XmlTagBlock.getChildAttributes must not return null");
            return childAttributes;
        }
        childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
        if (childAttributes != null) return childAttributes;
        throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/xml/XmlTagBlock.getChildAttributes must not return null");
    }

    private boolean isAfterAttribute(int newChildIndex) {
        int index = newChildIndex - 1;
        List<Block> subBlocks = this.getSubBlocks();
        Block prevBlock = index < subBlocks.size() ? subBlocks.get(index) : null;
        return prevBlock instanceof SyntheticBlock && ((SyntheticBlock)prevBlock).endsWithAttribute();
    }
}

