/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.common.JavaBlockUtil;
import com.intellij.psi.formatter.java.AlignmentStrategy;
import com.intellij.psi.formatter.java.BlockContainingJavaBlock;
import com.intellij.psi.formatter.java.CodeBlockBlock;
import com.intellij.psi.formatter.java.DocCommentBlock;
import com.intellij.psi.formatter.java.ExtendsListBlock;
import com.intellij.psi.formatter.java.JavaBlock;
import com.intellij.psi.formatter.java.JavaSpacePropertyProcessor;
import com.intellij.psi.formatter.java.LabeledJavaBlock;
import com.intellij.psi.formatter.java.LeafBlock;
import com.intellij.psi.formatter.java.PartialWhitespaceBlock;
import com.intellij.psi.formatter.java.SimpleJavaBlock;
import com.intellij.psi.formatter.java.SyntheticCodeBlock;
import com.intellij.psi.formatter.java.WrappingStrategy;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.impl.source.tree.java.ClassElement;
import com.intellij.psi.jsp.JspElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJavaBlock
extends AbstractBlock
implements JavaBlock {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.formatter.java.AbstractJavaBlock");
    protected final CodeStyleSettings mySettings;
    private final Indent myIndent;
    protected Indent myChildIndent;
    protected Alignment myChildAlignment;
    protected boolean myUseChildAttributes = false;
    private boolean myIsAfterClassKeyword = false;
    private Wrap myAnnotationWrap = null;
    protected Alignment myReservedAlignment;
    protected Alignment myReservedAlignment2;

    protected AbstractJavaBlock(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, CodeStyleSettings settings) {
        super(node, wrap, alignment);
        this.mySettings = settings;
        this.myIndent = indent;
    }

    public static Block createJavaBlock(ASTNode child, CodeStyleSettings settings, Indent indent, Wrap wrap, Alignment alignment) {
        return AbstractJavaBlock.createJavaBlock(child, settings, indent, wrap, alignment, -1);
    }

    public static Block createJavaBlock(ASTNode child, CodeStyleSettings settings, Indent indent, Wrap wrap, Alignment alignment, int startOffset) {
        Indent actualIndent = indent == null ? AbstractJavaBlock.getDefaultSubtreeIndent(child) : indent;
        IElementType elementType = child.getElementType();
        if (child.getPsi() instanceof PsiWhiteSpace) {
            int end;
            String text = child.getText();
            int start = CharArrayUtil.shiftForward((CharSequence)text, (int)0, (String)" \t\n");
            LOG.assertTrue(start < (end = CharArrayUtil.shiftBackward((CharSequence)text, (int)(text.length() - 1), (String)" \t\n") + 1));
            return new PartialWhitespaceBlock(child, new TextRange(start + child.getStartOffset(), end + child.getStartOffset()), wrap, alignment, actualIndent, settings);
        }
        if (child.getPsi() instanceof PsiClass) {
            return new CodeBlockBlock(child, wrap, alignment, actualIndent, settings);
        }
        if (AbstractJavaBlock.isBlockType(elementType)) {
            return new BlockContainingJavaBlock(child, wrap, alignment, actualIndent, settings);
        }
        if (AbstractJavaBlock.isStatement(child, child.getTreeParent())) {
            return new CodeBlockBlock(child, wrap, alignment, actualIndent, settings);
        }
        if (child instanceof LeafElement) {
            LeafBlock block = new LeafBlock(child, wrap, alignment, actualIndent);
            block.setStartOffset(startOffset);
            return block;
        }
        if (AbstractJavaBlock.isLikeExtendsList(elementType)) {
            return new ExtendsListBlock(child, wrap, alignment, settings);
        }
        if (elementType == JavaElementType.CODE_BLOCK) {
            return new CodeBlockBlock(child, wrap, alignment, actualIndent, settings);
        }
        if (elementType == JavaElementType.LABELED_STATEMENT) {
            return new LabeledJavaBlock(child, wrap, alignment, actualIndent, settings);
        }
        if (elementType == JavaDocElementType.DOC_COMMENT) {
            return new DocCommentBlock(child, wrap, alignment, actualIndent, settings);
        }
        SimpleJavaBlock simpleJavaBlock = new SimpleJavaBlock(child, wrap, alignment, actualIndent, settings);
        simpleJavaBlock.setStartOffset(startOffset);
        return simpleJavaBlock;
    }

    private static boolean isLikeExtendsList(IElementType elementType) {
        return elementType == JavaElementType.EXTENDS_LIST || elementType == JavaElementType.IMPLEMENTS_LIST || elementType == JavaElementType.THROWS_LIST;
    }

    private static boolean isBlockType(IElementType elementType) {
        return elementType == JavaElementType.SWITCH_STATEMENT || elementType == JavaElementType.FOR_STATEMENT || elementType == JavaElementType.WHILE_STATEMENT || elementType == JavaElementType.DO_WHILE_STATEMENT || elementType == JavaElementType.TRY_STATEMENT || elementType == JavaElementType.CATCH_SECTION || elementType == JavaElementType.IF_STATEMENT || elementType == JavaElementType.METHOD || elementType == JavaElementType.ARRAY_INITIALIZER_EXPRESSION || elementType == JavaElementType.ANNOTATION_ARRAY_INITIALIZER || elementType == JavaElementType.CLASS_INITIALIZER || elementType == JavaElementType.SYNCHRONIZED_STATEMENT || elementType == JavaElementType.FOREACH_STATEMENT;
    }

    public static Block createJavaBlock(ASTNode child, CodeStyleSettings settings) {
        return AbstractJavaBlock.createJavaBlock(child, settings, AbstractJavaBlock.getDefaultSubtreeIndent(child), null, null);
    }

    @Nullable
    private static Indent getDefaultSubtreeIndent(ASTNode child) {
        Indent defaultChildIndent;
        ASTNode parent = child.getTreeParent();
        IElementType childNodeType = child.getElementType();
        if (childNodeType == JavaElementType.ANNOTATION) {
            if (parent.getPsi() instanceof PsiArrayInitializerMemberValue) {
                return Indent.getNormalIndent();
            }
            return Indent.getNoneIndent();
        }
        ASTNode prevElement = AbstractJavaBlock.getPrevElement(child);
        if (prevElement != null && prevElement.getElementType() == JavaElementType.MODIFIER_LIST) {
            return Indent.getNoneIndent();
        }
        if (childNodeType == JavaDocElementType.DOC_TAG) {
            return Indent.getNoneIndent();
        }
        if (childNodeType == JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS) {
            return Indent.getSpaceIndent((int)1);
        }
        if (child.getPsi() instanceof PsiFile) {
            return Indent.getNoneIndent();
        }
        if (parent != null && (defaultChildIndent = AbstractJavaBlock.getChildIndent(parent)) != null) {
            return defaultChildIndent;
        }
        return null;
    }

    @Nullable
    private static Indent getChildIndent(ASTNode parent) {
        IElementType parentType = parent.getElementType();
        if (parentType == JavaElementType.MODIFIER_LIST) {
            return Indent.getNoneIndent();
        }
        if (parentType == JspElementType.JSP_CODE_BLOCK) {
            return Indent.getNormalIndent();
        }
        if (parentType == JspElementType.JSP_CLASS_LEVEL_DECLARATION_STATEMENT) {
            return Indent.getNormalIndent();
        }
        if (parentType == ElementType.DUMMY_HOLDER) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.CLASS) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.IF_STATEMENT) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.TRY_STATEMENT) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.CATCH_SECTION) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.FOR_STATEMENT) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.FOREACH_STATEMENT) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.BLOCK_STATEMENT) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.DO_WHILE_STATEMENT) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.WHILE_STATEMENT) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.SWITCH_STATEMENT) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.METHOD) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaDocElementType.DOC_COMMENT) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaDocElementType.DOC_TAG) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaDocElementType.DOC_INLINE_TAG) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.IMPORT_LIST) {
            return Indent.getNoneIndent();
        }
        if (parentType == JavaElementType.FIELD) {
            return Indent.getContinuationWithoutFirstIndent();
        }
        if (SourceTreeToPsiMap.treeElementToPsi(parent) instanceof PsiFile) {
            return Indent.getNoneIndent();
        }
        return null;
    }

    public Spacing getSpacing(Block child1, Block child2) {
        return JavaSpacePropertyProcessor.getSpacing(AbstractJavaBlock.getTreeNode(child2), this.mySettings);
    }

    @Override
    public ASTNode getFirstTreeNode() {
        return this.myNode;
    }

    @Override
    public Indent getIndent() {
        return this.myIndent;
    }

    protected static boolean isStatement(ASTNode child, ASTNode parentNode) {
        if (parentNode != null) {
            IElementType parentType = parentNode.getElementType();
            if (parentType == JavaElementType.CODE_BLOCK) {
                return false;
            }
            int role = ((CompositeElement)parentNode).getChildRole(child);
            if (parentType == JavaElementType.IF_STATEMENT) {
                return role == 33 || role == 34;
            }
            if (parentType == JavaElementType.FOR_STATEMENT) {
                return role == 38;
            }
            if (parentType == JavaElementType.WHILE_STATEMENT) {
                return role == 38;
            }
            if (parentType == JavaElementType.DO_WHILE_STATEMENT) {
                return role == 38;
            }
            if (parentType == JavaElementType.FOREACH_STATEMENT) {
                return role == 38;
            }
        }
        return false;
    }

    @Nullable
    protected Wrap createChildWrap() {
        IElementType nodeType = this.myNode.getElementType();
        if (nodeType == JavaElementType.EXTENDS_LIST || nodeType == JavaElementType.IMPLEMENTS_LIST) {
            return Wrap.createWrap((WrapType)AbstractJavaBlock.getWrapType(this.mySettings.EXTENDS_LIST_WRAP), (boolean)false);
        }
        if (nodeType == JavaElementType.BINARY_EXPRESSION) {
            Wrap actualWrap;
            Wrap wrap = actualWrap = this.myWrap != null ? this.myWrap : this.getReservedWrap(JavaElementType.BINARY_EXPRESSION);
            if (actualWrap == null) {
                return Wrap.createWrap((WrapType)AbstractJavaBlock.getWrapType(this.mySettings.BINARY_OPERATION_WRAP), (boolean)false);
            }
            if (!this.hasTheSamePriority(this.myNode.getTreeParent())) {
                return Wrap.createChildWrap((Wrap)actualWrap, (WrapType)AbstractJavaBlock.getWrapType(this.mySettings.BINARY_OPERATION_WRAP), (boolean)false);
            }
            return actualWrap;
        }
        if (nodeType == JavaElementType.CONDITIONAL_EXPRESSION) {
            return Wrap.createWrap((WrapType)AbstractJavaBlock.getWrapType(this.mySettings.TERNARY_OPERATION_WRAP), (boolean)false);
        }
        if (nodeType == JavaElementType.ASSERT_STATEMENT) {
            return Wrap.createWrap((WrapType)AbstractJavaBlock.getWrapType(this.mySettings.ASSERT_STATEMENT_WRAP), (boolean)false);
        }
        if (nodeType == JavaElementType.FOR_STATEMENT) {
            return Wrap.createWrap((WrapType)AbstractJavaBlock.getWrapType(this.mySettings.FOR_STATEMENT_WRAP), (boolean)false);
        }
        if (nodeType == JavaElementType.THROWS_LIST) {
            return Wrap.createWrap((WrapType)AbstractJavaBlock.getWrapType(this.mySettings.THROWS_LIST_WRAP), (boolean)true);
        }
        if (nodeType == JavaElementType.CODE_BLOCK) {
            return Wrap.createWrap((WrapType)Wrap.NORMAL, (boolean)false);
        }
        if (this.isAssignment()) {
            return Wrap.createWrap((WrapType)AbstractJavaBlock.getWrapType(this.mySettings.ASSIGNMENT_WRAP), (boolean)true);
        }
        return null;
    }

    private boolean isAssignment() {
        IElementType nodeType = this.myNode.getElementType();
        return nodeType == JavaElementType.ASSIGNMENT_EXPRESSION || nodeType == JavaElementType.LOCAL_VARIABLE || nodeType == JavaElementType.FIELD;
    }

    @Nullable
    protected Alignment createChildAlignment() {
        IElementType nodeType = this.myNode.getElementType();
        if (nodeType == JavaElementType.ASSIGNMENT_EXPRESSION) {
            if (this.myNode.getTreeParent() != null && this.myNode.getTreeParent().getElementType() == JavaElementType.ASSIGNMENT_EXPRESSION && this.myAlignment != null) {
                return this.myAlignment;
            }
            return AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_ASSIGNMENT, null);
        }
        if (nodeType == JavaElementType.PARENTH_EXPRESSION) {
            return AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION, null);
        }
        if (nodeType == JavaElementType.CONDITIONAL_EXPRESSION) {
            return AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_TERNARY_OPERATION, null);
        }
        if (nodeType == JavaElementType.FOR_STATEMENT) {
            return AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_FOR, null);
        }
        if (nodeType == JavaElementType.EXTENDS_LIST) {
            return AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_EXTENDS_LIST, null);
        }
        if (nodeType == JavaElementType.IMPLEMENTS_LIST) {
            return AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_EXTENDS_LIST, null);
        }
        if (nodeType == JavaElementType.THROWS_LIST) {
            return AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_THROWS_LIST, null);
        }
        if (nodeType == JavaElementType.PARAMETER_LIST) {
            return AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_PARAMETERS, null);
        }
        if (nodeType == JavaElementType.BINARY_EXPRESSION) {
            Alignment defaultAlignment = null;
            if (this.shouldInheritAlignment()) {
                defaultAlignment = this.myAlignment;
            }
            return AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_BINARY_OPERATION, defaultAlignment);
        }
        if (nodeType == JavaElementType.CLASS) {
            return Alignment.createAlignment();
        }
        if (nodeType == JavaElementType.METHOD) {
            return Alignment.createAlignment();
        }
        if (nodeType == JavaElementType.MODIFIER_LIST) {
            return this.myAlignment;
        }
        return null;
    }

    @Nullable
    protected Alignment createChildAlignment2(Alignment base) {
        IElementType nodeType = this.myNode.getElementType();
        if (nodeType == JavaElementType.CONDITIONAL_EXPRESSION) {
            return base == null ? AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_TERNARY_OPERATION, null) : AbstractJavaBlock.createAlignment(base, this.mySettings.ALIGN_MULTILINE_TERNARY_OPERATION, null);
        }
        return null;
    }

    protected Alignment chooseAlignment(Alignment alignment, Alignment alignment2, ASTNode child) {
        if (this.preferesSlaveAlignment(child)) {
            return alignment2;
        }
        return alignment;
    }

    private boolean preferesSlaveAlignment(ASTNode child) {
        IElementType nodeType = this.myNode.getElementType();
        if (nodeType == JavaElementType.CONDITIONAL_EXPRESSION) {
            IElementType childType = child.getElementType();
            return childType == JavaTokenType.QUEST || childType == JavaTokenType.COLON;
        }
        return false;
    }

    private boolean shouldInheritAlignment() {
        ASTNode treeParent;
        if (this.myNode.getElementType() == JavaElementType.BINARY_EXPRESSION && (treeParent = this.myNode.getTreeParent()) != null && treeParent.getElementType() == JavaElementType.BINARY_EXPRESSION) {
            return this.hasTheSamePriority(treeParent);
        }
        return false;
    }

    @Nullable
    protected ASTNode processChild(ArrayList<Block> result, ASTNode child, Alignment defaultAlignment, Wrap defaultWrap, Indent childIndent) {
        return this.processChild(result, child, defaultAlignment, defaultWrap, childIndent, -1);
    }

    @Nullable
    protected ASTNode processChild(ArrayList<Block> result, ASTNode child, Alignment defaultAlignment, Wrap defaultWrap, Indent childIndent, int childOffset) {
        IElementType childType = child.getElementType();
        if (childType == JavaTokenType.CLASS_KEYWORD || childType == JavaTokenType.INTERFACE_KEYWORD) {
            this.myIsAfterClassKeyword = true;
        }
        if (childType == JavaElementType.METHOD_CALL_EXPRESSION) {
            result.add(this.createMethodCallExpressiobBlock(child, this.arrangeChildWrap(child, defaultWrap), this.arrangeChildAlignment(child, defaultAlignment)));
        } else {
            IElementType nodeType = this.myNode.getElementType();
            if (childType == JavaTokenType.LBRACE && nodeType == JavaElementType.ARRAY_INITIALIZER_EXPRESSION) {
                Wrap wrap = Wrap.createWrap((WrapType)AbstractJavaBlock.getWrapType(this.mySettings.ARRAY_INITIALIZER_WRAP), (boolean)false);
                child = this.processParenBlock(JavaTokenType.LBRACE, JavaTokenType.RBRACE, result, child, WrappingStrategy.createDoNotWrapCommaStrategy(wrap), this.mySettings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION);
            } else if (childType == JavaTokenType.LBRACE && nodeType == JavaElementType.ANNOTATION_ARRAY_INITIALIZER) {
                Wrap wrap = Wrap.createWrap((WrapType)AbstractJavaBlock.getWrapType(this.mySettings.ARRAY_INITIALIZER_WRAP), (boolean)false);
                child = this.processParenBlock(JavaTokenType.LBRACE, JavaTokenType.RBRACE, result, child, WrappingStrategy.createDoNotWrapCommaStrategy(wrap), this.mySettings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION);
            } else if (childType == JavaTokenType.LPARENTH && nodeType == JavaElementType.EXPRESSION_LIST) {
                Wrap wrap = Wrap.createWrap((WrapType)AbstractJavaBlock.getWrapType(this.mySettings.CALL_PARAMETERS_WRAP), (boolean)false);
                if (this.mySettings.PREFER_PARAMETERS_WRAP) {
                    wrap.ignoreParentWraps();
                }
                child = this.processParenBlock(result, child, WrappingStrategy.createDoNotWrapCommaStrategy(wrap), this.mySettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS);
            } else if (childType == JavaTokenType.LPARENTH && nodeType == JavaElementType.PARAMETER_LIST) {
                Wrap wrap = Wrap.createWrap((WrapType)AbstractJavaBlock.getWrapType(this.mySettings.METHOD_PARAMETERS_WRAP), (boolean)false);
                child = this.processParenBlock(result, child, WrappingStrategy.createDoNotWrapCommaStrategy(wrap), this.mySettings.ALIGN_MULTILINE_PARAMETERS);
            } else if (childType == JavaTokenType.LPARENTH && nodeType == JavaElementType.ANNOTATION_PARAMETER_LIST) {
                Wrap wrap = Wrap.createWrap((WrapType)AbstractJavaBlock.getWrapType(this.mySettings.CALL_PARAMETERS_WRAP), (boolean)false);
                child = this.processParenBlock(result, child, WrappingStrategy.createDoNotWrapCommaStrategy(wrap), this.mySettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS);
            } else if (childType == JavaTokenType.LPARENTH && nodeType == JavaElementType.PARENTH_EXPRESSION) {
                child = this.processParenBlock(result, child, WrappingStrategy.DO_NOT_WRAP, this.mySettings.ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION);
            } else if (childType == JavaElementType.ENUM_CONSTANT && this.myNode instanceof ClassElement) {
                child = this.processEnumBlock(result, child, ((ClassElement)this.myNode).findEnumConstantListDelimiterPlace());
            } else if (this.mySettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE && this.isTernaryOperationSign(child)) {
                child = this.processTernaryOperationRange(result, child, defaultWrap, childIndent);
            } else if (childType == JavaElementType.FIELD) {
                child = this.processField(result, child, defaultAlignment, defaultWrap, childIndent);
            } else {
                Block block = AbstractJavaBlock.createJavaBlock(child, this.mySettings, childIndent, this.arrangeChildWrap(child, defaultWrap), this.arrangeChildAlignment(child, defaultAlignment), childOffset);
                if (childType == JavaElementType.MODIFIER_LIST && AbstractJavaBlock.containsAnnotations(child)) {
                    this.myAnnotationWrap = Wrap.createWrap((WrapType)AbstractJavaBlock.getWrapType(this.getAnnotationWrapType()), (boolean)true);
                }
                if (block instanceof AbstractJavaBlock) {
                    AbstractJavaBlock javaBlock = (AbstractJavaBlock)block;
                    if (nodeType == JavaElementType.METHOD_CALL_EXPRESSION && childType == JavaElementType.REFERENCE_EXPRESSION) {
                        javaBlock.setReservedWrap(this.getReservedWrap(nodeType), nodeType);
                        javaBlock.setReservedWrap(this.getReservedWrap(childType), childType);
                    } else if (nodeType == JavaElementType.REFERENCE_EXPRESSION && childType == JavaElementType.METHOD_CALL_EXPRESSION) {
                        javaBlock.setReservedWrap(this.getReservedWrap(nodeType), nodeType);
                        javaBlock.setReservedWrap(this.getReservedWrap(childType), childType);
                    } else if (nodeType == JavaElementType.BINARY_EXPRESSION) {
                        javaBlock.setReservedWrap(defaultWrap, nodeType);
                    } else if (childType == JavaElementType.MODIFIER_LIST) {
                        javaBlock.setReservedWrap(this.myAnnotationWrap, JavaElementType.MODIFIER_LIST);
                        if (!AbstractJavaBlock.lastChildIsAnnotation(child)) {
                            this.myAnnotationWrap = null;
                        }
                    }
                }
                result.add(block);
            }
        }
        return child;
    }

    private ASTNode processField(ArrayList<Block> result, ASTNode child, Alignment defaultAlignment, Wrap defaultWrap, Indent childIndent) {
        ASTNode lastFieldInGroup = AbstractJavaBlock.findLastFieldInGroup(child);
        if (lastFieldInGroup == child) {
            result.add(AbstractJavaBlock.createJavaBlock(child, this.getSettings(), childIndent, this.arrangeChildWrap(child, defaultWrap), this.arrangeChildAlignment(child, defaultAlignment)));
            return child;
        }
        ArrayList<Block> localResult = new ArrayList<Block>();
        while (child != null) {
            if (!FormatterUtil.containsWhiteSpacesOnly(child)) {
                localResult.add(AbstractJavaBlock.createJavaBlock(child, this.getSettings(), Indent.getContinuationWithoutFirstIndent(), this.arrangeChildWrap(child, defaultWrap), this.arrangeChildAlignment(child, defaultAlignment)));
            }
            if (child == lastFieldInGroup) break;
            child = child.getTreeNext();
        }
        if (!localResult.isEmpty()) {
            result.add(new SyntheticCodeBlock(localResult, null, this.getSettings(), childIndent, null));
        }
        return lastFieldInGroup;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static ASTNode findLastFieldInGroup(ASTNode child) {
        ASTNode aSTNode;
        PsiTypeElement typeElement = ((PsiVariable)child.getPsi()).getTypeElement();
        if (typeElement == null) {
            aSTNode = child;
            if (aSTNode == null) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/AbstractJavaBlock.findLastFieldInGroup must not return null");
            return aSTNode;
        }
        ASTNode lastChildNode = child.getLastChildNode();
        if (lastChildNode == null) {
            aSTNode = child;
            if (aSTNode == null) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/AbstractJavaBlock.findLastFieldInGroup must not return null");
            return aSTNode;
        }
        if (lastChildNode.getElementType() == JavaTokenType.SEMICOLON) {
            aSTNode = child;
            if (aSTNode == null) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/AbstractJavaBlock.findLastFieldInGroup must not return null");
            return aSTNode;
        }
        ASTNode currentResult = child;
        for (ASTNode currentNode = child.getTreeNext(); currentNode != null; currentNode = currentNode.getTreeNext()) {
            if (currentNode.getElementType() == TokenType.WHITE_SPACE || currentNode.getElementType() == JavaTokenType.COMMA || StdTokenSets.COMMENT_BIT_SET.contains(currentNode.getElementType())) continue;
            if (currentNode.getElementType() == JavaElementType.FIELD) {
                if (((PsiVariable)currentNode.getPsi()).getTypeElement() != typeElement) {
                    aSTNode = currentResult;
                    if (aSTNode == null) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/AbstractJavaBlock.findLastFieldInGroup must not return null");
                    return aSTNode;
                } else {
                    currentResult = currentNode;
                    continue;
                }
            }
            aSTNode = currentResult;
            if (aSTNode == null) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/AbstractJavaBlock.findLastFieldInGroup must not return null");
            return aSTNode;
        }
        aSTNode = currentResult;
        if (aSTNode != null) return aSTNode;
        throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/AbstractJavaBlock.findLastFieldInGroup must not return null");
    }

    @Nullable
    private ASTNode processTernaryOperationRange(ArrayList<Block> result, ASTNode child, Wrap defaultWrap, Indent childIndent) {
        ArrayList<Block> localResult = new ArrayList<Block>();
        Wrap wrap = this.arrangeChildWrap(child, defaultWrap);
        Alignment alignment = this.myReservedAlignment;
        Alignment alignment2 = this.myReservedAlignment2;
        localResult.add((Block)new LeafBlock(child, wrap, this.chooseAlignment(alignment, alignment2, child), childIndent));
        ASTNode current = child.getTreeNext();
        while (current != null) {
            if (!FormatterUtil.containsWhiteSpacesOnly(current) && current.getTextLength() > 0) {
                if (this.isTernaryOperationSign(current)) break;
                current = this.processChild(localResult, current, this.chooseAlignment(alignment, alignment2, current), defaultWrap, childIndent);
            }
            if (current == null) continue;
            current = current.getTreeNext();
        }
        result.add(new SyntheticCodeBlock(localResult, this.chooseAlignment(alignment, alignment2, child), this.getSettings(), null, wrap));
        if (current == null) {
            return null;
        }
        return current.getTreePrev();
    }

    private boolean isTernaryOperationSign(ASTNode child) {
        if (this.myNode.getElementType() != JavaElementType.CONDITIONAL_EXPRESSION) {
            return false;
        }
        int role = ((CompositeElement)child.getTreeParent()).getChildRole(child);
        return role == 63 || role == 87;
    }

    private Block createMethodCallExpressiobBlock(ASTNode node, Wrap blockWrap, Alignment alignment) {
        ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
        ArrayList<Block> subBlocks = new ArrayList<Block>();
        AbstractJavaBlock.collectNodes(nodes, node);
        Wrap wrap = Wrap.createWrap((WrapType)AbstractJavaBlock.getWrapType(this.mySettings.METHOD_CALL_CHAIN_WRAP), (boolean)false);
        while (!nodes.isEmpty()) {
            ArrayList<ASTNode> subNodes = AbstractJavaBlock.readToNextDot(nodes);
            subBlocks.add(this.createSynthBlock(subNodes, wrap));
        }
        return new SyntheticCodeBlock(subBlocks, alignment, this.mySettings, Indent.getContinuationWithoutFirstIndent(), blockWrap);
    }

    private Block createSynthBlock(ArrayList<ASTNode> subNodes, Wrap wrap) {
        ArrayList<Block> subBlocks = new ArrayList<Block>();
        ASTNode firstNode = subNodes.get(0);
        if (firstNode.getElementType() == JavaTokenType.DOT) {
            subBlocks.add(AbstractJavaBlock.createJavaBlock(firstNode, this.getSettings(), Indent.getNoneIndent(), null, null));
            subNodes.remove(0);
            if (!subNodes.isEmpty()) {
                subBlocks.add(this.createSynthBlock(subNodes, wrap));
            }
            return new SyntheticCodeBlock(subBlocks, null, this.mySettings, Indent.getContinuationIndent(), wrap);
        }
        return new SyntheticCodeBlock(this.createJavaBlocks(subNodes), null, this.mySettings, Indent.getContinuationWithoutFirstIndent(), null);
    }

    private List<Block> createJavaBlocks(ArrayList<ASTNode> subNodes) {
        ArrayList<Block> result = new ArrayList<Block>();
        for (ASTNode node : subNodes) {
            result.add(AbstractJavaBlock.createJavaBlock(node, this.getSettings(), Indent.getContinuationWithoutFirstIndent(), null, null));
        }
        return result;
    }

    private static ArrayList<ASTNode> readToNextDot(ArrayList<ASTNode> nodes) {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>();
        result.add(nodes.remove(0));
        Iterator<ASTNode> iterator = nodes.iterator();
        while (iterator.hasNext()) {
            ASTNode node = iterator.next();
            if (node.getElementType() == JavaTokenType.DOT) {
                return result;
            }
            result.add(node);
            iterator.remove();
        }
        return result;
    }

    private static void collectNodes(List<ASTNode> nodes, ASTNode node) {
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (FormatterUtil.containsWhiteSpacesOnly(child)) continue;
            if (child.getElementType() == JavaElementType.METHOD_CALL_EXPRESSION || child.getElementType() == JavaElementType.REFERENCE_EXPRESSION) {
                AbstractJavaBlock.collectNodes(nodes, child);
                continue;
            }
            nodes.add(child);
        }
    }

    private static boolean lastChildIsAnnotation(ASTNode child) {
        ASTNode current;
        for (current = child.getLastChildNode(); current != null && current.getElementType() == TokenType.WHITE_SPACE; current = current.getTreePrev()) {
        }
        return current != null && current.getElementType() == JavaElementType.ANNOTATION;
    }

    private static boolean containsAnnotations(ASTNode child) {
        return ((PsiModifierList)child.getPsi()).getAnnotations().length > 0;
    }

    private int getAnnotationWrapType() {
        IElementType nodeType = this.myNode.getElementType();
        if (nodeType == JavaElementType.METHOD) {
            return this.mySettings.METHOD_ANNOTATION_WRAP;
        }
        if (nodeType == JavaElementType.CLASS) {
            return this.mySettings.CLASS_ANNOTATION_WRAP;
        }
        if (nodeType == JavaElementType.FIELD) {
            return this.mySettings.FIELD_ANNOTATION_WRAP;
        }
        if (nodeType == JavaElementType.PARAMETER) {
            return this.mySettings.PARAMETER_ANNOTATION_WRAP;
        }
        if (nodeType == JavaElementType.LOCAL_VARIABLE) {
            return this.mySettings.VARIABLE_ANNOTATION_WRAP;
        }
        return 0;
    }

    @Nullable
    private Alignment arrangeChildAlignment(ASTNode child, Alignment defaultAlignment) {
        int role = ((CompositeElement)child.getTreeParent()).getChildRole(child);
        IElementType nodeType = this.myNode.getElementType();
        if (nodeType == JavaElementType.FOR_STATEMENT) {
            if (role == 39 || role == 32 || role == 40) {
                return defaultAlignment;
            }
            return null;
        }
        if (nodeType == JavaElementType.EXTENDS_LIST || nodeType == JavaElementType.IMPLEMENTS_LIST) {
            if (role == 29 || role == 27) {
                return defaultAlignment;
            }
            return null;
        }
        if (nodeType == JavaElementType.THROWS_LIST) {
            if (role == 29) {
                return defaultAlignment;
            }
            return null;
        }
        if (nodeType == JavaElementType.CLASS) {
            if (role == 11) {
                return defaultAlignment;
            }
            if (this.myIsAfterClassKeyword) {
                return null;
            }
            if (role == 8) {
                return defaultAlignment;
            }
            if (role == 7) {
                return defaultAlignment;
            }
            return null;
        }
        if (nodeType == JavaElementType.METHOD) {
            if (role == 8) {
                return defaultAlignment;
            }
            if (role == 245) {
                return defaultAlignment;
            }
            if (role == 10) {
                return defaultAlignment;
            }
            if (role == 9) {
                return defaultAlignment;
            }
            return null;
        }
        if (nodeType == JavaElementType.ASSIGNMENT_EXPRESSION) {
            if (role == 61) {
                return defaultAlignment;
            }
            if (role == 62 && child.getElementType() == JavaElementType.ASSIGNMENT_EXPRESSION) {
                return defaultAlignment;
            }
            return null;
        }
        return defaultAlignment;
    }

    private static Alignment createAlignment(boolean alignOption, Alignment defaultAlignment) {
        return alignOption ? AbstractJavaBlock.createAlignmentOrDefault(null, defaultAlignment) : defaultAlignment;
    }

    private static Alignment createAlignment(Alignment base, boolean alignOption, Alignment defaultAlignment) {
        return alignOption ? AbstractJavaBlock.createAlignmentOrDefault(base, defaultAlignment) : defaultAlignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Wrap arrangeChildWrap(ASTNode child, Wrap defaultWrap) {
        if (this.myAnnotationWrap != null) {
            try {
                Wrap wrap = this.myAnnotationWrap;
                return wrap;
            }
            finally {
                this.myAnnotationWrap = null;
            }
        }
        ASTNode parent = child.getTreeParent();
        int role = ((CompositeElement)parent).getChildRole(child);
        IElementType nodeType = this.myNode.getElementType();
        if (nodeType == JavaElementType.BINARY_EXPRESSION) {
            if (role == 63 && !this.mySettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE) {
                return null;
            }
            if (role == 62 && this.mySettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE) {
                return null;
            }
            return defaultWrap;
        }
        IElementType childType = child.getElementType();
        if (childType == JavaElementType.EXTENDS_LIST || childType == JavaElementType.IMPLEMENTS_LIST) {
            return Wrap.createWrap((WrapType)AbstractJavaBlock.getWrapType(this.mySettings.EXTENDS_KEYWORD_WRAP), (boolean)true);
        }
        if (childType == JavaElementType.THROWS_LIST) {
            return Wrap.createWrap((WrapType)AbstractJavaBlock.getWrapType(this.mySettings.THROWS_KEYWORD_WRAP), (boolean)true);
        }
        if (nodeType == JavaElementType.EXTENDS_LIST || nodeType == JavaElementType.IMPLEMENTS_LIST) {
            if (role == 29) {
                return defaultWrap;
            }
            return null;
        }
        if (nodeType == JavaElementType.THROWS_LIST) {
            if (role == 29) {
                return defaultWrap;
            }
            return null;
        }
        if (nodeType == JavaElementType.CONDITIONAL_EXPRESSION) {
            if (role == 87 && !this.mySettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE) {
                return null;
            }
            if (role == 114 && !this.mySettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE) {
                return null;
            }
            if (role == 112 && this.mySettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE) {
                return null;
            }
            if (role == 113 && this.mySettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE) {
                return null;
            }
            return defaultWrap;
        }
        if (this.isAssignment()) {
            if (role == 20 && this.mySettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE) {
                return defaultWrap;
            }
            if (role == 20 && !this.mySettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE) {
                return null;
            }
            if (role == 63 && this.mySettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE) {
                return defaultWrap;
            }
            if (role == 63 && !this.mySettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE) {
                return null;
            }
            if (role == 21 && !this.mySettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE) {
                return defaultWrap;
            }
            if (role == 21 && this.mySettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE) {
                return null;
            }
            if (role == 62 && !this.mySettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE) {
                return defaultWrap;
            }
            if (role == 62 && this.mySettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE) {
                return null;
            }
            if (role == 22) {
                return null;
            }
            return defaultWrap;
        }
        if (nodeType == JavaElementType.REFERENCE_EXPRESSION) {
            if (role == 55) {
                return this.getReservedWrap(JavaElementType.REFERENCE_EXPRESSION);
            }
            return defaultWrap;
        }
        if (nodeType == JavaElementType.FOR_STATEMENT) {
            if (role == 39 || role == 32 || role == 40) {
                return defaultWrap;
            }
            if (role == 38) {
                boolean dontWrap = (childType == JavaElementType.CODE_BLOCK || childType == JavaElementType.BLOCK_STATEMENT) && this.mySettings.BRACE_STYLE == 1;
                return Wrap.createWrap((WrapType)(dontWrap ? WrapType.NONE : WrapType.NORMAL), (boolean)true);
            }
            return null;
        }
        if (nodeType == JavaElementType.METHOD) {
            if (role == 16) {
                return defaultWrap;
            }
            return null;
        }
        if (nodeType == JavaElementType.MODIFIER_LIST) {
            if (childType == JavaElementType.ANNOTATION) {
                return this.getReservedWrap(JavaElementType.MODIFIER_LIST);
            }
            ASTNode prevElement = AbstractJavaBlock.getPrevElement(child);
            if (prevElement != null && prevElement.getElementType() == JavaElementType.ANNOTATION) {
                return this.getReservedWrap(JavaElementType.MODIFIER_LIST);
            }
            return null;
        }
        if (nodeType == JavaElementType.ASSERT_STATEMENT) {
            if (role == 32) {
                return defaultWrap;
            }
            if (role == 117 && !this.mySettings.ASSERT_STATEMENT_COLON_ON_NEXT_LINE) {
                return defaultWrap;
            }
            if (role == 87 && this.mySettings.ASSERT_STATEMENT_COLON_ON_NEXT_LINE) {
                return defaultWrap;
            }
            return null;
        }
        if (nodeType == JavaElementType.CODE_BLOCK) {
            if (role == 56) {
                return defaultWrap;
            }
            return null;
        }
        if (nodeType == JavaElementType.IF_STATEMENT) {
            if (childType == JavaElementType.IF_STATEMENT && role == 34 && this.getSettings().SPECIAL_ELSE_IF_TREATMENT) {
                return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
            }
            if (role == 33 || role == 34) {
                if (childType == JavaElementType.BLOCK_STATEMENT) {
                    return null;
                }
                return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
            }
        } else if (nodeType == JavaElementType.FOREACH_STATEMENT || nodeType == JavaElementType.WHILE_STATEMENT) {
            if (role == 38) {
                if (childType == JavaElementType.BLOCK_STATEMENT) {
                    return null;
                }
                return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
            }
        } else if (nodeType == JavaElementType.DO_WHILE_STATEMENT) {
            if (role == 38) {
                return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
            }
            if (role == 35) {
                return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
            }
        } else if (nodeType == JavaElementType.ANNOTATION_ARRAY_INITIALIZER && role == 249) {
            return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
        }
        return defaultWrap;
    }

    @Nullable
    private static ASTNode getPrevElement(ASTNode child) {
        ASTNode result;
        for (result = child.getTreePrev(); result != null && result.getElementType() == TokenType.WHITE_SPACE; result = result.getTreePrev()) {
        }
        return result;
    }

    private boolean hasTheSamePriority(ASTNode node) {
        if (node == null) {
            return false;
        }
        if (node.getElementType() != JavaElementType.BINARY_EXPRESSION) {
            return false;
        }
        PsiBinaryExpression expr1 = (PsiBinaryExpression)SourceTreeToPsiMap.treeElementToPsi(this.myNode);
        PsiBinaryExpression expr2 = (PsiBinaryExpression)SourceTreeToPsiMap.treeElementToPsi(node);
        PsiJavaToken op1 = expr1.getOperationSign();
        PsiJavaToken op2 = expr2.getOperationSign();
        return op1.getTokenType() == op2.getTokenType();
    }

    private static WrapType getWrapType(int wrap) {
        switch (wrap) {
            case 2: {
                return WrapType.ALWAYS;
            }
            case 1: {
                return WrapType.NORMAL;
            }
            case 0: {
                return WrapType.NONE;
            }
        }
        return WrapType.CHOP_DOWN_IF_LONG;
    }

    private ASTNode processParenBlock(List<Block> result, ASTNode child, WrappingStrategy wrappingStrategy, boolean doAlign) {
        this.myUseChildAttributes = true;
        IElementType from = JavaTokenType.LPARENTH;
        IElementType to = JavaTokenType.RPARENTH;
        return this.processParenBlock(from, to, result, child, wrappingStrategy, doAlign);
    }

    private ASTNode processParenBlock(IElementType from, IElementType to, List<Block> result, ASTNode child, WrappingStrategy wrappingStrategy, boolean doAlign) {
        Indent externalIndent = Indent.getNoneIndent();
        Indent internalIndent = Indent.getContinuationIndent();
        AlignmentStrategy alignmentStrategy = AlignmentStrategy.createDoNotAlingCommaStrategy(AbstractJavaBlock.createAlignment(doAlign, null));
        this.setChildIndent(internalIndent);
        this.setChildAlignment(alignmentStrategy.getAlignment(null));
        boolean isAfterIncomplete = false;
        ASTNode prev = child;
        int startOffset = child.getTextRange().getStartOffset();
        while (child != null) {
            boolean bl = isAfterIncomplete = isAfterIncomplete || child.getElementType() == TokenType.ERROR_ELEMENT || child.getElementType() == JavaElementType.EMPTY_EXPRESSION;
            if (!FormatterUtil.containsWhiteSpacesOnly(child) && child.getTextLength() > 0) {
                if (child.getElementType() == from) {
                    result.add(AbstractJavaBlock.createJavaBlock(child, this.mySettings, externalIndent, null, null));
                } else {
                    if (child.getElementType() == to) {
                        result.add(AbstractJavaBlock.createJavaBlock(child, this.mySettings, isAfterIncomplete ? internalIndent : externalIndent, null, isAfterIncomplete ? alignmentStrategy.getAlignment(null) : null));
                        return child;
                    }
                    IElementType elementType = child.getElementType();
                    result.add(AbstractJavaBlock.createJavaBlock(child, this.mySettings, internalIndent, wrappingStrategy.getWrap(elementType), alignmentStrategy.getAlignment(elementType), startOffset));
                    if (to == null) {
                        return child;
                    }
                }
                isAfterIncomplete = false;
            }
            prev = child;
            startOffset += child.getTextLength();
            child = child.getTreeNext();
        }
        return prev;
    }

    @Nullable
    private ASTNode processEnumBlock(List<Block> result, ASTNode child, ASTNode last) {
        WrappingStrategy wrappingStrategy = WrappingStrategy.createDoNotWrapCommaStrategy(Wrap.createWrap((WrapType)AbstractJavaBlock.getWrapType(this.mySettings.ENUM_CONSTANTS_WRAP), (boolean)true));
        while (child != null) {
            if (!FormatterUtil.containsWhiteSpacesOnly(child) && child.getTextLength() > 0) {
                result.add(AbstractJavaBlock.createJavaBlock(child, this.mySettings, Indent.getNormalIndent(), wrappingStrategy.getWrap(child.getElementType()), null));
                if (child == last) {
                    return child;
                }
            }
            child = child.getTreeNext();
        }
        return null;
    }

    private void setChildAlignment(Alignment alignment) {
        this.myChildAlignment = alignment;
    }

    private void setChildIndent(Indent internalIndent) {
        this.myChildIndent = internalIndent;
    }

    private static Alignment createAlignmentOrDefault(Alignment base, Alignment defaultAlignment) {
        if (defaultAlignment == null) {
            return base == null ? Alignment.createAlignment() : Alignment.createChildAlignment((Alignment)base);
        }
        return defaultAlignment;
    }

    private int getBraceStyle() {
        PsiElement psiNode = SourceTreeToPsiMap.treeElementToPsi(this.myNode);
        if (psiNode instanceof PsiClass) {
            return this.mySettings.CLASS_BRACE_STYLE;
        }
        if (psiNode instanceof PsiMethod) {
            return this.mySettings.METHOD_BRACE_STYLE;
        }
        if (psiNode instanceof PsiCodeBlock && psiNode.getParent() != null && psiNode.getParent() instanceof PsiMethod) {
            return this.mySettings.METHOD_BRACE_STYLE;
        }
        return this.mySettings.BRACE_STYLE;
    }

    protected Indent getCodeBlockInternalIndent(int baseChildrenIndent) {
        if (this.isTopLevelClass() && this.mySettings.DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS) {
            return Indent.getNoneIndent();
        }
        int braceStyle = this.getBraceStyle();
        return braceStyle == 3 ? AbstractJavaBlock.createNormalIndent(baseChildrenIndent - 1) : AbstractJavaBlock.createNormalIndent(baseChildrenIndent);
    }

    protected static Indent createNormalIndent(int baseChildrenIndent) {
        if (baseChildrenIndent == 1) {
            return Indent.getNormalIndent();
        }
        if (baseChildrenIndent <= 0) {
            return Indent.getNoneIndent();
        }
        LOG.assertTrue(false);
        return Indent.getNormalIndent();
    }

    private boolean isTopLevelClass() {
        return this.myNode.getElementType() == JavaElementType.CLASS && SourceTreeToPsiMap.treeElementToPsi(this.myNode.getTreeParent()) instanceof PsiFile;
    }

    protected Indent getCodeBlockExternalIndent() {
        int braceStyle = this.getBraceStyle();
        if (braceStyle == 1 || braceStyle == 2 || braceStyle == 5) {
            return Indent.getNoneIndent();
        }
        return Indent.getNormalIndent();
    }

    protected Indent getCodeBlockChildExternalIndent(int newChildIndex) {
        int braceStyle = this.getBraceStyle();
        if (!this.isAfterCodeBlock(newChildIndex)) {
            return Indent.getNormalIndent();
        }
        if (braceStyle == 2 || braceStyle == 5 || braceStyle == 1) {
            return Indent.getNoneIndent();
        }
        return Indent.getNormalIndent();
    }

    private boolean isAfterCodeBlock(int newChildIndex) {
        if (newChildIndex == 0) {
            return false;
        }
        Block blockBefore = this.getSubBlocks().get(newChildIndex - 1);
        return blockBefore instanceof CodeBlockBlock;
    }

    protected abstract Wrap getReservedWrap(IElementType var1);

    protected abstract void setReservedWrap(Wrap var1, IElementType var2);

    @Nullable
    protected static ASTNode getTreeNode(Block child2) {
        if (child2 instanceof JavaBlock) {
            return ((JavaBlock)child2).getFirstTreeNode();
        }
        if (child2 instanceof LeafBlock) {
            return ((LeafBlock)child2).getTreeNode();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes;
        if (this.myUseChildAttributes) {
            childAttributes = new ChildAttributes(this.myChildIndent, this.myChildAlignment);
            if (childAttributes == null) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/AbstractJavaBlock.getChildAttributes must not return null");
            return childAttributes;
        }
        if (this.isAfter(newChildIndex, new IElementType[]{JavaDocElementType.DOC_COMMENT})) {
            childAttributes = new ChildAttributes(Indent.getNoneIndent(), this.myChildAlignment);
            if (childAttributes == null) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/AbstractJavaBlock.getChildAttributes must not return null");
            return childAttributes;
        }
        childAttributes = super.getChildAttributes(newChildIndex);
        if (childAttributes != null) return childAttributes;
        throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/AbstractJavaBlock.getChildAttributes must not return null");
    }

    @Override
    @Nullable
    protected Indent getChildIndent() {
        return AbstractJavaBlock.getChildIndent(this.myNode);
    }

    public CodeStyleSettings getSettings() {
        return this.mySettings;
    }

    protected boolean isAfter(int newChildIndex, IElementType[] elementTypes) {
        if (newChildIndex == 0) {
            return false;
        }
        Block previousBlock = this.getSubBlocks().get(newChildIndex - 1);
        if (!(previousBlock instanceof AbstractBlock)) {
            return false;
        }
        IElementType previousElementType = ((AbstractBlock)previousBlock).getNode().getElementType();
        for (IElementType elementType : elementTypes) {
            if (previousElementType != elementType) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected Alignment getUsedAlignment(int newChildIndex) {
        List<Block> subBlocks = this.getSubBlocks();
        for (int i = 0; i < newChildIndex; ++i) {
            if (i >= subBlocks.size()) {
                return null;
            }
            Block block = subBlocks.get(i);
            Alignment alignment = block.getAlignment();
            if (alignment == null) continue;
            return alignment;
        }
        return null;
    }

    public boolean isLeaf() {
        return JavaBlockUtil.mayShiftIndentInside(this.myNode);
    }
}

