/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.types;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ReflectionCache;

public class TypeClassFilter
implements ElementFilter {
    private final ElementFilter myFilter;

    public TypeClassFilter(ElementFilter _filter) {
        this.myFilter = _filter;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return ReflectionCache.isAssignable(PsiType.class, (Class)hintClass);
    }

    public boolean isAcceptable(Object element, PsiElement context) {
        PsiClass psiClass;
        PsiType type;
        if (element instanceof PsiType && (type = (PsiType)element) instanceof PsiClassType && PsiUtil.resolveClassInType((PsiType)type) != null && (psiClass = PsiUtil.resolveClassInType((PsiType)type)) != null) {
            return this.myFilter.isAcceptable((Object)psiClass, context);
        }
        return false;
    }
}

