/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.getters;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.SmartCompletionDecorator;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Nullable;

public class MembersGetter {
    public static void addMembers(PsiElement position, PsiType expectedType, CompletionResultSet results) {
        PsiElement parent;
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)expectedType);
        if (psiClass != null) {
            MembersGetter.processMembers(position, results, psiClass, PsiTreeUtil.getParentOfType((PsiElement)position, PsiAnnotation.class) != null, expectedType);
        }
        if (expectedType instanceof PsiPrimitiveType && PsiType.DOUBLE.isAssignableFrom(expectedType) && (parent = position.getParent()) instanceof PsiReferenceExpression) {
            PsiClass aClass;
            PsiBinaryExpression binaryExpression;
            PsiElement refParent = parent.getParent();
            if (refParent instanceof PsiExpressionList) {
                PsiClass aClass2 = MembersGetter.getCalledClass(refParent.getParent());
                if (aClass2 != null) {
                    MembersGetter.processMembers(position, results, aClass2, false, expectedType);
                }
            } else if (refParent instanceof PsiBinaryExpression && parent == (binaryExpression = (PsiBinaryExpression)refParent).getROperand() && JavaTokenType.EQEQ == binaryExpression.getOperationSign().getTokenType() && (aClass = MembersGetter.getCalledClass((PsiElement)binaryExpression.getLOperand())) != null) {
                MembersGetter.processMembers(position, results, aClass, false, expectedType);
            }
        }
    }

    @Nullable
    private static PsiClass getCalledClass(@Nullable PsiElement call) {
        PsiJavaCodeReferenceElement reference;
        if (call instanceof PsiMethodCallExpression) {
            for (JavaResolveResult result : ((PsiMethodCallExpression)call).getMethodExpression().multiResolve(true)) {
                PsiClass aClass;
                PsiElement element = result.getElement();
                if (!(element instanceof PsiMethod) || (aClass = ((PsiMethod)element).getContainingClass()) == null) continue;
                return aClass;
            }
        }
        if (call instanceof PsiNewExpression && (reference = ((PsiNewExpression)call).getClassReference()) != null) {
            for (JavaResolveResult result : reference.multiResolve(true)) {
                PsiElement element = result.getElement();
                if (!(element instanceof PsiClass)) continue;
                return (PsiClass)element;
            }
        }
        return null;
    }

    private static void processMembers(PsiElement context, CompletionResultSet results, PsiClass where, boolean acceptMethods, PsiType expectedType) {
        FilterScopeProcessor processor = new FilterScopeProcessor(TrueFilter.INSTANCE);
        where.processDeclarations(processor, ResolveState.initial(), null, context);
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)context.getProject()).getResolveHelper();
        for (PsiElement result : processor.getResults()) {
            PsiMember member;
            if (!(result instanceof PsiMember) || result instanceof PsiClass || !(member = (PsiMember)result).hasModifierProperty("static") || PsiTreeUtil.isAncestor((PsiElement)member.getContainingClass(), (PsiElement)context, (boolean)false) || !resolveHelper.isAccessible(member, context, null) || result instanceof PsiField && !member.hasModifierProperty("final") || result instanceof PsiMethod && acceptMethods) continue;
            LookupItem item = (LookupItem)LookupItemUtil.objectToLookupItem(result);
            item.setAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
            JavaCompletionUtil.qualify(item);
            if (member instanceof PsiMethod) {
                ((JavaMethodCallElement)item).setInferenceSubstitutor(SmartCompletionDecorator.calculateMethodReturnTypeSubstitutor((PsiMethod)member, expectedType));
            }
            results.addElement((LookupElement)item);
        }
    }
}

