/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.classes;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.filters.classes.ClassAssignableFilter;

public class ClassAssignableToFilter
extends ClassAssignableFilter {
    public ClassAssignableToFilter(String className) {
        this.myClassName = className;
    }

    public ClassAssignableToFilter(PsiClass psiClass) {
        this.myClass = psiClass;
    }

    public ClassAssignableToFilter() {
    }

    @Override
    public boolean isAcceptable(Object aClass, PsiElement context) {
        if (aClass instanceof PsiClass) {
            PsiManager manager = ((PsiElement)aClass).getManager();
            PsiClass psiClass = this.getPsiClass(manager, context.getResolveScope());
            return psiClass == aClass || ((PsiClass)aClass).isInheritor(psiClass, true);
        }
        return false;
    }

    @Override
    public String toString() {
        return "class-assignable-to(" + this.getPsiClass(null, null) + ")";
    }
}

