/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ReflectionCache;
import com.intellij.util.containers.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiplePsiFilesPerDocumentFileViewProvider
extends SingleRootFileViewProvider {
    private final ConcurrentMap<Language, PsiFile> myRoots = new ConcurrentHashMap(1, 0.75f, 1);
    private MultiplePsiFilesPerDocumentFileViewProvider myOriginal = null;

    public MultiplePsiFilesPerDocumentFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical) {
        super(manager, virtualFile, physical, Language.ANY);
    }

    @Override
    @NotNull
    public abstract Language getBaseLanguage();

    @Override
    @NotNull
    public List<PsiFile> getAllFiles() {
        ArrayList<PsiFile> roots = new ArrayList<PsiFile>();
        for (Language language : this.getLanguages()) {
            PsiFile psi = this.getPsi(language);
            if (psi == null) continue;
            roots.add(psi);
        }
        PsiFile base = this.getPsi(this.getBaseLanguage());
        if (!roots.isEmpty() && roots.get(0) != base) {
            roots.remove(base);
            roots.add(0, base);
        }
        ArrayList<PsiFile> arrayList = roots;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider.getAllFiles must not return null");
        }
        return arrayList;
    }

    protected void removeFile(Language language) {
        this.myRoots.remove(language);
    }

    @Override
    protected PsiFile getPsiInner(Language target) {
        PsiFile file = (PsiFile)this.myRoots.get(target);
        if (file == null) {
            PsiFile originalFile;
            VirtualFile virtualFile;
            VirtualFile parent;
            if (this.isPhysical() && (parent = (virtualFile = this.getVirtualFile()).getParent()) != null) {
                this.getManager().findDirectory(parent);
            }
            if ((file = this.createFile(target)) == null) {
                return null;
            }
            if (this.myOriginal != null && (originalFile = this.myOriginal.getPsi(target)) != null) {
                ((PsiFileImpl)file).setOriginalFile(originalFile);
            }
            file = (PsiFile)ConcurrencyUtil.cacheOrGet(this.myRoots, (Object)target, (Object)file);
        }
        return file;
    }

    @Override
    public PsiFile getCachedPsi(Language target) {
        return (PsiFile)this.myRoots.get(target);
    }

    @Override
    public FileElement[] getKnownTreeRoots() {
        ArrayList<FileElement> files = new ArrayList<FileElement>(this.myRoots.size());
        for (PsiFile file : this.myRoots.values()) {
            FileElement treeElement = ((PsiFileImpl)file).getTreeElement();
            if (treeElement == null) continue;
            files.add(treeElement);
        }
        return files.toArray(new FileElement[files.size()]);
    }

    public void checkAllTreesEqual() {
        Collection roots = this.myRoots.values();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.getManager().getProject());
        documentManager.commitAllDocuments();
        for (PsiFile root : roots) {
            Document document = documentManager.getDocument(root);
            PsiDocumentManagerImpl.checkConsistency(root, document);
            assert (root.getText().equals(document.getText()));
        }
    }

    @Override
    @NotNull
    public final MultiplePsiFilesPerDocumentFileViewProvider createCopy(LightVirtualFile fileCopy) {
        MultiplePsiFilesPerDocumentFileViewProvider copy = this.cloneInner((VirtualFile)fileCopy);
        copy.myOriginal = this.myOriginal == null ? this : this.myOriginal;
        MultiplePsiFilesPerDocumentFileViewProvider multiplePsiFilesPerDocumentFileViewProvider = copy;
        if (multiplePsiFilesPerDocumentFileViewProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider.createCopy must not return null");
        }
        return multiplePsiFilesPerDocumentFileViewProvider;
    }

    protected abstract MultiplePsiFilesPerDocumentFileViewProvider cloneInner(VirtualFile var1);

    @Override
    @Nullable
    public PsiElement findElementAt(int offset, Class<? extends Language> lang) {
        PsiFile mainRoot = this.getPsi(this.getBaseLanguage());
        PsiElement ret = null;
        for (Language language : this.getLanguages()) {
            PsiFile psiRoot;
            PsiElement psiElement;
            if (!ReflectionCache.isAssignable(lang, language.getClass()) || lang.equals(Language.class) && !this.getLanguages().contains(language) || (psiElement = MultiplePsiFilesPerDocumentFileViewProvider.findElementAt((PsiElement)(psiRoot = this.getPsi(language)), offset)) == null || psiElement instanceof OuterLanguageElement || ret != null && psiRoot == mainRoot) continue;
            ret = psiElement;
        }
        return ret;
    }

    @Override
    @Nullable
    public PsiElement findElementAt(int offset) {
        return this.findElementAt(offset, Language.class);
    }

    @Override
    @Nullable
    public PsiReference findReferenceAt(int offset) {
        TextRange minRange = new TextRange(0, this.getContents().length());
        PsiReference ret = null;
        for (Language language : this.getLanguages()) {
            TextRange textRange;
            PsiFile psiRoot = this.getPsi(language);
            PsiReference reference = SharedPsiElementImplUtil.findReferenceAt((PsiElement)psiRoot, offset, language);
            if (reference == null || !minRange.contains(textRange = reference.getRangeInElement().shiftRight(reference.getElement().getTextRange().getStartOffset()))) continue;
            minRange = textRange;
            ret = reference;
        }
        return ret;
    }
}

