/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.ex.SeverityEditorDialog;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.ui.ComboboxWithBrowseButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;

public class LevelChooser
extends ComboboxWithBrowseButton {
    private final MyRenderer ourRenderer = new MyRenderer();

    public LevelChooser(final SeverityRegistrar severityRegistrar) {
        JComboBox comboBox = this.getComboBox();
        final DefaultComboBoxModel model = new DefaultComboBoxModel();
        comboBox.setModel(model);
        LevelChooser.fillModel(model, severityRegistrar);
        comboBox.setRenderer(this.ourRenderer);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeverityEditorDialog dlg = new SeverityEditorDialog((JComponent)((Object)LevelChooser.this), (HighlightSeverity)LevelChooser.this.getComboBox().getSelectedItem(), severityRegistrar);
                dlg.show();
                if (dlg.isOK()) {
                    Object item = LevelChooser.this.getComboBox().getSelectedItem();
                    LevelChooser.fillModel(model, severityRegistrar);
                    HighlightInfoType type = dlg.getSelectedType();
                    if (type != null) {
                        LevelChooser.this.getComboBox().setSelectedItem(type.getSeverity(null));
                    } else {
                        LevelChooser.this.getComboBox().setSelectedItem(item);
                    }
                }
            }
        });
    }

    private static void fillModel(DefaultComboBoxModel model, SeverityRegistrar severityRegistrar) {
        model.removeAllElements();
        TreeSet<HighlightSeverity> severities = new TreeSet<HighlightSeverity>(severityRegistrar);
        for (SeverityRegistrar.SeverityBasedTextAttributes type : severityRegistrar.getRegisteredHighlightingInfoTypes()) {
            severities.add(type.getSeverity());
        }
        severities.add(HighlightSeverity.ERROR);
        severities.add(HighlightSeverity.WARNING);
        severities.add(HighlightSeverity.INFO);
        severities.add(HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING);
        for (HighlightSeverity severity : severities) {
            model.addElement(severity);
        }
    }

    public HighlightDisplayLevel getLevel() {
        HighlightSeverity severity = (HighlightSeverity)this.getComboBox().getSelectedItem();
        if (severity == null) {
            return HighlightDisplayLevel.WARNING;
        }
        return HighlightDisplayLevel.find((HighlightSeverity)severity);
    }

    public void setLevel(HighlightDisplayLevel level) {
        this.getComboBox().setSelectedItem(level.getSeverity());
    }

    private static class MyRenderer
    extends DefaultListCellRenderer {
        private MyRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof HighlightSeverity) {
                HighlightSeverity severity = (HighlightSeverity)value;
                this.setText(SingleInspectionProfilePanel.renderSeverity(severity));
                this.setIcon(HighlightDisplayLevel.find((HighlightSeverity)severity).getIcon());
            }
            return this;
        }
    }
}

