/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection;

import com.intellij.codeInsight.daemon.InspectionProfileConvertor;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingSettingsPerFile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profile.ApplicationProfileManager;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.ProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.SeverityProvider;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionProfileManager
extends ApplicationProfileManager
implements SeverityProvider,
ExportableApplicationComponent,
JDOMExternalizable {
    @NonNls
    private static final String PROFILE_NAME_TAG = "profile_name";
    private final InspectionToolRegistrar myRegistrar;
    private final SchemesManager<Profile, InspectionProfileImpl> mySchemesManager;
    private final AtomicBoolean myProfilesAreInitialized = new AtomicBoolean(false);
    private final SeverityRegistrar mySeverityRegistrar;
    @NonNls
    private static final String INSPECTION_DIR = "inspection";
    @NonNls
    private static final String FILE_SPEC = "$ROOT_CONFIG$/inspection";
    private final List<ProfileChangeAdapter> myProfileChangeAdapters = new ArrayList<ProfileChangeAdapter>();
    private final String myProfileType;
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.profile.DefaultProfileManager");
    private volatile boolean LOAD_PROFILES = !ApplicationManager.getApplication().isUnitTestMode();

    public static InspectionProfileManager getInstance() {
        return (InspectionProfileManager)ApplicationManager.getApplication().getComponent(InspectionProfileManager.class);
    }

    public InspectionProfileManager(InspectionToolRegistrar registrar, SchemesManagerFactory schemesManagerFactory) {
        this.myProfileType = "INSPECTION";
        this.myRegistrar = registrar;
        this.mySeverityRegistrar = new SeverityRegistrar();
        SchemeProcessor<InspectionProfileImpl> processor = new SchemeProcessor<InspectionProfileImpl>(){

            public InspectionProfileImpl readScheme(Document document) {
                InspectionProfileImpl profile = new InspectionProfileImpl(InspectionProfileManager.getProfileName(document), InspectionProfileManager.this.myRegistrar, (ProfileManager)InspectionProfileManager.this);
                profile.load(document.getRootElement());
                return profile;
            }

            public boolean shouldBeSaved(InspectionProfileImpl scheme) {
                return scheme.wasInitialized();
            }

            public Document writeScheme(InspectionProfileImpl scheme) throws WriteExternalException {
                return scheme.saveToDocument();
            }

            public void initScheme(InspectionProfileImpl scheme) {
            }

            public void onSchemeAdded(InspectionProfileImpl scheme) {
                InspectionProfileManager.updateProfileImpl((Profile)scheme);
                InspectionProfileManager.this.fireProfileChanged((Profile)scheme);
                InspectionProfileManager.this.onProfilesChanged();
            }

            public void onSchemeDeleted(InspectionProfileImpl scheme) {
                InspectionProfileManager.this.onProfilesChanged();
            }

            public void onCurrentSchemeChanged(Scheme oldCurrentScheme) {
                Profile current = (Profile)InspectionProfileManager.this.mySchemesManager.getCurrentScheme();
                if (current != null) {
                    InspectionProfileManager.this.fireProfileChanged((Profile)oldCurrentScheme, current, null);
                }
                InspectionProfileManager.this.onProfilesChanged();
            }
        };
        this.mySchemesManager = schemesManagerFactory.createSchemesManager(FILE_SPEC, (SchemeProcessor)processor, RoamingType.PER_USER);
    }

    private static InspectionProfileImpl createSampleProfile() {
        return new InspectionProfileImpl("Default");
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{InspectionProfileManager.getProfileDirectory()};
        if (fileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/profile/codeInspection/InspectionProfileManager.getExportFiles must not return null");
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = InspectionsBundle.message((String)"inspection.profiles.presentable.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/profile/codeInspection/InspectionProfileManager.getPresentableName must not return null");
        }
        return string;
    }

    public Collection<Profile> getProfiles() {
        this.initProfiles();
        return this.mySchemesManager.getAllSchemes();
    }

    public void forceInitProfiles(boolean flag) {
        this.LOAD_PROFILES = flag;
        this.myProfilesAreInitialized.set(false);
    }

    public void initProfiles() {
        if (this.myProfilesAreInitialized.getAndSet(true)) {
            return;
        }
        if (!this.LOAD_PROFILES) {
            return;
        }
        this.mySchemesManager.loadSchemes();
        List profiles = this.mySchemesManager.getAllSchemes();
        if (profiles.isEmpty()) {
            this.createDefaultProfile();
        } else {
            for (Profile profile : profiles) {
                this.addProfile(profile);
            }
        }
    }

    public void createDefaultProfile() {
        InspectionProfileImpl defaultProfile = (InspectionProfileImpl)this.createProfile();
        defaultProfile.setBaseProfile(InspectionProfileImpl.getDefaultProfile());
        this.addProfile((Profile)defaultProfile);
    }

    public Profile loadProfile(String path) throws IOException, JDOMException {
        File file = new File(path);
        if (file.exists()) {
            InspectionProfileImpl profile = new InspectionProfileImpl(InspectionProfileManager.getProfileName(file), this.myRegistrar, (ProfileManager)this);
            profile.load(JDOMUtil.loadDocument((File)file).getRootElement());
            return profile;
        }
        return this.getProfile(path, false);
    }

    private static String getProfileName(Document document) {
        String name = InspectionProfileManager.getRootElementAttribute(document, PROFILE_NAME_TAG);
        if (name != null) {
            return name;
        }
        return "unnamed";
    }

    private static String getProfileName(File file) {
        String name = InspectionProfileManager.getRootElementAttribute(file, PROFILE_NAME_TAG);
        if (name != null) {
            return name;
        }
        return FileUtil.getNameWithoutExtension((File)file);
    }

    private static String getRootElementAttribute(Document document, @NonNls String name) {
        Element root = document.getRootElement();
        return root.getAttributeValue(name);
    }

    @Nullable
    private static String getRootElementAttribute(File file, @NonNls String name) {
        try {
            Document doc = JDOMUtil.loadDocument((File)file);
            return InspectionProfileManager.getRootElementAttribute(doc, name);
        }
        catch (JDOMException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    public String getComponentName() {
        if ("InspectionProfileManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/profile/codeInspection/InspectionProfileManager.getComponentName must not return null");
        }
        return "InspectionProfileManager";
    }

    public void updateProfile(Profile profile) {
        this.mySchemesManager.addNewScheme((Scheme)profile, true);
        InspectionProfileManager.updateProfileImpl(profile);
    }

    private static void updateProfileImpl(Profile profile) {
        Project[] projects;
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            InspectionProjectProfileManager.getInstance(project).initProfileWrapper(profile);
        }
    }

    @Override
    public SeverityRegistrar getSeverityRegistrar() {
        return this.mySeverityRegistrar;
    }

    @Override
    public SeverityRegistrar getOwnSeverityRegistrar() {
        return this.mySeverityRegistrar;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.mySeverityRegistrar.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.mySeverityRegistrar.writeExternal(element);
    }

    public InspectionProfileConvertor getConverter() {
        return new InspectionProfileConvertor(this);
    }

    public Profile createProfile() {
        return InspectionProfileManager.createSampleProfile();
    }

    public String getProfileType() {
        return this.myProfileType;
    }

    public void addProfileChangeListener(ProfileChangeAdapter listener) {
        this.myProfileChangeAdapters.add(listener);
    }

    public void addProfileChangeListener(ProfileChangeAdapter listener, Disposable parentDisposable) {
        ContainerUtil.add((Object)listener, this.myProfileChangeAdapters, (Disposable)parentDisposable);
    }

    public void removeProfileChangeListener(ProfileChangeAdapter listener) {
        this.myProfileChangeAdapters.remove(listener);
    }

    public void fireProfileChanged(Profile profile) {
        for (ProfileChangeAdapter adapter : this.myProfileChangeAdapters) {
            adapter.profileChanged(profile);
        }
    }

    public void fireProfileChanged(Profile oldProfile, Profile profile, NamedScope scope) {
        for (ProfileChangeAdapter adapter : this.myProfileChangeAdapters) {
            adapter.profileActivated(oldProfile, profile);
        }
    }

    public void setRootProfile(String rootProfile) {
        Profile current = (Profile)this.mySchemesManager.getCurrentScheme();
        if (current != null && !Comparing.strEqual((String)rootProfile, (String)current.getName())) {
            this.fireProfileChanged(current, this.getProfile(rootProfile), null);
        }
        this.mySchemesManager.setCurrentSchemeName(rootProfile);
    }

    public Profile getProfile(@NotNull String name, boolean returnRootProfileIfNamedIsAbsent) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/profile/codeInspection/InspectionProfileManager.getProfile must not be null");
        }
        Profile found = (Profile)this.mySchemesManager.findSchemeByName(name);
        if (found != null) {
            return found;
        }
        if (returnRootProfileIfNamedIsAbsent) {
            return this.getRootProfile();
        }
        return null;
    }

    public Profile getRootProfile() {
        Profile current = (Profile)this.mySchemesManager.getCurrentScheme();
        if (current != null) {
            return current;
        }
        Collection<Profile> profiles = this.getProfiles();
        if (profiles.isEmpty()) {
            return InspectionProfileManager.createSampleProfile();
        }
        return profiles.iterator().next();
    }

    public void deleteProfile(String profile) {
        Profile found = (Profile)this.mySchemesManager.findSchemeByName(profile);
        if (found != null) {
            this.mySchemesManager.removeScheme((Scheme)found);
        }
    }

    public void addProfile(Profile profile) {
        this.mySchemesManager.addNewScheme((Scheme)profile, true);
    }

    @Nullable
    public static File getProfileDirectory() {
        String directoryPath = PathManager.getConfigPath() + File.separator + INSPECTION_DIR;
        File directory = new File(directoryPath);
        if (!directory.exists() && !directory.mkdir()) {
            return null;
        }
        return directory;
    }

    public String[] getAvailableProfileNames() {
        Collection names = this.mySchemesManager.getAllSchemeNames();
        return ArrayUtil.toStringArray((Collection)names);
    }

    public Profile getProfile(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/profile/codeInspection/InspectionProfileManager.getProfile must not be null");
        }
        return this.getProfile(name, true);
    }

    public SchemesManager<Profile, InspectionProfileImpl> getSchemesManager() {
        return this.mySchemesManager;
    }

    public void onProfilesChanged() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            HighlightingSettingsPerFile.getInstance(project).cleanProfileSettings();
            InspectionProjectProfileManager.getInstance(project).updateStatusBar();
        }
    }
}

