/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.tree.events.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.tree.events.ChangeInfo;
import com.intellij.pom.tree.events.ReplaceChangeInfo;
import com.intellij.pom.tree.events.TreeChange;
import com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import com.intellij.pom.tree.events.impl.ReplaceChangeInfoImpl;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TreeChangeImpl
implements TreeChange {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.events.impl.TreeChangeImpl");
    private final Map<ASTNode, ChangeInfo> myChanges = new THashMap();
    private final List<Pair<ASTNode, Integer>> myOffsets = new ArrayList<Pair<ASTNode, Integer>>();
    private final ASTNode myParent;

    public TreeChangeImpl(ASTNode parent) {
        this.myParent = parent;
    }

    public void addChange(ASTNode child, ChangeInfo changeInfo) {
        LOG.assertTrue(child.getTreeParent() == this.myParent);
        ChangeInfo current = this.myChanges.get(child);
        if (current != null && changeInfo.getChangeType() == 3) {
            return;
        }
        if (changeInfo.getChangeType() == 2) {
            ReplaceChangeInfoImpl replaceChangeInfo = (ReplaceChangeInfoImpl)changeInfo;
            ASTNode replaced = replaceChangeInfo.getReplaced();
            ChangeInfo replacedInfo = this.myChanges.get(replaced);
            if (replacedInfo == null) {
                this.addChangeInternal(child, changeInfo);
            } else {
                switch (replacedInfo.getChangeType()) {
                    case 2: {
                        replaceChangeInfo.setOldLength(replacedInfo.getOldLength());
                        replaceChangeInfo.setReplaced(((ReplaceChangeInfo)replacedInfo).getReplaced());
                        break;
                    }
                    case 0: {
                        changeInfo = ChangeInfoImpl.create((short)0, replaced);
                        this.removeChangeInternal(replaced);
                    }
                }
                this.addChangeInternal(child, changeInfo);
            }
            return;
        }
        if (current != null && current.getChangeType() == 1) {
            if (changeInfo.getChangeType() == 0) {
                if (!(child instanceof LeafElement)) {
                    changeInfo = ChangeInfoImpl.create((short)3, child);
                    ((ChangeInfoImpl)changeInfo).setOldLength(current.getOldLength());
                    this.myChanges.put(child, changeInfo);
                } else {
                    this.removeChangeInternal(child);
                }
            }
            return;
        }
        if (current != null && current.getChangeType() == 0) {
            if (changeInfo.getChangeType() == 1) {
                this.removeChangeInternal(child);
            }
            return;
        }
        if (changeInfo.getChangeType() == 1) {
            if (child instanceof LeafElement) {
                CharSequence charTabIndex = child.getChars();
                if (this.checkLeaf(child.getTreeNext(), charTabIndex) || this.checkLeaf(child.getTreePrev(), charTabIndex)) {
                    return;
                }
            }
            this.addChangeInternal(child, changeInfo);
            if (current != null) {
                ((ChangeInfoImpl)changeInfo).setOldLength(current.getOldLength());
            }
            return;
        }
        if (current == null) {
            this.addChangeInternal(child, changeInfo);
        }
    }

    private void addChangeInternal(ASTNode child, ChangeInfo info) {
        if (!this.myChanges.containsKey(child)) {
            int nodeOffset = this.getNodeOffset(child);
            this.addChangeAtOffset(child, nodeOffset);
        }
        this.myChanges.put(child, info);
    }

    private void addChangeAtOffset(ASTNode child, int nodeOffset) {
        int index = 0;
        for (Pair<ASTNode, Integer> pair : this.myOffsets) {
            if (child == pair.getFirst()) {
                return;
            }
            if (nodeOffset < (Integer)pair.getSecond() || nodeOffset == (Integer)pair.getSecond() && TreeChangeImpl.isAfter((ASTNode)pair.getFirst(), child)) {
                this.myOffsets.add(index, (Pair<ASTNode, Integer>)new Pair((Object)child, (Object)nodeOffset));
                return;
            }
            ++index;
        }
        this.myOffsets.add((Pair<ASTNode, Integer>)new Pair((Object)child, (Object)nodeOffset));
    }

    private static boolean isAfter(ASTNode what, ASTNode afterWhat) {
        ASTNode current = afterWhat.getTreeNext();
        while (current != null) {
            if (current == what) {
                return true;
            }
            if ((current = current.getTreeNext()) == null || current.getTextLength() == 0) continue;
            break;
        }
        return false;
    }

    private void removeChangeInternal(ASTNode child) {
        this.myChanges.remove(child);
        int n = this.myOffsets.size();
        for (int i = 0; i < n; ++i) {
            if (child != this.myOffsets.get(i).getFirst()) continue;
            this.myOffsets.remove(i);
            break;
        }
    }

    private boolean checkLeaf(ASTNode treeNext, CharSequence charTabIndex) {
        if (!(treeNext instanceof LeafElement)) {
            return false;
        }
        ChangeInfo right = this.myChanges.get(treeNext);
        if (right != null && right.getChangeType() == 0 && charTabIndex == treeNext.getChars()) {
            this.removeChangeInternal(treeNext);
            return true;
        }
        return false;
    }

    public TreeElement[] getAffectedChildren() {
        TreeElement[] treeElements = new TreeElement[this.myChanges.size()];
        int index = 0;
        for (Pair<ASTNode, Integer> pair : this.myOffsets) {
            treeElements[index++] = (TreeElement)pair.getFirst();
        }
        return treeElements;
    }

    public ChangeInfo getChangeByChild(ASTNode child) {
        return this.myChanges.get(child);
    }

    public int getChildOffsetInNewTree(ASTNode child) {
        return this.myParent.getStartOffset() + this.getNewOffset(child);
    }

    public void composite(TreeChange treeChange) {
        TreeChangeImpl change = (TreeChangeImpl)treeChange;
        Set<Map.Entry<ASTNode, ChangeInfo>> entries = change.myChanges.entrySet();
        for (Map.Entry<ASTNode, ChangeInfo> entry : entries) {
            this.addChange(entry.getKey(), entry.getValue());
        }
    }

    public boolean isEmpty() {
        return false;
    }

    public void removeChange(ASTNode beforeEqualDepth) {
        this.removeChangeInternal(beforeEqualDepth);
    }

    public void add(TreeChange value) {
        TreeChangeImpl impl = (TreeChangeImpl)value;
        LOG.assertTrue(impl.myParent == this.myParent);
        for (Pair<ASTNode, Integer> pair : impl.myOffsets) {
            ASTNode replaced;
            ASTNode child = (ASTNode)pair.getFirst();
            ChangeInfo change = impl.getChangeByChild(child);
            if (change.getChangeType() == 1) {
                ChangeInfo oldChange = this.getChangeByChild(child);
                if (oldChange != null) {
                    switch (oldChange.getChangeType()) {
                        case 0: {
                            this.removeChangeInternal(child);
                            break;
                        }
                        case 2: {
                            replaced = ((ReplaceChangeInfo)oldChange).getReplaced();
                            this.removeChangeInternal(child);
                            this.myChanges.put(replaced, ChangeInfoImpl.create((short)1, replaced));
                            this.addChangeAtOffset(replaced, this.getOldOffset((Integer)pair.getSecond()));
                            break;
                        }
                        case 3: {
                            ((ChangeInfoImpl)change).setOldLength(oldChange.getOldLength());
                            this.myChanges.put(child, change);
                        }
                    }
                    continue;
                }
                this.myChanges.put(child, change);
                this.addChangeAtOffset(child, this.getOldOffset((Integer)pair.getSecond()));
                continue;
            }
            if (change.getChangeType() == 2) {
                ReplaceChangeInfo replaceChangeInfo = (ReplaceChangeInfo)change;
                replaced = replaceChangeInfo.getReplaced();
                ChangeInfo oldChange = this.getChangeByChild(replaced);
                if (oldChange != null) {
                    switch (oldChange.getChangeType()) {
                        case 0: {
                            change = ChangeInfoImpl.create((short)0, child);
                            break;
                        }
                        case 3: {
                            ((ChangeInfoImpl)change).setOldLength(oldChange.getOldLength());
                            break;
                        }
                        case 2: {
                            ASTNode oldReplaced = ((ReplaceChangeInfo)oldChange).getReplaced();
                            change = ChangeInfoImpl.create((short)2, child);
                            ((ReplaceChangeInfoImpl)change).setReplaced(oldReplaced);
                        }
                    }
                    this.removeChangeInternal(replaced);
                }
                this.addChange(child, change);
                continue;
            }
            this.addChange(child, change);
        }
    }

    public int getOldLength() {
        int oldLength = ((TreeElement)this.myParent).getNotCachedLength();
        for (Map.Entry<ASTNode, ChangeInfo> entry : this.myChanges.entrySet()) {
            ASTNode key = entry.getKey();
            ChangeInfo change = entry.getValue();
            int length = ((TreeElement)key).getNotCachedLength();
            switch (change.getChangeType()) {
                case 0: {
                    oldLength -= length;
                    break;
                }
                case 1: {
                    oldLength += length;
                    break;
                }
                case 2: 
                case 3: {
                    oldLength += change.getOldLength() - length;
                }
            }
        }
        return oldLength;
    }

    private static int getNewLength(ChangeInfo change, ASTNode node) {
        if (change.getChangeType() == 1) {
            return 0;
        }
        return node.getTextLength();
    }

    private int getNodeOffset(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this.myParent);
        int oldOffsetInParent = 0;
        ASTNode lastChangedElementBeforeChild = null;
        for (ASTNode current = this.myParent.getFirstChildNode(); current != child; current = current.getTreeNext()) {
            if (!this.myChanges.containsKey(current)) {
                oldOffsetInParent += current.getTextLength();
            }
            if (!this.myChanges.containsKey(child)) continue;
            lastChangedElementBeforeChild = current;
        }
        for (Pair<ASTNode, Integer> offset : this.myOffsets) {
            ASTNode changedNode;
            if ((Integer)offset.getSecond() > oldOffsetInParent || (changedNode = (ASTNode)offset.getFirst()) == lastChangedElementBeforeChild) break;
            ChangeInfo change = this.getChangeByChild(changedNode);
            oldOffsetInParent += change.getOldLength();
        }
        return oldOffsetInParent;
    }

    private int getOldOffset(int offset) {
        for (Pair<ASTNode, Integer> pair : this.myOffsets) {
            if ((Integer)pair.getSecond() > offset) break;
            ASTNode changedNode = (ASTNode)pair.getFirst();
            ChangeInfo change = this.getChangeByChild(changedNode);
            offset += change.getOldLength() - TreeChangeImpl.getNewLength(change, changedNode);
        }
        return offset;
    }

    private int getNewOffset(ASTNode node) {
        ASTNode current = this.myParent.getFirstChildNode();
        Iterator<Pair<ASTNode, Integer>> i = this.myOffsets.iterator();
        Pair<ASTNode, Integer> currentChange = i.hasNext() ? i.next() : null;
        int currentOffsetInNewTree = 0;
        int currentOldOffset = 0;
        while (current != null) {
            boolean counted = false;
            while (currentChange != null && currentOldOffset == (Integer)currentChange.getSecond()) {
                if (currentChange.getFirst() == node) {
                    return currentOffsetInNewTree;
                }
                if (current == currentChange.getFirst()) {
                    int textLength = current.getTextLength();
                    counted = true;
                    current = current.getTreeNext();
                    currentOffsetInNewTree += textLength;
                }
                ChangeInfo changeInfo = this.myChanges.get(currentChange.getFirst());
                currentOldOffset += changeInfo.getOldLength();
                currentChange = i.hasNext() ? i.next() : null;
            }
            if (current == null) break;
            if (counted) continue;
            int textLength = current.getTextLength();
            currentOldOffset += textLength;
            current = current.getTreeNext();
            currentOffsetInNewTree += textLength;
        }
        return currentOffsetInNewTree;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Iterator<Pair<ASTNode, Integer>> iterator = this.myOffsets.iterator();
        while (iterator.hasNext()) {
            Pair<ASTNode, Integer> pair = iterator.next();
            ASTNode node = (ASTNode)pair.getFirst();
            buffer.append("(");
            buffer.append(node.getElementType().toString());
            buffer.append(" at ").append(pair.getSecond()).append(", ");
            buffer.append(this.getChangeByChild(node).toString());
            buffer.append(")");
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }
}

