/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.platform.NewDirectoryProjectDialog;
import com.intellij.platform.PlatformProjectOpenProcessor;
import java.io.File;
import javax.swing.Icon;

public class NewDirectoryProjectAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        int rc;
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        NewDirectoryProjectDialog dlg = new NewDirectoryProjectDialog(project);
        dlg.show();
        if (dlg.getExitCode() != 0) {
            return;
        }
        DirectoryProjectGenerator generator = dlg.getProjectGenerator();
        final File location = new File(dlg.getNewProjectLocation());
        if (!location.exists() && !location.mkdirs()) {
            Messages.showErrorDialog((Project)project, (String)("Cannot create directory '" + location + "'"), (String)"Create Project");
            return;
        }
        VirtualFile baseDir = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(location);
            }
        });
        baseDir.refresh(false, true);
        if (baseDir.getChildren().length > 0 && (rc = Messages.showYesNoDialog((Project)project, (String)("The directory '" + location + "' is not empty. Would you like to create a project from existing sources instead?"), (String)"Create New Project", (Icon)Messages.getQuestionIcon())) == 0) {
            PlatformProjectOpenProcessor.getInstance().doOpenProject(baseDir, null, false);
            return;
        }
        Object settings = null;
        if (generator != null) {
            try {
                settings = generator.showGenerationSettings(baseDir);
            }
            catch (ProcessCanceledException e1) {
                return;
            }
        }
        GeneralSettings.getInstance().setLastProjectLocation(location.getParent());
        Project newProject = PlatformProjectOpenProcessor.getInstance().doOpenProject(baseDir, null, false);
        if (generator != null && newProject != null) {
            generator.generateProject(newProject, baseDir, settings);
        }
    }
}

