/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.ui;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.TreeNodePresentation;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleElementPresentation
extends TreeNodePresentation {
    private final ModulePointer myModulePointer;
    private final ArtifactEditorContext myContext;

    public ModuleElementPresentation(@Nullable ModulePointer modulePointer, @NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/ui/ModuleElementPresentation.<init> must not be null");
        }
        this.myModulePointer = modulePointer;
        this.myContext = context;
    }

    public String getPresentableName() {
        return this.myModulePointer != null ? this.myModulePointer.getModuleName() : "<unknown>";
    }

    public boolean canNavigateToSource() {
        return this.findModule() != null;
    }

    public Object getSourceObject() {
        return this.findModule();
    }

    @Nullable
    private Module findModule() {
        return this.myModulePointer != null ? this.myModulePointer.getModule() : null;
    }

    public void navigateToSource() {
        Module module = this.findModule();
        if (module != null) {
            this.myContext.selectModule(module);
        }
    }

    public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
        String moduleName;
        if (presentationData == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/ui/ModuleElementPresentation.render must not be null");
        }
        Module module = this.findModule();
        if (module != null) {
            presentationData.setOpenIcon(module.getModuleType().getNodeIcon(true));
            presentationData.setClosedIcon(module.getModuleType().getNodeIcon(false));
        }
        if (module != null) {
            String newName;
            moduleName = module.getName();
            ModifiableModuleModel moduleModel = this.myContext.getModifiableModuleModel();
            if (moduleModel != null && (newName = moduleModel.getNewName(module)) != null) {
                moduleName = newName;
            }
        } else {
            moduleName = this.myModulePointer != null ? this.myModulePointer.getModuleName() : "<unknown>";
        }
        presentationData.addText(CompilerBundle.message((String)"node.text.0.compile.output", (Object[])new Object[]{moduleName}), module != null ? mainAttributes : SimpleTextAttributes.ERROR_ATTRIBUTES);
    }

    public int getWeight() {
        return 20;
    }
}

