/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.CompositePackagingElementType;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.ArchiveElementType;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.impl.elements.ArtifactRootElementImpl;
import com.intellij.packaging.impl.elements.CompositeElementWithManifest;
import com.intellij.packaging.impl.elements.DirectoryCopyElementType;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.DirectoryElementType;
import com.intellij.packaging.impl.elements.DirectoryPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyElementType;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.impl.elements.LibraryElementType;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.packaging.impl.elements.ModuleOutputElementType;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagingElementFactoryImpl
extends PackagingElementFactory {
    public static final PackagingElementType<DirectoryPackagingElement> DIRECTORY_ELEMENT_TYPE = new DirectoryElementType();
    public static final PackagingElementType<ArchivePackagingElement> ARCHIVE_ELEMENT_TYPE = new ArchiveElementType();
    public static final PackagingElementType<FileCopyPackagingElement> FILE_COPY_ELEMENT_TYPE = new FileCopyElementType();
    public static final PackagingElementType<DirectoryCopyPackagingElement> DIRECTORY_COPY_ELEMENT_TYPE = new DirectoryCopyElementType();
    public static final PackagingElementType<ArtifactRootElement<?>> ARTIFACT_ROOT_ELEMENT_TYPE = new ArtifactRootElementType();
    private static final PackagingElementType[] STANDARD_TYPES = new PackagingElementType[]{DIRECTORY_ELEMENT_TYPE, ARCHIVE_ELEMENT_TYPE, LibraryElementType.LIBRARY_ELEMENT_TYPE, ModuleOutputElementType.MODULE_OUTPUT_ELEMENT_TYPE, ArtifactElementType.ARTIFACT_ELEMENT_TYPE, FILE_COPY_ELEMENT_TYPE, DIRECTORY_COPY_ELEMENT_TYPE};

    @NotNull
    public PackagingElementType<?>[] getNonCompositeElementTypes() {
        ArrayList<PackagingElementType> elementTypes = new ArrayList<PackagingElementType>();
        for (PackagingElementType elementType : this.getAllElementTypes()) {
            if (elementType instanceof CompositePackagingElementType) continue;
            elementTypes.add(elementType);
        }
        PackagingElementType[] packagingElementTypeArray = elementTypes.toArray(new PackagingElementType[elementTypes.size()]);
        if (packagingElementTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.getNonCompositeElementTypes must not return null");
        }
        return packagingElementTypeArray;
    }

    @NotNull
    public ComplexPackagingElementType<?>[] getComplexElementTypes() {
        ArrayList<ComplexPackagingElementType> types = new ArrayList<ComplexPackagingElementType>();
        for (PackagingElementType type : this.getAllElementTypes()) {
            if (!(type instanceof ComplexPackagingElementType)) continue;
            types.add((ComplexPackagingElementType)type);
        }
        ComplexPackagingElementType[] complexPackagingElementTypeArray = types.toArray(new ComplexPackagingElementType[types.size()]);
        if (complexPackagingElementTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.getComplexElementTypes must not return null");
        }
        return complexPackagingElementTypeArray;
    }

    @NotNull
    public CompositePackagingElementType<?>[] getCompositeElementTypes() {
        ArrayList<CompositePackagingElementType> elementTypes = new ArrayList<CompositePackagingElementType>();
        for (PackagingElementType elementType : this.getAllElementTypes()) {
            if (!(elementType instanceof CompositePackagingElementType)) continue;
            elementTypes.add((CompositePackagingElementType)elementType);
        }
        CompositePackagingElementType[] compositePackagingElementTypeArray = elementTypes.toArray(new CompositePackagingElementType[elementTypes.size()]);
        if (compositePackagingElementTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.getCompositeElementTypes must not return null");
        }
        return compositePackagingElementTypeArray;
    }

    public PackagingElementType<?> findElementType(String id) {
        for (PackagingElementType elementType : this.getAllElementTypes()) {
            if (!elementType.getId().equals(id)) continue;
            return elementType;
        }
        if (id.equals(ARTIFACT_ROOT_ELEMENT_TYPE.getId())) {
            return ARTIFACT_ROOT_ELEMENT_TYPE;
        }
        throw new AssertionError((Object)(id + " not registered"));
    }

    @NotNull
    public PackagingElementType[] getAllElementTypes() {
        Object[] types = (PackagingElementType[])Extensions.getExtensions((ExtensionPointName)PackagingElementType.EP_NAME);
        PackagingElementType[] packagingElementTypeArray = (PackagingElementType[])ArrayUtil.mergeArrays((Object[])STANDARD_TYPES, (Object[])types, PackagingElementType.class);
        if (packagingElementTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.getAllElementTypes must not return null");
        }
        return packagingElementTypeArray;
    }

    @NotNull
    public PackagingElement<?> createArtifactElement(@NotNull Artifact artifact, @NotNull Project project) {
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createArtifactElement must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createArtifactElement must not be null");
        }
        ArtifactPackagingElement artifactPackagingElement = new ArtifactPackagingElement(project, ArtifactPointerManager.getInstance((Project)project).createPointer(artifact));
        if (artifactPackagingElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createArtifactElement must not return null");
        }
        return artifactPackagingElement;
    }

    @NotNull
    public DirectoryPackagingElement createDirectory(@NotNull @NonNls String directoryName) {
        if (directoryName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createDirectory must not be null");
        }
        DirectoryPackagingElement directoryPackagingElement = new DirectoryPackagingElement(directoryName);
        if (directoryPackagingElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createDirectory must not return null");
        }
        return directoryPackagingElement;
    }

    @NotNull
    public ArtifactRootElement<?> createArtifactRootElement() {
        ArtifactRootElementImpl artifactRootElementImpl = new ArtifactRootElementImpl();
        if (artifactRootElementImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createArtifactRootElement must not return null");
        }
        return artifactRootElementImpl;
    }

    @NotNull
    public CompositePackagingElement<?> getOrCreateDirectory(@NotNull CompositePackagingElement<?> parent, @NotNull String relativePath) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.getOrCreateDirectory must not be null");
        }
        if (relativePath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.getOrCreateDirectory must not be null");
        }
        CompositePackagingElement<?> compositePackagingElement = this.getOrCreateDirectoryOrArchive(parent, relativePath, true);
        if (compositePackagingElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.getOrCreateDirectory must not return null");
        }
        return compositePackagingElement;
    }

    @NotNull
    public CompositePackagingElement<?> getOrCreateArchive(@NotNull CompositePackagingElement<?> parent, @NotNull String relativePath) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.getOrCreateArchive must not be null");
        }
        if (relativePath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.getOrCreateArchive must not be null");
        }
        CompositePackagingElement<?> compositePackagingElement = this.getOrCreateDirectoryOrArchive(parent, relativePath, false);
        if (compositePackagingElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.getOrCreateArchive must not return null");
        }
        return compositePackagingElement;
    }

    public void addFileCopy(@NotNull CompositePackagingElement<?> root, @NotNull String outputDirectoryPath, @NotNull String sourceFilePath) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.addFileCopy must not be null");
        }
        if (outputDirectoryPath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.addFileCopy must not be null");
        }
        if (sourceFilePath == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.addFileCopy must not be null");
        }
        this.addFileCopy(root, outputDirectoryPath, sourceFilePath, null);
    }

    public void addFileCopy(@NotNull CompositePackagingElement<?> root, @NotNull String outputDirectoryPath, @NotNull String sourceFilePath, @Nullable String outputFileName) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.addFileCopy must not be null");
        }
        if (outputDirectoryPath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.addFileCopy must not be null");
        }
        if (sourceFilePath == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.addFileCopy must not be null");
        }
        String fileName = PathUtil.getFileName((String)sourceFilePath);
        if (outputFileName != null && outputFileName.equals(fileName)) {
            outputFileName = null;
        }
        this.getOrCreateDirectory(root, outputDirectoryPath).addOrFindChild((PackagingElement)new FileCopyPackagingElement(sourceFilePath, outputFileName));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private CompositePackagingElement<?> getOrCreateDirectoryOrArchive(@NotNull CompositePackagingElement<?> root, @NotNull @NonNls String path, boolean directory) {
        CompositePackagingElement<?> last;
        CompositePackagingElement compositePackagingElement;
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.getOrCreateDirectoryOrArchive must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.getOrCreateDirectoryOrArchive must not be null");
        }
        if ((path = StringUtil.trimStart((String)StringUtil.trimEnd((String)path, (String)"/"), (String)"/")).length() == 0) {
            compositePackagingElement = root;
            if (compositePackagingElement == null) throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.getOrCreateDirectoryOrArchive must not return null");
            return compositePackagingElement;
        }
        int index = path.lastIndexOf(47);
        String lastName = path.substring(index + 1);
        String parentPath = index != -1 ? path.substring(0, index) : "";
        CompositePackagingElement<?> parent = this.getOrCreateDirectoryOrArchive(root, parentPath, true);
        compositePackagingElement = (CompositePackagingElement)parent.addOrFindChild(last = directory ? this.createDirectory(lastName) : this.createArchive(lastName));
        if (compositePackagingElement != null) return compositePackagingElement;
        throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.getOrCreateDirectoryOrArchive must not return null");
    }

    @NotNull
    public PackagingElement<?> createModuleOutput(@NotNull String moduleName, @NotNull Project project) {
        if (moduleName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createModuleOutput must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createModuleOutput must not be null");
        }
        ModulePointer pointer = ModulePointerManager.getInstance((Project)project).create(moduleName);
        ModuleOutputPackagingElement moduleOutputPackagingElement = new ModuleOutputPackagingElement(project, pointer);
        if (moduleOutputPackagingElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createModuleOutput must not return null");
        }
        return moduleOutputPackagingElement;
    }

    @NotNull
    public PackagingElement<?> createModuleOutput(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createModuleOutput must not be null");
        }
        ModulePointer modulePointer = ModulePointerManager.getInstance((Project)module.getProject()).create(module);
        ModuleOutputPackagingElement moduleOutputPackagingElement = new ModuleOutputPackagingElement(module.getProject(), modulePointer);
        if (moduleOutputPackagingElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createModuleOutput must not return null");
        }
        return moduleOutputPackagingElement;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<? extends PackagingElement<?>> createLibraryElements(@NotNull Library library) {
        Module module;
        List<PackagingElement<?>> list;
        if (library == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createLibraryElements must not be null");
        }
        LibraryTable table = library.getTable();
        String libraryName = library.getName();
        if (table != null) {
            list = Collections.singletonList(this.createLibraryFiles(libraryName, table.getTableLevel(), null));
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createLibraryElements must not return null");
            return list;
        }
        if (libraryName != null && (module = ((LibraryImpl)library).getModule()) != null) {
            list = Collections.singletonList(this.createLibraryFiles(libraryName, "module", module.getName()));
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createLibraryElements must not return null");
            return list;
        }
        ArrayList elements = new ArrayList();
        for (VirtualFile file : library.getFiles(OrderRootType.CLASSES)) {
            String path = FileUtil.toSystemIndependentName((String)PathUtil.getLocalPath((VirtualFile)file));
            elements.add(file.isDirectory() && file.isInLocalFileSystem() ? new DirectoryCopyPackagingElement(path) : new FileCopyPackagingElement(path));
        }
        list = elements;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createLibraryElements must not return null");
    }

    @NotNull
    public PackagingElement<?> createArtifactElement(@NotNull ArtifactPointer artifactPointer, @NotNull Project project) {
        if (artifactPointer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createArtifactElement must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createArtifactElement must not be null");
        }
        ArtifactPackagingElement artifactPackagingElement = new ArtifactPackagingElement(project, artifactPointer);
        if (artifactPackagingElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createArtifactElement must not return null");
        }
        return artifactPackagingElement;
    }

    @NotNull
    public PackagingElement<?> createLibraryFiles(@NotNull String libraryName, @NotNull String level, String moduleName) {
        if (libraryName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createLibraryFiles must not be null");
        }
        if (level == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createLibraryFiles must not be null");
        }
        LibraryPackagingElement libraryPackagingElement = new LibraryPackagingElement(level, libraryName, moduleName);
        if (libraryPackagingElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createLibraryFiles must not return null");
        }
        return libraryPackagingElement;
    }

    @NotNull
    public CompositePackagingElement<?> createArchive(@NotNull @NonNls String archiveFileName) {
        if (archiveFileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createArchive must not be null");
        }
        ArchivePackagingElement archivePackagingElement = new ArchivePackagingElement(archiveFileName);
        if (archivePackagingElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createArchive must not return null");
        }
        return archivePackagingElement;
    }

    @Nullable
    private static PackagingElement<?> findArchiveOrDirectoryByName(@NotNull CompositePackagingElement<?> parent, @NotNull String name) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.findArchiveOrDirectoryByName must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.findArchiveOrDirectoryByName must not be null");
        }
        for (PackagingElement element : parent.getChildren()) {
            if ((!(element instanceof ArchivePackagingElement) || !((ArchivePackagingElement)element).getArchiveFileName().equals(name)) && (!(element instanceof DirectoryPackagingElement) || !((DirectoryPackagingElement)element).getDirectoryName().equals(name))) continue;
            return element;
        }
        return null;
    }

    @NotNull
    public static String suggestFileName(@NotNull CompositePackagingElement<?> parent, @NonNls @NotNull String prefix, @NonNls @NotNull String suffix) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.suggestFileName must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.suggestFileName must not be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.suggestFileName must not be null");
        }
        String name = prefix + suffix;
        int i = 2;
        while (PackagingElementFactoryImpl.findArchiveOrDirectoryByName(parent, name) != null) {
            name = prefix + i++ + suffix;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.suggestFileName must not return null");
        }
        return string;
    }

    @NotNull
    public PackagingElement<?> createDirectoryCopyWithParentDirectories(@NotNull String filePath, @NotNull String relativeOutputPath) {
        if (filePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createDirectoryCopyWithParentDirectories must not be null");
        }
        if (relativeOutputPath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createDirectoryCopyWithParentDirectories must not be null");
        }
        PackagingElement<?> packagingElement = this.createParentDirectories(relativeOutputPath, new DirectoryCopyPackagingElement(filePath));
        if (packagingElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createDirectoryCopyWithParentDirectories must not return null");
        }
        return packagingElement;
    }

    @NotNull
    public PackagingElement<?> createFileCopyWithParentDirectories(@NotNull String filePath, @NotNull String relativeOutputPath) {
        if (filePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createFileCopyWithParentDirectories must not be null");
        }
        if (relativeOutputPath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createFileCopyWithParentDirectories must not be null");
        }
        PackagingElement<?> packagingElement = this.createFileCopyWithParentDirectories(filePath, relativeOutputPath, null);
        if (packagingElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createFileCopyWithParentDirectories must not return null");
        }
        return packagingElement;
    }

    @NotNull
    public PackagingElement<?> createFileCopyWithParentDirectories(@NotNull String filePath, @NotNull String relativeOutputPath, @Nullable String outputFileName) {
        if (filePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createFileCopyWithParentDirectories must not be null");
        }
        if (relativeOutputPath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createFileCopyWithParentDirectories must not be null");
        }
        FileCopyPackagingElement file = new FileCopyPackagingElement(filePath, outputFileName);
        PackagingElement<?> packagingElement = this.createParentDirectories(relativeOutputPath, file);
        if (packagingElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createFileCopyWithParentDirectories must not return null");
        }
        return packagingElement;
    }

    @NotNull
    public PackagingElement<?> createParentDirectories(@NotNull String relativeOutputPath, @NotNull PackagingElement<?> element) {
        if (relativeOutputPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createParentDirectories must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createParentDirectories must not be null");
        }
        PackagingElement<?> packagingElement = this.createParentDirectories(relativeOutputPath, Collections.singletonList(element)).get(0);
        if (packagingElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createParentDirectories must not return null");
        }
        return packagingElement;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<? extends PackagingElement<?>> createParentDirectories(@NotNull String relativeOutputPath, @NotNull List<? extends PackagingElement<?>> elements) {
        List<Object> list;
        if (relativeOutputPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createParentDirectories must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createParentDirectories must not be null");
        }
        if ((relativeOutputPath = StringUtil.trimStart((String)relativeOutputPath, (String)"/")).length() == 0) {
            list = elements;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createParentDirectories must not return null");
            return list;
        }
        int slash = relativeOutputPath.indexOf(47);
        if (slash == -1) {
            slash = relativeOutputPath.length();
        }
        String rootName = relativeOutputPath.substring(0, slash);
        String pathTail = relativeOutputPath.substring(slash);
        DirectoryPackagingElement root = this.createDirectory(rootName);
        CompositePackagingElement<?> last = this.getOrCreateDirectory(root, pathTail);
        last.addOrFindChildren(elements);
        list = Collections.singletonList(root);
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createParentDirectories must not return null");
    }

    public static CompositePackagingElement<?> createDirectoryOrArchiveWithParents(@NotNull String path, boolean archive) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl.createDirectoryOrArchiveWithParents must not be null");
        }
        path = FileUtil.toSystemIndependentName((String)path);
        String parentPath = PathUtil.getParentPath((String)path);
        String fileName = PathUtil.getFileName((String)path);
        CompositeElementWithManifest element = archive ? new ArchivePackagingElement(fileName) : new DirectoryPackagingElement(fileName);
        return (CompositePackagingElement)PackagingElementFactoryImpl.getInstance().createParentDirectories(parentPath, (PackagingElement)element);
    }

    private static class ArtifactRootElementType
    extends PackagingElementType<ArtifactRootElement<?>> {
        protected ArtifactRootElementType() {
            super("root", "");
        }

        public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
            if (context == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl$ArtifactRootElementType.canCreate must not be null");
            }
            if (artifact == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl$ArtifactRootElementType.canCreate must not be null");
            }
            return false;
        }

        @NotNull
        public List<? extends ArtifactRootElement<?>> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
            if (context == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl$ArtifactRootElementType.chooseAndCreate must not be null");
            }
            if (artifact == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl$ArtifactRootElementType.chooseAndCreate must not be null");
            }
            if (parent == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl$ArtifactRootElementType.chooseAndCreate must not be null");
            }
            throw new UnsupportedOperationException("'create' not implemented in " + ((Object)((Object)this)).getClass().getName());
        }

        @NotNull
        public ArtifactRootElement<?> createEmpty(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/PackagingElementFactoryImpl$ArtifactRootElementType.createEmpty must not be null");
            }
            ArtifactRootElementImpl artifactRootElementImpl = new ArtifactRootElementImpl();
            if (artifactRootElementImpl == null) {
                throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/PackagingElementFactoryImpl$ArtifactRootElementType.createEmpty must not return null");
            }
            return artifactRootElementImpl;
        }
    }
}

