/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.IncrementalCompilerInstructionCreator;
import com.intellij.packaging.elements.PackagingFileFilter;
import com.intellij.packaging.impl.compiler.ArtifactsProcessingItemsBuilderContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IncrementalCompilerInstructionCreatorBase
implements IncrementalCompilerInstructionCreator {
    protected final ArtifactsProcessingItemsBuilderContext myContext;

    public IncrementalCompilerInstructionCreatorBase(ArtifactsProcessingItemsBuilderContext context) {
        this.myContext = context;
    }

    public void addDirectoryCopyInstructions(@NotNull VirtualFile directory) {
        if (directory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/compiler/IncrementalCompilerInstructionCreatorBase.addDirectoryCopyInstructions must not be null");
        }
        this.addDirectoryCopyInstructions(directory, null);
    }

    public void addDirectoryCopyInstructions(@NotNull VirtualFile directory, @Nullable PackagingFileFilter filter) {
        if (directory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/compiler/IncrementalCompilerInstructionCreatorBase.addDirectoryCopyInstructions must not be null");
        }
        VirtualFile[] children = directory.getChildren();
        if (children != null) {
            FileTypeManager fileTypeManager = FileTypeManager.getInstance();
            for (VirtualFile child : children) {
                if (fileTypeManager.isFileIgnored(child.getName()) || filter != null && !filter.accept(child, this.myContext.getCompileContext())) continue;
                if (!child.isDirectory()) {
                    this.addFileCopyInstruction(child, child.getName());
                    continue;
                }
                this.subFolder(child.getName()).addDirectoryCopyInstructions(child, filter);
            }
        }
    }

    public IncrementalCompilerInstructionCreator subFolderByRelativePath(@NotNull String relativeDirectoryPath) {
        if (relativeDirectoryPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/compiler/IncrementalCompilerInstructionCreatorBase.subFolderByRelativePath must not be null");
        }
        List folders = StringUtil.split((String)relativeDirectoryPath, (String)"/");
        IncrementalCompilerInstructionCreatorBase current = this;
        for (String folder : folders) {
            current = current.subFolder(folder);
        }
        return current;
    }
}

