/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@State(name="ArtifactsWorkspaceSettings", storages={@Storage(id="other", file="$WORKSPACE_FILE$")})
public class ArtifactsWorkspaceSettings
implements PersistentStateComponent<ArtifactsWorkspaceSettingsState> {
    private ArtifactsWorkspaceSettingsState myState = new ArtifactsWorkspaceSettingsState();
    private final Project myProject;

    public ArtifactsWorkspaceSettings(Project project) {
        this.myProject = project;
    }

    public static ArtifactsWorkspaceSettings getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/compiler/ArtifactsWorkspaceSettings.getInstance must not be null");
        }
        return (ArtifactsWorkspaceSettings)ServiceManager.getService((Project)project, ArtifactsWorkspaceSettings.class);
    }

    public List<Artifact> getArtifactsToBuild() {
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)this.myProject);
        for (String name : this.myState.myArtifactsToBuild) {
            ContainerUtil.addIfNotNull((Object)artifactManager.findArtifact(name), result);
        }
        return result;
    }

    public void setArtifactsToBuild(@NotNull Collection<? extends Artifact> artifacts) {
        if (artifacts == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/compiler/ArtifactsWorkspaceSettings.setArtifactsToBuild must not be null");
        }
        this.myState.myArtifactsToBuild.clear();
        for (Artifact artifact : artifacts) {
            this.myState.myArtifactsToBuild.add(artifact.getName());
        }
        Collections.sort(this.myState.myArtifactsToBuild);
    }

    public ArtifactsWorkspaceSettingsState getState() {
        return this.myState;
    }

    public void loadState(ArtifactsWorkspaceSettingsState state) {
        this.myState = state;
    }

    public static class ArtifactsWorkspaceSettingsState {
        @Tag(value="artifacts-to-build")
        @AbstractCollection(surroundWithTag=false, elementTag="artifact", elementValueAttribute="name")
        public List<String> myArtifactsToBuild = new ArrayList<String>();
    }
}

