/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.util.SmartList;
import com.intellij.util.StringBuilderSpinAllocator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagingElementPath {
    public static final PackagingElementPath EMPTY = new PackagingElementPath(null, null);
    private final PackagingElementPath myParentPath;
    private final PackagingElement<?> myLastElement;

    private PackagingElementPath(PackagingElementPath parentPath, PackagingElement<?> lastElement) {
        this.myParentPath = parentPath;
        this.myLastElement = lastElement;
    }

    public PackagingElementPath appendComplex(ComplexPackagingElement<?> element) {
        return new PackagingElementPath(this, (PackagingElement<?>)element);
    }

    public PackagingElementPath appendComposite(CompositePackagingElement<?> element) {
        return new PackagingElementPath(this, (PackagingElement<?>)element);
    }

    @Nullable
    public PackagingElementPath getParentPath() {
        return this.myParentPath;
    }

    public PackagingElement<?> getLastElement() {
        return this.myLastElement;
    }

    @NotNull
    public String getPathString() {
        String string = this.getPathString("/");
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/artifacts/PackagingElementPath.getPathString must not return null");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getPathString(String separator) {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        List<CompositePackagingElement<?>> parents = this.getParents();
        for (int i = parents.size() - 1; i >= 0; --i) {
            builder.append(parents.get(i).getName());
            if (i <= 0) continue;
            builder.append(separator);
        }
        String string = builder.toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/artifacts/PackagingElementPath.getPathString must not return null");
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    public List<CompositePackagingElement<?>> getParents() {
        SmartList result = new SmartList();
        PackagingElementPath path = this;
        while (path != EMPTY) {
            if (path.myLastElement instanceof CompositePackagingElement) {
                result.add((CompositePackagingElement)path.myLastElement);
            }
            path = path.myParentPath;
        }
        return result;
    }

    public List<PackagingElement<?>> getAllElements() {
        SmartList result = new SmartList();
        PackagingElementPath path = this;
        while (path != EMPTY) {
            result.add(path.myLastElement);
            path = path.myParentPath;
        }
        return result;
    }

    @Nullable
    public CompositePackagingElement<?> getLastParent() {
        PackagingElementPath path = this;
        while (path != EMPTY) {
            if (path.myLastElement instanceof CompositePackagingElement) {
                return (CompositePackagingElement)path.myLastElement;
            }
            path = path.myParentPath;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.myParentPath == null;
    }

    @Nullable
    public Artifact findLastArtifact(PackagingElementResolvingContext context) {
        PackagingElementPath path = this;
        while (path != EMPTY) {
            PackagingElement<?> element = path.myLastElement;
            if (element instanceof ArtifactPackagingElement) {
                return ((ArtifactPackagingElement)element).findArtifact(context);
            }
            path = path.myParentPath;
        }
        return null;
    }
}

