/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.packageDependencies.ui.DependencyNodeComparator;
import com.intellij.packageDependencies.ui.FileNode;
import com.intellij.packageDependencies.ui.GeneralGroupNode;
import com.intellij.packageDependencies.ui.LibraryNode;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.ModuleGroupNode;
import com.intellij.packageDependencies.ui.ModuleNode;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.PackageNode;
import com.intellij.packageDependencies.ui.RootNode;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.util.Icons;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeModelBuilder {
    private static final Key<Integer> FILE_COUNT = Key.create((String)"FILE_COUNT");
    private final ProjectFileIndex myFileIndex;
    private final PsiManager myPsiManager;
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.packageDependencies.ui.TreeModelBuilder");
    private final boolean myShowModuleGroups;
    private final boolean myShowModules;
    private final boolean myGroupByScopeType;
    private final boolean myFlattenPackages;
    private boolean myShowFiles;
    private final boolean myShowIndividualLibs;
    private final Marker myMarker;
    private final boolean myAddUnmarkedFiles;
    private final PackageDependenciesNode myRoot;
    private final Map<ScopeType, Map<Pair<Module, PsiPackage>, PackageNode>> myModulePackageNodes = new HashMap<ScopeType, Map<Pair<Module, PsiPackage>, PackageNode>>();
    private final Map<ScopeType, Map<Pair<OrderEntry, PsiPackage>, PackageNode>> myLibraryPackageNodes = new HashMap<ScopeType, Map<Pair<OrderEntry, PsiPackage>, PackageNode>>();
    private final Map<ScopeType, Map<Module, ModuleNode>> myModuleNodes = new HashMap<ScopeType, Map<Module, ModuleNode>>();
    private final Map<ScopeType, Map<String, ModuleGroupNode>> myModuleGroupNodes = new HashMap<ScopeType, Map<String, ModuleGroupNode>>();
    private final Map<ScopeType, Map<OrderEntry, LibraryNode>> myLibraryNodes = new HashMap<ScopeType, Map<OrderEntry, LibraryNode>>();
    private int myScannedFileCount = 0;
    private int myTotalFileCount = 0;
    private int myMarkedFileCount = 0;
    private GeneralGroupNode myAllLibsNode = null;
    private GeneralGroupNode mySourceRoot = null;
    private GeneralGroupNode myTestRoot = null;
    private GeneralGroupNode myLibsRoot = null;
    private static final Icon LIB_ICON_OPEN = IconLoader.getIcon((String)"/nodes/ppLibOpen.png");
    private static final Icon LIB_ICON_CLOSED = IconLoader.getIcon((String)"/nodes/ppLibClosed.png");
    private static final Icon TEST_ICON = IconLoader.getIcon((String)"/nodes/testSourceFolder.png");
    public static final String PRODUCTION_NAME = AnalysisScopeBundle.message((String)"package.dependencies.production.node.text", (Object[])new Object[0]);
    public static final String TEST_NAME = AnalysisScopeBundle.message((String)"package.dependencies.test.node.text", (Object[])new Object[0]);
    public static final String LIBRARY_NAME = AnalysisScopeBundle.message((String)"package.dependencies.library.node.text", (Object[])new Object[0]);

    public TreeModelBuilder(Project project, boolean showIndividualLibs, Marker marker, DependenciesPanel.DependencyPanelSettings settings) {
        this.myProject = project;
        this.myShowModules = settings.UI_SHOW_MODULES;
        this.myGroupByScopeType = settings.UI_GROUP_BY_SCOPE_TYPE;
        this.myFlattenPackages = settings.UI_FLATTEN_PACKAGES;
        this.myShowFiles = settings.UI_SHOW_FILES;
        this.myShowIndividualLibs = showIndividualLibs;
        this.myShowModuleGroups = settings.UI_SHOW_MODULE_GROUPS;
        this.myMarker = marker;
        this.myAddUnmarkedFiles = !settings.UI_FILTER_LEGALS;
        this.myRoot = new RootNode();
        this.myFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        this.myPsiManager = PsiManager.getInstance((Project)project);
        this.createMaps(ScopeType.LIB);
        this.createMaps(ScopeType.SOURCE);
        this.createMaps(ScopeType.TEST);
        if (this.myGroupByScopeType) {
            this.mySourceRoot = new GeneralGroupNode(PRODUCTION_NAME, Icons.PACKAGE_OPEN_ICON, Icons.PACKAGE_ICON);
            this.myTestRoot = new GeneralGroupNode(TEST_NAME, TEST_ICON, TEST_ICON);
            this.myLibsRoot = new GeneralGroupNode(LIBRARY_NAME, LIB_ICON_OPEN, LIB_ICON_CLOSED);
            this.myRoot.add(this.mySourceRoot);
            this.myRoot.add(this.myTestRoot);
            this.myRoot.add(this.myLibsRoot);
        }
    }

    private void createMaps(ScopeType scopeType) {
        this.myModulePackageNodes.put(scopeType, new HashMap());
        this.myLibraryPackageNodes.put(scopeType, (Map<Pair<OrderEntry, PsiPackage>, PackageNode>)new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<Pair<OrderEntry, PsiPackage>>(){

            public int computeHashCode(Pair<OrderEntry, PsiPackage> key) {
                return key.getSecond() == null ? 0 : ((PsiPackage)key.getSecond()).hashCode();
            }

            public boolean equals(Pair<OrderEntry, PsiPackage> o1, Pair<OrderEntry, PsiPackage> o2) {
                return Comparing.equal((Object)o1.getSecond(), (Object)o2.getSecond());
            }
        }));
        this.myModuleGroupNodes.put(scopeType, new HashMap());
        this.myModuleNodes.put(scopeType, new HashMap());
        this.myLibraryNodes.put(scopeType, new HashMap());
    }

    public static synchronized TreeModel createTreeModel(Project project, boolean showProgress, Set<PsiFile> files, Marker marker, DependenciesPanel.DependencyPanelSettings settings) {
        return new TreeModelBuilder(project, true, marker, settings).build(files, showProgress);
    }

    public static synchronized TreeModel createTreeModel(Project project, Marker marker, DependenciesPanel.DependencyPanelSettings settings) {
        return new TreeModelBuilder(project, true, marker, settings).build(project, false);
    }

    public static synchronized TreeModel createTreeModel(Project project, boolean showProgress, boolean showIndividualLibs, Marker marker) {
        return new TreeModelBuilder(project, showIndividualLibs, marker, new DependenciesPanel.DependencyPanelSettings()).build(project, showProgress);
    }

    private void countFiles(Project project) {
        Integer fileCount = (Integer)project.getUserData(FILE_COUNT);
        if (fileCount == null) {
            this.myFileIndex.iterateContent(new ContentIterator(){

                public boolean processFile(VirtualFile fileOrDir) {
                    if (!fileOrDir.isDirectory()) {
                        TreeModelBuilder.this.counting(fileOrDir);
                    }
                    return true;
                }
            });
            for (VirtualFile root : LibraryUtil.getLibraryRoots((Project)project)) {
                this.countFilesRecursively(root);
            }
            project.putUserData(FILE_COUNT, (Object)this.myTotalFileCount);
        } else {
            this.myTotalFileCount = fileCount;
        }
    }

    public static void clearCaches(Project project) {
        project.putUserData(FILE_COUNT, null);
    }

    public TreeModel build(Project project, boolean showProgress) {
        return this.build(project, showProgress, false);
    }

    public TreeModel build(final Project project, boolean showProgress, boolean sortByType) {
        Runnable buildingRunnable = new Runnable(){

            @Override
            public void run() {
                TreeModelBuilder.this.countFiles(project);
                final PsiManager psiManager = PsiManager.getInstance((Project)project);
                TreeModelBuilder.this.myFileIndex.iterateContent(new ContentIterator(){

                    public boolean processFile(VirtualFile fileOrDir) {
                        PsiFile psiFile;
                        if (!fileOrDir.isDirectory() && (psiFile = psiManager.findFile(fileOrDir)) != null) {
                            TreeModelBuilder.this.buildFileNode(psiFile);
                        }
                        return true;
                    }
                });
                for (VirtualFile root : LibraryUtil.getLibraryRoots((Project)project)) {
                    TreeModelBuilder.this.processFilesRecursively(root, psiManager);
                }
            }
        };
        if (showProgress) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(buildingRunnable, AnalysisScopeBundle.message((String)"package.dependencies.build.process.title", (Object[])new Object[0]), true, project);
        } else {
            buildingRunnable.run();
        }
        TreeUtil.sort((DefaultMutableTreeNode)this.myRoot, (Comparator)new DependencyNodeComparator(sortByType));
        return new TreeModel(this.myRoot, this.myTotalFileCount, this.myMarkedFileCount);
    }

    private void processFilesRecursively(VirtualFile file, PsiManager psiManager) {
        if (file.isDirectory()) {
            VirtualFile[] children;
            for (VirtualFile aChildren : children = file.getChildren()) {
                this.processFilesRecursively(aChildren, psiManager);
            }
        } else {
            PsiFile psiFile = psiManager.findFile(file);
            if (psiFile != null) {
                this.buildFileNode(psiFile);
            }
        }
    }

    private void countFilesRecursively(VirtualFile file) {
        if (file.isDirectory()) {
            VirtualFile[] children;
            for (VirtualFile aChildren : children = file.getChildren()) {
                this.countFilesRecursively(aChildren);
            }
        } else {
            this.counting(file);
        }
    }

    private void counting(VirtualFile file) {
        ++this.myTotalFileCount;
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText(AnalysisScopeBundle.message((String)"package.dependencies.build.progress.text", (Object[])new Object[0]));
            indicator.setIndeterminate(true);
            indicator.setText2(file.getPresentableUrl());
        }
    }

    private TreeModel build(final Set<PsiFile> files, boolean showProgress) {
        if (files.size() == 1) {
            this.myShowFiles = true;
        }
        Runnable buildingRunnable = new Runnable(){

            @Override
            public void run() {
                for (PsiFile file : files) {
                    if (file == null) continue;
                    TreeModelBuilder.this.buildFileNode(file);
                }
            }
        };
        if (showProgress) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(buildingRunnable, AnalysisScopeBundle.message((String)"package.dependencies.build.process.title", (Object[])new Object[0]), false, this.myProject);
        } else {
            buildingRunnable.run();
        }
        TreeUtil.sort((DefaultMutableTreeNode)this.myRoot, (Comparator)new DependencyNodeComparator());
        return new TreeModel(this.myRoot, this.myTotalFileCount, this.myMarkedFileCount);
    }

    private void buildFileNode(PsiFile file) {
        boolean isMarked;
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setIndeterminate(false);
            indicator.setText(AnalysisScopeBundle.message((String)"package.dependencies.build.progress.text", (Object[])new Object[0]));
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile != null) {
                indicator.setText2(virtualFile.getPresentableUrl());
            }
            indicator.setFraction((double)this.myScannedFileCount++ / (double)this.myTotalFileCount);
        }
        if (file == null || !file.isValid()) {
            return;
        }
        boolean bl = isMarked = this.myMarker != null && this.myMarker.isMarked(file);
        if (isMarked) {
            ++this.myMarkedFileCount;
        }
        if (isMarked || this.myAddUnmarkedFiles) {
            PackageDependenciesNode dirNode = this.getFileParentNode(file);
            if (this.myShowFiles) {
                FileNode fileNode = new FileNode(file, isMarked);
                dirNode.add(fileNode);
            } else {
                dirNode.addFile(file, isMarked);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PackageDependenciesNode getFileParentNode(PsiFile file) {
        PackageDependenciesNode packageDependenciesNode;
        VirtualFile vFile = file.getVirtualFile();
        LOG.assertTrue(vFile != null);
        VirtualFile containingDirectory = vFile.getParent();
        LOG.assertTrue(containingDirectory != null);
        PsiPackage aPackage = null;
        if (file instanceof PsiJavaFile) {
            aPackage = this.getFilePackage((PsiJavaFile)file);
        } else {
            String packageName = this.myFileIndex.getPackageNameByDirectory(containingDirectory);
            if (packageName != null) {
                aPackage = JavaPsiFacade.getInstance((Project)this.myPsiManager.getProject()).findPackage(packageName);
            }
        }
        if (aPackage != null) {
            if (!(this.myFileIndex.isInLibrarySource(vFile) || this.myFileIndex.isInLibraryClasses(vFile) ? (packageDependenciesNode = this.getLibraryDirNode(aPackage, this.getLibraryForFile(file))) != null : (packageDependenciesNode = this.getModuleDirNode(aPackage, this.myFileIndex.getModuleForFile(vFile), this.getFileScopeType(vFile))) != null)) throw new IllegalStateException("@NotNull method com/intellij/packageDependencies/ui/TreeModelBuilder.getFileParentNode must not return null");
            return packageDependenciesNode;
        }
        packageDependenciesNode = this.getModuleNode(this.myFileIndex.getModuleForFile(vFile), this.getFileScopeType(vFile));
        if (packageDependenciesNode != null) return packageDependenciesNode;
        throw new IllegalStateException("@NotNull method com/intellij/packageDependencies/ui/TreeModelBuilder.getFileParentNode must not return null");
    }

    @Nullable
    private PsiPackage getFilePackage(PsiJavaFile file) {
        String packageName;
        VirtualFile directory;
        VirtualFile vFile = file.getVirtualFile();
        if (vFile != null && this.myFileIndex.isInLibrarySource(vFile) && (directory = vFile.getParent()) != null && (packageName = this.myFileIndex.getPackageNameByDirectory(directory)) != null) {
            return JavaPsiFacade.getInstance((Project)this.myPsiManager.getProject()).findPackage(packageName);
        }
        return JavaPsiFacade.getInstance((Project)this.myPsiManager.getProject()).findPackage(file.getPackageName());
    }

    private ScopeType getFileScopeType(VirtualFile file) {
        if (this.myFileIndex.isLibraryClassFile(file) || this.myFileIndex.isInLibrarySource(file)) {
            return ScopeType.LIB;
        }
        if (this.myFileIndex.isInTestSourceContent(file)) {
            return ScopeType.TEST;
        }
        return ScopeType.SOURCE;
    }

    @Nullable
    private OrderEntry getLibraryForFile(PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        List orders = this.myFileIndex.getOrderEntriesForFile(virtualFile);
        for (OrderEntry order : orders) {
            if (!(order instanceof LibraryOrderEntry) && !(order instanceof JdkOrderEntry)) continue;
            return order;
        }
        return null;
    }

    private <T> T getMap(Map<ScopeType, T> map, ScopeType scopeType) {
        return map.get((Object)(this.myGroupByScopeType ? scopeType : ScopeType.SOURCE));
    }

    private PackageDependenciesNode getLibraryDirNode(PsiPackage aPackage, OrderEntry libraryOrJdk) {
        if (aPackage == null || aPackage.getName() == null) {
            return this.getLibraryOrJDKNode(libraryOrJdk);
        }
        if (!this.myShowModules && !this.myGroupByScopeType) {
            return this.getModuleDirNode(aPackage, null, ScopeType.LIB);
        }
        Pair descriptor = new Pair(this.myShowModules ? libraryOrJdk : null, (Object)aPackage);
        PackageNode node = this.getMap(this.myLibraryPackageNodes, ScopeType.LIB).get(descriptor);
        if (node != null) {
            return node;
        }
        node = new PackageNode(aPackage, this.myFlattenPackages);
        this.getMap(this.myLibraryPackageNodes, ScopeType.LIB).put((Pair<OrderEntry, PsiPackage>)descriptor, node);
        if (this.myFlattenPackages) {
            this.getLibraryOrJDKNode(libraryOrJdk).add(node);
        } else {
            this.getLibraryDirNode(aPackage.getParentPackage(), libraryOrJdk).add(node);
        }
        return node;
    }

    private PackageDependenciesNode getModuleDirNode(PsiPackage aPackage, Module module, ScopeType scopeType) {
        if (aPackage == null) {
            return this.getModuleNode(module, scopeType);
        }
        Pair descriptor = new Pair(this.myShowModules ? module : null, (Object)aPackage);
        PackageNode node = this.getMap(this.myModulePackageNodes, scopeType).get(descriptor);
        if (node != null) {
            return node;
        }
        node = new PackageNode(aPackage, this.myFlattenPackages);
        this.getMap(this.myModulePackageNodes, scopeType).put((Pair<Module, PsiPackage>)descriptor, node);
        if (this.myFlattenPackages) {
            this.getModuleNode(module, scopeType).add(node);
        } else {
            this.getModuleDirNode(aPackage.getParentPackage(), module, scopeType).add(node);
        }
        return node;
    }

    @Nullable
    private PackageDependenciesNode getModuleNode(Module module, ScopeType scopeType) {
        if (module == null || !this.myShowModules) {
            return this.getRootNode(scopeType);
        }
        ModuleNode node = this.getMap(this.myModuleNodes, scopeType).get(module);
        if (node != null) {
            return node;
        }
        node = new ModuleNode(module);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        String[] groupPath = moduleManager.getModuleGroupPath(module);
        if (groupPath == null) {
            this.getMap(this.myModuleNodes, scopeType).put(module, node);
            this.getRootNode(scopeType).add(node);
            return node;
        }
        this.getMap(this.myModuleNodes, scopeType).put(module, node);
        if (this.myShowModuleGroups) {
            this.getParentModuleGroup(groupPath, scopeType).add(node);
        } else {
            this.getRootNode(scopeType).add(node);
        }
        return node;
    }

    private PackageDependenciesNode getParentModuleGroup(String[] groupPath, ScopeType scopeType) {
        ModuleGroupNode groupNode = this.getMap(this.myModuleGroupNodes, scopeType).get(groupPath[groupPath.length - 1]);
        if (groupNode == null) {
            groupNode = new ModuleGroupNode(new ModuleGroup(groupPath));
            this.getMap(this.myModuleGroupNodes, scopeType).put(groupPath[groupPath.length - 1], groupNode);
            this.getRootNode(scopeType).add(groupNode);
        }
        if (groupPath.length > 1) {
            String[] path = new String[groupPath.length - 1];
            System.arraycopy(groupPath, 0, path, 0, groupPath.length - 1);
            PackageDependenciesNode node = this.getParentModuleGroup(path, scopeType);
            node.add(groupNode);
        }
        return groupNode;
    }

    private PackageDependenciesNode getLibraryOrJDKNode(OrderEntry libraryOrJdk) {
        if (libraryOrJdk == null || !this.myShowModules) {
            return this.getRootNode(ScopeType.LIB);
        }
        if (!this.myShowIndividualLibs) {
            if (this.myGroupByScopeType) {
                return this.getRootNode(ScopeType.LIB);
            }
            if (this.myAllLibsNode == null) {
                this.myAllLibsNode = new GeneralGroupNode(AnalysisScopeBundle.message((String)"dependencies.libraries.node.text", (Object[])new Object[0]), LIB_ICON_OPEN, LIB_ICON_CLOSED);
                this.getRootNode(ScopeType.LIB).add(this.myAllLibsNode);
            }
            return this.myAllLibsNode;
        }
        LibraryNode node = this.getMap(this.myLibraryNodes, ScopeType.LIB).get(libraryOrJdk);
        if (node != null) {
            return node;
        }
        node = new LibraryNode(libraryOrJdk);
        this.getMap(this.myLibraryNodes, ScopeType.LIB).put(libraryOrJdk, node);
        this.getRootNode(ScopeType.LIB).add(node);
        return node;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private PackageDependenciesNode getRootNode(ScopeType scopeType) {
        PackageDependenciesNode packageDependenciesNode;
        if (!this.myGroupByScopeType) {
            packageDependenciesNode = this.myRoot;
            if (packageDependenciesNode == null) throw new IllegalStateException("@NotNull method com/intellij/packageDependencies/ui/TreeModelBuilder.getRootNode must not return null");
            return packageDependenciesNode;
        }
        if (scopeType == ScopeType.TEST) {
            packageDependenciesNode = this.myTestRoot;
            if (packageDependenciesNode == null) throw new IllegalStateException("@NotNull method com/intellij/packageDependencies/ui/TreeModelBuilder.getRootNode must not return null");
            return packageDependenciesNode;
        }
        if (scopeType == ScopeType.SOURCE) {
            packageDependenciesNode = this.mySourceRoot;
            if (packageDependenciesNode == null) throw new IllegalStateException("@NotNull method com/intellij/packageDependencies/ui/TreeModelBuilder.getRootNode must not return null");
            return packageDependenciesNode;
        }
        packageDependenciesNode = this.myLibsRoot;
        if (packageDependenciesNode != null) return packageDependenciesNode;
        throw new IllegalStateException("@NotNull method com/intellij/packageDependencies/ui/TreeModelBuilder.getRootNode must not return null");
    }

    private static enum ScopeType {
        TEST,
        SOURCE,
        LIB;

    }
}

